;;;	(c) Copyright 1989, 1990, 1991 Sun Microsystems, Inc. 
;;;	Sun design patents pending in the U.S. and foreign countries. 
;;;	See LEGAL_NOTICE file for terms of the license.

;;;@(#)output.lisp	3.10 11/1/91


(in-package "LISPVIEW")


(defmethod initialize-instance :after ((gc graphics-context) &rest initargs)
  (declare (dynamic-extent initargs))
  (apply #'dd-initialize-graphics-context (platform gc) gc initargs))


(defmethod initialize-instance :around ((gc graphics-context) &key status &allow-other-keys)
  (prog1
      (call-next-method)
    (when (eq status :realized)
      (setf (status gc) :realized))))


(defmethod (setf status) ((value (eql :realized)) (gc graphics-context))
  (when (eq (status gc) :initialized)
    (dd-realize-graphics-context (platform gc) gc))
  (setf (slot-value gc 'status) :realized))


(defmethod (setf status) ((value (eql :destroyed)) (gc graphics-context))
  (when (eq (status gc) :realized)
    (dd-destroy-graphics-context (platform gc) gc))
  (setf (slot-value gc 'status) :destroyed))



(def-solo-accessor OPERATION graphics-context
  :driver dd-gc-operation
  :type boole-constant)

(def-solo-accessor PLANE-MASK graphics-context
  :driver dd-gc-plane-mask
  :type integer)

(def-solo-accessor FOREGROUND graphics-context
  :driver dd-gc-foreground
  :type color)

(def-solo-accessor BACKGROUND graphics-context
  :driver dd-gc-background
  :type color)

(def-solo-accessor LINE-WIDTH graphics-context
  :driver dd-gc-line-width
  :type positive-fixnum)

(def-solo-accessor LINE-STYLE graphics-context
  :driver dd-gc-line-style
  :type line-style)

(def-solo-accessor CAP-STYLE graphics-context
  :driver dd-gc-cap-style
  :type cap-style)

(def-solo-accessor JOIN-STYLE graphics-context
  :driver dd-gc-join-style
  :type join-style)

(def-solo-accessor FILL-STYLE graphics-context
  :driver dd-gc-fill-style
  :type fill-style)

(def-solo-accessor FILL-RULE graphics-context
  :driver dd-gc-fill-rule
  :type fill-rule)

(def-solo-accessor TILE graphics-context
  :driver dd-gc-tile
  :type (or null image))

(def-solo-accessor STIPPLE graphics-context
  :driver dd-gc-stipple
  :type (or null image))

(def-solo-accessor TS-X-ORIGIN graphics-context
  :driver dd-gc-ts-x-origin
  :type integer)

(def-solo-accessor TS-Y-ORIGIN graphics-context
  :driver dd-gc-ts-y-origin
  :type integer)

(def-solo-accessor FONT graphics-context
  :driver dd-gc-font
  :type font)

(def-solo-accessor SUBWINDOW-MODE graphics-context
  :driver dd-gc-subwindow-mode
  :type subwindow-mode)

(def-solo-accessor GRAPHICS-EXPOSURES graphics-context
  :driver dd-gc-graphics-exposures
  :type on-off)

(def-solo-accessor CLIP-X-ORIGIN graphics-context
  :driver dd-gc-clip-x-origin
  :type integer)

(def-solo-accessor CLIP-Y-ORIGIN graphics-context
  :driver dd-gc-clip-x-origin
  :type integer)

(def-solo-accessor CLIP-MASK graphics-context
  :driver dd-gc-clip-mask
  :type clip-mask)

(def-solo-accessor DASH-OFFSET graphics-context
  :driver dd-gc-dash-offset
  :type integer)

(def-solo-accessor DASHES graphics-context
  :driver dd-gc-dashes
  :type dashes-list)

(def-solo-accessor ARC-MODE graphics-context
  :driver dd-gc-arc-mode
  :type arc-mode)




;;; Temporarily bind the specified slots in an existing graphics context.
;;; For example:
;;;
;;;  (with-graphics-context (gc :line-width 4 :line-style style) 
;;;     (draw-line drawable 10 20 30 90 :gc gc)
;;;     (incf (line-width gc) 2)
;;;     (draw-line drawable 20 50 30 10 :gc gc))
;;;
;;; sets the line-width and line-style in the graphics context gc to the
;;; specified values (4 and style) within the body of the form.  When the
;;; body is exited the affected graphics context slots are restored to
;;; their original values.  If the new value for a graphics-context slot
;;; is nil it is not modified.
;;;
;;; The general form of the code  generated by this macro is:
;;;
;;; (let (<bind new gc slot values that aren't constants to gensyms>
;;;       <save old values for each (to be) modified gc slot>)
;;;   (unwind-protect
;;; 	  (progn
;;; 	    <setf gc slots to new, non nil, values>
;;; 	    <body>)
;;;     (progn
;;; 	 <setf gc slots to old values>)))
;;;

(defmacro with-graphics-context ((gc &rest args) &body body)
  (let ((arg-plists nil)
	(gc-var (gensym))
	(lv-package (find-package :lispview)))
    (do ((arg-cdr args (cddr arg-cdr)))
	((null arg-cdr))
      (let ((keyword (car arg-cdr))
	    (value (cadr arg-cdr)))
	(unless (null value)
	  (push (list :keyword keyword
		      :value value
		      :value-var (if (not (constantp value)) (gensym))
		      :accessor (list (intern (format nil "~A" keyword) lv-package)
				      gc-var)
		      :old-value-var (gensym))
		arg-plists))))
    `(let* ((,gc-var ,gc)
	    ;; Bind all of the new slot values that are not constants to 
	    ;; the :value-var gensym.
	    ,@(mapcan #'(lambda (pl)
			  (if (getf pl :value-var)
			      `((,(getf pl :value-var) ,(getf pl :value)))))
		      arg-plists)
	    ;; Bind all of the old slot values that are going to change to 
	    ;; the :old-value-var gensym.  A gc slot value will only change if
	    ;; its new value is non nil.  
	    ,@(mapcar #'(lambda (pl)
			  (let ((old-value-var (getf pl :old-value-var))
				(accessor (getf pl :accessor)))
			    (if (constantp (getf pl :value))
				`(,old-value-var ,accessor)
			      `(,old-value-var (if ,(getf pl :value-var) ,accessor)))))
		      arg-plists))
       (unwind-protect
	   (progn
	     ;; Setf the gc slots that have new non nil values.  
	     ,@(mapcar #'(lambda (pl)
			   (let ((accessor (getf pl :accessor)))
			     (if (constantp (getf pl :value))
				 `(setf ,accessor ,(getf pl :value))
			       `(if ,(getf pl :value-var)
				    (setf ,accessor ,(getf pl :value-var))))))
		       arg-plists)
	     ,@body)
	 (progn
	   ;; restore all modified gc slots
	   ,@(mapcar #'(lambda (pl)
			  (let ((old-value-var (getf pl :old-value-var))
				(accessor (getf pl :accessor)))
			    (if (constantp (getf pl :value))
				`(setf ,accessor ,old-value-var)
			      `(if ,(getf pl :value-var)
				   (setf ,accessor ,old-value-var)))))
		     arg-plists))))))
		     

;;; Define all of the output methods.  Each output method definition looks 
;;; about like this:
;;;
;;; (defmethod name (<required args> &rest args &key gc <keyword args> &allow-other-keys)
;;;   (unless gc
;;;     (setq gc (graphics-context (display <drawable>))))
;;;   (if <no-gc-args-specified>
;;;       (dd-name (platform gc) <required args> <all non gc keyword args>)
;;;     (with-graphics-context (gc <all gc keyword args>)
;;;       (dd-name (platform gc) <required args> <all non gc keyword args>))))
;;;
;;; <drawable> is the first argument specialized to drawable
;;;
;;; <no-gc-args-specified> is an expression that yields non nil if any of the 
;;; keyword gc arguments were specified.

(macrolet
 ((def-output-method (name check-arglist &rest args)
    (let* ((key-position (position '&key args :test #'eq))
	   (required-arglist (if key-position 
				 (subseq args 0 key-position)
			       args))
	   (drawable (car (find 'drawable required-arglist :key #'cadr :test #'eq)))
	   (keyword-args 
	    (append '(clip-mask
		      clip-x-origin
		      clip-y-origin)
		    (if key-position 
			(subseq args (1+ key-position)))))
	   (driver (intern (format nil "DD-~A" name)))
	   (driver-args 
	    (mapcar #'(lambda (arg)
			(if (consp arg) (car arg) arg))
		    required-arglist))
	   (display-var (gensym))
	   (gc-args 
	    (mapcan #'(lambda (keyword-arg)
			(let ((keyword (if (consp keyword-arg)
					   (car keyword-arg)
					 keyword-arg)))
			  (if (member keyword graphics-context-slot-names :test #'eq)
			      (list (intern (string keyword) (find-package :keyword))
				    keyword)
			    (progn 
			      (setq driver-args (append driver-args (list keyword))) 
			      nil))))
		    keyword-args)))
      (unless drawable
	(error "Couldn't locate a drawable in arglist ~S" args))
      `(defmethod ,name (,@required-arglist &rest args
					    &key 
					      gc 
					      ,@keyword-args 
					    &allow-other-keys)
	 (declare (dynamic-extent args))
	 ,check-arglist
	 (unless gc
	   (setq gc (graphics-context (display ,drawable))))
	 (check-type gc graphics-context)
	 (if (or (null args)
		 (and (eq (car args) :gc) (= (length args) 2)))
	     (,driver (platform gc) gc ,@driver-args)
	   (with-graphics-context (gc ,@gc-args)    
	     (,driver (platform gc) gc ,@driver-args)))))))

   (def-output-method draw-line 
     (check-arglist (x1 fixnum) (y1 fixnum) (x2 fixnum) (y2 fixnum))
     (d drawable) x1 y1 x2 y2 
     &key operation plane-mask foreground line-width line-style cap-style 
          dash-offset dashes subwindow-mode)

   (def-output-method draw-lines
     (check-type accessor function)
     (d drawable) lines accessor
     &key operation plane-mask foreground line-width line-style cap-style join-style 
          dash-offset dashes subwindow-mode)

   (def-output-method draw-arc 
     (check-arglist (x fixnum) (y fixnum) (width fixnum) (height fixnum)
		    (start-angle number) (stop-angle number))
     (d drawable) x y width height start-angle stop-angle 
     &key operation plane-mask foreground line-width line-style cap-style fill-style tile stipple 
          ts-x-origin ts-y-origin dash-offset dashes subwindow-mode arc-mode fill-p)

   (def-output-method draw-arcs
     (check-type accessor function)
     (d drawable) arcs accessor
     &key operation plane-mask foreground line-width line-style cap-style fill-style tile stipple
          ts-x-origin ts-y-origin dash-offset dashes subwindow-mode arc-mode fill-p)

   (def-output-method draw-rectangle 
     (check-arglist (x fixnum) (y fixnum) (width fixnum) (height fixnum))
     (d drawable) x y width height
     &key operation plane-mask foreground line-width line-style join-style fill-style tile stipple 
          ts-x-origin ts-y-origin subwindow-mode dash-offset dashes fill-p)

   (def-output-method draw-rectangles
     (check-type accessor function)
     (d drawable) rectangles accessor
     &key operation plane-mask foreground line-width line-style join-style fill-style tile stipple 
     ts-x-origin ts-y-origin subwindow-mode dash-offset dashes fill-p)

   #+ignore
   (def-output-method draw-polygon
     (d drawable) vertices accessor
     &key operation plane-mask foreground line-width line-style join-style fill-style tile stipple 
          ts-x-origin ts-y-origin subwindow-mode dash-offset dashes closed fill-p)

   (def-output-method draw-string 
     (check-arglist (x fixnum) (y fixnum) (string string))
     (d drawable) x y string 
     &key operation plane-mask foreground font subwindow-mode start end)

   (def-output-method draw-char 
     (check-arglist (x fixnum) (y fixnum) (char character))
     (d drawable) x y char
     &key operation plane-mask foreground font subwindow-mode)

   (def-output-method copy-area 
     (check-arglist (from-x fixnum) (from-y fixnum) (width fixnum) (height fixnum)
		    (to-x fixnum) (to-y fixnum))
     (from drawable) (to drawable) from-x from-y width height to-x to-y 
     &key operation plane-mask foreground background fill-style tile stipple 
          ts-x-origin ts-y-origin subwindow-mode))


(defmethod clear ((d opaque-canvas))
  (let ((r (bounding-region d)))
    (draw-rectangle d 0 0 (region-width r) (region-height r)
		    :foreground (background d)
		    :operation boole-1
		    :fill-p t)))


(defmethod clear ((d viewport))
  (let ((r (output-region d)))
    (draw-rectangle d 0 0 (region-width r) (region-height r)
		    :foreground (background d)
		    :operation boole-1
		    :fill-p t)))

