;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(defun abs&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or
                              'integer
                              (list 'or 'real 'float))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun acons&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list
                                    (list 'list
                                          (lderef var#4?))))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (or
                            (trybind (setq *tempreg*
                                           (lderef (cadr fp2)))
                                     (list 'list
                                           (lderef var#4?)))
                            (and (consp *tempreg*)
                                 (= (length *tempreg*) 2)
                                 (or
                                   (eq 'list
                                       (setq *tempreg* (lderef (caadr fp2))))
                                   (qtrybind *tempreg* 'list))
                                 (bind var#4?
                                       (cadar (cdr fp2)))))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'phi
                                  var#3?
                                  (list 'list
                                        (list 'list var#4?))
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun adjoin&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun adjoin-aux&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list (list 'adjoin-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test-not (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list (list 'adjoin-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':key (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list (list 'adjoin-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun alpha-char-p&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun alphanumericp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun and&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#3?)
                        (append (list (list 'and& var#2? 'bool var#3?))
                                continuation))))
             ((backtrack))))

(defun fboundp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun function&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list (list var#1?) var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (qtrybind (setq *tempreg* (car fp1))
                                      (list var#1?))
                            (and (consp *tempreg*)
                                 (= (length *tempreg*) 1)
                                 (bind var#1? (caar fp1))))
                          (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list (lderef var#3?)
                                    '->
                                    (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#3? (car fp2))
                          (or
                            (eq '->
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* '->))
                          (bind var#4? (caddr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#5?)
                        (append (list (list 'phi var#2? var#4? var#5?))
                                continuation))))
             ((and
                (rename
                  '(var#1? var#4? var#2? var#5? var#3? var#6? var#7?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list (list var#1? var#2?)
                                  var#3?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (or
                         (qtrybind (setq *tempreg* (car fp1))
                                   (list var#1? var#2?))
                         (and (consp *tempreg*)
                              (= (length *tempreg*) 2)
                              (bind var#1? (caar fp1))
                              (bind var#2? (cadar fp1))))
                       (bind var#3? (cadr fp1))))
                (or
                  (trybind (setq *tempreg* (lderef fp2))
                           (list (list (lderef var#4?)
                                       (lderef var#5?))
                                 '->
                                 (lderef var#6?)))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 3)
                       (or
                         (trybind (setq *tempreg*
                                        (lderef (car fp2)))
                                  (list (lderef var#4?)
                                        (lderef var#5?)))
                         (and (consp *tempreg*)
                              (= (length *tempreg*) 2)
                              (bind var#4? (caar fp2))
                              (bind var#5? (cadar fp2))))
                       (or (eq '->
                               (setq *tempreg* (lderef (cadr fp2))))
                           (qtrybind *tempreg* '->))
                       (bind var#6? (caddr fp2))))
                (bind var#7? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (lderef var#4?)
                     (lderef var#7?)
                     (append
                       (list (list 'phi var#2? var#5? var#7?)
                             (list 'phi var#3? var#6? var#7?))
                       continuation))))
             ((and
                (rename
                  '(var#1? var#5? var#2? var#6? var#3? var#7? var#4? var#8?
                    var#9?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list (list var#1? var#2? var#3?)
                                  var#4?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (or
                         (qtrybind (setq *tempreg* (car fp1))
                                   (list var#1? var#2? var#3?))
                         (and (consp *tempreg*)
                              (= (length *tempreg*) 3)
                              (bind var#1? (caar fp1))
                              (bind var#2? (cadar fp1))
                              (bind var#3?
                                    (caddr (car fp1)))))
                       (bind var#4? (cadr fp1))))
                (or
                  (trybind (setq *tempreg* (lderef fp2))
                           (list
                             (list (lderef var#5?)
                                   (lderef var#6?)
                                   (lderef var#7?))
                             '->
                             (lderef var#8?)))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 3)
                       (or
                         (trybind (setq *tempreg*
                                        (lderef (car fp2)))
                                  (list (lderef var#5?)
                                        (lderef var#6?)
                                        (lderef var#7?)))
                         (and (consp *tempreg*)
                              (= (length *tempreg*) 3)
                              (bind var#5? (caar fp2))
                              (bind var#6? (cadar fp2))
                              (bind var#7?
                                    (caddr (car fp2)))))
                       (or (eq '->
                               (setq *tempreg* (lderef (cadr fp2))))
                           (qtrybind *tempreg* '->))
                       (bind var#8? (caddr fp2))))
                (bind var#9? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (lderef var#5?)
                     (lderef var#9?)
                     (append
                       (list (list 'phi var#2? var#6? var#9?)
                             (list 'phi var#3? var#7? var#9?)
                             (list 'phi var#4? var#8? var#9?))
                       continuation))))
             ((backtrack))))

(defun append&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1?))
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#1?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#1? (cadr fp2))))
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'append&
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun apply&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#5?
                                    var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#5?)
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#5?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun apropos&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun apropos-list&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun ash&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun assoc&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list
                                        (list 'list var#4?))
                                  var#5?)
                            (list 'assoc-aux&
                                  var#3?
                                  (list 'list var#4?)
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun assoc-aux&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list (list 'adjoin-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test-not (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list (list 'adjoin-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#2? var#1? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':key (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        continuation)))
             ((backtrack))))

(defun assoc-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (list 'list (lderef var#3?))
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list
                                        (list 'list var#3?))
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun assoc-if-not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (list 'list (lderef var#3?))
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list
                                        (list 'list var#3?))
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun atom&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun bind&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#3?)
                        (append (list (list 'phi var#2? var#4? var#3?))
                                continuation))))
             ((backtrack))))

(defun both-case-p&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun boundp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun break&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (bind var#1? fp2)
                   (bind var#2? fp3)
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun butlast&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#2?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#2?))
                        (lderef var#3?)
                        continuation)))
             ((and (rename '(var#1? var#3? var#2? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#4?))
                                continuation))))
             ((backtrack))))

(defun character&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun characterp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun character-bit&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'symbol
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character-bits&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun character-code&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun character-control-bit
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun char&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun char-code&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#2? var#1?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list 'term))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (or (eq 'term
                                    (setq *tempreg* (car fp1)))
                                (qtrybind *tempreg* 'term))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#1? fp3)
                   (change-stacks)
                   (phi (lderef var#2?)
                        'character
                        (lderef var#1?)
                        continuation)))
             ((backtrack))))

(defun character-downcase&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun char-equal&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character-font&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun character-greaterp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character-int&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun character-lessp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character-name&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun character-not-equal&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character-not-greaterp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character-not-lessp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character-upcase&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun character/=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character<&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character<=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character>&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character>=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun character-meta-bit&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#3?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun clone&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun coerce&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? 'character))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (or (eq 'character
                                  (setq *tempreg* (cadr fp1)))
                              (qtrybind *tempreg* 'character))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or
                              'symbol
                              (list 'or 'integer 'string))
                        (lderef var#2?)
                        continuation)))
             ((and (rename '(var#1? var#2?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? 'list))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (or (eq 'list
                                  (setq *tempreg* (cadr fp1)))
                              (qtrybind *tempreg* 'list))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list 'character))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (or
                            (eq 'character
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'character))))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun compile&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'symbol
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'symbol))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun commonp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun compiled-function-p&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun compile-file&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun concatenate&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list 'string var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or (eq 'string
                                  (setq *tempreg* (car fp1)))
                              (qtrybind *tempreg* 'string))
                          (bind var#1? (cadr fp1))
                          (bind var#2? (caddr fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'string
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list 'list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or (eq 'list
                                  (setq *tempreg* (car fp1)))
                              (qtrybind *tempreg* 'list))
                          (bind var#1? (cadr fp1))
                          (bind var#2? (caddr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun concat&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'symbol
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'symbol))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'symbol
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun cons&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun consp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun count&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun count-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun count-if-not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun decode-universal-time&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun delete&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'delete-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun delete-aux&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list (list 'delete-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test-not (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list (list 'delete-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':key (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list (list 'delete-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':count (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'delete-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':start (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'delete-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':end (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'delete-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':from-end (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#4?)
                        (append
                          (list (list 'delete-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun delete-duplicates&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'delete-duplicates-aux&
                                  var#2?
                                  var#3?
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun delete-duplicates-aux&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'delete-duplicates-aux&
                                  var#2?
                                  var#3?
                                  var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test-not (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'delete-duplicates-aux&
                                  var#2?
                                  var#3?
                                  var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':key (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'delete-duplicates-aux&
                                  var#2?
                                  var#3?
                                  var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':start (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list
                            (list 'delete-duplicates-aux&
                                  var#2?
                                  var#3?
                                  var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':end (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list
                            (list 'delete-duplicates-aux&
                                  var#2?
                                  var#3?
                                  var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':from-end (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#4?)
                        (append
                          (list
                            (list 'delete-duplicates-aux&
                                  var#2?
                                  var#3?
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun delete-file&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun delete-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'delete-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun delete-if-not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'delete-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun describe&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun denominator&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'rational
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun digit-char&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'or 'character 'bool))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or (eq 'or
                                  (setq *tempreg* (lderef (car fp2))))
                              (qtrybind *tempreg* 'or))
                          (or
                            (eq 'character
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'character))
                          (or
                            (eq 'bool
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'bool))))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'or 'character 'bool))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or
                            (eq 'or
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'or))
                          (or
                            (eq 'character
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'character))
                          (or
                            (eq 'bool
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'bool))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun digit-char-p&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((and (rename '(var#2? var#1? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'or 'integer 'bool))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or
                            (eq 'or
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'or))
                          (or
                            (eq 'integer
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'integer))
                          (or
                            (eq 'bool
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'bool))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#1?
                                            'integer
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun disassemble&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun documentation&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#2? var#1? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'or 'string 'bool))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or (eq 'or
                                  (setq *tempreg* (lderef (car fp2))))
                              (qtrybind *tempreg* 'or))
                          (or
                            (eq 'string
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'string))
                          (or
                            (eq 'bool
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'bool))))
                   (member (lderef var#2?)
                           (list 'variable
                                 'function
                                 'structure
                                 'type
                                 'setf))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun dribble&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun ed&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun elt&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#4?))
                                continuation))))
             ((backtrack))))

(defun encode-universal-time&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?
                                    var#6?
                                    var#7?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3? var#4? var#5? var#6?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 6)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))
                          (bind var#4?
                                (caddr (cdr fp1)))
                          (bind var#5?
                                (caddr (cddr fp1)))
                          (bind var#6?
                                (caddr (cdddr fp1)))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#7? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#7?)
                        (append
                          (list (list 'phi var#2? 'integer var#7?)
                                (list 'phi var#3? 'integer var#7?)
                                (list 'phi var#4? 'integer var#7?)
                                (list 'phi var#5? 'integer var#7?)
                                (list 'phi var#6? 'integer var#7?))
                          continuation))))
             ((and
                (rename
                  '(var#1? var#2? var#3? var#4? var#5? var#6? var#7? var#8?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list var#1?
                                  var#2?
                                  var#3?
                                  var#4?
                                  var#5?
                                  var#6?
                                  var#7?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 7)
                       (bind var#1? (car fp1))
                       (bind var#2? (cadr fp1))
                       (bind var#3? (caddr fp1))
                       (bind var#4?
                             (caddr (cdr fp1)))
                       (bind var#5?
                             (caddr (cddr fp1)))
                       (bind var#6?
                             (caddr (cdddr fp1)))
                       (bind var#7?
                             (caddr (cdddr (cdr fp1))))))
                (or (eq 'integer
                        (setq *tempreg* (lderef fp2)))
                    (qtrybind *tempreg* 'integer))
                (bind var#8? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     'integer
                     (lderef var#8?)
                     (append
                       (list (list 'phi var#2? 'integer var#8?)
                             (list 'phi var#3? 'integer var#8?)
                             (list 'phi var#4? 'integer var#8?)
                             (list 'phi var#5? 'integer var#8?)
                             (list 'phi var#6? 'integer var#8?)
                             (list 'phi var#7? 'integer var#8?))
                       continuation))))
             ((backtrack))))

(defun enough-namestring&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'string
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun endp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun eq&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#3?)
                        (append (list (list 'phi var#2? var#4? var#3?))
                                continuation))))
             ((backtrack))))

(defun eql&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#3?)
                        (append
                          (list (list 'phi var#2? var#4? var#3?)
                                (list 'eql-aux& var#4?))
                          continuation))))
             ((backtrack))))

(defun eql-aux&
       (fp1 continuation)
       (cond ((and (rename nil)
                   (eq 'symbol fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename nil)
                   (eq 'rational fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename nil)
                   (eq 'integer fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename nil)
                   (eq 'bool fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename nil)
                   (eq 'float fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun equal&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#3?)
                        (append (list (list 'phi var#2? var#4? var#3?))
                                continuation))))
             ((backtrack))))

(defun equalp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#3?)
                        (append (list (list 'phi var#2? var#4? var#3?))
                                continuation))))
             ((backtrack))))

(defun eval&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#2? var#4? var#1? var#3?))
                   (consp fp1)
                   (= (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (symbolp (lderef var#1?))
                   (eq (get (lderef var#1?) 'global)
                       'identifier)
                   (bind (lderef var#4?)
                         (gentemp "&&"))
                   (change-stacks)
                   (phi (lderef var#4?)
                        (lderef var#2?)
                        (cons
                          (list (lderef var#4?)
                                '*
                                (get (lderef var#1?) 'type))
                          (lderef var#3?))
                        continuation)))
             ((and (rename '(var#1? var#2? var#4? var#3?))
                   (consp fp1)
                   (= (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (symbolp (lderef var#1?))
                   (eq (get (lderef var#1?) 'global)
                       'identifier)
                   (bind (lderef var#4?)
                         (gentemp "&&"))
                   (change-stacks)
                   (phi (lderef var#4?)
                        (get (lderef var#1?)
                             (lderef var#2?))
                        (cons (list (lderef var#4?)
                                    '*
                                    'type)
                              (lderef var#3?))
                        continuation)))
             ((backtrack))))

(defun evenp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun every&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun exp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'rational
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'rational))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (or 'rational 'integer)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun expt&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or (eq 'rational
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'rational))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'rational
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'rational
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or (eq 'float
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'float))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'float
                        (lderef var#3?)
                        (append (list (list 'phi var#2? 'float var#3?))
                                continuation))))
             ((backtrack))))

(defun fail&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun fail-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?) '-> 'bool)
                        (lderef var#4?)
                        (append (list (list 'phi var#2? var#3? var#4?))
                                continuation))))
             ((backtrack))))

(defun file-author&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun find&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'delete-duplicates-aux&
                                  var#3?
                                  var#4?
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun find-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'delete-if-aux&
                                  var#3?
                                  var#4?
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun find-if-not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'delete-if-aux&
                                  var#3?
                                  var#4?
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun float-digits&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'float
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun float-precision&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'float
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun float-radix&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'float
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun float-sign&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'float
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'float))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'float
                        (lderef var#3?)
                        (append (list (list 'phi var#2? 'float var#3?))
                                continuation))))
             ((backtrack))))

(defun floatp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun force-output&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun format&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list t var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (or (eq 't
                                    (setq *tempreg* (car fp1)))
                                (qtrybind *tempreg* 't))
                            (bind var#1? (cadr fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks))
              (or
                (phi (lderef var#1?)
                     'string
                     (lderef var#2?)
                     continuation)
                (backtrack)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list nil var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (or (eq 'nil
                                    (setq *tempreg* (car fp1)))
                                (qtrybind *tempreg* 'nil))
                            (bind var#1? (cadr fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#2? fp3)
                   (change-stacks))
              (or
                (phi (lderef var#1?)
                     'string
                     (lderef var#2?)
                     continuation)
                (backtrack)))
             ((and (rename '(var#1? var#2? var#4? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (or (eq 't
                           (setq *tempreg* (car fp1)))
                       (qtrybind *tempreg* 't))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list (list 'phi-progn var#2? var#4? var#3?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#4? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (or (eq 'nil
                           (setq *tempreg* (car fp1)))
                       (qtrybind *tempreg* 'nil))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list (list 'phi-progn var#2? var#4? var#3?))
                          continuation))))
             ((backtrack))))

(defun phi-progn
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((and (rename '(var#1? var#5? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#5?)
                        (lderef var#4?)
                        (append
                          (list (list 'phi-progn var#2? var#3? var#4?))
                          continuation))))
             ((backtrack))))

(defun fresh-line&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#3?)
                        'bool
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun functionp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun funcall&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#5?
                                    var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#5?)
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        (append (list (list 'phi var#2? var#5? var#4?))
                                continuation))))
             ((and
                (rename
                  '(var#1? var#4? var#2? var#6? var#3? var#7? var#5?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list var#1? var#2? var#3?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 3)
                       (bind var#1? (car fp1))
                       (bind var#2? (cadr fp1))
                       (bind var#3? (caddr fp1))))
                (bind var#4? fp2)
                (bind var#5? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (list (lderef var#6?)
                           (lderef var#7?)
                           '->
                           (lderef var#4?))
                     (lderef var#5?)
                     (append
                       (list (list 'phi var#2? var#6? var#5?)
                             (list 'phi var#3? var#7? var#5?))
                       continuation))))
             ((and
                (rename
                  '(var#1? var#5? var#2? var#7? var#3? var#8? var#4? var#9?
                    var#6?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list var#1? var#2? var#3? var#4?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 4)
                       (bind var#1? (car fp1))
                       (bind var#2? (cadr fp1))
                       (bind var#3? (caddr fp1))
                       (bind var#4?
                             (caddr (cdr fp1)))))
                (bind var#5? fp2)
                (bind var#6? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (list (lderef var#7?)
                           (lderef var#8?)
                           (lderef var#9?)
                           '->
                           (lderef var#5?))
                     (lderef var#6?)
                     (append
                       (list (list 'phi var#2? var#7? var#6?)
                             (list 'phi var#3? var#8? var#6?)
                             (list 'phi var#4? var#9? var#6?))
                       continuation))))
             ((backtrack))))

(defun gcd&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'integer
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun gensym&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'symbol
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'symbol))
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'symbol
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'symbol))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi 'term
                        (list 'or 'integer 'string)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun gentemp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1?))
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'symbol
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'symbol))
                   (bind var#1? fp3)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'symbol
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'symbol))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun head&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#2?))
                        (lderef var#3?)
                        continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'sequent
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'sequent))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun identity&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#5?)
                        (append
                          (list (list 'phi var#2? var#4? var#5?)
                                (list 'phi var#3? var#4? var#5?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? var#3? var#4?)
                                (list 'phi nil var#3? var#4?))
                          continuation))))
             ((backtrack))))

(defun get-internal-real-time&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun get-internal-run-time&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun graphic-char-p&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun infs&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun inst&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#5?
                                    var#2?
                                    var#3?
                                    var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#5?)
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'term var#4?)
                                (list 'phi var#3? 'proof var#4?))
                          continuation))))
             ((backtrack))))

(defun integerp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun int-char&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun integer-length&
       (fp1 fp2 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun intersection&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun isqrt&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun keywordp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun last&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#2?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#2?))
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun lcm&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'integer
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun ldiff&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun lemma&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        't-expr
                        (lderef var#3?)
                        (append (list (list 'phi var#2? 'proof var#3?))
                                continuation))))
             ((backtrack))))

(defun length&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun lisp-implementation-type&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun lisp-implementation-version&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun list-length&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun list&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (or (qtrybind (setq *tempreg* fp2)
                                 (list 'list var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (or (eq 'list
                                    (setq *tempreg* (car fp2)))
                                (qtrybind *tempreg* 'list))
                            (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            (lderef var#2?)
                            (lderef var#3?)
                            continuation)))
             ((backtrack))))

(defun listp& (fp1 fp2 fp3 continuation)
  (cond ((and (rename '(var#1? var#3? var#2?))
              (or (qtrybind (setq *tempreg* fp1)
                            (list var#1?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*)
                          1)
                       (bind var#1? (car fp1))))
              (or (eq 'bool
                      (setq *tempreg* (lderef fp2)))
                  (qtrybind *tempreg* 'bool))
              (bind var#2? fp3)
              (change-stacks)
              (phi (lderef var#1?)
                   (lderef var#3?)
                   (lderef var#2?)
                   continuation)))
        ((backtrack))))

(defun log&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#2? var#1? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'float
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'float))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or
                              'integer
                              (list 'or 'float 'rational))
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi
                                  var#1?
                                  (list 'or
                                        'integer
                                        (list 'or
                                              'float
                                              'rational))
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun logical-var&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun long-site-name&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun machine-instance&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun machine-type&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun machine-version&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1?))
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#1? fp3)
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun make-char&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun make-list&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#2? var#1? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#2?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi nil
                        (lderef var#2?)
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#1?
                                            'integer
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1?
                                     ':initial-element
                                     var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (or
                            (eq ':initial-element
                                (setq *tempreg* (cadr fp1)))
                            (qtrybind *tempreg*
                                      ':initial-element))
                          (bind var#2? (caddr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append (list (list 'phi var#2? var#3? var#4?))
                                continuation))))
             ((backtrack))))

(defun xmap&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#5?
                                    var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1?
                                     (list 'cons var#2? nil)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (or
                            (qtrybind (setq *tempreg* (cadr fp1))
                                      (list 'cons var#2? nil))
                            (and (consp *tempreg*)
                                 (= (length *tempreg*) 3)
                                 (or (eq 'cons
                                         (setq *tempreg* (caadr fp1)))
                                     (qtrybind *tempreg* 'cons))
                                 (bind var#2?
                                       (cadar (cdr fp1)))
                                 (or
                                   (eq 'nil
                                       (setq *tempreg* (lderef
                                                         (caddr (cadr fp1)))))
                                   (qtrybind *tempreg* 'nil))))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#5?)
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#5?)
                                  var#4?))
                          continuation))))
             ((and
                (rename
                  '(var#1? var#4? var#2? var#6? var#3? var#7? var#5?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list var#1?
                                  (list 'cons
                                        var#2?
                                        (list 'cons var#3? nil))))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (bind var#1? (car fp1))
                       (or
                         (qtrybind (setq *tempreg* (cadr fp1))
                                   (list 'cons
                                         var#2?
                                         (list 'cons var#3? nil)))
                         (and (consp *tempreg*)
                              (= (length *tempreg*) 3)
                              (or (eq 'cons
                                      (setq *tempreg* (caadr fp1)))
                                  (qtrybind *tempreg* 'cons))
                              (bind var#2?
                                    (cadar (cdr fp1)))
                              (or
                                (trybind
                                  (setq *tempreg* (lderef (caddr (cadr fp1))))
                                        
                                  (list 'cons
                                        (lderef var#3?)
                                        nil))
                                (and (consp *tempreg*)
                                     (= (length *tempreg*)
                                        3)
                                     (or
                                       (eq 'cons
                                           (setq *tempreg* (lderef
                                                             (caadr
                                                               (cdadr fp1)))))
                                       (qtrybind *tempreg* 'cons))
                                     (bind var#3?
                                           (cadar (cddar (cdr fp1))))
                                     (or
                                       (eq 'nil
                                           (setq *tempreg* (lderef
                                                             (caddr
                                                               (caddr
                                                                 (cadr fp1)))))
                                                 )
                                       (qtrybind *tempreg* 'nil))))))))
                (or
                  (trybind (setq *tempreg* (lderef fp2))
                           (list 'list (lderef var#4?)))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (or (eq 'list
                               (setq *tempreg* (lderef (car fp2))))
                           (qtrybind *tempreg* 'list))
                       (bind var#4? (cadr fp2))))
                (bind var#5? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (list (lderef var#6?)
                           (lderef var#7?)
                           '->
                           (lderef var#4?))
                     (lderef var#5?)
                     (append
                       (list (list 'phi
                                   var#2?
                                   (list 'list var#6?)
                                   var#5?)
                             (list 'phi
                                   var#3?
                                   (list 'list var#7?)
                                   var#5?))
                       continuation))))
             ((and
                (rename
                  '(var#1? var#5? var#2? var#7? var#3? var#8? var#4? var#9?
                    var#6?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list var#1?
                                  (list 'cons
                                        var#2?
                                        (list 'cons
                                              var#3?
                                              (list 'cons var#4? nil)))))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (bind var#1? (car fp1))
                       (or
                         (qtrybind (setq *tempreg* (cadr fp1))
                                   (list 'cons
                                         var#2?
                                         (list 'cons
                                               var#3?
                                               (list 'cons var#4? nil))))
                         (and (consp *tempreg*)
                              (= (length *tempreg*) 3)
                              (or (eq 'cons
                                      (setq *tempreg* (caadr fp1)))
                                  (qtrybind *tempreg* 'cons))
                              (bind var#2?
                                    (cadar (cdr fp1)))
                              (or
                                (trybind
                                  (setq *tempreg* (lderef (caddr (cadr fp1))))
                                        
                                  (list 'cons
                                        (lderef var#3?)
                                        (list 'cons
                                              (lderef var#4?)
                                              nil)))
                                (and (consp *tempreg*)
                                     (= (length *tempreg*)
                                        3)
                                     (or
                                       (eq 'cons
                                           (setq *tempreg* (lderef
                                                             (caadr
                                                               (cdadr fp1)))))
                                       (qtrybind *tempreg* 'cons))
                                     (bind var#3?
                                           (cadar (cddar (cdr fp1))))
                                     (or
                                       (trybind
                                         (setq *tempreg* (lderef
                                                           (caddr
                                                             (caddr
                                                               (cadr fp1)))))
                                         (list 'cons
                                               (lderef var#4?)
                                               nil))
                                       (and (consp *tempreg*)
                                            (= (length *tempreg*)
                                               3)
                                            (or
                                              (eq 'cons
                                                  (setq *tempreg* (lderef
                                                                    (caadr
                                                                      (cdadr
                                                                      (cdadr
                                                                      fp1)))))
                                                        )
                                              (qtrybind *tempreg* 'cons))
                                            (bind var#4?
                                                  (cadar
                                                    (cddar (cddar (cdr fp1)))))
                                            (or
                                              (eq 'nil
                                                  (setq *tempreg* (lderef
                                                                    (caddr
                                                                      (caddr
                                                                      (caddr
                                                                      (cadr
                                                                      fp1))))))
                                                        )
                                              (qtrybind *tempreg* 'nil))))))))))
                (or
                  (trybind (setq *tempreg* (lderef fp2))
                           (list 'list (lderef var#5?)))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (or (eq 'list
                               (setq *tempreg* (lderef (car fp2))))
                           (qtrybind *tempreg* 'list))
                       (bind var#5? (cadr fp2))))
                (bind var#6? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (list (lderef var#7?)
                           (lderef var#8?)
                           (lderef var#9?)
                           '->
                           (lderef var#5?))
                     (lderef var#6?)
                     (append
                       (list (list 'phi
                                   var#2?
                                   (list 'list var#7?)
                                   var#6?)
                             (list 'phi
                                   var#3?
                                   (list 'list var#8?)
                                   var#6?)
                             (list 'phi
                                   var#4?
                                   (list 'list var#9?)
                                   var#6?))
                       continuation))))
             ((backtrack))))

(defun mapcar&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#5?
                                    var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#5?)
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#5?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun mapcan&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#5?
                                    var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#5?)
                              '->
                              (list 'list (lderef var#3?)))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#5?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun maplist&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#5?
                                    var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (list 'list (lderef var#5?))
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#5?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun max&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or
                     (qtrybind (setq *tempreg* fp2)
                               (list 'or 'integer 'float))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or (eq 'or
                                  (setq *tempreg* (car fp2)))
                              (qtrybind *tempreg* 'or))
                          (or
                            (eq 'integer
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'integer))
                          (or
                            (eq 'float
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'float))))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            (list 'or 'integer 'float)
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun member&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun member-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?) '-> 'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#6?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? ':key var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 4)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (or (eq ':key
                                  (setq *tempreg* (caddr fp1)))
                              (qtrybind *tempreg* ':key))
                          (bind var#3?
                                (caddr (cdr fp1)))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'phi
                                  var#3?
                                  (list var#4? '-> var#6?)
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun member-if-not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?) '-> 'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#6?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? ':key var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 4)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (or (eq ':key
                                  (setq *tempreg* (caddr fp1)))
                              (qtrybind *tempreg* ':key))
                          (bind var#3?
                                (caddr (cdr fp1)))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'phi
                                  var#3?
                                  (list var#4? '-> var#6?)
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun metarewrite& (fp1 fp2 fp3 continuation)
  (cond ((and (rename '(var#1? var#2?))
              (or (qtrybind (setq *tempreg* fp1)
                            (list var#1?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*)
                          1)
                       (bind var#1? (car fp1))))
              (or (eq 'symbol
                      (setq *tempreg* (lderef fp2)))
                  (qtrybind *tempreg* 'symbol))
              (bind var#2? fp3)
              (change-stacks)
              (phi (lderef var#1?)
                   'symbol
                   (lderef var#2?)
                   continuation)))
        ((backtrack))))

(defun xmerge&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'phi
                                  var#3?
                                  (list var#4? var#4? '-> 'bool)
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun min&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'integer
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'float
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'float))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun minusp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun mismatch&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#5?
                                    var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'or 'integer 'bool))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or (eq 'or
                                  (setq *tempreg* (lderef (car fp2))))
                              (qtrybind *tempreg* 'or))
                          (or
                            (eq 'integer
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'integer))
                          (or
                            (eq 'bool
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'bool))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#5?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#5?)
                                  var#4?)
                            (list 'mismatch-aux&
                                  var#3?
                                  var#5?
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun mismatch-aux&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':start1 (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'mismatch-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':start2 (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'mismatch-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':end1 (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'mismatch-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':end2 (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'mismatch-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list (list 'mismatch-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':test-not (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              (lderef var#3?)
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list (list 'mismatch-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':from-end (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#4?)
                        (append
                          (list (list 'mismatch-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':key (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?)
                              '->
                              (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list (list 'mismatch-aux&
                                      var#2?
                                      var#3?
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun mod&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or (eq 'rational
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'rational))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'rational
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'or
                                        'rational
                                        'integer)
                                  var#3?))
                          continuation))))
             ((and (rename '(var#2? var#1? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or (eq 'rational
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'rational))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or 'rational 'integer)
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#1?
                                            'rational
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or (eq 'float
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'float))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'float
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'or
                                        (list 'or
                                              'rational
                                              'integer)
                                        'float)
                                  var#3?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or (eq 'float
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'float))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or
                              (list 'or 'rational 'integer)
                              'float)
                        (lderef var#3?)
                        (append (list (list 'phi var#2? 'float var#3?))
                                continuation))))
             ((backtrack))))

(defun nbutlast&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#2?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#2?))
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun nconc&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (or (qtrybind (setq *tempreg* fp2)
                                 (list 'list var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (or (eq 'list
                                    (setq *tempreg* (car fp2)))
                                (qtrybind *tempreg* 'list))
                            (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            (list 'list (lderef var#2?))
                            (lderef var#3?)
                            continuation)))
             ((backtrack))))

(defun nreconc&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun nintersection&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun newv&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'symbol
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'symbol))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun newvar&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun notany&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#4?
                                    var#5?
                                    var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (> (length (lderef var#1?))
                      1)
                   (bind (lderef var#3?)
                         (first (lderef var#1?)))
                   (bind (lderef var#4?)
                         (rest (lderef var#1?)))
                   (change-stacks)
                   (phi (lderef var#3?)
                        (list (lderef var#5?) '-> 'bool)
                        (lderef var#2?)
                        (append
                          (list
                            (list 'phi-rpt
                                  var#4?
                                  (list 'list var#5?)
                                  var#2?))
                          continuation))))
             ((backtrack))))

(defun notevery&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#4?
                                    var#5?
                                    var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (> (length (lderef var#1?))
                      1)
                   (bind (lderef var#3?)
                         (first (lderef var#1?)))
                   (bind (lderef var#4?)
                         (rest (lderef var#1?)))
                   (change-stacks)
                   (phi (lderef var#3?)
                        (list (lderef var#5?) '-> 'bool)
                        (lderef var#2?)
                        (append
                          (list
                            (list 'phi-rpt
                                  var#4?
                                  (list 'list var#5?)
                                  var#2?))
                          continuation))))
             ((backtrack))))

(defun nreverse&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#2?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#2?))
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun nset-difference&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun nset-exclusive-or&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun nstring-capitalize&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list
                            (list 'nstring-capitalize-aux&
                                  var#2?
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun nstring-capitalize-aux&
       (fp1 fp2 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':start (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append
                          (list
                            (list 'nstring-capitalize-aux&
                                  var#2?
                                  var#3?))
                          continuation))))
             ((and (rename '(var#1? var#2?))
                   (consp fp1)
                   (= (length fp1) 2)
                   (eq ':end (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun nstring-downcase&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list
                            (list 'nstring-capitalize-aux&
                                  var#2?
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun nstring-upcase&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list
                            (list 'nstring-capitalize-aux&
                                  var#2?
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun nsubst&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?
                                    var#6?))
                   (consp fp1)
                   (> (length fp1) 2)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (caddr fp1))
                   (bind var#4? (cdddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#5?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#5? (cadr fp2))))
                   (bind var#6? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#5?)
                        (lderef var#6?)
                        (append
                          (list (list 'phi var#2? var#5? var#6?)
                                (list 'phi
                                      var#3?
                                      (list 'list var#5?)
                                      var#6?)
                                (list 'adjoin-aux&
                                      var#4?
                                      var#5?
                                      var#6?))
                          continuation))))
             ((backtrack))))

(defun nsubst-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#3?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'phi
                                  var#2?
                                  (list var#4? '-> 'bool)
                                  var#5?))
                          continuation))))
             ((and
                (rename
                  '(var#1? var#3? var#2? var#4? var#5? var#7? var#6?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list var#1? var#2? var#3? ':key var#4?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 5)
                       (bind var#1? (car fp1))
                       (bind var#2? (cadr fp1))
                       (bind var#3? (caddr fp1))
                       (or (eq ':key
                               (setq *tempreg* (caddr (cdr fp1))))
                           (qtrybind *tempreg* ':key))
                       (bind var#4?
                             (caddr (cddr fp1)))))
                (or
                  (trybind (setq *tempreg* (lderef fp2))
                           (list 'list (lderef var#5?)))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (or (eq 'list
                               (setq *tempreg* (lderef (car fp2))))
                           (qtrybind *tempreg* 'list))
                       (bind var#5? (cadr fp2))))
                (bind var#6? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (lderef var#5?)
                     (lderef var#6?)
                     (append
                       (list (list 'phi
                                   var#3?
                                   (list 'list var#5?)
                                   var#6?)
                             (list 'phi
                                   var#2?
                                   (list var#5? '-> 'bool)
                                   var#6?)
                             (list 'phi
                                   var#4?
                                   (list var#5? '-> var#7?)
                                   var#6?))
                       continuation))))
             ((backtrack))))

(defun nsubst-if-not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#3?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'phi
                                  var#2?
                                  (list var#4? '-> 'bool)
                                  var#5?))
                          continuation))))
             ((and
                (rename
                  '(var#1? var#3? var#2? var#4? var#5? var#7? var#6?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list var#1? var#2? var#3? ':key var#4?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 5)
                       (bind var#1? (car fp1))
                       (bind var#2? (cadr fp1))
                       (bind var#3? (caddr fp1))
                       (or (eq ':key
                               (setq *tempreg* (caddr (cdr fp1))))
                           (qtrybind *tempreg* ':key))
                       (bind var#4?
                             (caddr (cddr fp1)))))
                (or
                  (trybind (setq *tempreg* (lderef fp2))
                           (list 'list (lderef var#5?)))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (or (eq 'list
                               (setq *tempreg* (lderef (car fp2))))
                           (qtrybind *tempreg* 'list))
                       (bind var#5? (cadr fp2))))
                (bind var#6? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (lderef var#5?)
                     (lderef var#6?)
                     (append
                       (list (list 'phi
                                   var#3?
                                   (list 'list var#5?)
                                   var#6?)
                             (list 'phi
                                   var#2?
                                   (list var#5? '-> 'bool)
                                   var#6?)
                             (list 'phi
                                   var#4?
                                   (list var#5? '-> var#7?)
                                   var#6?))
                       continuation))))
             ((backtrack))))

(defun xnth&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun nthcdr&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun null&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun numerator&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or 'rational 'integer)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun nunion&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun oddp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun peek-char&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename nil)
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list t))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (or (eq 't
                                    (setq *tempreg* (car fp1)))
                                (qtrybind *tempreg* 't))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun eigen&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#4?
                                    var#2?
                                    var#5?
                                    var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#3?)
                        (append (list (list 'phi var#2? var#5? var#3?))
                                continuation))))
             ((backtrack))))

(defun or&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'bool
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun plusp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun xposition&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#3? fp3)
                   (change-stacks))
              (or
                (phi (lderef var#1?)
                     (lderef var#4?)
                     (lderef var#3?)
                     (append
                       (list (list 'phi
                                   var#2?
                                   (list 'list var#4?)
                                   var#3?))
                       continuation))
                (backtrack)))
             ((backtrack))))

(defun xposition-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#3? fp3)
                   (change-stacks))
              (or
                (phi (lderef var#1?)
                     (list (lderef var#4?) '-> 'bool)
                     (lderef var#3?)
                     (append
                       (list (list 'phi
                                   var#2?
                                   (list 'list var#4?)
                                   var#3?))
                       continuation))
                (backtrack)))
             ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#6?
                                    var#5?
                                    var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? ':key var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 4)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (or (eq ':key
                                  (setq *tempreg* (caddr fp1)))
                              (qtrybind *tempreg* ':key))
                          (bind var#3?
                                (caddr (cdr fp1)))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#4? fp3)
                   (change-stacks))
              (or
                (phi (lderef var#1?)
                     (list (lderef var#5?) '-> 'bool)
                     (lderef var#4?)
                     (append
                       (list (list 'phi
                                   var#2?
                                   (list 'list var#6?)
                                   var#4?)
                             (list 'phi
                                   var#3?
                                   (list var#6? '-> var#5?)
                                   var#4?))
                       continuation))
                (backtrack)))
             ((backtrack))))

(defun pprint&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun princ&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun princ-to-string&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun print&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun prin1&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun prin1-to-string&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun protect& (fp1 fp2 fp3 continuation)
  (cond ((and (rename '(var#1? var#2? var#3?))
              (or (qtrybind (setq *tempreg* fp1)
                            (list var#1?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*)
                          1)
                       (bind var#1? (car fp1))))
              (bind var#2? fp2)
              (bind var#3? fp3)
              (change-stacks)
              (phi (lderef var#1?)
                   (lderef var#2?)
                   (lderef var#3?)
                   continuation)))
        ((backtrack))))

(defun xprobe-file&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun prog1&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#5?
                                    var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#4?)
                        (append (list (list 'phi var#2? var#5? var#4?))
                                continuation))))
             ((backtrack))))

(defun prog2&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#5?
                                    var#2?
                                    var#3?
                                    var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#5?)
                        (lderef var#4?)
                        (append (list (list 'phi var#2? var#3? var#4?))
                                continuation))))
             ((backtrack))))

(defun progn&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((and (rename '(var#1? var#5? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#5?)
                        (lderef var#4?)
                        (append (list (list 'progn& var#2? var#3? var#4?))
                                continuation))))
             ((backtrack))))

(defun random&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun rassoc&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list
                                        (list 'list var#4?))
                                  var#5?)
                            (list 'adjoin-aux&
                                  var#3?
                                  (list 'list var#4?)
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun rassoc-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (list 'list (lderef var#3?))
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list
                                        (list 'list var#3?))
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun rassoc-if-not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (list 'list (lderef var#3?))
                              '->
                              'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list
                                        (list 'list var#3?))
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun rational&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'rational
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'rational))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or 'rational 'float)
                        (lderef var#2?)
                        continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun rationalp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun rationalize&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'rational
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'rational))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or
                              'rational
                              (list 'or 'integer 'float))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun reduce&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#4?
                                    var#3?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?)
                              (lderef var#4?)
                              '->
                              (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'nstring-capitalize-aux&
                                  var#3?
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun refine&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'integer var#4?)
                                (list 'phi var#3? 'proof var#4?))
                          continuation))))
             ((backtrack))))

(defun rem&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'or 'rational 'integer))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or
                            (eq 'or
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'or))
                          (or
                            (eq 'rational
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'rational))
                          (or
                            (eq 'integer
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'integer))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'rational
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'or 'rational 'integer))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or
                            (eq 'or
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'or))
                          (or
                            (eq 'rational
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'rational))
                          (or
                            (eq 'integer
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'integer))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'rational
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'or 'rational 'integer))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or
                            (eq 'or
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'or))
                          (or
                            (eq 'rational
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'rational))
                          (or
                            (eq 'integer
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'integer))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'rational
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'rational
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun swap&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'integer var#4?)
                                (list 'phi var#3? 'proof var#4?))
                          continuation))))
             ((backtrack))))

(defun input+& (fp1 fp2 fp3 continuation)
  (cond ((and (rename '(var#1? var#2?))
              (or (qtrybind (setq *tempreg* fp1)
                            (list var#1?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*)
                          1)
                       (bind var#1? (car fp1))))
              (bind var#2? fp2)
              (unify (remove-conses (lderef var#1?))
                     (lderef var#2?))
              (change-stacks)
              (popstack continuation)))
        ((backtrack))))

(defun remove-conses (fp1)
  (cond ((and (consp fp1)
              (= (length fp1) 3)
              (eq 'cons (car fp1)))
         (cons (remove-conses (cadr fp1))
               (remove-conses (caddr fp1))))
        (t fp1)))

(defun repseq&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'sequent
                        (lderef var#3?)
                        (append (list (list 'phi var#2? 'proof var#3?))
                                continuation))))
             ((backtrack))))

(defun rewrite&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 't-expr '-> 't-expr)
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'integer var#4?)
                                (list 'phi var#3? 'proof var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#6?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3? var#4?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 4)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))
                          (bind var#4?
                                (caddr (cdr fp1)))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 't-expr
                              (lderef var#6?)
                              '->
                              't-expr)
                        (lderef var#5?)
                        (append
                          (list (list 'phi var#2? 'integer var#5?)
                                (list 'phi var#3? var#6? var#5?)
                                (list 'phi var#4? 'proof var#5?))
                          continuation))))
             ((backtrack))))

(defun xtt&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun remove&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'delete-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun remove-duplicates&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'delete-duplicates-aux&
                                  var#2?
                                  var#3?
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun remove-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?) '-> 'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun remove-if-not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#3?) '-> 'bool)
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun rest&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#2?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#2?))
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun restart&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun revappend&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#3?)
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun reverse&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#2?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#2?))
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun room&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun round&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or
                              'integer
                              (list 'or 'rational 'float))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun error&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun raise&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun rotate&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'integer var#4?)
                                (list 'phi var#3? 'proof var#4?))
                          continuation))))
             ((backtrack))))

(defun scale-float&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'float
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'float))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'float
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun schar&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'character
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'character))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'integer
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun set-difference&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun set-syntax-from-char&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'character
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun short-site-name&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun signum&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or
                              'integer
                              (list 'or 'rational 'float))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun signature&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun software-type&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun software-version&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun sort&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list var#3? var#3? '-> 'bool)
                                  var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#6?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? ':key var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 4)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (or (eq ':key
                                  (setq *tempreg* (caddr fp1)))
                              (qtrybind *tempreg* ':key))
                          (bind var#3?
                                (caddr (cdr fp1)))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#6?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list var#4? var#4? '-> 'bool)
                                  var#5?)
                            (list 'phi
                                  var#3?
                                  (list var#6? '-> var#4?)
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun stable-sort&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#3?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#3? (cadr fp2))))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#3?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list var#3? var#3? '-> 'bool)
                                  var#4?))
                          continuation))))
             ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#6?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? ':key var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 4)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (or (eq ':key
                                  (setq *tempreg* (caddr fp1)))
                              (qtrybind *tempreg* ':key))
                          (bind var#3?
                                (caddr (cdr fp1)))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#6?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list var#4? var#4? '-> 'bool)
                                  var#5?)
                            (list 'phi
                                  var#3?
                                  (list var#6? '-> var#4?)
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun suppress&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list 'symbol)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun put-prop&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#5?
                                    var#2?
                                    var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (symbolp (lderef var#2?))
                   (eq (get (lderef var#2?) 'global)
                       'pointer)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#5?)
                        (append
                          (list (list 'phi var#3? var#4? var#5?)
                                (list 'logic-equal
                                      (get (lderef var#2?)
                                           'type)
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun get-prop&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#5?
                                    var#2?
                                    var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (symbolp (lderef var#2?))
                   (eq (get (lderef var#2?) 'global)
                       'pointer)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#5?)
                        (append
                          (list (list 'phi var#3? var#4? var#5?)
                                (list 'logic-equal
                                      (get (lderef var#2?)
                                           'type)
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun get-theory-length&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun set&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (eq (get (lderef var#1?) 'global)
                       'identifier)
                   (change-stacks)
                   (logic-equal (get (lderef var#1?) 'type)
                                (lderef var#3?)
                                (append
                                  (list (list 'phi var#2? var#3? var#4?))
                                  continuation))))
             ((backtrack))))

(defun build-array&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'symbol
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'symbol))
                   (bind var#3? fp3)
                   (symbolp 'array)
                   (eq (get (lderef var#1?) 'global)
                       'array)
                   (change-stacks)
                   (phi (lderef var#2?)
                        (list 'list 'integer)
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun build-hash-table&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#7?
                                    var#4?
                                    var#5?
                                    var#6?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1?
                                     ':size
                                     var#2?
                                     ':test
                                     var#3?
                                     ':rehash-size
                                     var#4?
                                     ':rehash-threshold
                                     var#5?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 9)
                          (bind var#1? (car fp1))
                          (or (eq ':size
                                  (setq *tempreg* (cadr fp1)))
                              (qtrybind *tempreg* ':size))
                          (bind var#2? (caddr fp1))
                          (or
                            (eq ':test
                                (setq *tempreg* (lderef (caddr (cdr fp1)))))
                            (qtrybind *tempreg* ':test))
                          (bind var#3?
                                (caddr (cddr fp1)))
                          (or
                            (eq ':rehash-size
                                (setq *tempreg* (lderef (caddr (cdddr fp1)))))
                            (qtrybind *tempreg* ':rehash-size))
                          (bind var#4?
                                (caddr (cdddr (cdr fp1))))
                          (or
                            (eq ':rehash-threshold
                                (setq *tempreg* (lderef
                                                  (caddr (cdddr (cddr fp1)))))
                                      )
                            (qtrybind *tempreg*
                                      ':rehash-threshold))
                          (bind var#5?
                                (caddr (cdddr (cdddr fp1))))))
                   (or (eq 'symbol
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'symbol))
                   (symbolp (lderef var#1?))
                   (eq (get (lderef var#1?) 'global)
                       'hash-table)
                   (bind var#6? fp3)
                   (change-stacks)
                   (phi (lderef var#2?)
                        'integer
                        (lderef var#6?)
                        (append
                          (list
                            (list 'phi
                                  var#3?
                                  (list var#7? var#7? '-> 'bool)
                                  var#6?)
                            (list 'phi var#4? 'integer var#6?)
                            (list 'phi var#5? 'integer var#6?))
                          continuation))))
             ((backtrack))))

(defun get-hash&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#2? var#6?
                                    var#3?
                                    var#5?
                                    var#1?
                                    var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (symbolp (lderef var#1?))
                   (boundp (lderef var#1?))
                   (hash-table-p (eval (lderef var#1?)))
                   (change-stacks)
                   (phi (lderef var#2?)
                        (lderef var#6?)
                        (lderef var#5?)
                        (append
                          (list (list 'phi var#3? var#4? var#5?)
                                (list 'logic-equal
                                      (get (lderef var#1?)
                                           'type)
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun put-hash&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#2? var#3?
                                    var#5?
                                    var#1?
                                    var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (symbolp (lderef var#1?))
                   (boundp (lderef var#1?))
                   (hash-table-p (eval (lderef var#1?)))
                   (change-stacks)
                   (phi (lderef var#2?)
                        'symbol
                        (lderef var#5?)
                        (append
                          (list (list 'phi var#3? var#4? var#5?)
                                (list 'logic-equal
                                      (get (lderef var#1?)
                                           'type)
                                      var#4?))
                          continuation))))
             ((and (rename '(var#2? var#3? var#5? var#1? var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (symbolp (lderef var#1?))
                   (boundp (lderef var#1?))
                   (hash-table-p (eval (lderef var#1?)))
                   (change-stacks)
                   (phi (lderef var#2?)
                        'integer
                        (lderef var#5?)
                        (append
                          (list (list 'phi var#3? var#4? var#5?)
                                (list 'logic-equal
                                      (get (lderef var#1?)
                                           'type)
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun get-array&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#5?
                                    var#2?
                                    var#4?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (symbolp (lderef var#1?))
                   (bind var#4? fp2)
                   (boundp (lderef var#1?))
                   (arrayp (eval (lderef var#1?)))
                   (bind var#5? fp3)
                   (change-stacks)
                   (logic-equal (lderef var#5?)
                                (get (lderef var#1?) 'type)
                                (append
                                  (list (list 'phi var#3? var#5? var#4?)
                                        (list 'phi
                                              var#2?
                                              (list 'list 'integer)
                                              var#4?))
                                  continuation))))
             ((backtrack))))

(defun put-array&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#4?
                                    var#2?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (symbolp (lderef var#1?))
                   (boundp (lderef var#1?))
                   (arrayp (eval (lderef var#1?)))
                   (bind var#4? fp2)
                   (bind var#5? fp3)
                   (change-stacks)
                   (logic-equal (lderef var#4?)
                                (get (lderef var#1?) 'type)
                                (append
                                  (list (list 'phi var#3? var#4? var#5?)
                                        (list 'phi
                                              var#2?
                                              (list 'list 'integer)
                                              var#5?))
                                  continuation))))
             ((backtrack))))

(defun set-exclusive-or&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux& var#3? var#4? var#5?))
                          continuation))))
             ((backtrack))))

(defun thin&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'proof
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'proof))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append (list (list 'phi var#2? 'proof var#3?))
                                continuation))))
             ((backtrack))))

(defun some&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list (lderef var#4?) '-> 'bool)
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun string&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun stringp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun string-capitalize&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list
                            (list 'nstring-capitalize-aux&
                                  var#2?
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun string-downcase&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list
                            (list 'nstring-capitalize-aux&
                                  var#2?
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun string-equal&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'string var#4?)
                                (list 'string-equal-aux&
                                      var#3?
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun string-equal-aux&
       (fp1 fp2 continuation)
       (cond ((and (rename nil)
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (or (eq ':start1
                           (setq *tempreg* (car fp1)))
                       (qtrybind *tempreg* ':start1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append
                          (list (list 'string-equal-aux&
                                      var#2?
                                      var#3?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (or (eq ':start2
                           (setq *tempreg* (car fp1)))
                       (qtrybind *tempreg* ':start2))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append
                          (list (list 'string-equal-aux&
                                      var#2?
                                      var#3?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (or (eq ':end1
                           (setq *tempreg* (car fp1)))
                       (qtrybind *tempreg* ':end1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append
                          (list (list 'string-equal-aux&
                                      var#2?
                                      var#3?))
                          continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (or (eq ':end2
                           (setq *tempreg* (car fp1)))
                       (qtrybind *tempreg* ':end2))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append
                          (list (list 'string-equal-aux&
                                      var#2?
                                      var#3?))
                          continuation))))
             ((backtrack))))

(defun string-greaterp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'string var#4?)
                                (list 'string-equal-aux&
                                      var#3?
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun string-left-trim&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list 'character)
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'string
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun string-lessp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'string var#4?)
                                (list 'string-equal-aux&
                                      var#3?
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun string-not-equal&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'string var#4?)
                                (list 'string-equal-aux&
                                      var#3?
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun string-not-greaterp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'string var#4?)
                                (list 'string-equal-aux&
                                      var#3?
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun string-not-lessp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#4?)
                        (append
                          (list (list 'phi var#2? 'string var#4?)
                                (list 'string-equal-aux&
                                      var#3?
                                      var#4?))
                          continuation))))
             ((backtrack))))

(defun string-right-trim&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list 'character)
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'string
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun string-upcase&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list
                            (list 'nstring-capitalize-aux&
                                  var#2?
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun xstring/=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'string
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun xstring<&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'string
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun xstring<=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#2? var#1? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun xstring=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'string
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun xstring>&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append (list (list 'phi
                                            var#2?
                                            'string
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun subsetp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#5?
                                    var#4?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#5?))
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#5?)
                                  var#4?)
                            (list 'adjoin-aux& var#3? var#5? var#4?))
                          continuation))))
             ((backtrack))))

(defun subst&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?
                                    var#6?))
                   (consp fp1)
                   (> (length fp1) 2)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (caddr fp1))
                   (bind var#4? (cdddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#5?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#5? (cadr fp2))))
                   (bind var#6? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#5?)
                        (lderef var#6?)
                        (append
                          (list (list 'phi var#2? var#5? var#6?)
                                (list 'phi
                                      var#3?
                                      (list 'list var#5?)
                                      var#6?)
                                (list 'adjoin-aux&
                                      var#4?
                                      var#5?
                                      var#6?))
                          continuation))))
             ((backtrack))))

(defun subst-if&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#3?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'phi
                                  var#2?
                                  (list var#4? '-> 'bool)
                                  var#5?))
                          continuation))))
             ((and
                (rename
                  '(var#1? var#3? var#2? var#4? var#5? var#7? var#6?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list var#1? var#2? var#3? ':key var#4?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 5)
                       (bind var#1? (car fp1))
                       (bind var#2? (cadr fp1))
                       (bind var#3? (caddr fp1))
                       (or (eq ':key
                               (setq *tempreg* (caddr (cdr fp1))))
                           (qtrybind *tempreg* ':key))
                       (bind var#4?
                             (caddr (cddr fp1)))))
                (or
                  (trybind (setq *tempreg* (lderef fp2))
                           (list 'list (lderef var#5?)))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (or (eq 'list
                               (setq *tempreg* (lderef (car fp2))))
                           (qtrybind *tempreg* 'list))
                       (bind var#5? (cadr fp2))))
                (bind var#6? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (lderef var#5?)
                     (lderef var#6?)
                     (append
                       (list (list 'phi
                                   var#3?
                                   (list 'list var#5?)
                                   var#6?)
                             (list 'phi
                                   var#2?
                                   (list var#5? '-> 'bool)
                                   var#6?)
                             (list 'phi
                                   var#4?
                                   (list var#5? '-> var#7?)
                                   var#6?))
                       continuation))))
             ((backtrack))))

(defun subst-if-not&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3?
                                    var#2?
                                    var#4?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list var#1? var#2? var#3?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#1? (car fp1))
                          (bind var#2? (cadr fp1))
                          (bind var#3? (caddr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#3?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'phi
                                  var#2?
                                  (list var#4? '-> 'bool)
                                  var#5?))
                          continuation))))
             ((and
                (rename
                  '(var#1? var#3? var#2? var#4? var#5? var#7? var#6?))
                (or
                  (qtrybind (setq *tempreg* fp1)
                            (list var#1? var#2? var#3? ':key var#4?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 5)
                       (bind var#1? (car fp1))
                       (bind var#2? (cadr fp1))
                       (bind var#3? (caddr fp1))
                       (or (eq ':key
                               (setq *tempreg* (caddr (cdr fp1))))
                           (qtrybind *tempreg* ':key))
                       (bind var#4?
                             (caddr (cddr fp1)))))
                (or
                  (trybind (setq *tempreg* (lderef fp2))
                           (list 'list (lderef var#5?)))
                  (and (consp *tempreg*)
                       (= (length *tempreg*) 2)
                       (or (eq 'list
                               (setq *tempreg* (lderef (car fp2))))
                           (qtrybind *tempreg* 'list))
                       (bind var#5? (cadr fp2))))
                (bind var#6? fp3)
                (change-stacks)
                (phi (lderef var#1?)
                     (lderef var#5?)
                     (lderef var#6?)
                     (append
                       (list (list 'phi
                                   var#3?
                                   (list 'list var#5?)
                                   var#6?)
                             (list 'phi
                                   var#2?
                                   (list var#5? '-> 'bool)
                                   var#6?)
                             (list 'phi
                                   var#4?
                                   (list var#5? '-> var#7?)
                                   var#6?))
                       continuation))))
             ((backtrack))))

(defun symbol-function&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'unit
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'unit))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun symbol-name&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun symbolp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun tail&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#2?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#2? (cadr fp2))))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#2?))
                        (lderef var#3?)
                        continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list 'sequent))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (or
                            (eq 'sequent
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'sequent))))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun tailp&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#4? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1? var#2?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 2)
                            (bind var#1? (car fp1))
                            (bind var#2? (cadr fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun terpri&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1?))
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#1? fp3)
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun time&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((backtrack))))

(defun unintern&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun union&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (bind var#1? (car fp1))
                   (bind var#2? (cadr fp1))
                   (bind var#3? (cddr fp1))
                   (or
                     (trybind (setq *tempreg*
                                    (lderef fp2))
                              (list 'list (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#4? (cadr fp2))))
                   (bind var#5? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'list (lderef var#4?))
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  var#2?
                                  (list 'list var#4?)
                                  var#5?)
                            (list 'adjoin-aux&
                                  var#3?
                                  (list 'list var#4?)
                                  var#5?))
                          continuation))))
             ((backtrack))))

(defun unsolved-nodes&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'proof
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun upper-case-p&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'character
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun var&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun warn&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun when&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#4?)
                        (append
                          (list
                            (list 'phi
                                  (cons 'progn
                                        (lderef var#2?))
                                  var#3?
                                  var#4?))
                          continuation))))
             ((backtrack))))

(defun write&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#3? var#2? var#4?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#3?)
                        (lderef var#4?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#4?))
                                continuation))))
             ((backtrack))))

(defun write-aux&
       (fp1 fp2 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':escape (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#3?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':radix (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#3?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':base (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#3?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':circle (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#3?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':pretty (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#3?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':level (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or 'bool 'integer)
                        (lderef var#3?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':length (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or 'bool 'integer)
                        (lderef var#3?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#3?))
                                continuation))))
             ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 1)
                   (eq ':gensym (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (cddr fp1))
                   (bind var#3? fp2)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'bool
                        (lderef var#3?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun write-line&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list
                            (list 'nstring-capitalize-aux&
                                  var#2?
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun write-string&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#3?)
                        (append
                          (list
                            (list 'nstring-capitalize-aux&
                                  var#2?
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun write-to-string&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#4? var#2? var#3?))
                   (consp fp1)
                   (> (length fp1) 0)
                   (bind var#1? (car fp1))
                   (bind var#2? (cdr fp1))
                   (or (eq 'string
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'string))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#4?)
                        (lderef var#3?)
                        (append (list (list 'write-aux&
                                            var#2?
                                            var#3?))
                                continuation))))
             ((backtrack))))

(defun y-or-n-p&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1?))
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#1? fp3)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun yes-or-no-p&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1?))
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#1? fp3)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'string
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun zerop&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'bool
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (list 'or
                              'integer
                              (list 'or 'rational 'float))
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun *&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'integer
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'rational
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'rational))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'float
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'float))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun +&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'integer
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'rational
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'rational))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'float
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'float))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun -&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'integer
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'rational
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'rational))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'float
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'float))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun /&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'rational
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'rational))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or
                     (qtrybind (setq *tempreg* fp2)
                               (list 'or 'integer 'rational))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (or (eq 'or
                                  (setq *tempreg* (car fp2)))
                              (qtrybind *tempreg* 'or))
                          (or
                            (eq 'integer
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* 'integer))
                          (or
                            (eq 'rational
                                (setq *tempreg* (lderef (caddr fp2))))
                            (qtrybind *tempreg* 'rational))))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'float
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'float))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun /=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun 1+&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'rational
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'rational))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'rational
                        (lderef var#2?)
                        continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'float
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'float))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'float
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun 1-&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'integer
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'integer))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'integer
                        (lderef var#2?)
                        continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'rational
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'rational))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'rational
                        (lderef var#2?)
                        continuation)))
             ((and (rename '(var#1? var#2?))
                   (or (qtrybind (setq *tempreg* fp1)
                                 (list var#1?))
                       (and (consp *tempreg*)
                            (= (length *tempreg*) 1)
                            (bind var#1? (car fp1))))
                   (or (eq 'float
                           (setq *tempreg* (lderef fp2)))
                       (qtrybind *tempreg* 'float))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        'float
                        (lderef var#2?)
                        continuation)))
             ((backtrack))))

(defun <&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun <=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun =&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun >&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun >=&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'integer
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'rational
                            (lderef var#2?)
                            continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (or (eq 'bool
                           (setq *tempreg* fp2))
                       (qtrybind *tempreg* 'bool))
                   (bind var#2? fp3)
                   (change-stacks)
                   (phi-rpt (lderef var#1?)
                            'float
                            (lderef var#2?)
                            continuation)))
             ((backtrack))))

(defun /.&
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#4?
                                    var#6?
                                    var#3?
                                    var#5?))
                   (or
                     (qtrybind (setq *tempreg* fp1)
                               (list (list var#1?) var#2?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (qtrybind (setq *tempreg* (car fp1))
                                      (list var#1?))
                            (and (consp *tempreg*)
                                 (= (length *tempreg*) 1)
                                 (bind var#1? (caar fp1))))
                          (bind var#2? (cadr fp1))))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list (lderef var#3?)
                                    '->
                                    (lderef var#4?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#3? (car fp2))
                          (or
                            (eq '->
                                (setq *tempreg* (lderef (cadr fp2))))
                            (qtrybind *tempreg* '->))
                          (bind var#4? (caddr fp2))))
                   (bind var#5? fp3)
                   (bind (lderef var#6?)
                         (gentemp "&&"))
                   (change-stacks)
                   (phi (lderef var#1?)
                        'symbol
                        (lderef var#5?)
                        (append
                          (list
                            (list 'phi
                                  (subst (lderef var#6?)
                                         (lderef var#1?)
                                         (lderef var#2?))
                                  var#4?
                                  (cons
                                    (list (lderef var#6?)
                                          '*
                                          (lderef var#3?))
                                    (lderef var#5?))))
                          continuation))))
             ((backtrack))))

(defun xmap
       (fp1 fp2)
       (apply 'map
              (cons 'list (cons fp1 fp2))))

(defun xmerge
       (fp1 fp2 fp3)
       (merge 'list fp1 fp2 fp3))

(defun xnth
       (fp1 fp2)
       (cond ((and (equal 0 fp1) (consp fp2)) (car fp2))
             ((and (> fp1 0) (consp fp2)) (xnth (1- fp1)
                                                (cdr fp2)))
             (t (raise "code 13: No Patterns have Fired in xnth"))))

(defun xposition
       (fp1 fp2)
       (or (position fp1 fp2) -1))

(defun xposition-if
       (fp1 fp2)
       (or (position-if fp1 fp2) -1))

(defun xprobe-file
       (fp1)
       (if (probe-file fp1)
           t
           nil))

(defun xstring/=
       (fp1 fp2)
       (if (null (string/= fp1 fp2))
           nil
           t))

(defun xstring<
       (fp1 fp2)
       (if (null (string< fp1 fp2))
           nil
           t))

(defun xstring<=
       (fp1 fp2)
       (if (null (string<= fp1 fp2))
           nil
           t))

(defun xstring=
       (fp1 fp2)
       (if (null (string= fp1 fp2))
           nil
           t))

(defun xstring>
       (fp1 fp2)
       (if (null (string> fp1 fp2))
           nil
           t))

(defun remove-assoc-type& (fp1 fp2 fp3 continuation)
  (cond ((and (rename '(var#1? var#2?))
              (or (qtrybind (setq *tempreg* fp1)
                            (list var#1?))
                  (and (consp *tempreg*)
                       (= (length *tempreg*)
                          1)
                       (bind var#1? (car fp1))))
              (or
                (trybind (setq *tempreg*
                               (lderef fp2))
                         (list 'list
                               (list 'list 'symbol)))
                (and (consp *tempreg*)
                     (= (length *tempreg*) 2)
                     (or
                       (eq 'list
                           (setq *tempreg* (lderef (car fp2))))
                       (qtrybind *tempreg* 'list))
                     (or
                       (trybind
                         (setq *tempreg* (lderef (cadr fp2)))
                         (list 'list 'symbol))
                       (and (consp *tempreg*)
                            (= (length *tempreg*)
                               2)
                            (or
                              (eq 'list
                                  (setq *tempreg* (lderef
                                                    (caadr fp2)))
                                        )
                              (qtrybind *tempreg* 'list))
                            (or
                              (eq 'symbol
                                  (setq *tempreg* (lderef
                                                    (cadar
                                                      (cdr fp2))))
                                        )
                              (qtrybind *tempreg* 'symbol))))))
              (bind var#2? fp3)
              (change-stacks)
              (phi (lderef var#1?)
                   'symbol
                   (lderef var#2?)
                   continuation)))
        ((backtrack))))

(defun add-assoc-type& (fp1 fp2 fp3 continuation)
  (cond ((and (rename '(var#1? var#2? var#3?))
              (or
                (qtrybind (setq *tempreg* fp1)
                          (list var#1? var#2?))
                (and (consp *tempreg*)
                     (= (length *tempreg*)
                        2)
                     (bind var#1? (car fp1))
                     (bind var#2? (cadr fp1))))
              (or
                (trybind (setq *tempreg*
                               (lderef fp2))
                         (list 'list
                               (list 'list 'symbol)))
                (and (consp *tempreg*)
                     (= (length *tempreg*) 2)
                     (or
                       (eq 'list
                           (setq *tempreg* (lderef (car fp2))))
                       (qtrybind *tempreg* 'list))
                     (or
                       (trybind
                         (setq *tempreg* (lderef (cadr fp2)))
                         (list 'list 'symbol))
                       (and (consp *tempreg*)
                            (= (length *tempreg*)
                               2)
                            (or
                              (eq 'list
                                  (setq *tempreg* (lderef
                                                    (caadr fp2)))
                                        )
                              (qtrybind *tempreg* 'list))
                            (or
                              (eq 'symbol
                                  (setq *tempreg* (lderef
                                                    (cadar
                                                      (cdr fp2))))
                                        )
                              (qtrybind *tempreg* 'symbol))))))
              (bind var#3? fp3)
              (change-stacks)
              (phi (lderef var#1?)
                   'symbol
                   (lderef var#3?)
                   (append
                     (list (list 'phi
                                 var#2?
                                 'symbol
                                 var#3?))
                     continuation))))
        ((backtrack))))
