;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)
(proclaim '(special kr::*buffer*))

(defun call-interface ()
 (declare (special kr::*buffer*))
 (update-statistics)
 (setq kr::*buffer* nil)
 (inter::main-event-loop)
 (terpri)
 (nreverse kr::*buffer*))

(defun alert ()
  (garnet-gadgets::display-error kr::type-error "TYPE ERROR")) 

(defun update-statistics () 
  (declare (special *tactical-inferences* start-time))
  (if (= 1 *tactical-inferences*)
      (kr::s-value kr::infs :string
       (format nil "~A inference" *tactical-inferences*))
      (kr::s-value kr::infs :string 
       (format nil "~A inferences" *tactical-inferences*)))
  (kr::s-value kr::tips :string
    (format nil "~A TIPS"  
      (round (/ *tactical-inferences*
         (calibrate (- (get-internal-run-time) start-time))))))
  (kr::s-value kr::cpu :string 
    (format nil "~A secs CPU"
       (calibrate (- (get-internal-run-time) start-time))))
  (opal::update kr::prooftool-window))

(defun update-everything ()
  (declare (special kr::prooftool-window kr::tactics-2-menu kr::theories-menu
                    kr::tactics-1-menu kr::tactics-0-menu kr::rewrites-menu))
(kr::s-value kr::prooftool-window :visible t)
(kr::s-value kr::tactics-2-menu :items *tactics2*)
(kr::s-value kr::tactics-1-menu :items *tactics1*)
(kr::s-value kr::tactics-0-menu :items *tactics0*)
(kr::s-value kr::rewrites-menu :items *rewrites*)
(kr::s-value kr::theories-menu :items *theories*)
(opal::notice-items-changed (kr::g-value kr::rewrites-menu :MENU-ITEM-LIST))
(opal::notice-items-changed (kr::g-value kr::tactics-2-menu :MENU-ITEM-LIST))
(opal::notice-items-changed (kr::g-value kr::tactics-1-menu :MENU-ITEM-LIST))
(opal::notice-items-changed (kr::g-value kr::tactics-0-menu :MENU-ITEM-LIST))
(opal::notice-items-changed (kr::g-value kr::theories-menu :MENU-ITEM-LIST))
(opal::update kr::prooftool-window))

(OPAL:CHANGE-GARNET-DISPLAY "csparc16")
;;----------------------------------------------------------------
;; create window

(in-package :kr)

(create-instance 'mainagg opal:aggregate)

(create-instance 'prooftool-window inter:interactor-window
      (:height 600)
      (:width (o-formula (+ (k) 350)))
      (:visible nil)
      (:title "Proof Tool")
      (:aggregate mainagg))

;;(create-instance 'buff opal:color
 ;; (:red 0.5)
  ;;(:green 0.5)
  ;;(:blue 0))

;;(create-instance 'background-colour opal:filling-style
 ;;  ;;(:background-color buff)
  ;; (:foreground-color buff)) 

;;(defun cc (FP1 FP2 FP3)
 ;; (s-value buff :RED FP1)
  ;;(s-value buff :GREEN FP2)
  ;;(s-value buff :BLUE FP3))

(create-instance 'background opal:rectangle
    (:height (o-formula (g-value prooftool-window :height)))
    (:width (o-formula (g-value prooftool-window :width)))
    (:filling-style opal:light-gray-fill))

(opal:add-component mainagg background)

(create-instance 'middle-down-button inter:button-interactor
  (:window prooftool-window)
  (:start-event :middledown)
  (:start-where (list :check-leaf-but-return-element mainagg))
  (:final-function #'(lambda (x y) (declare (ignore x y))
                         (inter:exit-main-event-loop))))

;;----------------------------------------------------------------
;; create offset 

(defun k ()
  (declare (special rewrites-menu tactics-2-menu))
  (if (> (g-value rewrites-menu :width) 150)
      (g-value rewrites-menu :width)
      (if (> (g-value tactics-2-menu :width) 150)
          (g-value tactics-2-menu :width)
          150)))

;;(setq *buffer* nil)
;;---------------------------------------------------------------
;; create error window

(create-instance 'type-error garnet-gadgets:error-gadget
  (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold))))

;;---------------------------------------------------------------
;; create rewrites-menu

(create-instance 'rewrites-menu garnet-gadgets:scrolling-menu
        (:items sequel::*rewrites*)
        (:left 25)
        (:top 50)
        (:height 200)
        (:item-font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:min-frame-width 150)
        (:num-visible 9)
        (:menu-selection-function 
           #'(lambda (x y) (prog2 (if (lhm (return-menu-item x y))
                                      (pushbuffer 'sequel::rewrite))
                                  (pushbuffer (return-menu-item x y))))))

(defun pushbuffer (item) 
   (display-item item)
   (do-push-buffer item))

(defun display-item (item)
  (cond ((member item '(sequel::done sequel::undo sequel::read)) t)
        ((scroll-menu-item item) (if (lhm item) 
                                     (format t "~A " (cdr item))))
        (t (format t "~A " item))))

(defun do-push-buffer (item)
  (cond ((scroll-menu-item item) (if (lhm item)
                                     (push-menu-item-on-buffer item)
                                     (call-pop-up-help (cdr item))))
        ((eq item 'sequel::done) (inter::exit-main-event-loop))
        ((eq item 'sequel::read) (pop-up-read))
        ((eq item 'sequel::undo) (format t "~%Re-enter> ") (setq *buffer* nil))
        (t (push item *buffer*))))

(defun scroll-menu-item (item)
  (and (consp item) (not (listp (cdr item)))))

(defun lhm (item) (eq (car item) :LEFTDOWN))

(defun push-menu-item-on-buffer (item) (push (cdr item) *buffer*))

(defun pop-up-read ()
  (declare (special read-window))
  (s-value read-window :visible t)
  (opal:update read-window))

(opal:add-component mainagg rewrites-menu)

(create-instance 'rewrites-menu-title opal:text
        (:string "Rewrites")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:top 25)
        (:left 70))
(opal:add-component mainagg rewrites-menu-title)
;;---------------------------------------------------------------------------
;; create pop-up read window

(create-instance 'readagg opal:aggregate)

(create-instance 'read-window inter:interactor-window
      (:left 400)
      (:top 400)
      (:height 100)
      (:width 300)
      (:visible nil)
      (:title "Pop Up Read")
      (:aggregate readagg))

(create-instance 'pop-up-read-box garnet-gadgets:labeled-box
   (:label-string "  > ")
   (:height (o-formula (- (g-value read-window :height) 50)))
   (:width (o-formula (- (g-value read-window :width) 100)))
   (:field-font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
   (:selection-function #'(lambda (x y) (declare (ignore x))
                                       (progn
                                         (pushbuffer (read-from-string y))
                                         (pop-down-read))))
   (:value "                                            "))

(defun pop-down-read ()
  (declare (special read-window pop-up-read-box))
  (s-value read-window :visible nil)
  (opal:update read-window)
  (s-value pop-up-read-box :value
                  "                                            "))

(opal:add-component readagg pop-up-read-box)
;;--------------------------------------------------------------
;; create pop-up help window

(create-instance 'helpagg opal:aggregate)

(create-instance 'pop-up-help-window inter:interactor-window
      (:left 40)
      (:top 40)
      (:height 200) 
      (:width 300)
      (:visible nil)
      (:title "Help")
      (:aggregate helpagg))

(defun calc-size-text (fp1) (cst1 (coerce fp1 'list) 0 0 0))

(defun cst1 (fp1 fp2 fp3 fp4)
  (declare (type list fp1) (type integer fp2) (type integer fp3) (type integer fp4))
  (the list
       (cond ((null fp1) (list (* fp3 7) (+ (* fp4 15) 100)))
             ((and (consp fp1) (equal #\Newline (car fp1)))
              (if (> fp2 fp3)
                  (cst1 (cdr fp1) 0 fp2 (1+ fp4))
                  (cst1 (cdr fp1) 0 fp3 (1+ fp4))))
             ((consp fp1) (cst1 (cdr fp1) (1+ fp2) fp3 fp4))
             (t (raise "code 13: No Patterns have Fired in cst1")))))

(create-instance 'pop-up-help opal:multi-text
        (:string "")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:top 10)
        (:left 10))

(create-instance 'help-button garnet-gadgets:text-button-panel
  (:items '("Done"))
  (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
  (:selection-function #'(lambda (x y) (declare (ignore x y))
                               (pop-down-help)))
  (:shadow-offset 0)
  (:top 10)
  (:left 10))

(opal:add-component helpagg help-button) 

(opal:add-component helpagg pop-up-help)

(defun call-pop-up-help (tactic)
  (declare (special pop-up-help help-button pop-up-help-window))
  (let* ((doc (sequel::get-document tactic))
        (dims (calc-size-text doc)))
  (s-value pop-up-help :string doc)
  (s-value pop-up-help-window :width (car dims))
  (s-value pop-up-help-window :height (cadr dims)) 
  (s-value help-button :top (- (cadr dims) 50))
  (s-value pop-up-help-window :visible t)
  (opal:update pop-up-help-window))) 

(defun pop-down-help ()
  (declare (special pop-up-help-window))
  (s-value pop-up-help-window :visible nil)
  (opal:update pop-up-help-window))
;;---------------------------------------------------------------
;; create tactics-2-menu

(create-instance 'tactics-2-menu garnet-gadgets:scrolling-menu
        (:items sequel::*tactics2*)
        (:top 300)
        (:left 25)
        (:item-font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:num-visible 9)
        (:min-frame-width 150)
        (:menu-selection-function 
           #'(lambda (x y) (pushbuffer (return-menu-item x y)))))

(defun return-menu-item (x y)
  (declare (ignore y))
  (cons
   (g-value (g-value x :selector) :start-char)
   (g-value (g-value (g-value x :selector) :remembered-last-object) :item)))

(opal:add-component mainagg tactics-2-menu)

(create-instance 'tactics-2-menu-title opal:text
        (:string "Type 2 Tactics")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:top 275)
        (:left 60))
(opal:add-component mainagg tactics-2-menu-title)
;;--------------------------------------------------------------
;; type 0 & 1 tactic menus

(create-instance 'tactics-1-menu garnet-gadgets:scrolling-menu
        (:items sequel::*tactics1*)
        (:item-font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:num-visible 9)
        (:min-frame-width 150)
        (:menu-selection-function
          #'(lambda (x y) (pushbuffer (return-menu-item x y))))) 

(create-instance 'tactics-1-window inter:interactor-window
   (:width (g-value tactics-1-menu :width))
   (:height (g-value tactics-1-menu :height)) 
   (:top 10)
   (:left 10)
   (:visible nil)
   (:title "Type 1 Tactics"))

(create-instance 't1agg opal:aggregadget)
(opal:add-component t1agg tactics-1-menu)
(s-value tactics-1-window :aggregate t1agg)

(create-instance 'tactics-0-menu garnet-gadgets:scrolling-menu
        (:items sequel::*tactics0*)
        (:item-font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:num-visible 9)
        (:min-frame-width 150)
        (:menu-selection-function
        #'(lambda (x y) (pushbuffer (return-menu-item x y)))))

(create-instance 'tactics-0-window inter:interactor-window
   (:width (g-value tactics-0-menu :width)) 
   (:height (g-value tactics-0-menu :height)) 
   (:visible nil)
   (:top 650)
   (:left 10)
   (:title "Type 0 Tactics"))

(create-instance 't0agg opal:aggregadget)
(opal:add-component t0agg tactics-0-menu)
(s-value tactics-0-window :aggregate t0agg)

;;-----------------------------------------------------
;; create primitives

(create-instance 'primitives garnet-gadgets:text-button-panel
          (:items '("Abort" "Back" "Inst" "Lemma" "Read" 
                    "Refine" "Rotate" "Swap" "Thin" 
                    "Undo" "XTT"))
          (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
          (:num-visible 9)
          (:v-spacing 8)
          (:selection-function 
             #'(lambda (x y) (pushbuffer (return-button-item x y))))
          (:shadow-offset 0)
          (:top 50)
          (:left (o-formula (+ (k) 70)))) 

(defun return-button-item (x y)
  (declare (special primitives) (ignore x))
  (cons (g-value (g-value primitives :BEHAVIORS) :start-char)
        (read-from-string y)))

(opal:add-component mainagg primitives)

(create-instance 'primitives-title opal:text
          (:string "Primitives")
          (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
          (:top 25)
          (:left (o-formula (+ (k) 73))))

(opal:add-component mainagg primitives-title)
;;-------------------------------------------------------------
;; create number pad

(create-instance 'number-pad garnet-gadgets:text-button-panel
        (:items '(" 7 " " 4 " " 1 " " 8 " " 5 " " 2 " " 9 " " 6 " " 3 "))
        (:num-visible 9)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:selection-function #'(lambda (x y) (declare (ignore x))
                               (pushbuffer (read-from-string y))))
        (:shadow-offset 0)
        (:left (o-formula (+ (k) 165)))
        (:top 415)
        (:rank-margin 3))

(opal:add-component mainagg number-pad)

(create-instance 'zero-button garnet-gadgets:text-button-panel
	(:items '("0"))
	(:num-visible 1)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:selection-function #'(lambda (x y) (declare (ignore x)) 
                                (pushbuffer (read-from-string y))))
	(:shadow-offset 0)
	(:top 540)
	(:left (o-formula (+ (k) 165)))
	(:fixed-width-size 115))
(opal:add-component mainagg zero-button)
;;---------------------------------------------------------------
;; type 1 and 0 tactics buttons

(create-instance 'type-0&1 garnet-gadgets:text-button-panel
          (:items '("Type 0" "Type 1"))
          (:direction :horizontal)
          (:selection-function #'(lambda (x y) (declare (ignore x))
                                     (popup-tactic-menu y)))
          (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
          (:num-visible 2)
          (:shadow-offset 0)
          (:fixed-width-size 82)
          (:top 540)
          (:left 25))

(defun popup-tactic-menu (x)
  (declare (special tactics-0-window tactics-1-window))
  (if (equal x "Type 0")
      (s-value tactics-0-window :visible t)
      (s-value tactics-1-window :visible t)))

(opal:add-component mainagg type-0&1)
;;--------------------------------------------------------------
;; create theories-menu

(create-instance 'theories-menu garnet-gadgets:scrolling-menu
	(:items sequel::*theories*)
        (:item-font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 260)
	(:min-frame-width 130)
        (:menu-selection-function
            #'(lambda (x y) (pushbuffer (return-menu-item x y))))          
	(:num-visible 5)
	(:left (o-formula (+ (k) 150))))

(opal:add-component mainagg theories-menu)

(create-instance 'theories-menu-title opal:text
	(:string "Theories")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 240)
	(:left (o-formula (+ (k) 200))))

(opal:add-component mainagg theories-menu-title)
;;---------------------------------------------------------------
;; create statistics box

(create-instance 'statistics-title opal:text
        (:string "Statistics")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:top 110)
        (:left (o-formula (+ (k) 195))))

(opal:add-component mainagg statistics-title)

(create-instance 'statsrect opal:rectangle
	(:top 130)
	(:left (o-formula (+ (k) 150)))
	(:width 150)
        (:filling-style opal:white-fill)
	(:height 90))

(opal:add-component mainagg statsrect)

(create-instance 'INFS opal:text
	(:string "0 inferences")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 150)
	(:left (o-formula (+ (k) 165))))

(opal:add-component mainagg INFS)

(create-instance 'CPU opal:text
	(:string "0 secs CPU")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 170)
	(:left (o-formula (+ (k) 165))))

(opal:add-component mainagg CPU)

(create-instance 'TIPS opal:text
	(:string "0 TIPS")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 190)
	(:left (o-formula (+ (k) 165))))

(opal:add-component mainagg TIPS)
;;---------------------------------------------------------------
;;  name, author & date

(create-instance 'name-box opal:rectangle 
    (:top 5)
    (:filling-style opal:white-fill)
    (:left (o-formula (+ (k) 150)))
    (:width 150)
    (:height 90))
     
(opal:add-component mainagg name-box)

(create-instance 'NAME opal:text
        (:string sequel::*framework*)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)
                    (:size :large)))
        (:top 10)
        (:left (o-formula (+ (k) 175))))

(opal:add-component mainagg NAME)

(create-instance 'AUTHOR opal:text
        (:string sequel::*author*)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:top 40)
        (:left (o-formula (+ (k) 165))))

(opal:add-component mainagg AUTHOR)

(create-instance 'DATE opal:text
        (:string sequel::*date*)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:top 60)
        (:left (o-formula (+ (k) 165))))

(opal:add-component mainagg DATE)
;;-------------------------------------------------
;; change scrolling menu behaviour to activate right-hand mouse button 

(s-value (car (g-value primitives :BEHAVIORS)) :START-EVENT
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (car (g-value tactics-2-menu :BEHAVIORS)) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (car (g-value tactics-2-menu :BEHAVIORS)) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (car (g-value tactics-1-menu :BEHAVIORS)) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (car (g-value tactics-0-menu :BEHAVIORS)) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (car (g-value rewrites-menu :BEHAVIORS)) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (car (g-value theories-menu :BEHAVIORS)) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
