/*
;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================| */

#include <math.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>     /* Get standard string definations. */
#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/List.h>

#define TRUE 1
#define FALSE 0
#define	NumberOfButtons	11

String	fallback_resources[] = {
	 "*Box.borderWidth:	0",
	 "*Box.vSpace:	10",
	 "*Label.borderWidth:	0",
	 "*List.borderWidth:	0",
	 "*Viewport.borderWidth:	3",
	 "*Viewport.borderColor:	dark green",
	 "*List.font:	-schumacher-clean-bold-*-*-*-*-160-*-*-*-*-*-*",
	 "*Label.font:	-schumacher-clean-bold-*-*-*-*-160-*-*-*-*-*-*",
	 "*Form.background:	OldLace",
	 "*Box.background:	OldLace",
	 "*Label.background:	OldLace",
	 "*Dialog.background:	gray70",
	 "*Dialog.borderColor:	dark green",
	 "*Dialog.foreground:	white",
	 "*Dialog.font:	-adobe-times-bold-r-normal--14-140-75-75-p-77-iso8859-1",
	 "*Dialog.borderWidth: 3",
	 "*Dialog.Width: 200",
	 "*Command.background:	gray70",
	 "*Command.borderColor:	dark green",
	 "*Command.foreground:	black",
	 "*Command.font:	-adobe-times-bold-r-normal--14-140-75-75-p-77-iso8859-1",
	 "*Command.borderWidth: 3",
	 "*AlertText.font: -*-*-bold-*-*-*-*-200-*-*-*-*-*-*",
	 "*TitleBox.font: -*-*-bold-*-*-*-*-350-*-*-*-*-*-*",
	 "*StatisticsBox.borderWidth: 3",
	 "*StatisticsBox.background: white",
	 "*StatisticsBox.borderColor: darkgreen",
         "*translations: #augment \\n <Btn2Down>: Terminate()",
	NULL
	};

static XrmOptionDescRec	options[] = { NULL };

XtAppContext	app_con;

void  Unhelp(), Help(), ListHelp(), Terminate();
Boolean terminate_loop;


static   XtActionsRec additionalCommandActionTable[] = {
      {"Help",    Help},
      {"ListHelp",      ListHelp},
      {"Terminate",      Terminate},
   };

static String  newTranslations =
   "<Btn3Down>: Help()\n";

static String  newListTranslations =
   "<Btn3Down>: Set() ListHelp()\n\
    <Btn3Up>:  Unset()\n";


XtTranslations parsedNewTranslations;
XtTranslations parsedNewListTranslations;


Widget	top_level,top_panel,title_2_box,title_box,statistics_box;
Widget	number_box,number_panel_item[10];
Widget	button_label,button_panel;
Widget	button_box,button_panel_item[12];
Widget	menu_0_label,tactic_menu_0_panel;
Widget	menu_1_label,tactic_menu_1_panel;
Widget	menu_2_label,tactic_menu_2_panel;
Widget	tactic_menu_0_viewport,tactic_menu_0_list;
Widget	tactic_menu_1_viewport,tactic_menu_1_list;
Widget	tactic_menu_2_viewport,tactic_menu_2_list;
Widget	tactic_menu_0_popup, tactic_menu_0_button;
Widget	tactic_menu_1_popup, tactic_menu_1_button;
Widget	rules_menu_panel,rules_menu_label;
Widget	rules_menu_viewport,rules_menu_list;
Widget	theories_menu_panel,theories_menu_label;
Widget	theories_menu_viewport,theories_menu_list;
Widget	popup_read_frame,read_dialog;
Widget  help_popup, help_panel, help_label, help_button;
Widget  alert_popup, alert_panel, alert_label, alert_button;

void	dismiss();
void	menu_stuff();
void	button_stuff();
void	read_callback();
void	read_stuff();
void	summon_menu();
void	update_menu();
void	update();
void	UpdateWidget();
/*============================================================================
=                                                                            =
=  Foreign lisp functions called by C to get menu prompts                    =
=                                                                            =
============================================================================*/
String get_rewrite_prompt();
String get_theories_prompt();
String get_tactics_0_prompt();
String get_tactics_1_prompt();
String get_tactics_2_prompt();
/*============================================================================
=                                                                            =
=  Default content for menu elements                                         =
=                                                                            =
============================================================================*/
String	full_menu_prompts[] = {"A","B","C","D","E","F","G","H","I","J"};
String	*rules_prompts = NULL;
String	*theories_prompts = NULL;
String	*tactics_menu_0_prompts = NULL;
String	*tactics_menu_1_prompts = NULL;
String	*tactics_menu_2_prompts = NULL;

char		statistics_buffer[200];
char		title_2_buffer[200];
/*============================================================================
=                                                                            =
=  Arrays containing labels for buttons                                      =
=                                                                            =
============================================================================*/

char	*button_name[] = {"ABORT","BACK","INST","LEMMA","READ","REFINE",
	"ROTATE","SWAP","THIN","UNDO","XTT"};
char	*digit[] = { "0","1","2","3","4","5","6","7","8","9" };



/*============================================================================
=                                                                            =
=  Main program defines top level window, calls create_windows() to fill     =
=  it.                                                                       =
=                                                                            =
============================================================================*/
windows()
	{
		int	argc = 0;
		char	**argv = NULL;
		top_level = XtAppInitialize(&app_con,
			"SEQUEL",
			options,0,
			&argc,argv,
			fallback_resources,
			NULL,ZERO);



		XtAppAddActions(app_con,additionalCommandActionTable,3);

		parsedNewTranslations = XtParseTranslationTable(newTranslations);
		parsedNewListTranslations = XtParseTranslationTable(newListTranslations);

		top_panel = XtVaCreateManagedWidget("NumberPanel",
			formWidgetClass,
			top_level,
			NULL,ZERO);

		create_windows();
		XtRealizeWidget(top_level);
		XStoreName(XtDisplay(top_level),
			XtWindow(top_level),
			"Proof Tool Interface");
	}

/*============================================================================
=                                                                            =
=  Procedure to generate sub-elements of application window                  =
=                                                                            =
============================================================================*/

create_windows()
	{
		create_rules_menu();
		create_tactic_menu_2();
		create_button();
		create_title_box();
		create_statistics_box();
		create_theories_menu();
		create_tactic_menu_1();
		create_tactic_menu_0();
		create_number();
		create_popup();
		create_help_window();
		create_alert();
	}

/*============================================================================
=                                                                            =
=  generates a popup window for the read button input			     =
=                                                                            =
============================================================================*/

create_popup()
	{
		popup_read_frame = XtCreatePopupShell("ReadPopup",
			topLevelShellWidgetClass,
			top_level,
			NULL,ZERO);

		read_dialog = XtVaCreateManagedWidget("ReadDialog",
			dialogWidgetClass,
			popup_read_frame,
			XtNlabel,	(XtArgVal)"input>",
			XtNvalue,	(XtArgVal)"                              ",
			NULL);

		XtVaSetValues(read_dialog,
			XtNvalue,   (XtArgVal)"",
         NULL);


		XawDialogAddButton(read_dialog,"DONE",read_stuff,0);
	}

/*============================================================================
=                                                                            =
=  generates a title box within the application window                       =
=                                                                            =
============================================================================*/

create_title_box()
	{
		title_box = XtVaCreateManagedWidget("TitleBox",
			labelWidgetClass,
			top_panel,
			XtNfromHoriz,	(XtArgVal) button_panel,
			XtNlabel,	(XtArgVal)"Tableau",
			XtNresize,	(XtArgVal) TRUE,
			XtNresizable, (XtArgVal) TRUE,
			NULL);
		title_2_box = XtVaCreateManagedWidget("TitleBox2",
			labelWidgetClass,
			top_panel,
			XtNlabel,	(XtArgVal)"Mark Tarver\n8-3-92",
			XtNfromHoriz,	(XtArgVal) button_panel,
			XtNfromVert,	title_box,
			XtNresize,	(XtArgVal) TRUE,
			XtNresizable, (XtArgVal) TRUE,
			NULL);
	}


/*============================================================================
=                                                                            =
=  generates a statistics box within the application window                  =
=                                                                            =
============================================================================*/

create_statistics_box()
	{
		statistics_box = XtVaCreateManagedWidget("StatisticsBox",
			labelWidgetClass,
			top_panel,
			XtNlabel,	(XtArgVal)"0 inferences\n0.00 secs CPU \n0 TIPS",
			XtNfromVert,	title_2_box,
			XtNfromHoriz,	(XtArgVal) button_panel,
			XtNwidth,	(XtArgVal) 140,
			NULL);
	}

initialise_statistics()
	{
		sprintf(statistics_buffer,"0 inferences\n0.00 secs CPU \n0 TIPS");
		XtVaSetValues(statistics_box,
			XtNlabel,   (XtArgVal)strdup(statistics_buffer),
         NULL);
	}


c_update_statistics(tactical_inferences,cpu_time)
	int	tactical_inferences;
	float	cpu_time;
	{
		sprintf(statistics_buffer,
			"%d inferences\n%.2f secs CPU \n%.2f TIPS",
			tactical_inferences,
			cpu_time,
			(float)(tactical_inferences/cpu_time));

		XtVaSetValues(statistics_box,
			XtNlabel,   (XtArgVal)strdup(statistics_buffer),
			NULL);

		XClearArea(XtDisplay(statistics_box),
			XtWindow(statistics_box),
			0,0,0,0,
			TRUE);

                update();

	}

/*============================================================================
=                                                                            =
=  Generates element containing number buttons                               =
=                                                                            =
============================================================================*/

create_number()
	{
		number_box = XtVaCreateManagedWidget("NumberBox",
			formWidgetClass,
			top_panel,
			XtNfromHoriz,	button_panel,
			XtNfromVert,	tactic_menu_1_button,
			XtNwidth,	(XtArgVal)142,
			XtNdefaultDistance,	(XtArgVal) 16,
			NULL);

		number_panel_item[7] = XtVaCreateManagedWidget(digit[7],
			commandWidgetClass,
			number_box,
			XtNwidth,	(XtArgVal) 20,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);

		XtAddCallback(number_panel_item[7],XtNcallback,button_stuff,digit[7]);
		number_panel_item[4] = XtVaCreateManagedWidget(digit[4],
			commandWidgetClass,
			number_box,
			XtNfromVert, (XtArgVal)number_panel_item[7],
			XtNwidth,	(XtArgVal) 20,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);
			

		XtAddCallback(number_panel_item[4],XtNcallback,button_stuff,digit[4]);
		number_panel_item[1] = XtVaCreateManagedWidget(digit[1],
			commandWidgetClass,
			number_box,
			XtNfromVert, (XtArgVal)number_panel_item[4],
			XtNwidth,	(XtArgVal) 20,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);

		XtAddCallback(number_panel_item[1],XtNcallback,button_stuff,digit[1]);

		number_panel_item[8] = XtVaCreateManagedWidget(digit[8],
			commandWidgetClass,
			number_box,
			XtNfromHoriz, (XtArgVal)number_panel_item[7],
			XtNwidth,	(XtArgVal) 20,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);

		XtAddCallback(number_panel_item[8],XtNcallback,button_stuff,digit[8]);

		number_panel_item[5] = XtVaCreateManagedWidget(digit[5],
			commandWidgetClass,
			number_box,
			XtNfromVert, (XtArgVal)number_panel_item[8],
			XtNfromHoriz, (XtArgVal)number_panel_item[4],
			XtNwidth,	(XtArgVal) 20,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);

		XtAddCallback(number_panel_item[5],XtNcallback,button_stuff,digit[5]);
		number_panel_item[2] = XtVaCreateManagedWidget(digit[2],
			commandWidgetClass,
			number_box,
			XtNfromVert, (XtArgVal)number_panel_item[5],
			XtNfromHoriz, (XtArgVal)number_panel_item[1],
			XtNwidth,	(XtArgVal) 20,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);

		XtAddCallback(number_panel_item[2],XtNcallback,button_stuff,digit[2]);
		number_panel_item[0] = XtVaCreateManagedWidget(digit[0],
			commandWidgetClass,
			number_box,
			XtNfromVert, (XtArgVal)number_panel_item[2],
			XtNwidth,	(XtArgVal) 106,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);

		XtAddCallback(number_panel_item[0],XtNcallback,button_stuff,digit[0]);

		number_panel_item[9] = XtVaCreateManagedWidget(digit[9],
			commandWidgetClass,
			number_box,
			XtNfromHoriz, (XtArgVal)number_panel_item[8],
			XtNwidth,	(XtArgVal) 20,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);

		XtAddCallback(number_panel_item[9],XtNcallback,button_stuff,digit[9]);

		number_panel_item[6] = XtVaCreateManagedWidget(digit[6],
			commandWidgetClass,
			number_box,
			XtNfromHoriz, (XtArgVal)number_panel_item[5],
			XtNfromVert, (XtArgVal)number_panel_item[9],
			XtNwidth,	(XtArgVal) 20,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);

		XtAddCallback(number_panel_item[6],XtNcallback,button_stuff,digit[6]);
		number_panel_item[3] = XtVaCreateManagedWidget(digit[3],
			commandWidgetClass,
			number_box,
			XtNfromHoriz, (XtArgVal)number_panel_item[5],
			XtNfromVert, (XtArgVal)number_panel_item[5],
			XtNwidth,	(XtArgVal) 20,
			XtNheight,	(XtArgVal) 20,
			XtNhorizDistance,	(XtArgVal) 16,
			XtNvertDistance,	(XtArgVal) 10,
			ZERO);

		XtAddCallback(number_panel_item[3],XtNcallback,button_stuff,digit[3]);


	}

/*============================================================================
=                                                                            =
=  Generates element containing command buttons                              =
=                                                                            =
============================================================================*/

create_button()
	{
		int	i;
		button_panel = XtVaCreateManagedWidget("ButtonPanel",
			boxWidgetClass,
			top_panel,
			XtNfromHoriz,	rules_menu_panel,
			ZERO);

		button_label = XtVaCreateManagedWidget("ButtonLabel",
			labelWidgetClass,
			button_panel,
			XtNlabel,	"Primitives",
			ZERO);


		button_box = XtVaCreateManagedWidget("ButtonBox",
			boxWidgetClass,
			button_panel,
			ZERO);

		for(i=0;i<NumberOfButtons;i++)
			{
				button_panel_item[i] = XtVaCreateManagedWidget(button_name[i],
					commandWidgetClass,
					button_box,
					XtNwidth,	(XtArgVal)90,
					NULL,ZERO);

				if (strcmp(button_name[i],"READ"))
					XtAddCallback(button_panel_item[i],
						XtNcallback,
						button_stuff,
						button_name[i]);
				else
				XtAddCallback(button_panel_item[i],
					XtNcallback,
					read_callback,
					button_name[i]);


				XtAugmentTranslations(button_panel_item[i],
					parsedNewTranslations);

			}
	}

/*============================================================================
=                                                                            =
=  Procedures to create the tactics menus                                    =
=                                                                            =
============================================================================*/

create_tactic_menu_2()
	{
		tactic_menu_2_panel = XtVaCreateManagedWidget("TacticMenu",
			boxWidgetClass,
			top_panel,
			XtNfromVert,	(XtArgVal) rules_menu_panel,
			XtNresizable,	(XtArgVal) FALSE,
			ZERO);

		menu_2_label = XtVaCreateManagedWidget("MenuLabel",
			labelWidgetClass,
			tactic_menu_2_panel,
			XtNlabel,(XtArgVal)"Type Two Tactics",
			XtNborderWidth,(XtArgVal)0,
			ZERO);

		tactic_menu_2_viewport = XtVaCreateManagedWidget("MenuViewport",
			viewportWidgetClass,
			tactic_menu_2_panel,
			XtNallowVert,	(XtArgVal)TRUE,
			ZERO);

		tactic_menu_2_list = XtVaCreateManagedWidget("MenuList_1",
			listWidgetClass,
			tactic_menu_2_viewport,
			XtNforceColumns,	(XtArgVal)TRUE,
			XtNdefaultColumns,(XtArgVal)1,
			XtNlist,(XtArgVal)full_menu_prompts,
			XtNnumberStrings,	(XtArgVal) 10,
			XtNlongest, 250,
			ZERO);


		XtAugmentTranslations(tactic_menu_2_list,
			parsedNewListTranslations);

		XtAddCallback(tactic_menu_2_list,XtNcallback,menu_stuff,NULL);

	}

create_tactic_menu_1()
	{
		tactic_menu_1_popup = XtCreatePopupShell("Type One Tactics",
			topLevelShellWidgetClass,
			top_level,
			NULL,ZERO);

		tactic_menu_1_button = XtVaCreateManagedWidget("TacticMenu_1_button",
			commandWidgetClass,
			top_panel,
			XtNlabel, (XtArgVal) "Type One",
			XtNfromHoriz, (XtArgVal) button_panel,
			XtNfromVert, (XtArgVal) theories_menu_panel,
			ZERO);

		XtAddCallback(tactic_menu_1_button,XtNcallback,summon_menu,1);

		tactic_menu_1_panel = XtVaCreateManagedWidget("TacticMenu_1",
			boxWidgetClass,
			tactic_menu_1_popup,
			ZERO);

		menu_1_label = XtVaCreateManagedWidget("MenuLabel",
			labelWidgetClass,
			tactic_menu_1_panel,
			XtNlabel,(XtArgVal)"Type One Tactics",
			XtNborderWidth,(XtArgVal)0,
			ZERO);

		tactic_menu_1_viewport = XtVaCreateManagedWidget("MenuViewport_1",
			viewportWidgetClass,
			tactic_menu_1_panel,
			XtNallowVert,	(XtArgVal)TRUE,
			ZERO);

		tactic_menu_1_list = XtVaCreateManagedWidget("MenuList_1",
			listWidgetClass,
			tactic_menu_1_viewport,
			XtNforceColumns,	(XtArgVal)TRUE,
			XtNdefaultColumns,(XtArgVal)1,
			XtNlist,(XtArgVal)full_menu_prompts,
			XtNnumberStrings,	(XtArgVal) 10,
			XtNlongest, 240,
			ZERO);

 		XtAugmentTranslations(tactic_menu_1_list,
			parsedNewListTranslations);

		XtAddCallback(tactic_menu_1_list,XtNcallback,menu_stuff,NULL);

	}

create_tactic_menu_0()
	{
		tactic_menu_0_popup = XtCreatePopupShell("Type Zero Tactics",
			topLevelShellWidgetClass,
			top_level,
			NULL,ZERO);

		tactic_menu_0_button = XtVaCreateManagedWidget("TacticMenu_0_button",
			commandWidgetClass,
			top_panel,
			XtNlabel,	(XtArgVal) "Type Zero",
			XtNfromHoriz, (XtArgVal) tactic_menu_1_button,
			XtNfromVert, (XtArgVal) theories_menu_panel,
			ZERO);

		XtAddCallback(tactic_menu_0_button,XtNcallback,summon_menu,0);


		tactic_menu_0_panel = XtVaCreateManagedWidget("TacticMenu_0",
			boxWidgetClass,
			tactic_menu_0_popup,
			ZERO);

		menu_0_label = XtVaCreateManagedWidget("MenuLabel",
			labelWidgetClass,
			tactic_menu_0_panel,
			XtNlabel,(XtArgVal)"Type Zero Tactics",
			XtNborderWidth,(XtArgVal)0,
			ZERO);

		tactic_menu_0_viewport = XtVaCreateManagedWidget("MenuViewport_0",
			viewportWidgetClass,
			tactic_menu_0_panel,
			XtNallowVert,	(XtArgVal)TRUE,
			ZERO);

		tactic_menu_0_list = XtVaCreateManagedWidget("MenuList_0",
			listWidgetClass,
			tactic_menu_0_viewport,
			XtNforceColumns,	(XtArgVal)TRUE,
			XtNdefaultColumns,(XtArgVal)1,
			XtNlist,(XtArgVal)full_menu_prompts,
			XtNnumberStrings,	(XtArgVal) 10,
			XtNlongest, 240,
			ZERO);

 		XtAugmentTranslations(tactic_menu_0_list,
			parsedNewListTranslations);

		XtAddCallback(tactic_menu_0_list,XtNcallback,menu_stuff,NULL);
	}

/*============================================================================
=                                                                            =
=  Procedure to create the rules menu                                        =
=                                                                            =
============================================================================*/

create_rules_menu()
	{
		rules_menu_panel = XtVaCreateManagedWidget("RulesMenu",
			boxWidgetClass,
			top_panel,
			XtNresizable,	(XtArgVal) FALSE,
			ZERO);

		rules_menu_label = XtVaCreateManagedWidget("RulesMenuLabel",
			labelWidgetClass,
			rules_menu_panel,
			XtNlabel,(XtArgVal)"Rewrite Rules",
			XtNborderWidth,(XtArgVal)0,
			ZERO);

		rules_menu_viewport = XtVaCreateManagedWidget("RulesMenuViewport",
			viewportWidgetClass,
			rules_menu_panel,
			XtNallowVert,	(XtArgVal)TRUE,
			ZERO);

		rules_menu_list = XtVaCreateManagedWidget("RulesMenuList",
			listWidgetClass,
			rules_menu_viewport,
			XtNforceColumns,	(XtArgVal)TRUE,
			XtNdefaultColumns,(XtArgVal)1,
			XtNlist,(XtArgVal)full_menu_prompts,
			XtNnumberStrings,	(XtArgVal) 10,
			XtNlongest, 250,
			ZERO);

 		XtAugmentTranslations(rules_menu_list,
			parsedNewListTranslations);

		XtAddCallback(rules_menu_list,XtNcallback,menu_stuff,NULL);
	}


/*============================================================================
=                                                                            =
=  Procedure to create the theories menu                                     =
=                                                                            =
============================================================================*/

create_theories_menu()
	{
		theories_menu_panel = XtVaCreateManagedWidget("TheoriesMenu",
			boxWidgetClass,
			top_panel,
			XtNresizable,	(XtArgVal) FALSE,
			XtNfromVert,	statistics_box,
			XtNfromHoriz,	(XtArgVal) button_panel,
			ZERO);

		theories_menu_label = XtVaCreateManagedWidget("TheoriesMenuLabel",
			labelWidgetClass,
			theories_menu_panel,
			XtNlabel,(XtArgVal)"Theories",
			XtNborderWidth,(XtArgVal)0,
			ZERO);

		theories_menu_viewport = XtVaCreateManagedWidget("TheoriesMenuViewport",
			viewportWidgetClass,
			theories_menu_panel,
			XtNallowVert,	(XtArgVal)TRUE,
			ZERO);

		theories_menu_list = XtVaCreateManagedWidget("TheoriesMenuList",
			listWidgetClass,
			theories_menu_viewport,
			XtNforceColumns,	(XtArgVal)TRUE,
			XtNdefaultColumns,(XtArgVal)1,
			XtNlist,(XtArgVal)full_menu_prompts,
			XtNnumberStrings,	(XtArgVal) 5,
			XtNlongest, 140,
			NULL,ZERO);

 		XtAugmentTranslations(theories_menu_list,
			parsedNewListTranslations);

		XtAddCallback(theories_menu_list,XtNcallback,menu_stuff,NULL);

	}


/*============================================================================
=                                                                            =
=  Procedure to create the online help window                                =
=                                                                            =
============================================================================*/

/* Changed "HelpPopup" to "Help" - Mark */

create_help_window()
	{
		help_popup = XtVaCreatePopupShell("Help",
			topLevelShellWidgetClass,
			top_level,
			ZERO);

		help_panel =XtVaCreateManagedWidget("HelpPanel",
			boxWidgetClass,
			help_popup,
			ZERO);

		help_label = XtVaCreateManagedWidget("HelpText",
			labelWidgetClass,
			help_panel,
			NULL);

		help_button = XtVaCreateManagedWidget("HelpButton",
			commandWidgetClass,
			help_panel,
			XtNlabel, (XtArgVal) "DONE",
			NULL);

		XtAddCallback(help_button,XtNcallback,Unhelp,NULL);
	}



/*============================================================================
=                                                                            =
=  Procedure to create the type error window                                 =
=                                                                            =
============================================================================*/

create_alert()
	{
		alert_popup = XtVaCreatePopupShell("",
			topLevelShellWidgetClass,
			top_level,
			XtNx,(XtArgVal) 400,
			XtNy,(XtArgVal) 400,
			ZERO);

		alert_panel =XtVaCreateManagedWidget("AlertPanel",
			boxWidgetClass,
			alert_popup,
			ZERO);

		alert_label = XtVaCreateManagedWidget("AlertText",
			labelWidgetClass,
			alert_panel,
			XtNlabel, (XtArgVal)"Type Error",
			NULL);

		alert_button = XtVaCreateManagedWidget("AlertButton",
			commandWidgetClass,
			alert_panel,
			XtNlabel, (XtArgVal) "DISMISS",
			NULL);

		XtAddCallback(alert_button,XtNcallback,dismiss,NULL);
	}


/*============================================================================
=                                                                            =
=  Function called by buttons to pass text to Sequel                         =
=  client_data contains pointer to string to pass                            =
=                                                                            =
============================================================================*/

void	button_stuff(w,client_data,call_data)
	Widget	w;
	XtPointer	client_data,	call_data;
	
	{
		extern	char 	*update_buffer();
		c_update_buffer(client_data);
		if (strcmp("UNDO",client_data))
			printf("%s ",client_data);
		fflush(stdout);
	}

/*============================================================================
=                                                                            =
=  Function called by menus to pass text to Sequel                           =
=  call_data contains pointer to structure containing string to pass         =
=                                                                            =
============================================================================*/

void	menu_stuff(w,client_data,call_data)
	Widget	w;
	XtPointer	client_data,	call_data;
	
	{
		extern	char 	*update_buffer();
		XawListReturnStruct *message = (XawListReturnStruct *) call_data;
		if (w == rules_menu_list)
			{
				printf("REWRITE ");
				c_update_buffer("rewrite");
			}
		printf("%s ",message->string);
		fflush(stdout);
		c_update_buffer(message->string);
		XawListUnhighlight(w);
	}


/*============================================================================
=                                                                            =
=  Function called by read button to prompt for input                        =
=                                                                            =
============================================================================*/

void	read_callback(w,client_data,call_data)
	Widget	w;
	XtPointer	client_data,	call_data;
	
	{
		extern	char 	*update_buffer();
		XtPopup(popup_read_frame,XtGrabExclusive);
	}


/*============================================================================
=                                                                            =
=  Function called by read menu buttons to popup menu                        =
=                                                                            =
============================================================================*/

void	summon_menu(w,client_data,call_data)
	Widget	w;
	XtPointer	client_data,	call_data;
	
	{
		switch (client_data)
			{
				case 0 : XtPopup(tactic_menu_0_popup,XtGrabNone);
					 break;
				case 1 : XtPopup(tactic_menu_1_popup,XtGrabNone);
			}
	}


/*============================================================================
=                                                                            =
=  Function called by read panel to pass text to sequel                      =
=                                                                            =
============================================================================*/

void	read_stuff(w,client_data,call_data)
	Widget	w;
	XtPointer	client_data,	call_data;
	
	{
		extern	char 	*update_buffer();
		String message;
		message = XawDialogGetValueString(read_dialog);
		printf("%s ",message);
		fflush(stdout);
		c_update_buffer(message);
		XtPopdown(popup_read_frame);
	}

/*============================================================================
=                                                                            =
=  Function called by sequel to reload contents of menus                     =
=                                                                            =
============================================================================*/

void   c_update_everything()
	{
		void	c_update_tactics_windows();
		void	c_update_theories_menu();
		void	c_update_rewrites_menu();
		void	c_update_titles();
		c_update_titles();
		c_update_tactics_windows();
		initialise_statistics();
		c_update_theories_menu();
		c_update_rewrites_menu();

		XClearArea(XtDisplay(top_panel),
			XtWindow(top_panel),
			0,0,0,0,
			TRUE);
	}

void	c_update_tactics_windows()
	{
		update_menu(tactic_menu_2_list,&tactics_menu_2_prompts,get_tactics_2_prompt);

		update_menu(tactic_menu_1_list,&tactics_menu_1_prompts,get_tactics_1_prompt);

		update_menu(tactic_menu_0_list,&tactics_menu_0_prompts,get_tactics_0_prompt);
	}

void	c_update_theories_menu()
	{
		update_menu(theories_menu_list,&theories_prompts,get_theories_prompt);
	}


void	c_update_rewrites_menu()
	{
		update_menu(rules_menu_list,&rules_prompts,get_rewrite_prompt);
	}

void	c_update_titles()
	{
		void	c_update_title();
		void	c_update_title_2();
		c_update_title();
		c_update_title_2();
	}

void	c_update_title()
	{
		extern	char *get_title();
		String	x;
		x = get_title();
		XtUnmanageChild(top_panel);
		XtVaSetValues(title_box,
			XtNlabel,	(XtArgVal)strdup(x),
			NULL);
		XtManageChild(top_panel);
	}

void	c_update_title_2()
	{
                extern  char *get_date(),*get_author();

		sprintf(title_2_buffer,"%s\n%s\n",get_author(),get_date());
		XtVaSetValues(title_2_box,
			XtNlabel,	(XtArgVal)strdup(title_2_buffer),
			NULL);
	}




/*============================================================================
=                                                                            =
=  Error alert function                                                      =
=                                                                            =
============================================================================*/

void	alert()
	{
		XtPopup(alert_popup,XtGrabExclusive);
	}


/*============================================================================
=                                                                            =
=  Refresh loop to update windows                                              =
=                                                                            =
============================================================================*/

void	update()
	{
		XEvent	event;
		while(!XtAppPending(app_con));
		while(XtAppPending(app_con))
		{
			XtAppNextEvent(app_con,&event);
			XtDispatchEvent(&event);
		}
	}




/*============================================================================
=                                                                            =
=  Main X Event processing loop                                              =
=                                                                            =
============================================================================*/

loop()
	{
		XEvent	event;
                terminate_loop = FALSE;
                while (!terminate_loop)
                {
                        XtAppNextEvent(app_con,&event);
                        XtDispatchEvent(&event);
                }
		printf("\n");
	}


/*============================================================================
= 
=
=  New Button Action procedures
=
=
=
============================================================================*/

void  Help(w,event,params,num_params)
   Widget   w;
   XEvent   *event;
   String   *params;
   Cardinal *num_params;
   {
      extern char *get_help();
      String	selection;
      Dimension height, width;
      XtVaGetValues(w,XtNlabel,&selection,ZERO);
      XtUnmanageChild(help_panel);
      XtVaSetValues(help_label,
         XtNlabel, (XtArgVal) get_help(selection),
         NULL);

      XtVaGetValues(help_label,
         XtNwidth,   &width,
         XtNheight,  &height,
         NULL);

      XtVaSetValues(help_popup,
         XtNwidth, (XtArgVal) width+10,
         XtNheight, (XtArgVal) height+50,
         NULL);

      XtManageChild(help_panel);

      XtPopup(help_popup,XtGrabNone);
   }

void  ListHelp(w,event,params,num_params)
   Widget   w;
   XEvent   *event;
   String   *params;
   Cardinal *num_params;
   {
      String   selection;
      extern char *get_help();
      Dimension   height, width;

      if ((XawListShowCurrent(w))->list_index == XAW_LIST_NONE) return;

      selection = ((XawListReturnStruct *)XawListShowCurrent(w))->string;

      XtUnmanageChild(help_panel);

      XtVaSetValues(help_label,
         XtNlabel, (XtArgVal) get_help(selection),
         NULL);

      XtVaGetValues(help_label,
         XtNwidth,   &width,
         XtNheight,  &height,
         NULL);

      XtVaSetValues(help_popup,
         XtNwidth, (XtArgVal) width+10,
         XtNheight, (XtArgVal) height+50,
         NULL);

      XtManageChild(help_panel);

      XtPopup(help_popup,XtGrabNone);

   }



void  dismiss(w,client_data,call_data)
   Widget   w;
   XtPointer   client_data,call_data;
   {
      XtPopdown(alert_popup);
   }

void  Unhelp(w,client_data,call_data)
   Widget   w;
   XtPointer   client_data,call_data;
   {
      XtPopdown(help_popup);
   }

void  Terminate(w,client_data,call_data)
   Widget   w;
   XtPointer   client_data,call_data;
   {
      terminate_loop = TRUE;
   }



void
UpdateWidget(w)
        Widget  w;
{
        XEvent  event;

        while (XCheckTypedWindowEvent(XtDisplay(w),XtWindow(w),Expose,&event))
               XtDispatchEvent(&event);
}

void	update_menu(list_widget,old_prompts,get_prompt)
	Widget	list_widget;
	String	*old_prompts[];
	String	(*get_prompt)();
	{
		String	*new_prompts;
		String	*get_prompts();

		XtUnmanageChild(list_widget);
		new_prompts = get_prompts(get_prompt);
		
		XawListChange(list_widget,new_prompts,0,240,TRUE);

		if (*old_prompts)
			free(*old_prompts);

		*old_prompts = new_prompts;
		XtManageChild(list_widget);
	}

String *get_prompts(get_prompt)
	String	(*get_prompt)();
	{
		int		i,count;
		String	*prompts;

		i = 0;
		while(strcmp("XXX",(*get_prompt)(i)))
			i++;
		count = i;
/* Malloc multiplied by 10 */
		prompts = (String *) malloc((count+1)*10*sizeof(String));

		for(i=0;i<count;i++)
			prompts[i] = (*get_prompt)(i);
		prompts[count] = NULL;

		return	prompts;
	}
