;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(def-foreign-callable (get_rewrite_prompt(:language :c)(:return-type :simple-string)
(:name "_get_rewrite_prompt")) ((number :int))
	(cond((nth number *rewrites*)(string(nth number *rewrites*)))
			(t "XXX")))
(def-foreign-callable (get_theories_prompt(:language :c)(:return-type :simple-string)
(:name "_get_theories_prompt")) ((number :int))
	(cond((nth number *theories*)(string(nth number *theories*)))
			(t "XXX")))
(def-foreign-callable (get_tactics_0_prompt(:language :c)(:return-type :simple-string)
(:name "_get_tactics_0_prompt")) ((number :int))
	(cond((nth number *tactics0*)(string(nth number *tactics0*)))
			(t "XXX")))
(def-foreign-callable (get_tactics_1_prompt(:language :c)(:return-type :simple-string)
(:name "_get_tactics_1_prompt")) ((number :int))
	(cond((nth number *tactics1*)(string(nth number *tactics1*)))
			(t "XXX")))
(def-foreign-callable (get_tactics_2_prompt(:language :c)(:return-type :simple-string)
(:name "_get_tactics_2_prompt")) ((number :int))
	(cond((nth number *tactics2*)(string(nth number *tactics2*)))
			(t "XXX")))


(def-foreign-callable (update_buffer(:language :c)(:return-type :simple-string)(:name "_c_update_buffer")) ((string :simple-string))
(prog (temp)
      (setq temp (read-from-string (count-str-brs (format nil "(~A)" string))))
      (if (eq (car temp) '<unreadable>)
          (progn (warn "Brackets are not balanced. Re-enter this expresion.")
                 (format t "~%New Expression> ")
                 (return "c")))
      (if (eq (car temp) 'undo)
          (prog2 (setq *buffer* nil) (format t "~%Re-enter> "))
          (setq *buffer* (append *buffer* temp)))
      (return "c")))


(defun count-str-brs (fp1)
  (if (csb1 (coerce fp1 'list) 0) fp1 "(<unreadable>)"))

(defun csb1 (fp1 fp2)
  (cond ((and (null fp1) (equal 0 fp2)) t)
        ((null fp1) nil) 
        ((and (consp fp1)
              (equal #\( (car fp1)))
         (csb1 (cdr fp1) (1+ fp2)))
        ((and (consp fp1)
              (equal #\) (car fp1)))
         (csb1 (cdr fp1) (1- fp2)))
        ((consp fp1) (csb1 (cdr fp1) fp2))
        (t (raise "code 13: No Patterns have Fired in csb1"))))

(def-foreign-callable (get_help(:language :c)(:return-type :simple-string)
	(:name "_get_help")) ((string :simple-string))
      (get-document (read-from-string string))
)

     
(def-foreign-callable (get_date(:language :c)(:return-type :simple-string)(:name "_get_date"))() *date*)
(def-foreign-callable (get_author(:language :c)(:return-type :simple-string)(:name "_get_author"))() *author*)
(def-foreign-callable (get_title(:language :c)(:return-type :simple-string)(:name "_get_title"))() *framework*)

(def-foreign-function (initialise-statistics (:name initialise_statistics)))
(def-foreign-function c_update_statistics (inferences :int)(time :double-float))
(def-foreign-function (main-event-loop (:name loop)))
(def-foreign-function (connect-widgets (:name windows)))
(def-foreign-function (alert))
(def-foreign-function (update-everything (:name c_update_everything)))
(def-foreign-function (update-tactics-windows (:name c_update_tactics_windows)))
(def-foreign-function (update-theory-menu (:name c_update_theories_menu)))
(def-foreign-function (update-framework-items-window(:name c_update_titles)))
(def-foreign-function (update-rewrites-items-window(:name c_update_rewrites_menu)))
(def-foreign-function (popup-input (:name read_callback)))

(defun update-statistics ()
(c_update_statistics *tactical-inferences* (/ (- (get-internal-run-time) start-time) 1000000.0)))
