;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(defun credit ()
  (format t "|==============================================|~%")
  (format t "| SEQUEL version 5.2, August 1993              |~%")
  (format t "| Written for Kyoto Common Lisp version 1.615  |~%")
  (format t "| Running under XTT version 3.0                |~%")
  (format t "|                                              |~%")
  (format t "| Written and Designed by Mark Tarver          |~%")
  (format t "|                                              |~%")
  (format t "| Computational Logic Group                    |~%")
  (format t "| Division of Artificial Intelligence          |~%")
  (format t "| Centre for Theoretical Computer Science      |~%")
  (format t "| University of Leeds                          |~%")
  (format t "|                                              |~%")
  (format t "| Copyright Mark Tarver 1990,1991,1992,1993    |~%")
  (format t "|==============================================|~%~%"))

(defun calibrate
       (fp1)
       (/ fp1 100.0))

(defun ppx (x) (make-like-lucid (symbol-function x)))

;;(define make-like-lucid 
 ;; [lambda-block f? fps? code?] 
  ;; -> [named-lambda f? fps? [block f? code?]] 
  ;;[lambda-block f? fps? [declare | declarations?] code?] 
  ;; -> [named-lambda f? fps? [declare | declarations?] [block f? code?]]
  ;;[lambda-block f? fps?  [declare | declarations?] | code?]
  ;; -> [named-lambda f? fps? [declare | declarations?] [block f? [progn | code?]]]
  ;;[lambda-block f? fps? | code?]  -> [named-lambda f? fps? [block f? [progn | code?]]]
  ;; _ -> (raise "code 29: problem in trace"))

(defun make-like-lucid (fp1)
  (cond
    ((and (consp fp1) (= (length fp1) 4) (eq 'lambda-block (car fp1)))
     (list 'named-lambda (cadr fp1) (caddr fp1)
           (list 'block (cadr fp1) (caddr (cdr fp1)))))
    ((and (consp fp1) (= (length fp1) 5) (eq 'lambda-block (car fp1))
          (consp (caddr (cdr fp1))) (eq 'declare (caadr (cddr fp1))))
     (list 'named-lambda (cadr fp1) (caddr fp1)
           (cons 'declare (cdadr (cddr fp1)))
           (list 'block (cadr fp1) (caddr (cddr fp1)))))
    ((and (consp fp1) (> (length fp1) 3) (eq 'lambda-block (car fp1))
          (consp (caddr (cdr fp1))) (eq 'declare (caadr (cddr fp1))))
     (list 'named-lambda (cadr fp1) (caddr fp1)
           (cons 'declare (cdadr (cddr fp1)))
           (list 'block (cadr fp1) (cons 'progn (cdddr (cdr fp1))))))
    ((and (consp fp1) (> (length fp1) 2) (eq 'lambda-block (car fp1)))
     (list 'named-lambda (cadr fp1) (caddr fp1)
           (list 'block (cadr fp1) (cons 'progn (cdddr fp1)))))
    (t (raise "code 29: problem in trace"))))

(defun lisp-compile-axioms (fp1) fp1)

(defun get-theory (fp1) (list fp1 'inter (get-prop fp1 'inter nil)))

(defun stats (fp1)
 (format t "CPU time ~F secs~%" fp1)
 (format t "~D tactical inferences~%" *tactical-inferences*)
 (format t "~D TIPS~%" (round (/ *tactical-inferences* (avoid-zero fp1)))))

(defun avoid-zero (fp1)
  (if (zerop fp1) 0.000001 fp1))
