;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, 1994 Mark Tarver          |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(OPAL:CHANGE-GARNET-DISPLAY "csparc16")
;;----------------------------------------------------------------
;; create window

(in-package :kr)

(create-instance 'sequelagg opal:aggregate)

(create-instance 'env-window inter:interactor-window
      (:height 600)
      (:width 300)
      (:title "SEQUEL")
      (:aggregate sequelagg))

(create-instance 'background opal:rectangle
    (:height (o-formula (g-value env-window :height)))
    (:width (o-formula (g-value env-window :width)))
    (:filling-style opal:light-gray-fill))

(opal:add-component sequelagg background)

(create-instance 'options garnet-gadgets:text-button-panel
          (:items '("Type+" "Type-" "Trace" "Untrace" "Framework" 
                    "Proof Tool"))
          (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
          (:num-visible 9)
          (:v-spacing 8)
          (:selection-function 
             #'(lambda (x y) (pushbuffer (return-button-item x y))))
          (:shadow-offset 0)
          (:top 50)
          (:left (o-formula (+ (k) 70)))) 

(defun return-button-item (x y) (read-from-string y))

(opal:add-component sequelagg options)

(create-instance 'options-title opal:text
          (:string ":q")
          (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
          (:top 25)
          (:left 50))

(opal:add-component sequelagg options-title)
;;-------------------------------------------------------------
;; create number pad

(create-instance 'number-pad garnet-gadgets:text-button-panel
        (:items '(" 7 " " 4 " " 1 " " 8 " " 5 " " 2 " " 9 " " 6 " " 3 "))
        (:num-visible 9)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:selection-function #'(lambda (x y) (pushbuffer (read-from-string y))))
        (:shadow-offset 0)
        (:left (o-formula (+ (k) 165)))
        (:top 415)
        (:rank-margin 3))

(opal:add-component sequelagg number-pad)

(create-instance 'zero-button garnet-gadgets:text-button-panel
	(:items '("0"))
	(:num-visible 1)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:selection-function #'(lambda (x y) (pushbuffer (read-from-string y))))
	(:shadow-offset 0)
	(:top 540)
	(:left (o-formula (+ (k) 165)))
	(:fixed-width-size 115))
(opal:add-component sequelagg zero-button)
;;---------------------------------------------------------------
;; type 1 and 0 tactics buttons

(create-instance 'type-0&1 garnet-gadgets:text-button-panel
          (:items '("Type 0" "Type 1"))
          (:direction :horizontal)
          (:selection-function #'(lambda (x y) (popup-tactic-menu y)))
          (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
          (:num-visible 2)
          (:shadow-offset 0)
          (:fixed-width-size 82)
          (:top 540)
          (:left 25))

(defun popup-tactic-menu (x)
  (if (equal x "Type 0")
      (s-value tactics-0-window :visible t)
      (s-value tactics-1-window :visible t)))

(opal:add-component sequelagg type-0&1)
;;--------------------------------------------------------------
;; create theories-menu

(create-instance 'theories-menu garnet-gadgets:scrolling-menu
	(:items sequel::*theories*)
        (:item-font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 260)
	(:min-frame-width 130)
        (:menu-selection-function
            #'(lambda (x y) (pushbuffer (return-menu-item x y))))          
	(:num-visible 5)
	(:left (o-formula (+ (k) 150))))

(opal:add-component sequelagg theories-menu)

(create-instance 'theories-menu-title opal:text
	(:string "Theories")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 240)
	(:left (o-formula (+ (k) 200))))

(opal:add-component sequelagg theories-menu-title)
;;---------------------------------------------------------------
;; create statistics box

(create-instance 'statistics-title opal:text
        (:string "Statistics")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:top 110)
        (:left (o-formula (+ (k) 195))))

(opal:add-component sequelagg statistics-title)

(create-instance 'statsrect opal:rectangle
	(:top 130)
	(:left (o-formula (+ (k) 150)))
	(:width 150)
        (:filling-style opal:white-fill)
	(:height 90))

(opal:add-component sequelagg statsrect)

(create-instance 'INFS opal:text
	(:string "0 inferences")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 150)
	(:left (o-formula (+ (k) 165))))

(opal:add-component sequelagg INFS)

(create-instance 'CPU opal:text
	(:string "0 secs CPU")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 170)
	(:left (o-formula (+ (k) 165))))

(opal:add-component sequelagg CPU)

(create-instance 'TIPS opal:text
	(:string "0 TIPS")
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
	(:top 190)
	(:left (o-formula (+ (k) 165))))

(opal:add-component sequelagg TIPS)
;;---------------------------------------------------------------
;;  name, author & date

(create-instance 'name-box opal:rectangle 
    (:top 5)
    (:filling-style opal:white-fill)
    (:left (o-formula (+ (k) 150)))
    (:width 150)
    (:height 90))
     
(opal:add-component sequelagg name-box)

(create-instance 'NAME opal:text
        (:string sequel::*framework*)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)
                    (:size :large)))
        (:top 10)
        (:left (o-formula (+ (k) 175))))

(opal:add-component sequelagg NAME)

(create-instance 'AUTHOR opal:text
        (:string sequel::*author*)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:top 40)
        (:left (o-formula (+ (k) 165))))

(opal:add-component sequelagg AUTHOR)

(create-instance 'DATE opal:text
        (:string sequel::*date*)
        (:font (create-instance nil opal:font
                    (:family :sans-serif)
                    (:face :bold)))
        (:top 60)
        (:left (o-formula (+ (k) 165))))

(opal:add-component sequelagg DATE)
;;-------------------------------------------------
;; change scrolling menu behaviour to activate right-hand mouse button 

(s-value (g-value options :BEHAVIORS) :START-EVENT
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (g-value tactics-2-menu :BEHAVIORS) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (g-value tactics-2-menu :BEHAVIORS) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (g-value tactics-1-menu :BEHAVIORS) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (g-value tactics-0-menu :BEHAVIORS) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (g-value rewrites-menu :BEHAVIORS) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
(s-value (g-value theories-menu :BEHAVIORS) :START-EVENT 
                 '(:LEFTDOWN :SHIFT-LEFTDOWN :RIGHTDOWN :SHIFT-RIGHTDOWN))
