;;|=========================================================================|
;;|                           COPYRIGHT NOTICE                              |
;;|                                                                         |
;;|                   Copyright 1992, Mark Tarver                           |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(defvar *author* "Mark Tarver")
(defvar *full-tc* t)
(defvar *date* "May 1992")
(defvar *intertypes* nil)
(defvar *definitions* nil)
(defvar *newnumber* 0)
(defvar *buffer*)
(defvar *step* nil)
(defvar *toplevel-directory* "~")
(defvar *skip* 0)
(defvar *cons-form* t)
(defvar *history* nil)
(defvar *funchistory* nil)
(defvar *constants* nil)
(defvar start-time)
(defvar *allsequents* nil) 
(defvar stop-time)
(defvar *pattern* nil)
(defvar *untypedfunctions* nil)
(defvar *print-untyped-functions* t)
(defvar *problem*)
(defvar *stats* nil)
(defvar stream)
(defvar *auto* nil)
(defvar *primitives* '(string integer bool symbol rational character float)) 
(defvar *tactics0* nil)
(defvar *tempreg*)
(defvar *tactics1* nil)
(defvar *ttc* nil)
(defvar *tactics2* nil)
(defvar *rewrites* nil)
(defvar *rewrites-auto*)
(defvar *deref-flag*)
(defvar *local-array*)
(defvar *var-counter*)
(defvar *temp*)
(defvar *newvar*)
(defvar *toptrail*)
(defvar *tactical-inferences* 0)
(defvar *refinements* 0)
(defvar *trailstack* nil)
(defvar *proofhistory* nil)
(defvar *varcounter* 0)
(defvar *call*)
(defvar *trace* nil)
(defvar *compile* nil)
(defvar *interactive* nil)
(defvar *deflog+* nil)
(defvar *globals* nil)
(defvar *graphics* nil)
(defvar *checked* nil)
(defvar *theories* nil)
(defvar var#1?)
(defvar var#2?)
(defvar var#3?)
(defvar var#4?)
(defvar var#5?)
(defvar var#6?)
(defvar var#7?)
(defvar var#8?)
(defvar var#9?)
(defvar var#10?)
(defvar var#11?)
(defvar var#12?)
(defvar var#13?)
(defvar var#14?)
(defvar var#15?)
(defvar var#16?)
(defvar var#17?)
(defvar var#18?)
(defvar var#19?)
(defvar var#20?)
(defvar *outfile* nil)
(defvar *type-check* nil)
(defvar *delayed* nil)
(defvar *optimise* t)
(defvar *autotypes* '())
(defvar *sfht*
  (make-hash-table :size 300 :rehash-size 2 :rehash-threshold 290))
(defvar *binding-array* (make-hash-table :size 100 :rehash-size 2 
                          :rehash-threshold 80))
(defvar *framework* "XTT version 1.01")
(defvar *greek-alphabet* '(alpha? beta? gamma? delta? epsilon?
                           zeta? eta? theta? iota? kappa? mu?
                           nu? xi? pi? rho? sigma? tau? upsilon?
                           phi? chi? psi? omega?))

(setf (get 'string 'recognisor) 'stringp)
(setf (get 'symbol 'recognisor) 'mysymbolp)
(setf (get 'integer 'recognisor) 'integerp)
(setf (get 'bool 'recognisor) 'boolp)
(setf (get 'proof 'recognisor) 'null)
(setf (get 'character 'recognisor) 'characterp)
(setf (get 'rational 'recognisor) 'rationalp)
(setf (get 'float 'recognisor) 'floatp)

(defmacro trace (&rest x) (list 'trace1 (list 'quote x)))
(defmacro theory (&rest x) (list 'compile-theory (list 'quote x)))
(defmacro untrace (&rest x) (list 'untrace1 (list 'quote x))) 
(defmacro deflog (&rest def) (list 'deflog1 (list 'quote def)))
(defmacro deflog- (&rest def) (list 'deflog1- (list 'quote def)))
(defmacro deflog+ (&rest def) (list 'deflog1+ (list 'quote def)))
(defmacro define (&rest def) (list 'define1 (q! def)))
(defmacro mutual (&rest def) (list 'mutual1 (list 'quote def)))
(defmacro pp (x) (list 'symbol-function (q! x)))
(defmacro add-tactics (&rest def) (list 'mapcar ''add-tactic (q! def)))
(defmacro deftactic (&rest def) (list 'deftactic1 (list 'quote def)))
(defmacro mk-dr (x &optional bool) (list 'mdr0 (list 'quote x) bool))
(defmacro defrew (&rest def) (list 'defrew1 (list 'quote def)))
(defmacro global (&rest x) (list 'global1 (list 'quote x)))
(defmacro primitive (&rest x) (list 'primitive1 (list 'quote x)))
(defstruct framework print_name
                     author
                     date
                     syntax 
                     theories 
                     rewrites 
                     tactics0 
                     tactics1 
                     tactics2)


(defun exclamation (x) (eq x '!))

(defun rewrite (&rest x) (rewrite-dispatch x))

(defun return-turnstile () '\|-)
(defun turnstile (x) (eq x '\|-))

(defun init-sigs (signatures)
  (mapcar #'(lambda (entry) (setf (gethash (key-entry entry) *sfht*) 
                                  (value-entry entry))) 
          signatures)) 

(defun key-entry (entry) (car entry))
(defun value-entry (entry) (cadr entry))
  
(defun q! (x) (list 'quote x))

(defun clear () (clear1 80))

(defun clear1 (n)
  (cond ((zerop n) (terpri))
        (n (terpri) (clear1 (1- n)))))

(setq *print-case* ':downcase)

(defun lsq () '[)
(defun rsq () '])

(defvar *reserved* '(deflog deflog- deflog+ define untrace deftactic defrew 
                     consult trace theory prooftool global primitive why
                     divert-proof ttc+ ttc- rpt stats+ stats- mutual mk-dr
                     quit print-delayed-functions type+ type- step+ step- 
                     history))

(defun comma (x) (eq x '|,|))

(init-sigs
     '((abs (integer -> integer))
       (acons (alpha? (list alpha?) (list (list alpha?)) -> (list (list alpha?))))
       (adjoin (alpha? (list alpha?) -> (list alpha?)))
       (alpha-char-p (character -> bool))
       (alphanumericp (character -> bool))
       (and (bool bool -> bool))
       (append ((list alpha?) (list alpha?) -> (list alpha?)))
       (apply ((alpha? -> beta?) (list alpha?) -> beta?)) 
       (apropos (string -> unit))
       (apropos-list (string -> unit))
       (ash (integer integer -> integer))
       (assoc (alpha? (list (list alpha?)) -> (list alpha?)))
       (assoc-if (((list alpha?) -> bool) (list (list alpha?)) -> (list alpha?)))
       (assoc-if-not (((list alpha?) -> bool) (list (list alpha?)) -> (list alpha?)))
       (atom (alpha? -> bool))
       (bind (alpha? alpha? -> bool))
       (both-case-p (character -> bool))
       (boundp (symbol -> bool))
       (break (-> alpha?))
       (butlast ((list alpha?) integer -> (list alpha?)))
       (character (integer -> character))
       (characterp (alpha? -> bool))
       (char-bit (character symbol -> bool))
       (char-code (character -> integer))
       (char-control-bit (character -> integer))
       (char (string integer -> character))
       (char-downcase (character -> character))
       (char-equal (character character -> bool))
       (char-font (character -> integer))
       (char-greaterp (character character -> bool))
       (char-int (character -> integer))
       (char-lessp (character character -> bool))
       (char-name (character -> unit))
       (char-not-equal (character character -> bool))
       (char-not-greaterp (character character -> bool))
       (char-not-lessp (character character -> bool))
       (char-upcase (character -> character))
       (char/= (character character -> bool))
       (char< (character character -> bool))
       (char<= (character character -> bool))
       (char= (character character -> bool))
       (char> (character character -> bool))
       (char-meta-bit (character -> integer))
       (coerce void)
       (compile (symbol -> symbol)) 
       (clone (alpha? -> alpha?))
       (commonp (alpha? -> bool))
       (compiled-function-p (alpha? -> bool))
       (compile-file (string -> unit))
       (concat (symbol symbol -> symbol))
       (concatenate void)
       (cons (alpha? (list alpha?) -> (list alpha?)))
       (consp (alpha? -> bool))
       (constantp ((list alpha?) -> bool))
       (copy-alist ((list (list alpha?)) -> (list (list alpha?))))
       (copy-list ((list alpha?) -> (list alpha?)))
       (count ((list alpha?) -> integer))    
       (count-if ((alpha? -> bool) (list alpha?) -> integer))
       (count-if-not ((alpha? -> bool) (list alpha?) -> integer))
       (decode-universal-time (integer -> unit))
       (decf (integer -> integer))
       (delete (alpha? (list alpha?) -> (list alpha?)))
       (delete-duplicates ((list alpha?) -> (list alpha?)))
       (delete-file (string -> bool))
       (delete-if ((alpha? -> bool) (list alpha?) -> (list alpha?)))
       (delete-if-not ((alpha? -> bool) (list alpha?) -> (list alpha?)))
       (describe (symbol -> unit))
       (denominator (rational -> integer))
       (digit-char (integer -> (or character bool)))
       (digit-char-p (character -> integer))
       (disassemble (symbol -> unit))
       (dribble void)
       (ed (string -> unit))
       (eigen (alpha? beta? -> bool))
       (elt ((list alpha?) integer -> alpha?))
       (encode-universal-time (integer integer integer integer integer integer 
                                -> integer))
       (enough-namestring (string -> string))
       (endp ((list alpha?) -> bool))
       (eq (alpha? alpha? -> bool))
       (eql (alpha? alpha? -> bool) )
       (equal (alpha? alpha? -> bool))
       (equalp (alpha? alpha? -> bool))
       (eval void)
       (fail (-> character))
       (fail-if void)
       (put-prop void)
       (get-prop void)
       (put-hash void)
       (build-hash-table void)
       (build-array void)
       (get-hash void) 
       (get-array void)
       (put-array void)
       (evenp (integer -> bool))
       (every ((alpha? -> bool) (list alpha?) -> bool)) 
       (expt (integer -> integer))
       (exp ((or rational integer) -> rational))
       (fboundp (symbol -> bool))
       (file-author (string -> string))
       (find ((alpha? -> bool) (list alpha?) -> alpha?))
       (find-if ((alpha? -> bool) (list alpha?) -> alpha?))
       (find-if-not ((alpha? -> bool) (list alpha?) -> alpha?))
       (float-digits (float -> integer))
       (float-precision (float -> integer))
       (float-radix (float -> integer))
       (float-sign (float float -> float))
       (floatp (alpha? -> bool))
       (force-output (-> bool))
       (format void) 
       (fresh-line (bool -> bool))
       (rewrite ((t-expr -> t-expr) integer proof -> proof))
       (get-theory-length (symbol -> integer))
       (head ((list alpha?) -> alpha?))
       (tail ((list alpha?) -> (list alpha?)))
       (functionp (alpha? -> bool))
       (funcall ((alpha? -> beta?) alpha? -> beta?))
       (gcd void)
       (gensym (-> symbol))
       (gentemp (-> symbol))
       (get-internal-real-time (-> integer))
       (get-internal-run-time (-> integer))
       (graphic-char-p (character -> bool))
       (identity (alpha? -> alpha?))
       (if (bool alpha? alpha? -> alpha?))
       (infs (-> integer))
       (input+ void)
       (int-char (integer -> character))
       (integer-length (integer -> integer))
       (isqrt (integer -> integer))
       (integerp (alpha? -> bool))
       (intersection ((list alpha?) (list alpha?) -> (list alpha?)))
       (keywordp (alpha? -> bool))
       (last ((list alpha?) -> (list alpha?)))
       (lcm void)
       (ldiff ((list alpha?) (list alpha?) -> (list alpha?)))
       (lemma (t-expr proof -> proof))
       (length ((list alpha?) -> integer))
       (lisp-implementation-type (-> string))
       (lisp-implementation-version (-> string))
       (log ((or float (or integer rational)) (or float (or integer rational))
               -> float))
       (long-site-name (-> unit))
       (machine-instance (-> unit))
       (machine-type (-> unit))
       (machine-version (-> string))
       (make-char (character -> character))
       (make-list void)
       (xmap void)
       (list-length ((list alpha?) -> integer))
       (list (alpha? alpha? -> (list alpha?)))
       (logical-var (alpha? -> bool))
       (machine-instance (-> string))
       (machine-type (-> string))
       (machine-version (-> string))
       (mapcar ((alpha? -> beta?) (list alpha?) -> (list beta?)))
       (mapcan ((alpha? -> (list beta?)) (list alpha?) -> (list beta?)))
       (member (alpha? (list alpha?) -> (list alpha?)))
       (member-if ((alpha? -> bool) (list alpha?) -> (list alpha?)))
       (member-if-not ((alpha? -> bool) (list alpha?) -> (list alpha?)))
       (xmerge ((list alpha?) (list alpha?) (alpha? alpha? -> bool) 
        -> (list alpha?)))
       (min void)
       (minusp (integer -> bool))
       (mismatch ((list alpha?) (list alpha?) -> (list alpha?)))
       (mod (integer integer -> integer))
       (nconc ((list alpha?) -> (list alpha?)))
       (nreconc ((list alpha?) -> (list alpha?)))
       (newterm (-> symbol))
       (newv (-> symbol))
       (newvar (-> unit))
       (not (bool -> bool))
       (notany ((alpha? -> bool) (list alpha?) -> bool))
       (notevery ((alpha? -> bool) (list alpha?) -> bool))
       (nbutlast ((list alpha?) -> (list alpha?)))
       (nintersection ((list alpha?) (list alpha?) -> (list alpha?)))
       (nset-difference ((list alpha?) (list alpha?) -> (list alpha?)))
       (nset-exclusive-or ((list alpha?) (list alpha?) -> (list alpha?)))
       (nstring-capitalize (string -> string))
       (nstring-downcase (string -> string))
       (nstring-upcase (string -> string))
       (nsubst ((list alpha?) (list alpha?) -> (list alpha?)))
       (nsubst-if (alpha? (alpha? -> bool) (list alpha?) -> (list alpha?)))
       (nsubst-if-not (alpha? (alpha? -> bool) (list alpha?) -> (list alpha?)))
       (nreverse ((list alpha?) -> (list alpha?)))
       (xnth (integer (list alpha?) -> alpha?)) 
       (nthcdr ((list alpha?) -> (list alpha?))) 
       (numerator ((or rational integer) -> integer))
       (nunion ((list alpha?) (list alpha?) -> (list alpha?)))
       (null ((list alpha?) -> bool))
       (oddp (integer -> bool))
       (or (bool bool -> bool))
       (peek-char (character -> character))
       (xposition (alpha? (list alpha?) -> integer))
       (xposition-if ((alpha? -> bool) (list alpha?) -> integer))
       (plusp (integer -> bool))
       (pprint (alpha? -> alpha?))
       (pprint-sequent (sequent -> unit))
       (princ (alpha? -> alpha?))
       (princ-to-string (alpha? -> string?))
       (print (alpha? -> alpha?))
       (prin1 (alpha? -> alpha?))
       (prin1-to-string (alpha? -> string))
       (xprobe-file (string -> bool))
       (prog1 (alpha? beta? -> alpha?))
       (prog2 (alpha? beta? -> beta?))
       (progn void)
       (quit void)
       (random (integer -> integer))
       (rassoc (alpha? (list (list alpha?)) -> (list alpha?)))
       (rassoc-if (((list alpha?) -> bool) (list (list alpha?)) 
                      -> (list alpha?)))
       (rassoc-if-not (((list alpha?) -> bool) (list (list alpha?)) 
                      -> (list alpha?)))
       (rational ((or rational float) -> rational)) 
       (rationalize ((or rational float) -> rational))
       (rationalp (alpha? -> bool))
       (refine (symbol integer proof -> proof))
       (rem (integer -> integer))
       (repseq (sequent proof -> proof))
       (signature (symbol -> unit))
       (stringp (alpha? -> bool))
       (suppress ((list symbol) -> bool))
       (symbolp (alpha? -> bool))
       (swap (integer integer proof -> proof))
       (thin (integer proof -> proof))
       (xtt (proof -> proof))
       (inst (alpha? term proof -> proof))
       (remove (alpha? (list alpha?) -> (list alpha?)))
       (remove-duplicates ((list alpha?) -> (list alpha?)))
       (remove-if ((alpha? -> bool) (list alpha?) -> (list alpha?)))
       (remove-if-not ((alpha? -> bool) (list alpha?)-> (list alpha?)))
       (rest ((list alpha?) -> (list alpha?)))
       (restart (-> alpha?))
       (revappend ((list alpha?) (list alpha?) -> (list alpha?)))
       (reverse ((list alpha?) -> (list alpha?)))
       (raise (string -> alpha?))
       (rotate (integer integer proof -> proof)) 
       (room (-> unit))
       (round ((or integer (or rational float)) -> integer))
       (error (string -> alpha?))
       (scale-float (float float -> integer))
       (schar (string integer -> character))
       (set-difference ((list alpha?) (list alpha?) -> (list alpha?)))
       (set void)
       (set-exclusive-or ((list alpha?) (list alpha?) -> (list alpha?)))
       (software-type (-> unit))
       (software-version (-> unit))
       (sort ((list alpha?) (alpha? alpha? -> bool) -> (list alpha?)))
       (stable-sort (-> unit))
       (some ((alpha? -> bool) (list alpha?) -> bool))
       (string-capitalize (string -> string))
       (string-downcase (string -> string))
       (string-equal (string string -> bool))
       (string-greaterp (string string -> bool))
       (string-left-trim ((list character) string -> string))
       (string-right-trim ((list character) string -> string))
       (string-lessp (string string -> bool))
       (string-not-equal (string string -> bool))
       (string-not-greaterp (string string -> bool))
       (string-not-lessp (string string -> bool))
       (string-upcase (string -> string))
       (symbol-function (symbol -> unit))
       (symbol-name (symbol -> string))
       (unintern (symbol -> bool))
       (upper-case-p (character -> bool))
       (when void)
       (xstring/= (string string -> bool))
       (xstring< (string string -> bool))
       (xstring<= (string string -> bool))
       (xstring= (string string -> bool))
       (xstring> (string string -> bool))
       (subsetp ((list alpha?) (list alpha?) -> bool))
       (subst (alpha? alpha? (list alpha?) -> (list alpha?)))
       (tailp ((list alpha?) (list alpha?) -> bool))
       (terpri (-> bool))
       (time (alpha? -> alpha?))
       (unintern (symbol -> bool))
       (union ((list alpha?) (list alpha?) -> (list alpha?)))
       (unsolved-nodes (proof -> integer))
       (var (alpha? -> bool))
       (warn (string -> bool))
       (write (alpha? -> alpha?))
       (write-string (string -> string))
       (write-line (string -> string))
       (write-to-string (alpha? -> string))
       (y-or-n-p (string -> bool))
       (yes-or-no-p (string -> bool))
       (zerop ((or integer (or rational float)) -> bool))
       (* (integer integer -> integer))
       (+ (integer integer -> integer))
       (- (integer integer -> integer))
       (/ (rational rational -> rational))
       (/= (integer integer -> bool))
       (1+ (integer -> integer))
       (1- (integer -> integer))
       (< (integer integer -> bool))
       (<= (integer integer -> bool))
       (= (integer integer -> bool))
       (> (integer integer -> bool))
       (>= (integer integer -> bool))
       (/. void)))
       
(defun lcurly (x) (eq x '}))
(defun rcurly (x) (eq x '{))

(defun return-{ (x y) (declare (ignore x) (ignore y)) '{)
(defun return-} (x y) (declare (ignore x) (ignore y)) '})
(defun return-[ (x y) (declare (ignore x) (ignore y)) '[)
(defun return-] (x y) (declare (ignore x) (ignore y)) '])
(defun return-% (x y) (declare (ignore x) (ignore y)) '%)
(defun return-! (x y) (declare (ignore x) (ignore y)) '!)
(defun return-comma (x y) (declare (ignore x) (ignore y)) '|,|)
(defun return-circumflex (x y) (declare (ignore x) (ignore y)) '^)

(proclaim '(inline lderef restricted-lderef logical-var bind
            invoke backtrack deallocate-values get-local-binding 
            imm-local-value))
(proclaim '(list *local-array*))
(proclaim '(hash-table *binding-array*))
(proclaim '(integer *var-counter*))
(proclaim '(integer *newvar*))
(proclaim '(list *toptrail*))
(proclaim '(list *trailstack*))
(proclaim '(integer *newnumber*))
(proclaim '(list *proof*))
(proclaim '(integer *varcounter*))
(proclaim '(atom *deref-flag*))

(setf (get 'abort 'doc) 
"This command has no signature.  
It simply aborts the proof.")

(setf (get 'xtt 'doc)
"Invokes the resident type system XTT on the problem.  
XTT is capable of solving any sequent of the form p', A |- p 
where p and p' are unifiable.  Any problem that can be solved 
by automatic type-checking in the SEQUEL top level will be 
solved by this command.")

(setf (get 'back 'doc)
"This command has no signature.  It does however 
require an integer input n and will roll the proof back 
n steps.  If n > the length of the proof, BACK will function 
as ABORT.")

(setf (get 'inst 'doc)
"This command will instantiate a variable by a term 
The variable is entered first.  If a non-variable is entered 
then this command has no effect.")

(setf (get 'lemma 'doc)
"LEMMA allows the user to set a new goal to be proved.  
Once proved the goal then become an assumption in the original 
sequent. Formally, this primitive obeys the following rule, 
(l is any lemma). 

A |- l  <---  this sequent is invoked by LEMMA 
l, A |- p
---------
A |- p

To use LEMMA, follow it by READ which will enables a t-expr
to be typed in as a goal.  LEMMA accepts formulae in 
external syntax.")

(setf (get 'read 'doc)
"This command has no signature.  It allows 
the user to type in the input through a pop-up window")

(setf (get 'refine 'doc)
"Invokes a theory and its 
nth axiom on the current sequent")

(setf (get 'rotate 'doc)
"SEQUEL stores unsolved sequents in a stack.  The ROTATE 
command will exchange the mth and nth sequents in the stack with 
each other.  The number of sequents currently in the stack is given 
by the integer in square brackets that appears against each step.")

(setf (get 'swap 'doc)
"Exchanges the mth and nth assumptions 
in the context of the current sequent with each other.")

(setf (get 'thin 'doc)
"Removes the nth assumption 
from the context of the current sequent")

(setf (get 'undo 'doc)
"This command has no signature.  It clears 
the buffer and enables the user to re-enter the command 
from scratch")

