;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, Mark Tarver               |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

(in-package :sequel)

(defun phi
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (print-if-tc-traced (lderef var#1?)
                                       (lderef var#2?)
                                       (lderef var#3?))
                   (change-stacks))
              (or (kill 1 continuation)
                  (backtrack)))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (consp fp1)
                   (= (length fp1) 3)
                   (eq 'define (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? (caddr fp1))
                   (bind var#3? fp2)
                   (bind var#4? fp3)
                   (change-stacks))
              (or
                (rule-of-recursions (lderef var#1?)
                                    (lderef var#2?)
                                    (rewrite-to-normal-form (lderef var#3?))
                                    (lderef var#4?)
                                    continuation)
                (backtrack)))
             ((and (rename '(var#1? var#4? var#2? var#3?))
                   (consp fp1)
                   (= (length fp1) 2)
                   (eq 'mutual (car fp1))
                   (bind var#1? (cadr fp1))
                   (bind var#2? fp2)
                   (bind (lderef var#3?)
                         (mapcar 'n-sig (lderef var#1?)))
                   (bind (lderef var#4?)
                         (mapcar 'skdef (lderef var#1?)))
                   (change-stacks))
              (or
                (logic-equal (lderef var#2?)
                             (mapcar 'get-c-types
                                     (lderef var#3?))
                             (append
                               (list
                                 (list 'phi-mutual
                                       var#4?
                                       var#2?
                                       var#3?))
                               continuation))
                (backtrack)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (arbterm (lderef var#1?))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (assoc (lderef var#1?)
                          (lderef var#3?))
                   (change-stacks)
                   (immediate (list (lderef var#1?)
                                    '*
                                    (lderef var#2?))
                              (lderef var#3?)
                              continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (eval '*auto*)
                   (bind var#3? fp3)
                   (change-stacks)
                   (immediate (list (lderef var#1?)
                                    '*
                                    (lderef var#2?))
                              (lderef var#3?)
                              continuation)))
             ((and (rename '(var#2? var#1? var#4? var#3?))
                   (bind var#1? fp1)
                   (consp (lderef var#1?))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (assoc (first (lderef var#1?))
                          (lderef var#3?))
                   (change-stacks)
                   (gen-type nil
                             (1- (length (lderef var#1?)))
                             (lderef var#2?)
                             (lderef var#4?)
                             (append
                               (list
                                 (list 'immediate
                                       (list (car (lderef var#1?))
                                             '*
                                             var#4?)
                                       var#3?)
                                 (list 'phi-recursion
                                       (cdr (lderef var#1?))
                                       var#4?
                                       var#3?))
                               continuation))))
             ((and (rename '(var#1? var#2? var#4? var#3?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (user-defined-type (lderef var#2?))
                   (bind (lderef var#4?)
                         (rewrite-auto
                           (list (lderef var#1?)
                                 '*
                                 (lderef var#2?))))
                   (not
                     (equal (list (lderef var#1?)
                                  '*
                                  (lderef var#2?))
                            (lderef var#4?)))
                   (change-stacks))
              (or (phi-rew (lderef var#4?)
                           (lderef var#3?)
                           continuation)
                  (backtrack)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (consp (lderef var#1?))
                   (signature (car (lderef var#1?)))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (call-f& (concat (car (lderef var#1?))
                                    '&)
                            (cdr (lderef var#1?))
                            (lderef var#2?)
                            (lderef var#3?)
                            continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (consp fp2)
                   (= (length fp2) 3)
                   (eq 'or (car fp2))
                   (bind var#2? (cadr fp2))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (consp fp2)
                   (= (length fp2) 3)
                   (eq 'or (car fp2))
                   (bind var#2? (caddr fp2))
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (lderef var#3?)
                        continuation)))
             ((and (rename '(var#3? var#4? var#1? var#2? var#5?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (disjunctive-context (lderef var#3?))
                   (bind (lderef var#4?)
                         (split-disjunctive-context-l (lderef var#3?)))
                   (bind (lderef var#5?)
                         (split-disjunctive-context-r (lderef var#3?)))
                   (change-stacks))
              (or
                (phi (lderef var#1?)
                     (lderef var#2?)
                     (lderef var#4?)
                     (append (list (list 'phi var#1? var#2? var#5?))
                             continuation))
                (backtrack)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (symbolp (lderef var#1?))
                   (bind var#2? fp2)
                   (consp (lderef var#2?))
                   (member '-> (lderef var#2?))
                   (change-stacks)
                   (logic-equal (internal-signature (lderef var#1?))
                                (lderef var#2?)
                                continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (symbolp (lderef var#1?))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (consp (lderef var#2?))
                   (member '-> (lderef var#2?))
                   (assoc (lderef var#1?)
                          (lderef var#3?))
                   (change-stacks)
                   (immediate (list (lderef var#1?)
                                    '*
                                    (lderef var#2?))
                              (lderef var#3?)
                              continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (consp (lderef var#1?))
                   (symbolp (car (lderef var#1?)))
                   (bind var#2? fp3)
                   (not (eq '$
                            (car (lderef var#1?))))
                   (not (signature (car (lderef var#1?))))
                   (not (assoc (first (lderef var#1?))
                               (lderef var#2?)))
                   (throw 'delay 'delayed)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#2? var#1? var#3?))
                   (bind var#1? fp1)
                   (symbolp (lderef var#1?))
                   (not (arbterm (lderef var#1?)))
                   (bind var#2? fp2)
                   (consp (lderef var#2?))
                   (bind var#3? fp3)
                   (member '-> (lderef var#2?))
                   (not (signature (lderef var#1?)))
                   (not (assoc (lderef var#1?)
                               (lderef var#3?)))
                   (throw 'delay 'delayed)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (not (arbterm (lderef var#1?)))
                   (bind var#2? fp2)
                   (change-stacks)
                   (phi-primitive-types (lderef var#1?)
                                        (lderef var#2?)
                                        (eval '*primitives*)
                                        continuation)))
             ((and (rename '(var#2? var#1? var#3?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (user-defined-type (lderef var#2?))
                   (fboundp (lderef var#2?))
                   (bind var#3? fp3)
                   (change-stacks)
                   (call-type (lderef var#2?)
                              (lderef var#1?)
                              (lderef var#3?)
                              continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (logical-var (lderef var#2?))
                   (eval '*full-tc*)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi-user (get-user-types)
                             (lderef var#1?)
                             (lderef var#2?)
                             (lderef var#3?)
                             continuation)))
             ((and (rename '(var#2? var#1? var#4? var#3?))
                   (bind var#1? fp1)
                   (consp fp2)
                   (= (length fp2) 2)
                   (eq 'list (car fp2))
                   (bind var#2? (cadr fp2))
                   (bind var#3? fp3)
                   (arbterm (lderef var#1?))
                   (user-defined-type (lderef var#2?))
                   (change-stacks)
                   (phi (lderef var#1?)
                        (lderef var#2?)
                        (list (list (lderef var#1?)
                                    '*
                                    (lderef var#4?)))
                        (append
                          (list (list 'not-logic-equal
                                      var#2?
                                      var#4?)
                                (list 'phi
                                      var#1?
                                      (list 'list var#4?)
                                      var#3?))
                          continuation))))
             ((backtrack))))

(defun gen-type
       (fp1 fp2 fp3 fp4 continuation)
       (cond ((and (rename '(var#3? var#1? var#2?))
                   (bind var#1? fp1)
                   (equal 0 fp2)
                   (bind var#2? fp3)
                   (bind var#3? fp4)
                   (unify (lderef var#3?)
                          (append (lderef var#1?)
                                  (list '-> (lderef var#2?))))
                   (change-stacks))
              (or (popstack continuation)
                  (backtrack)))
             ((and (rename '(var#5? var#1? var#2? var#3? var#4?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (bind var#4? fp4)
                   (change-stacks))
              (or
                (gen-type (cons (lderef var#5?)
                                (lderef var#1?))
                          (1- (lderef var#2?))
                          (lderef var#3?)
                          (lderef var#4?)
                          continuation)
                (backtrack)))
             ((backtrack))))

(defun kill
       (fp1 continuation)
       (cond ((and (rename nil)
                   (= 0 1)
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun phi-rew
       (fp1 fp2 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#3? var#4? var#1? var#2?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (unify (list (lderef var#3?)
                                '*
                                (lderef var#4?))
                          (car (lderef var#1?)))
                   (change-stacks)
                   (phi (lderef var#3?)
                        (lderef var#4?)
                        (lderef var#2?)
                        (append
                          (list
                            (list 'phi-rew
                                  (cdr (lderef var#1?))
                                  var#2?))
                          continuation))))
             ((backtrack))))

(defun phi-primitive-types
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1?))
                   (or (eq 'nil
                           (setq *tempreg* fp1))
                       (qtrybind *tempreg* 'nil))
                   (or
                     (trybind (setq *tempreg* (lderef fp2))
                              (list 'list (lderef var#1?)))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 2)
                          (or
                            (eq 'list
                                (setq *tempreg* (lderef (car fp2))))
                            (qtrybind *tempreg* 'list))
                          (bind var#1? (cadr fp2))))
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#3? var#2?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (consp (lderef var#3?))
                   (funcall (get (first (lderef var#3?))
                                 'recognisor)
                            (lderef var#1?))
                   (change-stacks)
                   (logic-equal (first (lderef var#3?))
                                (lderef var#2?)
                                continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (consp (lderef var#3?))
                   (change-stacks)
                   (phi-primitive-types (lderef var#1?)
                                        (lderef var#2?)
                                        (cdr (lderef var#3?))
                                        continuation)))
             ((backtrack))))

(defun phi-mutual
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (equal nil fp2)
                   (change-stacks))
              (or (popstack continuation)
                  (backtrack)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi-rules (car (lderef var#1?))
                              (car (lderef var#2?))
                              (lderef var#3?)
                              (append
                                (list
                                  (list 'phi-mutual
                                        (cdr (lderef var#1?))
                                        (cdr (lderef var#2?))
                                        var#3?))
                                continuation))))
             ((backtrack))))

(defun rule-of-recursions
       (fp1 fp2 fp3 fp4 continuation)
       (cond ((and (rename '(var#2? var#5?
                                    var#1?
                                    var#3?
                                    var#4?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (or
                     (qtrybind (setq *tempreg* fp3)
                               (list var#3? '-> var#4?))
                     (and (consp *tempreg*)
                          (= (length *tempreg*) 3)
                          (bind var#3? (car fp3))
                          (or (eq '->
                                  (setq *tempreg* (cadr fp3)))
                              (qtrybind *tempreg* '->))
                          (bind var#4? (caddr fp3))))
                   (bind (lderef var#5?)
                         (skolemise-rules (lderef var#2?)))
                   (bind (lderef var#3?)
                         (bldinput (first (first (lderef var#2?)))
                                   nil))
                   (change-stacks)
                   (phi-rules (lderef var#5?)
                              (list (lderef var#3?)
                                    '->
                                    (lderef var#4?))
                              (list
                                (list (lderef var#1?)
                                      '*
                                      (append (lderef var#3?)
                                              (list '->
                                                    (lderef var#4?)))))
                              continuation)))
             ((backtrack))))

(defun phi-rules
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks))
              (or (popstack continuation)
                  (backtrack)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi-rule (car (lderef var#1?))
                             (lderef var#2?)
                             (lderef var#3?)
                             (append
                               (list
                                 (list 'phi-rules
                                       (cdr (lderef var#1?))
                                       var#2?
                                       var#3?))
                               continuation))))
             ((backtrack))))

(defun phi-rule (fp1 fp2 fp3 continuation)
   (cond ((and
            (rename '(var#1? var#3?
                             var#5?
                             var#2?
                             var#4?
                             var#6?))
            (consp fp1)
            (= (length fp1) 3)
            (bind var#1? (car fp1))
            (bind var#2? (caddr fp1))
            (consp fp2)
            (= (length fp2) 3)
            (bind var#3? (car fp2))
            (eq '-> (cadr fp2))
            (bind var#4? (caddr fp2))
            (bind var#5? fp3)
            (change-stacks)
            (phi-pattern (pair (lderef var#1?)
                               (lderef var#3?))
                         (lderef var#5?)
                         (lderef var#6?)
                         (append
                           (list
                             (list 'phi var#2? var#4? var#6?))
                                        continuation))))
         ((backtrack))))

(defun phi-pattern (fp1 fp2 fp3 continuation)
  (cond ((and (rename '(var#1?))
              (or (eq 'nil
                      (setq *tempreg* fp1))
                  (qtrybind *tempreg* 'nil))
              (bind var#1? fp2)
              (unify (lderef var#1?)
                     (lderef fp3))
              (change-stacks)
              (popstack continuation)))
        ((and
           (rename '(var#1? var#2?
                            var#3?
                            var#4?
                            var#5?
                            var#6?))
           (consp fp1)
           (> (length fp1) 0)
           (or
             (qtrybind (setq *tempreg* (car fp1))
                       (list (list 'cons var#1? var#2?)
                             '*
                             (list 'list var#3?)))
             (and (consp *tempreg*)
                  (= (length *tempreg*) 3)
                  (or
                    (qtrybind (setq *tempreg*
                                    (caar fp1))
                              (list 'cons var#1? var#2?))
                    (and (consp *tempreg*)
                         (= (length *tempreg*)
                            3)
                         (or
                           (eq 'cons
                               (setq *tempreg* (caar (car fp1)))
                                     )
                           (qtrybind *tempreg* 'cons))
                         (bind var#1?
                               (cadar (car fp1)))
                         (bind var#2?
                               (caddr (caar fp1)))))
                  (or
                    (eq '*
                        (setq *tempreg* (lderef (cadar fp1))))
                    (qtrybind *tempreg* '*))
                  (or
                    (trybind
                      (setq *tempreg* (lderef
                                        (caddr (car fp1))))
                      (list 'list
                            (lderef var#3?)))
                    (and (consp *tempreg*)
                         (= (length *tempreg*)
                            2)
                         (or
                           (eq 'list
                               (setq *tempreg* (lderef
                                                 (caadr
                                                   (cdar fp1))))
                                     )
                           (qtrybind *tempreg* 'list))
                         (bind var#3?
                               (cadar (cddar fp1)))))))
           (bind var#4? (cdr fp1))
           (bind var#5? fp2)
           (bind var#6? fp3)
           (change-stacks)
           (phi-pattern
             (cons (list (lderef var#1?)
                         '*
                         (lderef var#3?))
                   (cons
                     (list (lderef var#2?)
                           '*
                           (list 'list
                                 (lderef var#3?)))
                     (lderef var#4?)))
             (lderef var#5?)
             (lderef var#6?)
             continuation)))
        ((and
           (rename
             '(var#1? var#2? var#6? var#3? var#4? var#5?))
           (consp fp1)
           (> (length fp1) 0)
           (or
             (qtrybind (setq *tempreg* (car fp1))
                       (list var#1? '* var#2?))
             (and (consp *tempreg*)
                  (= (length *tempreg*) 3)
                  (bind var#1? (caar fp1))
                  (or (eq '*
                          (setq *tempreg* (cadar fp1)))
                      (qtrybind *tempreg* '*))
                  (bind var#2?
                        (caddr (car fp1)))))
           (bind var#3? (cdr fp1))
           (bind var#4? fp2)
           (bind var#5? fp3)
           (user-defined-type (lderef var#2?))
           (bind (lderef var#6?)
                 (rewrite-auto
                   (list (lderef var#1?)
                         '*
                         (lderef var#2?))))
           (not
             (equal (lderef var#6?)
                    (list (lderef var#1?)
                          '*
                          (lderef var#2?))))
           (change-stacks)
           (phi-pattern
             (append (lderef var#6?)
                     (lderef var#3?))
             (lderef var#4?)
             (lderef var#5?)
             continuation)))
        ((and
           (rename '(var#3? var#1? var#2? var#4? var#5?))
           (consp fp1)
           (> (length fp1) 0)
           (or
             (qtrybind (setq *tempreg* (car fp1))
                       (list var#1? '* var#2?))
             (and (consp *tempreg*)
                  (= (length *tempreg*) 3)
                  (bind var#1? (caar fp1))
                  (or (eq '*
                          (setq *tempreg* (cadar fp1)))
                      (qtrybind *tempreg* '*))
                  (bind var#2?
                        (caddr (car fp1)))))
           (bind var#3? (cdr fp1))
           (bind var#4? fp2)
           (bind var#5? fp3)
           (free-arbterm (lderef var#1?)
                         (lderef var#4?))
           (change-stacks)
           (phi-pattern (lderef var#3?)
                        (add-arbterm
                          (list (lderef var#1?)
                                '*
                                (lderef var#2?))
                          (lderef var#4?))
                        (lderef var#5?)
                        continuation)))
        ((and
           (rename '(var#3? var#1? var#2? var#4? var#5?))
           (consp fp1)
           (> (length fp1) 0)
           (or
             (qtrybind (setq *tempreg* (car fp1))
                       (list (list 'recognise
                                   var#1?
                                   var#2?)
                             '*
                             '_))
             (and (consp *tempreg*)
                  (= (length *tempreg*) 3)
                  (or
                    (qtrybind (setq *tempreg*
                                    (caar fp1))
                              (list 'recognise
                                    var#1?
                                    var#2?))
                    (and (consp *tempreg*)
                         (= (length *tempreg*)
                            3)
                         (or
                           (eq 'recognise
                               (setq *tempreg* (caar (car fp1)))
                                     )
                           (qtrybind *tempreg*
                                     'recognise))
                         (bind var#1?
                               (cadar (car fp1)))
                         (bind var#2?
                               (caddr (caar fp1)))))
                  (or
                    (eq '*
                        (setq *tempreg* (lderef (cadar fp1))))
                    (qtrybind *tempreg* '*))))
           (bind var#3? (cdr fp1))
           (bind var#4? fp2)
           (bind var#5? fp3)
           (symbolp (lderef var#2?))
           (get (lderef var#2?)
                'recognisor)
           (change-stacks))
         (or
           (phi-pattern (lderef var#3?)
                        (cons
                          (list (lderef var#1?)
                                '*
                                (lderef var#2?))
                          (lderef var#4?))
                        (lderef var#5?)
                        continuation)
           (backtrack)))
        ((and
           (rename '(var#1? var#2? var#3? var#4? var#5?))
           (consp fp1)
           (> (length fp1) 0)
           (or
             (qtrybind (setq *tempreg* (car fp1))
                       (list var#1? '* var#2?))
             (and (consp *tempreg*)
                  (= (length *tempreg*) 3)
                  (bind var#1? (caar fp1))
                  (or (eq '*
                          (setq *tempreg* (cadar fp1)))
                      (qtrybind *tempreg* '*))
                  (bind var#2?
                        (caddr (car fp1)))))
           (bind var#3? (cdr fp1))
           (bind var#4? fp2)
           (bind var#5? fp3)
           (change-stacks)
           (phi (lderef var#1?)
                (lderef var#2?)
                (lderef var#4?)
                (append
                  (list
                    (list 'phi-pattern
                          var#3?
                          var#4?
                          var#5?))
                  continuation))))
        ((and
           (rename '(var#1? var#2? var#3? var#4? var#5?))
           (consp fp1)
           (> (length fp1) 0)
           (or
             (qtrybind (setq *tempreg* (car fp1))
                       (list var#1? '* var#2?))
             (and (consp *tempreg*)
                  (= (length *tempreg*) 3)
                  (bind var#1? (caar fp1))
                  (or (eq '*
                          (setq *tempreg* (cadar fp1)))
                      (qtrybind *tempreg* '*))
                  (bind var#2?
                        (caddr (car fp1)))))
           (bind var#3? (cdr fp1))
                         (bind var#4? fp2)
           (bind var#5? fp3)
           (logical-var (lderef var#2?))
           (change-stacks)
           (phi-pattern-user (get-user-types)
                             (list (lderef var#1?)
                                   '*
                                   (lderef var#2?))
                             (lderef var#3?)
                             (lderef var#4?)
                             (lderef var#5?)
                             continuation)))
        ((backtrack))))

(defun phi-pattern-user
       (fp1 fp2 fp3 fp4 fp5 continuation)
       (cond ((and (rename '(var#1? var#2?
                                    var#3?
                                    var#4?
                                    var#5?
                                    var#6?))
                   (bind var#1? fp1)
                   (consp fp2)
                   (= (length fp2) 3)
                   (bind var#2? (car fp2))
                   (eq '* (cadr fp2))
                   (bind var#3? (caddr fp2))
                   (bind var#4? fp3)
                   (bind var#5? fp4)
                   (bind var#6? fp5)
                   (consp (lderef var#1?))
                   (unify (car (lderef var#1?))
                          (lderef var#3?))
                   (change-stacks)
                   (phi-pattern
                     (cons (list (lderef var#2?)
                                 '*
                                 (lderef var#3?))
                           (lderef var#4?))
                     (lderef var#5?)
                     (lderef var#6?)
                     continuation)))
             ((and (rename '(var#1? var#2? var#3? var#4? var#5?))
                   (bind var#1? fp1)
                   (consp (lderef var#1?))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (bind var#4? fp4)
                   (bind var#5? fp5)
                   (change-stacks)
                   (phi-pattern-user (rest (lderef var#1?))
                                     (lderef var#2?)
                                     (lderef var#3?)
                                     (lderef var#4?)
                                     (lderef var#5?)
                                     continuation)))
             ((backtrack))))

(defun phi-user
       (fp1 fp2 fp3 fp4 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (bind var#4? fp4)
                   (consp (lderef var#1?))
                   (unify (car (lderef var#1?))
                          (lderef var#3?))
                   (change-stacks)
                   (phi (lderef var#2?)
                        (lderef var#3?)
                        (lderef var#4?)
                        continuation)))
             ((and (rename '(var#1? var#2? var#3? var#4?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (bind var#4? fp4)
                   (consp (lderef var#1?))
                   (change-stacks)
                   (phi-user (rest (lderef var#1?))
                             (lderef var#2?)
                             (lderef var#3?)
                             (lderef var#4?)
                             continuation)))
             ((backtrack))))

(defun immediate
       (fp1 fp2 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (consp (lderef var#2?))
                   (unify (lderef var#1?)
                          (car (lderef var#2?)))
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (consp (lderef var#2?))
                   (change-stacks)
                   (immediate (lderef var#1?)
                              (cdr (lderef var#2?))
                              continuation)))
             ((backtrack))))

(defun phi-recursion
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (consp (lderef var#1?))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (first (lderef var#1?))
                        (first (lderef var#2?))
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi-recursion
                                  (rest (lderef var#1?))
                                  (rest (lderef var#2?))
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun phi-rpt
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename nil)
                   (equal nil fp1)
                   (change-stacks)
                   (popstack continuation)))
             ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (consp (lderef var#1?))
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (phi (first (lderef var#1?))
                        (lderef var#2?)
                        (lderef var#3?)
                        (append
                          (list
                            (list 'phi-rpt
                                  (rest (lderef var#1?))
                                  var#2?
                                  var#3?))
                          continuation))))
             ((backtrack))))

(defun logic-equal
       (fp1 fp2 continuation)
       (cond ((and (rename '(var#1?))
                   (bind var#1? fp1)
                   (unify (lderef var#1?) fp2)
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun not-logic-equal
       (fp1 fp2 continuation)
       (cond ((and (rename '(var#1? var#2?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (not (equal (lderef var#1?)
                               (lderef var#2?)))
                   (change-stacks)
                   (popstack continuation)))
             ((backtrack))))

(defun call-f&
       (fp1 fp2 fp3 fp4 continuation)
       (cond ((and (rename '(var#1? var#2? var#3? var#4?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (bind var#4? fp4)
                   (change-stacks)
                   (funcall (lderef var#1?)
                            (lderef var#2?)
                            (lderef var#3?)
                            (lderef var#4?)
                            continuation)))
             ((backtrack))))

(defun call-type
       (fp1 fp2 fp3 continuation)
       (cond ((and (rename '(var#1? var#2? var#3?))
                   (bind var#1? fp1)
                   (bind var#2? fp2)
                   (bind var#3? fp3)
                   (change-stacks)
                   (funcall (lderef var#1?)
                            (lderef var#2?)
                            (lderef var#3?)
                            continuation)))
             ((backtrack))))

(defun full-tc
       (fp1)
       (cond ((eq '+ fp1) (set '*full-tc* t))
             ((eq '- fp1) (set '*full-tc* nil))
             (t (raise "code 13: No Patterns have Fired in full-tc"))))

(defun print-if-tc-traced
       (fp1 fp2 fp3)
       (cond ((eval '*ttc*)
              (rptprint "=" 50)
              (terpri)
              (write-string "?- ")
              (if *cons-form*
                  (print-formula (external-vars-out (list fp1 '* fp2)))
                  (ttc-sequel-print (external-vars-out (list fp1 '* fp2))))
              (format t "~% ~%")
              (phi-print-assumptions fp3)
              (if (ttc-choice)
                  nil
                  t))
             (t nil)))

(defun ttc-sequel-print
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '* (cadr fp1)))
              (sequel-print (insert-@-if-needed (car fp1)))
              (format t " * ")
              (sequel-print (insert-@-if-needed (caddr fp1))))
             (t (raise "code 13: No Patterns have Fired in ttc-sequel-print"))))

(defun insert-@-if-needed
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'cons (car fp1))
                   (null (caddr fp1)))
              (list (insert-@-if-needed (cadr fp1))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'cons (car fp1))
                   (and (consp (caddr fp1))
                        (= (length (caddr fp1))
                           3))
                   (eq 'cons
                       (caadr (cdr fp1))))
              (cons (insert-@-if-needed (cadr fp1))
                    (insert-@-if-needed
                      (list 'cons
                            (cadar (cddr fp1))
                            (caddr (caddr fp1))))))
             ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'cons (car fp1)))
              (list (insert-@-if-needed (cadr fp1))
                    '\|
                    (insert-@-if-needed (caddr fp1))))
             ((consp fp1) (cons '@
                                (mapcar 'insert-@-if-needed
                                        fp1)))
             (t fp1)))

(defun ttc-choice
       nil
       (prog (reply)
             (if (> *skip* 0)
                 (progn (decf *skip*) (return t)))
             (format t "Accept this sequent? ")
             (return (analyse-ttc-choice (lineread)))))

(defun analyse-ttc-choice
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 1)
                   (eq (car fp1) 'y))
              t)
             ((and (consp fp1)
                   (= (length fp1) 1)
                   (eq 'n (car fp1)))
              nil)
             ((and (consp fp1)
                   (= (length fp1) 1)
                   (eq 'abort (car fp1)))
              (restart))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq 'skip (car fp1))
                   (integerp (cadr fp1))
                   (> (cadr fp1) 0))
              (setq *skip* (cadr fp1)) t)
             ((and (consp fp1)
                   (= (length fp1) 1)
                   (eq 'leap (car fp1)))
              (setq *skip* 100000000) t)
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq 'cons (car fp1))
                   (eq '+ (cadr fp1)))
              (setq *cons-form* t) (format t "Acknowledged~%") (ttc-choice))
             ((and (consp fp1)
                   (= (length fp1) 2)
                   (eq 'cons (car fp1))
                   (eq '- (cadr fp1)))
              (setq *cons-form* nil)
              (format t "Acknowledged~%")
              (ttc-choice))
             ((and (consp fp1)
                   (= (length fp1) 1)
                   (eq 'help (car fp1)))
              (ttc-options) (ttc-choice))
             (t
              (format t
                      "Please type one of the following~%")
              (ttc-options)
              (ttc-choice))))

(defun ttc-options
       nil
       (format t
               "~%
y ........ Accept the sequent
n ........ Reject the sequent
abort .... Abort the trace
skip n ... Skip n steps
leap ..... Leap to end of trace
cons + ... Print lists in cons form using Lisp pretty-print
cons - ... Print lists in list form using Sequel print
help ..... Print this menu~%~%"))

(defun phi-print-assumptions
       (fp1)
       (ppa1 fp1 1))

(defun ppa1
       (fp1 fp2)
       (cond ((null fp1) (terpri))
             ((consp fp1)
              (format t "~A. " fp2)
              (if *cons-form*
                  (print-formula (external-vars-out (car fp1)))
                  (ttc-sequel-print (external-vars-out (car fp1))))
              (terpri)
              (ppa1 (cdr fp1) (1+ fp2)))
             (t (raise "code 13: No Patterns have Fired in ppa1"))))

(defun get-user-types nil *autotypes*)

(defun n-sig
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'define (car fp1)))
              (list (cadr fp1)
                    '*
                    (append (bldinput (first (first (caddr fp1)))
                                      nil)
                            (list '-> (newvar)))))
             (t (raise "code 13: No Patterns have Fired in n-sig"))))

(defun get-c-types
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '* (cadr fp1)))
              (list (butlast (caddr fp1) 2)
                    '->
                    (car (last (caddr fp1)))))
             (t (raise "code 13: No Patterns have Fired in get-c-types"))))

(defun skdef
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq 'define (car fp1)))
              (skolemise-rules (caddr fp1)))
             (t (raise "code 13: No Patterns have Fired in skdef"))))

(defun fail nil *failure-object*)

(defun pair
       (fp1 fp2)
       (cond ((and (null fp1) (null fp2)) nil)
             ((and (consp fp1)
                   (consp (car fp1))
                   (= (length (car fp1)) 3)
                   (eq 'cons (caar fp1))
                   (consp fp2))
              (cons
                (list (list 'cons
                            (cadar fp1)
                            (caddr (car fp1)))
                      '*
                      (car fp2))
                (pair (cdr fp1) (cdr fp2))))
             ((and (consp fp1)
                   (consp (car fp1)))
              (cons (list (car fp1) '* 'bool)
                    (pair (cdr fp1) fp2)))
             ((and (consp fp1) (consp fp2))
              (cons (list (car fp1) '* (car fp2))
                    (pair (cdr fp1) (cdr fp2))))
             (t
              (raise
                "code 27: arity mismatch between declared type and definition"))))

(defun recognise
       (fp1 fp2)
       (funcall (get fp2 'recognisor) fp1))

(defun add-arbterm
       (fp1 fp2)
       (append (aa1 (list fp1)) fp2))

(defun aa1
       (fp1)
       (cond ((null fp1) nil)
             ((and (consp fp1)
                   (equal (rewrite-auto (car fp1))
                          (car fp1)))
              (cons (car fp1)
                    (aa1 (cdr fp1))))
             ((consp fp1)
              (aa1 (append (rewrite-auto (car fp1))
                           (cdr fp1))))
             (t (raise "code 13: No Patterns have Fired in aa1"))))

(defun free-arbterm
       (fp1 fp2)
       (cond ((and (arbterm fp1)
                   (not (assoc fp1 fp2)))
              t)
             (t nil)))

(defun bldinput
       (fp1 fp2)
       (cond ((null fp1) fp2)
             ((and (consp fp1)
                   (consp (car fp1))
                   (not (equal (caar fp1) 'cons)))
              (bldinput (cdr fp1) fp2))
             ((consp fp1) (bldinput (cdr fp1)
                                    (cons (newvar) fp2)))
             (t (raise "code 13: No Patterns have Fired in bldinput"))))

(defun skolemise-rules
       (fp1)
       (mapcar 'skolemise-rule
               (mapcar 'remove-anon fp1)))

(defun remove-anon
       (fp1)
       (cond ((anon fp1) (concat (gentemp) '?))
             ((consp fp1) (mapcar 'remove-anon fp1))
             (t fp1)))

(defun skolemise-rule
       (fp1)
       (skolemise-rule1 fp1 fp1))

(defun skolemise-rule1
       (fp1 fp2)
       (cond ((null fp1) fp2)
             ((and (consp fp1)
                   (consp (car fp1)))
              (skolemise-rule1 (append (car fp1)
                                       (cdr fp1))
                               fp2))
             ((and (consp fp1)
                   (var (car fp1)))
              (skolemise-rule1 (subst 'junk
                                      (car fp1)
                                      (cdr fp1))
                               (subst (gentemp "&&")
                                      (car fp1)
                                      fp2)))
             ((consp fp1) (skolemise-rule1 (cdr fp1) fp2))
             (t (raise "code 13: No Patterns have Fired in skolemise-rule1"))))

(defun arbterm
       (fp1)
       (cond ((symbolp fp1) (arbterm1 (explode fp1)))
             (t nil)))

(defun arbterm1
       (fp1)
       (cond ((and (consp fp1)
                   (> (length fp1) 1)
                   (equal #\& (car fp1))
                   (equal #\& (cadr fp1)))
              t)
             (t nil)))

(defun user-defined-type
       (fp1)
       (cond ((symbolp fp1) (member fp1 *autotypes*))
             (t nil)))

(defun internal-signature
       (fp1)
       (internal-signature1 (gethash fp1 *sfht*)))

(defun internal-signature1
       (fp1)
       (ins$ (extrvars fp1) fp1))

(defun rewrite-auto
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '* (cadr fp1))
                   (symbolp (caddr fp1))
                   (fboundp (concat (caddr fp1) 'rewrite)))
              (funcall (concat (caddr fp1) 'rewrite)
                       (list (car fp1) '* (caddr fp1))))
             (t fp1)))

(defun rewrite-to-normal-form
       (fp1)
       (cond ((and (symbolp fp1)
                   (not (user-defined-type fp1)))
              fp1)
             ((symbolp fp1)
              (prog (temp sym)
                    (setq sym (gentemp))
                    (setq temp (rewrite-auto (list sym '* fp1)))
                    (if (= (length temp) 1)
                        (return (rewrite-to-normal-form (third (first temp))))
                        (return fp1))))
             ((consp fp1) (mapcar 'rewrite-to-normal-form
                                  fp1))
             (t
              (raise
                "code 13: No Patterns have Fired in rewrite-to-normal-form"))))

(defun disjunctive-context
       (fp1)
       (some 'disjunctive-t-expr fp1))

(defun disjunctive-t-expr
       (fp1)
       (cond ((and (consp fp1)
                   (= (length fp1) 3)
                   (eq '* (cadr fp1))
                   (and (consp (caddr fp1))
                        (= (length (caddr fp1))
                           3))
                   (eq 'or (caadr (cdr fp1))))
              t)
             (t nil)))

(defun split-disjunctive-context-l
       (fp1)
       (cond ((and (consp fp1)
                   (consp (car fp1))
                   (= (length (car fp1)) 3)
                   (eq '* (cadar fp1))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'or
                       (caadr (cdar fp1))))
              (cons (list (caar fp1)
                          '*
                          (cadar (cddar fp1)))
                    (cdr fp1)))
             ((consp fp1)
              (cons (car fp1)
                    (split-disjunctive-context-l (cdr fp1))))
             (t
              (raise
                "code 13: No Patterns have Fired in split-disjunctive-context-l"))))

(defun split-disjunctive-context-r
       (fp1)
       (cond ((and (consp fp1)
                   (consp (car fp1))
                   (= (length (car fp1)) 3)
                   (eq '* (cadar fp1))
                   (and (consp (caddr (car fp1)))
                        (= (length (caddr (car fp1)))
                           3))
                   (eq 'or
                       (caadr (cdar fp1))))
              (cons (list (caar fp1)
                          '*
                          (caddr (caddr (car fp1))))
                    (cdr fp1)))
             ((consp fp1)
              (cons (car fp1)
                    (split-disjunctive-context-r (cdr fp1))))
             (t
              (raise
                "code 13: No Patterns have Fired in split-disjunctive-context-r"))))
