;;|=========================================================================|
;;|                         COPYRIGHT NOTICE                                |
;;|                                                                         |
;;|             Copyright 1990, 1991, 1992, 1993, Mark Tarver               |
;;|                                                                         |
;;|        Permission to use, copy, and distribute this software and        |
;;| its documentation for any purpose is hereby granted providing           |
;;| any such use, copying and distribution is not done                      |
;;| for money, securities or any other pecuniary benefit and that both      |
;;| the above copyright and this permission notice appear in all copies     |
;;| and in the supporting documentation.  Any modification of the software  |
;;| or documentation should be accompanied by the name of the author of the |
;;| modification, and Mark Tarver must be formally notified                 |
;;| of this modification before distributing the software.                  |
;;|                                                                         |
;;|       Any commercial use of this software or use of the names "SEQUEL", |
;;| or "Mark Tarver" in connection with any version, modified or            |
;;| unmodified, of this software, through publicity or advertising,         |
;;| requires written permission.  Mark Tarver makes no                      |
;;| representation about the suitability of this software for any purpose.  |
;;| SEQUEL is provided "as is" without express or implied warranty.         |
;;|                                                                         |
;;|       Mark Tarver disclaims all warranties with regard to               |
;;| this software, including all implied warranties of merchantability and  |
;;| fitness. In no event shall Mark Tarver be liable for any                |
;;| special, indirect or consequential damages or any damages whatsoever    |
;;| resulting from loss of use, data or profits, whether in an action of    |
;;| contract, negligence or other tortious action, arising out of or in     |
;;| connection with the use or performance of this software.                |
;;|                                                                         |
;;|=========================================================================|

    (in-package :sequel)

(defun autoprove
       (fp1 fp2)
       (time (autoprove1 1
                         fp1
                         nil
                         (read-file fp2)
                         (list 0 0 0))))

(defun autoprove1
       (fp1 fp2 fp3 fp4 fp5)
       (cond ((and (null fp4)
                   (consp fp5)
                   (= (length fp5) 3))
              (autoprove-end (car fp5)
                             (cadr fp5)
                             (caddr fp5)))
             ((and (consp fp4)
                   (> (length fp4) 1)
                   (turnstile (car fp4)))
              (autoprove1 (1+ fp1)
                          fp2
                          nil
                          (cddr fp4)
                          (keep-tally
                            (autoprove2 fp1
                                        fp2
                                        (list fp3
                                              (return-turnstile) 
                                              (cadr fp4)))
                            fp5)))
             ((and (consp fp4)
                   (> (length fp4) 1)
                   (comma (cadr fp4)))
              (autoprove1 fp1
                          fp2
                          (append fp3
                                  (list (car fp4)))
                          (cddr fp4)
                          fp5))
             ((consp fp4)
              (autoprove1 fp1
                          fp2
                          (append fp3
                                  (list (car fp4)))
                          (cdr fp4)
                          fp5))
             (t (raise "code 31: syntax error from autoprove"))))

(defun autoprove-end
       (fp1 fp2 fp3)
       (format t "~%~A formulae proved~%" fp1)
       (format t "~A formulae unproved~%" fp2)
       (format t
               "~A tactical inferences performed~%~%"
               fp3)
       (list 'autoprove 'run 'completed))

(defun keep-tally
       (fp1 fp2)
       (cond ((and (equal t fp1)
                   (consp fp2)
                   (= (length fp2) 3))
              (list (1+ (car fp2))
                    (cadr fp2)
                    (+ *tactical-inferences*
                       (caddr fp2))))
             ((and (consp fp2)
                   (= (length fp2) 3))
              (list (car fp2)
                    (1+ (cadr fp2))
                    (+ *tactical-inferences* (caddr fp2))))
             (t (raise "code 13: No Patterns have Fired in keep-tally"))))

(defun autoprove2
       (fp1 fp2 fp3)
       (cond ((and (consp fp3)
                   (= (length fp3) 3)
                   (turnstile (cadr fp3)))
              (prog (start-time stop-time run-time sequent answer)
                    (setq *tactical-inferences* 0)
                    (setq sequent (list (mapcar 'external-syntax-in
                                                (car fp3))
                                        (return-turnstile) 
                                        (external-syntax-in (caddr fp3))))
                    (typecheck (put-conses sequent)
                               'sequent)
                    (print-auto-sequent fp1 sequent)
                    (terpri)
                    (initstacks)
                    (setq *proofhistory* nil)
                    (setq *problem* (list sequent))
                    (setq start-time (get-internal-run-time))
                    (setq answer (catch 'success
                                        (execute-proof-command (list fp2)
                                                               *problem*)))
                    (setq stop-time (get-internal-run-time))
                    (setq run-time (calibrate (- stop-time start-time)))
                    (if (eval '*stats*)
                        (stats run-time))
                    (if (eq t answer)
                        (format t "yes~%")
                        (format t "no~%"))
                    (return answer)))
             (t (raise "code 13: No Patterns have Fired in autoprove2"))))

(defun print-auto-sequent
       (fp1 fp2)
       (cond ((and (consp fp2)
                   (= (length fp2) 3)
                   (null (car fp2))
                   (turnstile (cadr fp2)))
              (rptprint "=" 50)
              (format t "~%Theorem ~A ~%~%" fp1)
              (write-string "?- ")
              (print-formula
                (external-syntax-out (external-vars-out (caddr fp2))))
              (format t "~%"))
             ((and (consp fp2)
                   (= (length fp2) 3)
                   (turnstile (cadr fp2)))
              (rptprint "=" 50)
              (format t "~%Theorem ~A ~%~%" fp1)
              (write-string "?- ")
              (print-formula
                (external-syntax-out (external-vars-out (caddr fp2))))
              (format t "~% ~%")
              (print-assumptions (car fp2)))
             (t
              (raise "code 13: No Patterns have Fired in print-auto-sequent"))))
