/*
 *
 *                        Otter 2.2
 *
 *                Automated Deduction System
 *         Copyright (C) Argonne National Laboratory
 *
 *   Argonne does not guarantee this software in any manner and is
 *   not responsible for any damages that may result from its use.
 *   Furthermore, Argonne does not provide any formal support for this
 *   software.  This is an experimental program.  This software
 *   or any part of it may be freely copied and redistributed,
 *   provided that this paragraph is included in each source file.
 *
 */

/*
 *   Conditional compilation.  Several places in the code assume that
 *   exactly one of the following 3 symbols is defined:
 *      
 *      TP_UNIX -- UNIX C compiler (usually cc or gcc)
 *      THINK_C -- Think-C compiler for Macintosh
 *      TURBO_C -- Turbo C compiler for PCs
 *
 *   If necessary, modify code for one of those to fit your compiler.
 *
 *   (ROO is defined for the parallel, shared memory version of Otter.) 
 */

#define IN_MAIN  /* so that global vars in header.h will not be external */
#include "header.h"

#ifdef TP_UNIX  /* for call to signal() */
#include <signal.h>
#endif

#ifdef THINK_C  /* Macintosh */
#include <console.h>  /* for call to ccommand */
#endif

#ifdef TURBO_C  /* PC */
extern unsigned _stklen = 16000;  /* stack size for Turbo C. */
#endif

main(argc,argv)
int argc;
char *argv[];
{
    struct clause *giv_cl;
    int errors, early_stop;
    char *str;

#ifdef THINK_C  /* macintosh */
    argc = ccommand(&argv);
#endif

#ifdef TP_UNIX
    signal(SIGINT,  interrupt_interact);
#endif

    print_banner(argc, argv);
    init();
    read_all_input();
    errors = Stats[INPUT_ERRORS];
    if (errors != 0) {
	fprintf(stderr, "\n%d input errors were found.\007\n\n", errors);
	printf("%d input errors were found.\n", errors);
	print_options(stdout);
	exit(1);
	}
    else {
	early_stop = 0;
	giv_cl = extract_given_clause();

/* --------------------- MAIN LOOP STARTS HERE --------------------- */

	while (giv_cl != NULL && early_stop == 0) {

	    if (Parms[REDUCE_WEIGHT_LIMIT].val != 0)
		reduce_weight_limit();

	    Stats[CL_GIVEN]++;
	    if (Flags[PRINT_GIVEN].val) {
		printf("\ngiven clause #%ld: ", Stats[CL_GIVEN]);
		printf("(wt=%d) ", giv_cl->weight);
		print_clause(stdout, giv_cl);
		fflush(stdout);
		}
#ifndef TP_UNIX
	    /* if PC or Macintosh, so user knows something is happening */
	    fprintf(stderr, "\ngiven clause #%ld: ", Stats[CL_GIVEN]);
	    fprintf(stderr, "(wt=%d) ", giv_cl->weight);
	    print_clause(stderr, giv_cl);
	    fflush(stderr);
#endif
	    index_lits_clash(giv_cl);
	    append_cl(Usable, giv_cl);
	    infer_and_process(giv_cl);
	    early_stop = check_stop();
	    if (early_stop == 0)
		giv_cl = extract_given_clause();
	    if (early_stop == 0 && giv_cl != NULL && Parms[REPORT].val > 0)
		report();

	    }  /* end of main loop */

/* --------------------- MAIN LOOP ENDS HERE --------------------- */

	/* print the reason the search ended */

	if (early_stop == 0) {
	    fprintf(stderr, "\nsos empty.\007\n\n");
	    printf("\nsos empty.\n");
	    }

	else {
	    if (early_stop == 1)
		str = "max_given";
	    else if (early_stop == 2)
		str = "max_seconds";
	    else if (early_stop == 3)
		str = "max_gen";
	    else if (early_stop == 4)
		str = "max_kept";
	    fprintf(stderr, "\nsearch stopped by %s option.\007\n\n", str);
	    printf("\nsearch stopped by %s option.\n", str);
	    }

	cleanup();

	}

}  /* main */

/*************
 *
 *    void print_banner(argc, argv)
 *
 *************/

void print_banner(argc, argv)
int argc;
char *argv[];
{
    int i;
    char host[64];

#ifdef TP_UNIX
    if (gethostname(host, 64) != 0)
	str_copy("???", host);
#else
#ifdef THINK_C
    str_copy("a Macintosh", host);
#else
#ifdef TURBO_C
    str_copy("a PC", host);
#else
    str_copy("???", host);
#endif
#endif
#endif

    printf("----- OTTER 2.2, July 1991 -----\nThe job began on %s, %s", host, get_time());

#ifdef TP_UNIX
    printf("The command was \"");
    for(i = 0; i < argc; i++)
        printf("%s%s", argv[i], (i < argc-1 ? " " : ""));
    printf("\".\n\n");
#endif    
    
}  /* print_banner */

#ifdef TP_UNIX

/*************
 *
 *    void interrupt_interact()
 *
 *    This routine provides some primitive interaction with the user.
 *
 *************/

void interrupt_interact()
{
    FILE *fp;
    struct term *t;
    int rc, go_back;

    fp = fopen("/dev/tty", "r+");

    if (fp == NULL)
	printf("interaction failure: cannot find tty.\n");
    else {

	printf("\n --- BEGIN INTERACTION ---\n\n");
	fprintf(fp, "\n --- BEGIN INTERACTION ---\n");
	fprintf(fp, "Commands are help, kill, continue, set(...), and assign(...,...).\n");
	fprintf(fp, "All commands must end with a period.\n> ");
	fflush(fp);
        fseek(fp, (long) 0, 2);  /* position at end of file */
	t = read_term(fp, &rc);
	fflush(fp);
	go_back = 0;
	while ((t != NULL || rc == 0) && !go_back) {
	    if (t == NULL)
		fprintf(fp, " malformed term; try again.\n> ");
	    else if (t->type == NAME || t->type == VARIABLE) {
		
		if (str_ident("help", sn_to_str(t->sym_num))) {
		    fprintf(fp, "Commands are help, kill, continue, set(...), and assign(...,...).\n");
		    fprintf(fp, "All commands end with a period.\n> ");
		    }
		else if (str_ident("kill", sn_to_str(t->sym_num))) {
		    printf("\nkilled during interaction.\n");
		    fprintf(stderr, "killed during interaction.\007\n");
		    fclose(fp);
		    cleanup();
		    exit(1);
		    }
		else if (str_ident("continue", sn_to_str(t->sym_num)))
		    go_back = 1;
		else
		    fprintf(fp, " command not understood.\n> ");
		}
	    else if (str_ident("set", sn_to_str(t->sym_num))) {
		if (change_flag(fp, t, 1)) {
		    print_term(stdout, t); printf(".\n");
		    fprintf(fp, " ok.\n> ");
		    }
		}
	    else if (str_ident("clear", sn_to_str(t->sym_num))) {
		if (change_flag(fp, t, 0)) {
		    print_term(stdout, t); printf(".\n");
		    fprintf(fp, " ok.\n> ");
		    }
		}
	    else if (str_ident("assign", sn_to_str(t->sym_num))) {
		if (change_parm(fp, t)) {
		    print_term(stdout, t); printf(".\n");
		    fprintf(fp, " ok.\n> ");
		    }
		}
	    else
		fprintf(fp, " command not understood.\n> ");
	    
	    if (t != NULL)
		zap_term(t);
	    if (go_back == 0) {
		fflush(fp);
		fseek(fp, (long) 0, 2);  /* position at end of file */
		t = read_term(fp, &rc);
		fflush(fp);
		}
	    }
	
	printf("\n --- end interaction ---\n\n");
	fprintf(fp,"\n --- end interaction ---\n");
	
	fclose(fp);
	}

}  /* interrupt_interact */

#endif

