
;;; Two Simple Text Editor Extensions as a proposal for
;;; the final version of ACLPC 2.0.
;;; 
;;; You may modify or distribute the code as you want, but
;;; we would appreciate an editor without the 32 K limit
;;; 
;;; Stefan Bamberger and Karsten Poeck
;;; {bambi|poeck}@informatik.uni-wuerzburg.de
;;; University of Wuerzburg, 
;;; 97218 Gerbrunn
;;; Germany
;;; May 1994

#|
te-display-lambda-list-in-status-bar
mapped to space in mac mode
Simple Code to display the arguments of a function just after you typed a space
after the function-name

Open Problem:
flickers a bit since it uses te::backward-word and te::current-symbol
|#

(te::set-event-function TE::*MAC-COMTAB* '(#\space) 'te-display-lambda-list-in-status-bar)

(defmethod te-display-lambda-list-in-status-bar (pane)
  (when pane
     (te::insert-character pane #\space)
     (:mark pane)
        (te::backward-word pane)
        (let ((symbol (te::current-symbol pane)))
           (when symbol
              (let ((neu (acl::help-lambda-list symbol)))
                 (when (and neu (not (eql :unknown neu)))
                    (window-message (window-parent *lisp-main-window*)
                       "~a" neu)))))
        (:exchange-to-mark pane))) 
#|
te-complete-form
mapped to (control-key #\space) in mac mode

A simple but working-symbol-completition utility for ACL/PC alpha-2.
Partially inspired by the several completition utilities for MCL 2.0

Open Problems
te-insert-word is painfully slow

(ask-user-for-choice-from-list "Select Completition"
                         (list 1 2 3 4)
                         :dialog-exterior-box (make-box 50 50 250 450)
                         )

is bogus wrt. to the :dialog-exterior-box

and

(window-warning (window-parent *lisp-main-window*)
   "This should not crash")

crashes

since 
window-message is called with nil as window argument

;patch
(defun patched-window-warning (window format-string &rest format-args)
   
   (apply #'window-message window format-string format-args)
   (beep window))

(patched-window-warning (window-parent *lisp-main-window*)
   "This should not crash")

|#

                  
(te::set-event-function TE::*MAC-COMTAB* '(control-key #\space) 'te-complete-form)
;set this to your favorite text editor mode

(defparameter *te-max-completitions* 100)

(unless (fboundp 'ask-user-for-choice-from-list)
     (defun ask-user-for-choice-from-list (titel auswahl)
          (first (b=auswahl auswahl
                       :ueberschrift titel
                       :werttyp :wert
                       :f-werte-verbalisieren #'symbol-name
                       )))
     )

(defmethod te-complete-form (pane)
   (when pane
      (te::backward-word pane)
      (let ((symbol (te::current-symbol pane)))
         (when symbol
            (let ((neu (te-complete symbol #+:acl2a (stream-package pane)
                               #-:acl2a *package*)))
               (cond (neu
                        (te::delete-word pane)
                        (te-insert-word pane
                           neu))
                     (t (te::forward-word pane))))))))

(defun te-insert-word (pane string)
   (dotimes (x (length string))
      (te::insert-character pane (CHAR-DOWNCASE (char string x)))))

;; adapted version of the symbol completion code of
;; Alex Repenning University of Colorado at Boulder 1990
(defun te-COMMON-SYMBOL-NAME-PREFIX-1 (Symbols)
  (let* ((First-String (symbol-name (first Symbols)))
         (rest-Strings (mapcar #'symbol-name (rest Symbols)))
         (kleinste-laenge (let ((zahl (or (length (first rest-strings)) 0))
                                )
                            (dolist (var (rest rest-strings) zahl)
                              (setq zahl (min zahl (length var)))
                              ))) ;;(apply #'min (mapcar #'length rest-strings)) )
         )
     (let ((string
      (with-output-to-string (S)
         (block hugo
       (dotimes (I (length First-String))
          (let ((Char (char First-String I)))
             (dolist (String rest-Strings (princ Char S))
                (when (or (>= I kleinste-laenge) 
                          (char/= (char String I) Char))
                   (return-from hugo nil)))))))))
        (unless (string= string "")
           string))))

(defun te-matching-prefix-symbol (string symbol-list)
   (let ((l (length string)))
      (remove-if-not
         #'(lambda(symbol)
              (string=
                 string
                 (symbol-name symbol)
                 :end1 l
                 :end2 l))
         symbol-list)))

(defun te-apropos-perhaps-prefix (string package)
   (let ((local-symbols (apropos-list string package))
         global-symbols
         prefix-lokal-symbols
         prefix-global-symbols)
      (if (setq prefix-lokal-symbols
             (te-matching-prefix-symbol string local-symbols))
         prefix-lokal-symbols
         (if (setq prefix-global-symbols
                (te-matching-prefix-symbol string
                 (setq global-symbols (apropos-list string))))
            prefix-global-symbols
            (or local-symbols
                global-symbols)))))

(defun te-possible-completitions (symbol package)
   (let* ((comps
          (remove symbol
             (te-apropos-perhaps-prefix (symbol-name symbol) package)))
          (number (length comps))
          (common-prefix-as-string 
             (when (cdr comps)
                    (te-COMMON-SYMBOL-NAME-PREFIX-1 comps)))
          )
      (if (and common-prefix-as-string
               (not (string-equal common-prefix-as-string
                       (symbol-name symbol))))
         common-prefix-as-string
         (if (< number *te-max-completitions*)
            (values comps number nil)
            (values (subseq comps 0 *te-max-completitions*) *te-max-completitions*
               number)))))

(defun te-complete (symbol &optional (package *package*))
   (multiple-value-bind
        (possible-completitions length to-much)
       (te-possible-completitions symbol package)
      (cond ((null possible-completitions)
             nil)
            ((stringp possible-completitions) possible-completitions)
            ((null (cdr possible-completitions))
             (symbol-name (first possible-completitions)))
            (T (window-message (window-parent *lisp-main-window*)
                  (format nil "Found ~a completitions ~a"
                     length (if to-much
                               (format nil "Truncated. from ~a "to-much)
                               ".")))
               (let ((choice
                        (ask-user-for-choice-from-list "Select Completition"
                         possible-completitions
                         ;:dialog-exterior-box (make-box 50 50 250 450)
                         )))
                  (when choice
                     (symbol-name choice))
                  )))))


