
 #|
New function (cg:set-window-parent child-window new-parent-window
&optional position)

child-window --- the window that is to be moved onto a new parent window

new-parent --- the window onto which child-window is to be moved;
you can't change the parent to *screen*, or change
the parent if the current parent is *screen*;  other errors will be
reported if you try to change the parent to be the child itself
or a descendant of the child

position --- if passed, specifies the position for the upper-left
corner of the child's exterior relative to the upper-left corner
of the new parent's interior.  If not passed, it will be equal to
the child's old position (that is, the child will be offset 
from the upper-left of its new parent at the same distance
that it was offset from the upper-left of its old parent).

---------------
New function (cg:window-ancestor-p window ancestor-maybe)

Returns non-NIL iff ancestor-maybe is either the parent window of
window, or the parent of the parent, and so on

---------------
|#

(in-package :pc)

(export 'cg::window-ancestor-p :cg)
(defun cg::window-ancestor-p (window ancestor-maybe)
   (and (not (eq window *screen*))
        (let ((parent (window-parent window)))
           (cond ((null parent) nil)
                 ((eq parent ancestor-maybe) t)
                 (t (window-ancestor-p parent ancestor-maybe))))))

;; new, perhaps for windows/windev1.lsp
(export 'cg::set-window-parent :cg)
(defun cg::set-window-parent (child-window new-parent-window
                                &optional position)
   (when (eq new-parent-window *screen*)
      (error "You can't change a window's parent to be the screen; ~
it must be created on the screen initially."))
   (when (eq child-window new-parent-window)
      (error "Tried to set the parent of a window to be itself."))
   (when (window-ancestor-p new-parent-window child-window)
      (error "Tried to set the parent of a window to be one of ~
its descendant windows."))
   (when (and position (not (positionp position)))
      (error "Bad position arg (~a) passed to set-window-parent"
         position))
   (let ((hdc (device-context child-window))
         (old-parent-window (window-parent child-window))
         box parent-box dx dy)
      (when (eq old-parent-window *screen*)
         (error "You can't change the parent of a window that was ~
created directly on the screen."))
      (setf (slot-value child-window 'acl::location)
            new-parent-window)
      ;; Clear focus from the moving window so that aclpc will not
      ;; have a bogus value in the focus-child slot of its old parent.
      (clear-focus child-window)
      (SetParent (window-handle child-window)
         (window-handle new-parent-window))
      (setf (slot-value child-window 'child-p)
            (if (eq new-parent-window *screen*)
               nil
               t))
      (set-focus new-parent-window)
      (set-focus child-window)
      (when position
         (move-window child-window position))
      (unless (device-context child-window)
         (setf (slot-value child-window 'device-handle2) hdc))
      ))

(defsetf window-parent set-window-parent)
