
;;
;; standarddialoge
;; stand 4/94, bambi
;;
;; dateiauswahl, -eingabe
;; schriftauswah
;; nachricht

(defun choose-file-dialog (&key directory button-string mac-file-type)
     (declare (ignore mac-file-type))
     (b=dateiauswahl :ordner directory
          :buttontext button-string)
     )

(defun choose-new-file-dialog (&key directory prompt button-string)
     (declare (ignore prompt button-string))
     (b=dateieingabe :ordner directory)
     )

(defun b=dateiauswahl ( &key ordner buttontext  &allow-other-keys)
     (when (and ordner (stringp ordner))
          (setq ordner (full-pathname ordner)))
     (let ((datei? (pop-up-open-file-dialog
                             *unser-haupt-fenster* nil
                             (nth (random 4) '( "Allegro" "Stefan" "Karsten" "D3"))
                             (or buttontext "Datei auswhlen")
                             nil
                             (merge-pathnames (or ordner *default-pathname-defaults*)))
             )
            )
         (if datei?
              datei?
            (throw-top-level))
         ))

(defun b=dateieingabe (&key ordner directory
                         &allow-other-keys)
   (when directory
      (setq ordner directory))
       (when (and ordner (stringp ordner))
          (setq ordner (full-pathname ordner)))
     (catch  'PC::DEFAULT-CANCEL
         (let ((datei?
                 (pop-up-save-file-dialog
                         *unser-haupt-fenster* (merge-pathnames (or ordner *default-pathname-defaults*))
                             (nth (random 4) '( "Allegro" "Stefan" "Karsten" "D3"))
                         "Datei angeben"
                         "foo"
                         (merge-pathnames (or ordner *default-pathname-defaults*)))
                     ))
         (if datei?
              datei?
            (throw-top-level))
         )
     )
     )

(defun b=schriftauswahl (&key (schrift (make-font nil nil 16))
                                            ueberschrift-ergaenzung)
     (declare (ignore ueberschrift-ergaenzung))
     (catch  'PC::DEFAULT-CANCEL
         (let ((font?  
                    (cg:ask-user-for-font 
                     :initial-font schrift))
                )
            (if font?
               font?
               (throw-top-level))
            )))

(defun b=ordnerauswahl (&key ordner buttontext text
                                             (throw-to-cancel t)
                                             directory
                                             button-string
                                             prompt)
     (declare (ignore throw-to-cancel prompt))
     (let ((datei (b=dateiauswahl :ordner (or ordner directory)
                           :buttontext (or buttontext
                                                  button-string
                                                  "Zum Ordner auswhlen Datei auswhlen"
                                                  ))))
         (when datei
              (make-pathname 
                    :device (pathname-device datei)
                    :directory (pathname-directory datei)))))
         
         
(defun b=nachricht (string &rest egal)
     (b=ja-nein string
          :abbrechen-text nil
          :ja-text (b=s :ok)
          :fensterbreite *screen-width*
          :nein-text nil
          :icon warning-icon)
     )

;;;      (pop-up-message-dialog
;;;           *unser-haupt-fenster*
;;;           "Nachricht"
;;;           (b=string-umbrechen string *screen-width*)
;;;           warning-icon
;;;           "Ok"))
