

#|
;Beispiel mit Propertylisten

(defun bb-schrifteingabe (schrift)
  (if schrift
    (b=schriftauswahl :schrift schrift)
    (b=schriftauswahl)))

(b=setplist 'test '(a 1  c f))
(modal-dialog 
      (setq hugo
 (b=konfigurationsdialog-erzeugen '("Test2" 
                           (a "Diagnosen" 1 2 3)
                           (c "Symptomnamen" a b c d e f g h)
                           (d "Zahlen" :numerisch 40)
                           (e "Texte" :text 70 7)
                           "Was"
                           (b "Schrift"  :button bb-schrifteingabe 300)
                           )
                         
                         'b=erzeuge-string
                         :f-inaktive-bezeichner #'(lambda()'(a b))

                         :lesefunktion #'(lambda(wert)
                                           (getf (symbol-plist 'test) wert))
                         :schreibfunktion #'(lambda(variable wert)
                                              (setf (getf (symbol-plist 'test) variable)
                                                    wert))
                         :fensterbreite 600
                         :alternativenabstand 70
                         :zeilenabstand 20
                         :defaultliste '((a 2)(c f)(d 99)(e "otto"))
                         :Ueberschrift "Testkonfigurierung")))
(symbol-plist 'test)
|#

#|
;Beispiel mit globalen Variablen

(defvar a )
(defvar b )
(defvar c )
(defvar d )

(setq a 1)
(setq b :hier)
(setq c 'f)
(setq d '(1 3))

(defvar fenstervariable)

 (setq fenstervariable nil)
(b=konfigurierungsdialog-aufrufen
 'fenstervariable
  '("Test" 
    (a "Diagnosen" 1 2 3)
    (c "Symptomnamen" :abstand 65 a b c d e f g h)
    
    "Was"
    (b "Symptome" :hier :auf :objekt)
    "Auch mehrfach"
    (d "Multiple" :multiple 1 2 3 4 5 6)
    )
  'b=erzeuge-string
  :f-inaktive-bezeichner #'(lambda()(list 'b))
  :fensterbreite 500
  :alternativenabstand 130
  :defaultliste '((a 2)(c f)(d (1 2 99))(e 77))
  :Ueberschrift "Testkonfigurierung"
  :f-sichern #'(lambda ()
                  (b=speichere-funktionsausgabe-auf-datei
                    (choose-new-file-dialog)
                    #'(lambda()(b=LISPbindungen-sichern t '(a b c d) :wertbindung))
                    nil))
  :f-laden #'(lambda()
               (load
                (choose-file-dialog)))
  )
|#

#|

;Beispiel mit Objekt Attributstruktur

(b=setze-propertywert 'test 'was 3)
(b=setze-propertywert 'test 'wer "Ich")
(b=setze-propertywert 'test1 'was99 :hier)

(modal-dialog 
 (b=konfigurationsdialog-erzeugen 
  '("Test3" 
                           ((test was)  "Diagnosen" 1 2 3)
                           ((test wer) "Symptomnamen" "Ich" "Du" "Er" "Sie")
                           
                           "Was"
                           ((test1 was99) "Symptome" :hier :auf :objek)
                           )
                          'b=erzeuge-string
                         :lesefunktion #'(lambda(paar)
                                           (get (first paar)(second paar)))
                         :schreibfunktion #'(lambda(paar wert)
                                              (setf (get (first paar) (second paar))
                                                    wert))
                         :fensterbreite 600
                          :alternativenabstand 70
                         :Ueberschrift "Testkonfigurierung Objekt Attribut"))
(b=plist 'test)
(b=plist 'test1)
|#

