
/*
;;;
;;;
;;;				NO WARRANTY
;;;
;;; This software is distributed free of charge and is in the public domain.
;;; Anyone may use, duplicate or modify this program.  Thinking Machines
;;; Corporation does not restrict in any way the use of this software by
;;; anyone.
;;; 
;;; Thinking Machines Corporation provides absolutely no warranty of any kind.
;;; The entire risk as to the quality and performance of this program is with
;;; you.  In no event will Thinking Machines Corporation be liable to you for
;;; damages, including any lost profits, lost monies, or other special,
;;; incidental or consequential damages arising out of the use of this program.
;;;
;;;
*/

/*  Cliff Lasser 7/24/87   (CAL@THINK.COM) */

/*  font-stripper.c


This program will strip Symbolics font information from a text file.  The syntax
is "font-stripper filename" or "font-stripper in-filename out-filename".  If only
a single filename is given, then the font-stripper replaces the source file with
the font stripped output.  With two filenames, the output file gets the
font-stripped output.  Warning: The program doesn't correctly deal with the case
where in-filename is the same as out-filename.


*/

#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
{
  FILE *fp_in, *fp_out, *fopen();
  /* void remove_fonts(FILE, FILE); */
  char *filename_in, *filename_out;

  char temp_filename_out1[2000], temp_filename_out2[2000];

  int c;

  filename_in = *++argv;
  filename_out = *++argv;

  switch (argc) {
  case 2:
    /* the user specified only a single arg.  Do the font stripping in place. */
    if ((fp_in = fopen(filename_in, "r")) == NULL) {
      printf("error: could not open the input file %s\n", filename_in);
      exit(1);
    }

    strcpy(temp_filename_out1, filename_in);
    strcat(temp_filename_out1, "-fontstripper-output");
    strcpy(temp_filename_out2, filename_in);
    strcat(temp_filename_out2, "-fontstripper-backup");

    if ((fp_out = fopen(temp_filename_out1, "w")) == NULL) {
      printf("error: could not open the output file %s\n", temp_filename_out1);
      exit(1);
    }
    remove_fonts(fp_in, fp_out);
    fclose(fp_out);

    /* rename the source to something */
    rename(filename_in, temp_filename_out2);
    /* rename the output file to the source file */
    rename(temp_filename_out1, filename_in);
    /* now delete the original source file */
    unlink(temp_filename_out2);

    break;

  case 3:
    if ((fp_in = fopen(filename_in, "r")) == NULL) {
      printf("error: could not open the input file %s\n", filename_in);
      exit(1);
    }    
    if ((fp_out = fopen(filename_out, "w")) == NULL) {
      printf("error: could not open the output file %s\n", filename_out);
      exit(1);
    }
    remove_fonts(fp_in, fp_out);
    fclose(fp_out);
    break;

  default:
    printf("error: arglist looks like  foo in out \n");
    exit(1);
  }

  /* now to copy the input file to the output file */

  fclose(fp_in);


}

remove_fonts(fp_in, fp_out)
     FILE *fp_in, *fp_out;
{     
  char c;
  int count;
  while ((c = getc(fp_in)) != EOF) {
    
    if (c != 6) {
      /* If the character is not a control-f, just put it to the output file */
      putc(c, fp_out);
    } else {
      /* we have font control here. */
      
      if ((c = getc(fp_in)) == EOF)
	/* we got an eof while trying to get more font control. finish copying */
	return;
      
      switch (c) {
      case '0': case '1': case '2': case '3': case '4': 
      case '5': case '6': case '7': case '8': case '9':
	/* we got a number.  Actually, there is nothing to do! Just remove it and keep going. */
	break;
      case 5:
	/* if the char is a control-e, remove all chars until the next "]" */
	while (((c = getc(fp_in)) != EOF) && (c != ']')) ;
	break;
      case '(':
	/* now we have to search until the next matching close paren. what a pain */
	count = 1;
	while ((c = getc(fp_in)) != EOF) {
	  switch (c) {
	  case '(': count += 1; break;
	  case ')': count -= 1; break;
	  }
	  if (count == 0) break;  /* we found a matching close parent */
	}
	break;
      default:
	printf("error, ran across character %d.", c);
	exit(1);
      }}}}
