;;; Copyright (c) 1987 John Peterson
;;;   Permission is given to freely modify and distribute this code
;;;   so long as this copyright notice is retained.
;;;; This file initializes postscript info on property lists.  It need
;;;; only be executed once (load time is best).

;;; This file defines all standard postscript operators.  Anything else
;;; must be generated by some lisp function.  Many of these are normally
;;; generated from lisp functions but are provided here anyway.

;;;  The following list contains all postscript functions known to this
;;;  program which may be called directly.  Others may be generated during
;;;  compilation.  The numbers are values in, values out.  Defaults 1,1.
;;;  See ps reference manual p 104.

(defun ps-init ()
  (mapc #'def-primitive
    '(
      ;; stack manipulation
	 ;;  Generated only by builtin Lisp functions
      ;; arithmetic and math
      (add 2 1)
      (div 2 1)
      (idiv 2)
      (mod 2)
      (mul 2)
      (sub 2)
      (abs 1)
      (neg 1)
      (ceiling 1)
      (floor 1)
      (round 1)
      (truncate 1)
      (sqrt 1)
      (atan 2)
      (cos 1)
      (sin 1)
      (exp 2)
      (ln 1)
      (log 1)
      (rand 0)
      (srand 1 0)
      (rrand 0)
      
      ;; Array Operators
      (array 1)
        ;; mark operators generated by make-vector or vector constants
      (length 1)
      (get 2)
      (put 3 0)
      (getinterval 3)
      (putinterval 3 0)
        ;; aload and astore not available
      (copy 2)
      (forall 2 0) ; use with great caution!!
      ;;  Dictionary Operators
      (dict 1)  ; many operations are declared in string section
      (maxlength 1)
      (begin 1 0)  ; Beware of hiding local environment
      (end 0 0)    ; !!
      (def 2 0)
      (load 1)
      (store 2 0)
      (known 2)
      (where 1 2 1)
      (errordict 0)
      (systemdict 0)
      (userdict 0)
      (currentdict 0)
      (countdictstack 0)
      (dictstack 1)
      ;;  String Operators
      (string 1)
      (anchorsearch 2 3 1)
      (search 2 4 2)
      (token 1 3 2)
      ;;  Relational, Boolean, Bitwise
      (eq 2)
      (ne 2)
      (ge 2)
      (gt 2)
      (lt 2)
      (le 2)
      (bitand 2)
      (not 1)
      (bitor 2)
      (xor 2)
      (true 0 1)
      (false 0 1)
      (bitshift 2)
      ;;  Control
      (exec 1 0)
      (for 4 0)
      (repeat 2 0)
      (loop 1 0)
      (exit 0 0)
      (stop 0 0)
      (stopped 1 1)
      (countexecstack 0 1)
      (execstack 1 1)
      (quit 0 0)
      (start 0 0)
	 ;; most of these are available only from lisp
      ;;  Type and conversion
      (type 1 1)
      (cvlit 1 1)
      (cvx 1 1)
      (xcheck 1 1)
      (executeonly 1 1)
      (noaccess 1 1)
      (readonly 1 1)
      (rcheck 1 1)
      (wcheck 1 1)
      (cvi 1 1)
      (cvn 1 1)
      (cvr 1 1)
      (cvrs 3 1)
      (cvs 2 1)
      ;; file operators
      (file 2 1)
      (closefile 1 0)
        ;;cant do read here
      (write 2 0)
      (readhexstring 2 2)
      (writehexstring 2 0)
      (readstring 2 2)
      (writestring 2 0)
      (readline 2 2)
      (file-token 1 3 1)
      (bytesavailable 1 1)
      (flush 0 0)
      (flushfile 1 0)
      (resetfile 1 0)
      (status 1 1)
      (run 1 0)
      (currentfile 0 1)
      (print 1 0)
      ;; = missing
      (stack 0 0)
      (pstack 0 0)
      (== 1 0)
      (echo 1 0)
      ;; virtual memory
      (save 0 1)
      (restore 1 0)
      (vmstatus 0 3)
      ;; misc operators
      (bind 1 1)
      (null 0 1)
      (usertime 0 1)
      (version 0 1)
      ;;  Graphics state
      (gsave 0 0)
      (grestore 0 0)
      (grestoreall 0 0)
      (initgraphics 0 0)
      (setlinewidth 1 0)
      (currentlinewidth 0 1)
      (setlinecap 1 0)
      (currentlinecap 0 1)
      (setlinejoin 1 0)
      (currentlinejoin 0 1)
      (setmiterlimit 1 0)
      (currentmiterlimit 0 1)
      (setdash 2 0)
      (currentdash 0 2)
      (setflat 1 0)
      (currentflat 0 1)
      (setgray 1 0)
      (currentgray 0 1)
      (sethsbcolor 3 0)
      (currentrhsbcolor 0 3)
      (setrgbcolor 3 0)
      (currentrgbcolor 0 3)
      (setscreen 3 0)
      (currentscreen 0 3)
      (settransfer 1 0)
      (currenttransfer 0 1)
      ;;  coord and matrix
      (matrix 0)
      (initmatrix 0 0)
      (identmatrix 1)
      (defaultmatrix 1)
      (currentmatrix 1)
      (setmatrix 1 0)
      (translate 2 0)
      (translate-matrix 3 1)
      (scale 2 0)
      (scale-matrix 3 1)
      (rotate 1 0)
      (rotate-matrix 2 1)
      (concat 1 0)
      (concatmatrix 3 1)
      (transform 2 2)
      (transform-matrix 3 2)
      (dtransform 2 2)
      (dtransform-matrix 3 2)
      (itransform 2 2)
      (itransform-matrix 3 2)
      (idtransform 2 2)
      (idtransform-matrix 3 2)
      (invertmatrix 2 1)
      ;;  Path
      (newpath 0 0)
      (currentpoint 0 2)
      (moveto 2 0)
      (rmoveto 2 0)
      (lineto 2 0)
      (rlineto 2 0)
      (arc 5 0)
      (arcn 5 0)
      (arcto 5 4)
      (curveto 6 0)
      (rcurveto 6 0)
      (closepath 0 0)
      (flattenpath 0 0)
      (reversepath 0 0)
      (strokepath 0 0)
      (charpath 2 0)
      (clippath 0 0)
      (pathbbox 0 4)
      (pathforall 4 0)
      (initclip 0 0)
      (clip 0 0)
      (eoclip 0 0)
      ;; Painting operators
      (erasepage 0 0)
      (fill 0 0)
      (eofill 0 0)
      (stroke 0 0)
      (image 5 0)
      (imagemask 5 0)
      ;;  Device
      (showpage 0 0)
      (copypage 0 0)
      (banddevice 4 0)
      (framedevice 4 0)
      (nulldevice 0 0)
      (renderbands 1 0)
      ;;  Char and font
      (definefont 2 1)
      (findfont 1 1)
      (scalefont 2 1)
      (makefont 2 1)
      (setfont 1 0)
      (currentfont 0 1)
      (show 1 0)
      (ashow 3 0)
      (widthshow 4 0)
      (awidthshow 6 0)
      (kshow 2 0)
      (stringwidth 1 2)
      (fontdirectory 0 1)
      (standardencoding 0 1)
      ;; Font Cache
      (cachestatus 0 7)
      (setcachedevice 6 0)
      (setcharwidth 2 0)
      (setcachelimit 1 0)
     ))

;;; put postscript information on property lists.  Set aliases for common
;;; symbols which need mixed case.

    (for (:in x
	     '(
		  (fontmatrix "FontMatrix")
		  (fonttype "FontType")
		  (fontbbox "FontBBox")
		  (encoding "Encoding")
		  (charprocs "CharProcs")
		  (buildchar "BuildChar")
                  (fontdirectory "FontDirectory")
		  (standardencoding "StandardEncoding")
		  (transform-matrix "transform")
		  (translate-matrix "translate")
		  (scale-matrix "scale")
		  (rotate-matrix "rotate")
		  (dtransform-matrix "dtransform")
		  (itransform-matrix "itransform")
		  (idtransform-matrix "idtransform")
		  (file-token "token")
		  (t "true")
		  (nil "false")
		  (bitand "and")
		  (bitor "or")
		  (Times-Roman "Times-Roman")
		  (Times-Bold "Times-Bold")
		  (Times-Italic "Times-Italic")
		  (Times-BoldItalic "Times-BoldItalic")
		  (AvantGarde-Book "AvantGarde-Book")
		  (AvantGarde-Demi "AvantGarde-Demi")
		  (AvantGarde-BookOblique "AvantGarde-BookOblique")
		  (AvantGarde-DemiOblique "AvantGarde-DemiOblique")
		  (NewCenturySchbk-Roman "NewCenturySchbk-Roman")
		  (NewCenturySchlbk-Bold "NewCenturySchlbk-Bold")
		  (NewCenturySchbk-Italic "NewCenturySchbk-Italic")
		  (NewCenturySchlbk-BoldItalic "NewCenturySchlbk-BoldItalic")
		  (Helvetica "Helvetica")
		  (Helvetica-Bold "Helvetica-Bold")
		  (Helvetica-Oblique "Helvetica-Oblique")
		  (Helvetica-BoldOblique "Helvetica-BoldOblique")
		  (Helvetica-Narrow "Helvetica-Narrow")
		  (Helvetica-Narrow-Bold "Helvetica-Narrow-Bold")
		  (Helvetica-Narrow-Oblique "Helvetica-Narrow-Oblique")
		  (Helvetica-Narrow-BoldOblique "Helvetica-Narrow-BoldOblique")
		  (Bookman-Light "Bookman-Light")
		  (Bookman-Demi "Bookman-Demi")
		  (Bookman-LightItalic "Bookman-LightItalic")
		  (Bookman-DemiItalic "Bookman-DemiItalic")
		  (Courier "Courier")
		  (Courier-Bold "Courier-Bold")
		  (Courier-Oblique "Courier-Oblique")
		  (Courier-BoldOblique "Courier-BoldOblique")
		  (Palatino-Roman "Palatino-Roman")
		  (Palatino-Bold "Palatino-Bold")
		  (Palatino-Italic "Palatino-Italic")
		  (Palatino-BoldItalic "Palatino-BoldItalic")
		  (ZapfChancery-MediumItalic "ZapfChancery-MediumItalic")
		  (Symbol "Symbol")
		  (ZapfDingbats "ZapfDingbats")
		  (Times-Roman "Times-Roman")
		  (Times-Bold "Times-Bold")
		  (Times-Italic "Times-Italic")
		  (Times-BoldItalic "Times-BoldItalic")
		  ))
 	 (:do   
            (setf (get (car x) 'new-ps-name) (cadr x))))
)

(defun def-primitive (x)
     (let ((fname (car x))
	   (args-in (or (cadr x) 1))
	   (args-out (or (caddr x) 1))
	   (stuff-count (cadddr x)))
	(setf (get fname 'ps-function) (list args-in args-out))
	(if stuff-count (setf (get fname 'stuff-count) stuff-count))))

	   
