/* 
  code to to cbreak mode on and off
*/

#include <sys/ioctl.h>

#define ERROR(s)	return (perror(s), -1)

cbreak_on()
{
  struct sgttyb  IOmode;
  
  if ( ioctl(0, TIOCGETP, &IOmode) < 0)
    ERROR("Problem getting IO mode...");

  IOmode.sg_flags |= CBREAK;
  if( ioctl(0, TIOCSETP, &IOmode) )
    ERROR("Problem setting IO mode...");
}

cbreak_off()
{
  struct sgttyb  IOmode;
  
  if ( ioctl(0, TIOCGETP, &IOmode) < 0)
    ERROR("Problem getting IO mode...");

  IOmode.sg_flags &= ~CBREAK;
  if( ioctl(0, TIOCSETP, &IOmode) )
    ERROR("Problem setting IO mode...");
}
