
(in-package :TRAPS)

(defconstant $gestaltSpeechAttr :|ttsc|);  Gestalt Manager selector for Speech Attributes 
(defconstant $gestaltSpeechMgrPresent 0);  Gestalt bit which indicates that Speech Manager exists 

(defconstant $kTextToSpeechSynthType :|ttsc|);  Text-to-Speech Synthesizer component type 	
(defconstant $kTextToSpeechVoiceType :|ttvd|);  Text-to-Speech Voice resource type 			
(defconstant $kTextToSpeechVoiceFileType :|ttvf|);  Text-to-Speech Voice file type 				
(defconstant $kTextToSpeechVoiceBundleType :|ttvb|);  Text-to-Speech Voice Bundle file type			

;  Speech Manager error codes (Range from 240 - 259) 

(defconstant $noSynthFound -240)
(defconstant $synthOpenFailed -241)
(defconstant $synthNotReady -242)
(defconstant $bufTooSmall -243)
(defconstant $voiceNotFound -244)
(defconstant $incompatibleVoice -245)
(defconstant $badDictFormat -246)

;  constants for SpeakBuffer and TextDone callback controlFlags bits 

(defconstant $kNoEndingProsody 1)
(defconstant $kNoSpeechInterrupt 2)
(defconstant $kPreflightThenPause 4)

;  constants for StopSpeechAt and PauseSpeechAt 

(defconstant $kImmediate 0)
(defconstant $kEndOfWord 1)
(defconstant $kEndOfSentence 2)

;  GetSpeechInfo & SetSpeechInfo selectors 

(defconstant $soStatus :|stat|)
(defconstant $soErrors :|erro|)
(defconstant $soInputMode :|inpt|)
(defconstant $soCharacterMode :|char|)
(defconstant $soNumberMode :|nmbr|)
(defconstant $soRate :|rate|)
(defconstant $soPitchBase :|pbas|)
(defconstant $soPitchMod :|pmod|)
(defconstant $soVolume :|volm|)
(defconstant $soSynthType :|vers|)
(defconstant $soRecentSync :|sync|)
(defconstant $soPhonemeSymbols :|phsy|)
(defconstant $soCurrentVoice :|cvox|)
(defconstant $soCommandDelimiter :|dlim|)
(defconstant $soReset :|rset|)
(defconstant $soCurrentA5 :|myA5|)
(defconstant $soRefCon :|refc|)
(defconstant $soTextDoneCallBack :|tdcb|)
(defconstant $soSpeechDoneCallBack :|sdcb|)
(defconstant $soSyncCallBack :|sycb|)
(defconstant $soErrorCallBack :|ercb|)
(defconstant $soPhonemeCallBack :|phcb|)
(defconstant $soWordCallBack :|wdcb|)
(defconstant $soSynthExtension :|xtnd|)

;  Speaking Mode Constants 

(defconstant $modeText :|TEXT|) ;  input mode constants 	
(defconstant $modeTX "TX")
(defconstant $modePhonemes :|PHON|)
(defconstant $modePH "PH")
(defconstant $modeNormal :|NORM|);  character mode and number mode constants 
(defconstant $modeLiteral :|LTRL|)

;  GetVoiceInfo selectors 

(defconstant $soVoiceDescription :|info|);  gets basic voice info 
(defconstant $soVoiceFile :|fref|);  gets voice file ref info 

(defconstant $kNeuter 0)
(defconstant $kMale 1)
(defconstant $kFemale 2)

(def-mactype :SPEECHCHANNELRECORD (find-mactype :SIGNED-LONG))
(def-mactype :SPEECHCHANNEL (find-mactype :POINTER))
(def-mactype :SPEECHCHANNELPTR (find-mactype :HANDLE))

(defrecord VoiceSpec 
   (creator :OSTYPE)            ;  creator id of required synthesizer 	
   (id :OSTYPE)                 ;  voice id on the specified synth 		
   )
(def-mactype :VOICESPECPTR (find-mactype :POINTER))

(defrecord VoiceDescription 
   (length :SIGNED-LONG)        ;  size of structure - set by application 	
   (voice :VOICESPEC)           ;  voice creator and id info 			
   (version :SIGNED-LONG)       ;  version code for voice 				
   (name (:STRING 63))          ;  name of voice 						
   (comment (:STRING 255))      ;  additional text info about voice 		
   (gender :SIGNED-INTEGER)     ;  neuter, male, or female				
   (age :SIGNED-INTEGER)        ;  approximate age in years 				
   (script :SIGNED-INTEGER)     ;  script code of text voice can process 
   (language :SIGNED-INTEGER)   ;  language code of voice output speech 	
   (region :SIGNED-INTEGER)     ;  region code of voice output speech 	
   (reserved1 :SIGNED-LONG)     ;  always zero - reserved for future use	
   (reserved2 :SIGNED-LONG)     ;  always zero - reserved for future use	
   (reserved3 :SIGNED-LONG)     ;  always zero - reserved for future use	
   (reserved4 :SIGNED-LONG)     ;  always zero - reserved for future use	
   )
(def-mactype :VOICEDESCRIPTIONPTR (find-mactype :POINTER))

(defrecord VoiceFileInfo 
   (fileSpec :FSSPEC)           ;  volume, dir, & name information for voice file 
   (resID :SIGNED-INTEGER)      ;  resource id of voice in the file 
   )
(def-mactype :VOICEFILEINFOPTR (find-mactype :POINTER))

(defrecord SpeechStatusInfo 
   (outputBusy :BOOLEAN)        ;  TRUE if audio is playing
   (outputPaused :BOOLEAN)      ;  TRUE if channel is paused
   (inputBytesLeft :SIGNED-LONG);  bytes of input left to process
   (phonemeCode :SIGNED-INTEGER);  code for current phoneme
   )
(def-mactype :SPEECHSTATUSINFOPTR (find-mactype :POINTER))

(defrecord SpeechModeInfo 
   (inputMode :OSTYPE)          ; 'TEXT' or 'PHON'
   (characterMode :OSTYPE)      ; 'NORM' or 'LTRL'
   (numberMode :OSTYPE)         ; 'NORM' or 'LTRL'
   (symbolMode :OSTYPE)         ; 'NORM' or 'LTRL'
   )
(def-mactype :SPEECHMODEINFOPTR (find-mactype :POINTER))

(defrecord SpeechVersionInfo 
   (synthType :OSTYPE)          ;  always ttsc 
   (synthSubType :OSTYPE)       ;  Flavor of synth 
   (synthManufacturer :OSTYPE)  ;  synth creator ID 
   (synthFlags :SIGNED-LONG)    ;  synth feature flags 
   (synthVersion :NUMVERSION)   ;  synth version number 
   )
(def-mactype :SPEECHVERSIONINFOPTR (find-mactype :POINTER))

(defrecord speechXtndData 
   (synthCreator :OSTYPE)       ; synthesizer ID selector
   (synthData (:ARRAY :CHARACTER 2));  data bytes TBD by synthesizer 
   )

(defrecord DelimiterInfo 
   (startDelimiter (:ARRAY :CHARACTER 2))
   (endDelimiter (:ARRAY :CHARACTER 2))
   )

(defrecord SpeechErrorInfo 
   (count :SIGNED-INTEGER)      ;  # of errs since last check 		
   (oldest :SIGNED-INTEGER)     ;  oldest unread error 				
   (oldPos :SIGNED-LONG)        ;  char position of oldest err 		
   (newest :SIGNED-INTEGER)     ;  most recent error 				
   (newPos :SIGNED-LONG)        ;  char position of newest err 		
   )

(defrecord PhonemeInfo 
   (opcode :SIGNED-INTEGER)     ;  opcode for the phoneme 			
   (phStr (:STRING 15))         ;  corresponding char string 		
   (exampleStr (:STRING 31))    ;  word that shows use of phoneme 	
   (hiliteStart :SIGNED-INTEGER);  segment of example word that	 	
   (hiliteEnd :SIGNED-INTEGER)  ;  should be hilighted (ala TextEdit) 
   )

(defrecord PhonemeDescriptor 
   (phonemeCount :SIGNED-INTEGER);  # of elements 		
   (thePhonemes (:ARRAY :PHONEMEINFO 1));  element list 		
   )


(deftrap _SPEECHMANAGERVERSION NIL
   (:STACK :NUMVERSION)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 0 16) 12)))


(deftrap _MAKEVOICESPEC ((CREATOR :OSTYPE) (ID :OSTYPE) (VOICE (:POINTER :VOICESPEC)))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1540 16) 12) CREATOR ID VOICE))

(deftrap _COUNTVOICES ((NUMVOICES :POINTER))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 264 16) 12) NUMVOICES))

(deftrap _GETINDVOICE ((INDEX :SIGNED-INTEGER) (VOICE (:POINTER :VOICESPEC)))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 780 16) 12) INDEX VOICE))

(deftrap _GETVOICEDESCRIPTION ((VOICE (:POINTER :VOICESPEC)) (INFO (:POINTER :VOICEDESCRIPTION)) (INFOLENGTH :SIGNED-LONG))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1552 16) 12) VOICE INFO INFOLENGTH))

(deftrap _GETVOICEINFO ((VOICE (:POINTER :VOICESPEC)) (SELECTOR :OSTYPE) (VOICEINFO :POINTER))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1556 16) 12) VOICE SELECTOR VOICEINFO))


(deftrap _STOPSPEECH ((CHAN (:POINTER :SIGNED-LONG)))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 556 16) 12) CHAN))


(deftrap _SETSPEECHRATE ((CHAN (:POINTER :SIGNED-LONG)) (RATE :SIGNED-LONG))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1092 16) 12) CHAN RATE))

(deftrap _GETSPEECHRATE ((CHAN (:POINTER :SIGNED-LONG)) (RATE :POINTER))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1096 16) 12) CHAN RATE))

(deftrap _SETSPEECHPITCH ((CHAN (:POINTER :SIGNED-LONG)) (PITCH :SIGNED-LONG))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1100 16) 12) CHAN PITCH))

(deftrap _GETSPEECHPITCH ((CHAN (:POINTER :SIGNED-LONG)) (PITCH :POINTER))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1104 16) 12) CHAN PITCH))


(deftrap _USEDICTIONARY ((CHAN (:POINTER :SIGNED-LONG)) (DICTIONARY :HANDLE))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1120 16) 12) CHAN DICTIONARY))


(deftrap _NEWSPEECHCHANNEL ((VOICE (:POINTER :VOICESPEC)) (CHANPTR (:HANDLE :SIGNED-LONG)))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1048 16) 12) VOICE CHANPTR))

(deftrap _DISPOSESPEECHCHANNEL ((CHAN (:POINTER :SIGNED-LONG)))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 540 16) 12) CHAN))


(deftrap _SPEAKSTRING ((S (:STRING 255)))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 544 16) 12) S))

(deftrap _SPEAKTEXT ((CHAN (:POINTER :SIGNED-LONG)) (TEXTBUF :POINTER) (BYTELEN :SIGNED-LONG))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1572 16) 12) CHAN TEXTBUF BYTELEN))

(deftrap _SPEAKBUFFER ((CHAN (:POINTER :SIGNED-LONG)) (TEXTBUF :POINTER) (BYTELEN :SIGNED-LONG) (CONTROLFLAGS :SIGNED-LONG))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 2088 16) 12) CHAN TEXTBUF BYTELEN CONTROLFLAGS))


(deftrap _STOPSPEECHAT ((CHAN (:POINTER :SIGNED-LONG)) (WHERETOSTOP :SIGNED-LONG))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1072 16) 12) CHAN WHERETOSTOP))

(deftrap _PAUSESPEECHAT ((CHAN (:POINTER :SIGNED-LONG)) (WHERETOPAUSE :SIGNED-LONG))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1076 16) 12) CHAN WHERETOPAUSE))

(deftrap _CONTINUESPEECH ((CHAN (:POINTER :SIGNED-LONG)))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 568 16) 12) CHAN))


(deftrap _SPEECHBUSY NIL
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 60 16) 12)))

(deftrap _SPEECHBUSYSYSTEMWIDE NIL
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 64 16) 12)))


(deftrap _GETSPEECHINFO ((CHAN (:POINTER :SIGNED-LONG)) (SELECTOR :OSTYPE) (SPEECHINFO :POINTER))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1624 16) 12) CHAN SELECTOR SPEECHINFO))

(deftrap _SETSPEECHINFO ((CHAN (:POINTER :SIGNED-LONG)) (SELECTOR :OSTYPE) (SPEECHINFO :POINTER))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 1620 16) 12) CHAN SELECTOR SPEECHINFO))


(deftrap _TEXTTOPHONEMES ((CHAN (:POINTER :SIGNED-LONG)) (TEXTBUF :POINTER) (TEXTBYTES :SIGNED-LONG) (PHONEMEBUF :HANDLE) (PHONEMEBYTES :POINTER))
   (:STACK :SIGNED-INTEGER)
   (:STACK-TRAP #xA800 :D0 (+ (ASH 2652 16) 12) CHAN TEXTBUF TEXTBYTES PHONEMEBUF PHONEMEBYTES))


(export '($KFEMALE $KMALE $KNEUTER $SOVOICEFILE $SOVOICEDESCRIPTION
          $MODELITERAL $MODENORMAL $MODEPH $MODEPHONEMES $MODETX $MODETEXT
          $SOSYNTHEXTENSION $SOWORDCALLBACK $SOPHONEMECALLBACK $SOERRORCALLBACK
          $SOSYNCCALLBACK $SOSPEECHDONECALLBACK $SOTEXTDONECALLBACK $SOREFCON
          $SOCURRENTA5 $SORESET $SOCOMMANDDELIMITER $SOCURRENTVOICE
          $SOPHONEMESYMBOLS $SORECENTSYNC $SOSYNTHTYPE $SOVOLUME $SOPITCHMOD
          $SOPITCHBASE $SORATE $SONUMBERMODE $SOCHARACTERMODE $SOINPUTMODE
          $SOERRORS $SOSTATUS $KENDOFSENTENCE $KENDOFWORD $KIMMEDIATE
          $KPREFLIGHTTHENPAUSE $KNOSPEECHINTERRUPT $KNOENDINGPROSODY
          $BADDICTFORMAT $INCOMPATIBLEVOICE $VOICENOTFOUND $BUFTOOSMALL
          $SYNTHNOTREADY $SYNTHOPENFAILED $NOSYNTHFOUND
          $KTEXTTOSPEECHVOICEBUNDLETYPE $KTEXTTOSPEECHVOICEFILETYPE
          $KTEXTTOSPEECHVOICETYPE $KTEXTTOSPEECHSYNTHTYPE
          $GESTALTSPEECHMGRPRESENT $GESTALTSPEECHATTR))
(provide-interface 'speech)