;;       
;;	File:		TextServices.p
;;
;;	Copyright:	 1983-1993 by Apple Computer, Inc.
;;				All rights reserved.
;;
;;	Version:	System 7.1 for ETO #11
;;	Created:	Tuesday, March 30, 1993 18:00
;;
;;      adaptated to MCL 2.0 by Gilles Serasset, GETA-IMAG, France

(in-package :traps)

;       $IFC UNDEFINED UsingIncludes
;       $SETC UsingIncludes := 0
;       $ENDC

;       $IFC NOT UsingIncludes
; UNIT TextServices;
; INTERFACE
;       $ENDC

;       $IFC UNDEFINED UsingTextServices
;       $SETC UsingTextServices := 1

;       $I+
;       $SETC UsingTextServices := UsingIncludes
;       $SETC UsingIncludes := 1
;       $IFC UNDEFINED UsingTypes
;       $I $$Shell(PInterfaces)Types.p
(require-interface 'TYPES)
;       $ENDC
;       $IFC UNDEFINED UsingEvents
;       $I $$Shell(PInterfaces)Events.p
(require-interface 'EVENTS) 
;       $ENDC
;       $IFC UNDEFINED UsingMenus
;       $I $$Shell(PInterfaces)Menus.p
(require-interface 'Menus) 
;       $ENDC
;       $IFC UNDEFINED UsingAppleEvents
;       $I $$Shell(PInterfaces)AppleEvents.p
(require-interface 'AppleEvents) 
;       $ENDC
;       $IFC UNDEFINED UsingErrors
;       $I $$Shell(PInterfaces)Errors.p
(require-interface 'Errors) 
;       $ENDC
;       $IFC UNDEFINED UsingComponents
;       $I $$Shell(PInterfaces)Components.p
(require-interface 'Components) 
;       $ENDC
;       $SETC UsingIncludes := UsingTextServices


(defconstant $kTSMVersion 1);        Version of Text Services Manager 
(defconstant $kTextService :|tsvc|);        Component type for component description 
(defconstant $kInputMethodService :|inpm|);        Component subtype for component description 

(defconstant $bTakeActiveEvent 15);        Bit set if the component takes activate events 
(defconstant $bScriptMask #x00007F00);        Bits 8 - 14 
(defconstant $bLanguageMask #x000000FF);        Bits 0 - 7 
(defconstant $bScriptLanguageMask (+ $bScriptMask $bLanguageMask));       Bits 0 - 14 

;        Hilite styles ... 
(defconstant $kCursorPosition 1);        specify cursor position 
(defconstant $kRawText 2);        specify range of raw text 
(defconstant $kSelectedRawText 3);        specify range of selected raw text 
(defconstant $kConvertedText 4);        specify range of converted text 
(defconstant $kSelectedConvertedText 5);        specify range of selected converted text 

;  Apple Event constants

(defconstant $kTextServiceClass $kTextService);        Event class 
(defconstant $kUpdateActiveInputArea :|updt|);        Update the active inline area 
(defconstant $kPos2Offset :|p2st|);        Convert global coordinates to character position 
(defconstant $kOffset2Pos :|st2p|);        Convert character position to global coordinate 
(defconstant $kShowHideInputWindow :|shiw|);        show or hide the input window 

;    Event keywords ... 

(defconstant $keyAETSMDocumentRefcon :|refc|);        TSM document refcon 

(defconstant $keyAEServerInstance :|srvi|);        Server instance 
(defconstant $keyAETheData :|kdat|);        typeText 
(defconstant $keyAEScriptTag :|sclg|);        Script tag 
(defconstant $keyAEFixLength :|fixl|)
(defconstant $keyAEHiliteRange :|hrng|);        Hilite range array 
(defconstant $keyAEUpdateRange :|udng|);        Update range array 
(defconstant $keyAEClauseOffsets :|clau|);        Clause offsets array 
(defconstant $keyAECurrentPoint :|cpos|);        Current point 
(defconstant $keyAEDragging :|bool|);        Dragging flag 
(defconstant $keyAEOffset :|ofst|);        Offset 
(defconstant $keyAERegionClass :|rgnc|);        Region class 
(defconstant $keyAEPoint :|gpos|);        Current point 
(defconstant $keyAEBufferSize :|buff|);        Buffer size to get the text 
(defconstant $keyAERequestedType :|rtyp|);        Requested text type 
(defconstant $keyAEMoveView :|mvvw|);        Move view flag 
(defconstant $keyAELength :|leng|);        Length 
(defconstant $keyAENextBody :|nxbd|);        Next or previous body 

;        optional keywords for Offset2Pos-- 28Mar92 

(defconstant $keyAETextFont :|ktxf|)
(defconstant $keyAETextPointSize :|ktps|)
(defconstant $keyAETextLineHeight :|ktlh|)
(defconstant $keyAETextLineAscent :|ktas|)
(defconstant $keyAEAngle :|kang|)

;        optional keyword for Pos2Offset

(defconstant $keyAELeftSide :|klef|);        type Boolean 

;        optional keyword for kShowHideInputWindow

(defconstant $keyAEShowHideInputWindow :|shiw|);        type Boolean 

;        keyword for PinRange  

(defconstant $keyAEPinRange :|pnrg|);        <#6> 


;        Desc type ... 

(defconstant $typeComponentInstance :|cmpi|);        Component instance 
(defconstant $typeTextRangeArray :|tray|);        Text range array 
(defconstant $typeOffsetArray :|ofay|);        Offset array 
(defconstant $typeIntlWritingCode :|intl|);        Script code 
(defconstant $typeQDPoint :|QDpt|);        QuickDraw point 
(defconstant $typeAEText :|tTXT|);        Apple Event text 
(defconstant $typeText :|TEXT|);        Plain text 

(defconstant $typeTextRange :|txrn|);        <#6> 


;       Error codes


(defconstant $tsmComponentNoErr 0);        Component result   no error 

(defconstant $tsmUnsupScriptLanguageErr -2500)
(defconstant $tsmInputMethodNotFoundErr -2501)
(defconstant $tsmNotAnAppErr -2502);        Not an application error 
(defconstant $tsmAlreadyRegisteredErr -2503);        Attemp to register again 
(defconstant $tsmNeverRegisteredErr -2504);        App never registered.  (Not TSM Aware) 
(defconstant $tsmInvalidDocIDErr -2505);        Invalid TSM documentation ID 
(defconstant $tsmTSMDocBusyErr -2506);        Document is still active 
(defconstant $tsmDocNotActiveErr -2507);        Document is not active 
(defconstant $tsmNoOpenTSErr -2508);        No open text service 
(defconstant $tsmCantOpenComponentErr -2509);        Can't open the component 
(defconstant $tsmTextServiceNotFoundErr -2510);        No text service found 
(defconstant $tsmDocumentOpenErr -2511);        There are open documents 
(defconstant $tsmUseInputWindowErr -2512);        Not TSM aware because an input window is being used 
(defconstant $tsmTSHasNoMenuErr -2513);        The Text Service has no menu 
(defconstant $tsmTSNotOpenErr -2514);        Text service is not open 
(defconstant $tsmComponentAlreadyOpenErr -2515);        Text service already open for document 

(defconstant $tsmInputMethodIsOldErr -2516);        Returned by GetDefaultInputMethod 
(defconstant $tsmScriptHasNoIMErr -2517);        Script has no input method or is using old input method 
(defconstant $tsmUnsupportedTypeErr -2518);        unSupported interface type error 
(defconstant $tsmUnknownErr -2519);        Any other errors 

(defconstant $kTSMOutsideOfBody 1)
(defconstant $kTSMInsideOfBody 2)
(defconstant $kTSMInsideOfActiveInputArea 3)

(defconstant $kNextBody 1)
(defconstant $kPreviousBody 2)

(defconstant $errOffsetInvalid -1800)
(defconstant $errOffsetIsOutsideOfView -1801)
(defconstant $errTopOfDocument -1810)
(defconstant $errTopOfBody -1811)
(defconstant $errEndOfDocument -1812)
(defconstant $errEndOfBody -1813)


;; Types

(def-mactype :TextRangeHandle (find-mactype :handle))
(def-mactype :TextRangePtr (find-mactype :pointer))

(defrecord (TextRange :handle)     ;  typeTextRange
  (fStart :signed-long)
  (fEnd :signed-long)
  (fHiliteStyle :signed-integer)
  )

(def-mactype :TextRangeArrayHandle (find-mactype :handle))
(def-mactype :TextRangeArrayPtr (find-mactype :pointer))
(defrecord (TextRangeArray :handle)       ; typeTextRangeArray
  (fNumOfRanges	:signed-integer)
  (fRange (:array :TextRange 1))
  )

(def-mactype :OffsetArrayHandle	(find-mactype :handle))
(def-mactype :OffsetArrayPtr (find-mactype :pointer))
(defrecord (OffsetArray :handle)    ; typeOffsetArray
  (fNumOfOffsets :signed-integer)
  (fOffset (:array :signed-long 1) )
)


(def-mactype :TextServicesInfoPtr (find-mactype :pointer))
(defrecord TextServiceInfo
  (fComponent :Component)
  (fItemName (:string 255))
)

(def-mactype :TextServiceListHandle (find-mactype :handle))
(def-mactype :TextServiceListPtr (find-mactype :pointer))
(defrecord (TextServiceList :handle)
  (fTextServiceCount :signed-integer)
  (fServices  (:array :TextServiceInfo 1))
  )
  	
(defrecord ScriptLanguageRecord
  (fScript :ScriptCode)
  (fLanguage :LangCode)
)
  		
(def-mactype :ScriptLanguageSupportHandle (find-mactype :handle))
(def-mactype :ScriptLanguageSupportPtr (find-mactype :pointer))
(defrecord (ScriptLanguageSupport :handle)
  (fScriptLanguageCount :signed-integer)
  (fScriptLanguageArray (:Array :ScriptLanguageRecord 1))
  )

(defrecord InterfaceTypeList (array (array :OSType 1)))
(def-mactype :TSMDocumentID(find-mactype :pointer))
	
;   Text Services Routines


(deftrap _NewTSMDocument ((numOfInterface :signed-integer) (supportedInterfaceTypes :InterfaceTypeList) (idocID (:pointer :TSMDocumentID)) (refCon :signed-long))
  (:stack :OSErr)
  (:stack-trap #xA83D :d0 0 numOfInterface supportedInterfaceTypes idocID refCon))

(deftrap _DeleteTSMDocument ((idocID :TSMDocumentID))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 1 idocID))

(deftrap _ActivateTSMDocument ((idocID :TSMDocumentID))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 2 idocID))

(deftrap _DeactivateTSMDocument ((idocID :TSMDocumentID))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 3 idocID))

(deftrap _TSMEvent ((event (:pointer :EventRecord)))
  (:stack :Boolean)
  (:stack-trap #xAA54 :d0 4 event))

(deftrap _TSMMenuSelect ((menuResult :signed-long))
  (:stack :Boolean)
  (:stack-trap #xAA54 :d0 5 menuResult))

(deftrap _SetTSMCursor ((mousePos :Point))
  (:stack :Boolean)
  (:stack-trap #xAA54 :d0 6 mousePos))

(deftrap _FixTSMDocument ((idocID :TSMDocumentID))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 7 idocID))

(deftrap _GetServiceList ((numOfInterface :signed-integer) (supportedInterfaceTypes :InterfaceTypeList) (serviceInfo (:pointer :TextServiceListHandle)) (seedValue (:pointer :signed-long)))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 8 numOfInterface supportedInterfaceTypes serviceInfo seedValue))

(deftrap _OpenTextService ((idocID :TSMDocumentID) (aComponent :Component) (aComponentInstance (:pointer :ComponentInstance)))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 9 idocID aComponent aComponentInstance))

(deftrap _CloseTextService ((idocID :TSMDocumentID) (aComponentInstance :ComponentInstance))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 10 idocID aComponentInstance))

(deftrap _SendAEFromTSMComponent ((theAppleEvent (:pointer :AppleEvent)) 
                                   (reply (:pointer :AppleEvent)) (sendMode :AESendMode) 
                                   (sendPriority :AESendPriority) (timeOutInTicks :signed-long) 
                                   (idleProc :IdleProcPtr) (filterProc :EventFilterProcPtr))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 11 theAppleEvent reply sendMode sendPriority
               timeOutInTicks idleProc filterProc))

(deftrap _InitTSMAwareApplication nil
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 20))

(deftrap _CloseTSMAwareApplication nil
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 21))

(deftrap _SetDefaultInputMethod ((ts :Component) (slRecord (:pointer :ScriptLanguageRecord)))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 12 ts slRecord))

(deftrap _GetDefaultInputMethod ((ts (:pointer :Component)) (slRecord (:pointer :ScriptLanguageRecord)))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 13 ts slRecord))

(deftrap _SetTextServiceLanguage ((slRecord (:pointer :ScriptLanguageRecord)))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 14 slRecord))

(deftrap _GetTextServiceLanguage ((slRecord (:pointer :ScriptLanguageRecord)))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 15 slRecord))

(deftrap _UseInputWindow ((idocID :TSMDocumentID) (useWindow :Boolean))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 16 idocID useWindow))

(deftrap _NewServiceWindow ((wStorage :pointer) (boundsRect :Rect) (title (:string 255))
                             (visible :Boolean) (theProc :signed-integer) (behind :WindowPtr)
                             (goAwayFlag :boolean) (ts :ComponentInstance) (window (:pointer :WindowPtr)))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 17 wStorage boundsRect title visible theProc behind goAwayFlag ts window))

(deftrap _CloseServiceWindow ((window :WindowPtr))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 18 window))

(deftrap _GetFrontServiceWindow ((window (:pointer :WindowPtr)))
  (:stack :OSErr)
  (:stack-trap #xAA54 :d0 19  window))

(deftrap _FindServiceWindow ((thePoint :Point) (theWindow (:pointer :WindowPtr)))
  (:stack :signed-integer)
  (:stack-trap #xAA54 :d0 23 thePoint theWindow))


;;	Low level Text Services routines

(deftrap _GetScriptLanguageSupport ((ts :ComponentInstance) (scriptHandle (:pointer :ScriptLanguageSupportHandle)))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts scriptHandle ((+ (ASH 1024 16) 1) :SIGNED-LONGINT)))

(deftrap _InitiateTextService ((ts :ComponentInstance))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts ((+ (ASH 0 16) 2) :SIGNED-LONGINT)))
  
(deftrap _TerminateTextService ((ts :ComponentInstance))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts ((+ (ASH 0 16) 3) :SIGNED-LONGINT)))

(deftrap _ActivateTextService ((ts :ComponentInstance))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts ((+ (ASH 0 16) 4) :SIGNED-LONGINT)))

(deftrap _DeactivateTextService ((ts :ComponentInstance))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts ((+ (ASH 0 16) 5) :SIGNED-LONGINT)))

(deftrap _TextServiceEvent ((ts :ComponentInstance) (numOfEvents :signed-integer) 
                            (event (:pointer :EventRecord)))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts numOfEvents event ((+ (ASH 0 16) 6) :SIGNED-LONGINT)))

(deftrap _GetTextServiceMenu ((ts :ComponentInstance) (serviceMenu (:pointer :MenuHandle)))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts serviceMenu ((+ (ASH 0 16) 7) :SIGNED-LONGINT)))

(deftrap _TextServiceMenuSelect ((ts :ComponentInstance) (serviceMenu :MenuHandle) 
                                 (item :signed-integer))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts serviceMenu item ((+ (ASH 0 16) 8) :SIGNED-LONGINT)))

(deftrap _FixTextService ((ts :ComponentInstance))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts ((+ (ASH 0 16) 9) :SIGNED-LONGINT)))

(deftrap _SetTextServiceCursor ((ts :ComponentInstance) (mousePos :Point))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts mousePos ((+ (ASH 0 16) 10) :SIGNED-LONGINT)))

(deftrap _HidePaletteWindows ((ts :ComponentInstance))
  (:stack :ComponentResult)
  (:stack-trap #xA82A :d0 0 ts ((+ (ASH 0 16) 12) :SIGNED-LONGINT)))


(export '($kTSMVersion $kTextService $kInputMethodService $bTakeActiveEvent $bScriptMask $bLanguageMask
          $bScriptLanguageMask $kCursorPosition $kRawText $kSelectedRawText $kConvertedText $kSelectedConvertedText
          $kTextServiceClass $kUpdateActiveInputArea $kPos2Offset $kOffset2Pos $kShowHideInputWindow 
          $keyAETSMDocumentRefcon $keyAEServerInstance $keyAETheData $keyAEScriptTag $keyAEFixLength 
          $keyAEHiliteRange $keyAEUpdateRange $keyAEClauseOffsets $keyAECurrentPoint $keyAEDragging $keyAEOffset 
          $keyAERegionClass $keyAEPoint $keyAEBufferSize $keyAERequestedType $keyAEMoveView $keyAELength
          $keyAENextBody $keyAETextFont $keyAETextPointSize $keyAETextLineHeight $keyAETextLineAscent $keyAEAngle
          $keyAELeftSide $keyAEShowHideInputWindow $keyAEPinRange $typeComponentInstance $typeTextRangeArray
          $typeOffsetArray $typeIntlWritingCode $typeQDPoint $typeAEText $typeText $typeTextRange
          $tsmComponentNoErr $tsmUnsupScriptLanguageErr $tsmInputMethodNotFoundErr $tsmNotAnAppErr
          $tsmAlreadyRegisteredErr $tsmNeverRegisteredErr $tsmInvalidDocIDErr $tsmTSMDocBusyErr 
          $tsmDocNotActiveErr $tsmNoOpenTSErr $tsmCantOpenComponentErr $tsmTextServiceNotFoundErr
          $tsmDocumentOpenErr $tsmUseInputWindowErr $tsmTSHasNoMenuErr $tsmTSNotOpenErr 
          $tsmComponentAlreadyOpenErr $tsmInputMethodIsOldErr $tsmScriptHasNoIMErr $tsmUnsupportedTypeErr
          $tsmUnknownErr $kTSMOutsideOfBody $kTSMInsideOfBody $kTSMInsideOfActiveInputArea $kNextBody
          $kPreviousBody $errOffsetInvalid $errOffsetIsOutsideOfView $errTopOfDocument $errTopOfBody
          $errEndOfDocument $errEndOfBody))

(provide-interface 'textservices)