
(in-package :TRAPS)             ; 
; 	File:		Script.p
; 
; 	Copyright:	 1983-1993 by Apple Computer, Inc.
; 				All rights reserved.
; 
; 	Version:	System 7.1 for ETO #11
; 	Created:	Tuesday, March 30, 1993 18:00
; 
; 

; $IFC UNDEFINED UsingIncludes
; $SETC UsingIncludes := 0
; $ENDC

; $IFC NOT UsingIncludes

; $ENDC

; $IFC UNDEFINED UsingScript
; $SETC UsingScript := 1

; $I+
; $SETC ScriptIncludes := UsingIncludes
; $SETC UsingIncludes := 1
; $IFC UNDEFINED UsingTypes

(require-interface 'TYPES)      ; $I $$Shell(PInterfaces)Types.p
; $ENDC
; $IFC UNDEFINED UsingQuickdraw

(require-interface 'QUICKDRAW)  ; $I $$Shell(PInterfaces)Quickdraw.p
; $ENDC
; $IFC UNDEFINED UsingIntlResources

(require-interface 'INTLRESOURCES); $I $$Shell(PInterfaces)IntlResources.p
; $ENDC
; $SETC UsingIncludes := ScriptIncludes

;  Script System constants 

(defconstant $smSystemScript -1); designates system script.
(defconstant $smCurrentScript -2); designates current font script.
(defconstant $smAllScripts -3)  ; designates any script

(defconstant $smRoman 0)        ; Roman
(defconstant $smJapanese 1)     ; Japanese
(defconstant $smTradChinese 2)  ; Traditional Chinese
(defconstant $smKorean 3)       ; Korean
(defconstant $smArabic 4)       ; Arabic
(defconstant $smHebrew 5)       ; Hebrew
(defconstant $smGreek 6)        ; Greek
(defconstant $smCyrillic 7)     ; Cyrillic
(defconstant $smRSymbol 8)      ; Right-left symbol
(defconstant $smDevanagari 9)   ; Devanagari
(defconstant $smGurmukhi 10)    ; Gurmukhi
(defconstant $smGujarati 11)    ; Gujarati
(defconstant $smOriya 12)       ; Oriya
(defconstant $smBengali 13)     ; Bengali
(defconstant $smTamil 14)       ; Tamil
(defconstant $smTelugu 15)      ; Telugu
(defconstant $smKannada 16)     ; Kannada/Kanarese
(defconstant $smMalayalam 17)   ; Malayalam
(defconstant $smSinhalese 18)   ; Sinhalese
(defconstant $smBurmese 19)     ; Burmese
(defconstant $smKhmer 20)       ; Khmer/Cambodian
(defconstant $smThai 21)        ; Thai
(defconstant $smLaotian 22)     ; Laotian
(defconstant $smGeorgian 23)    ; Georgian
(defconstant $smArmenian 24)    ; Armenian
(defconstant $smSimpChinese 25) ; Simplified Chinese
(defconstant $smTibetan 26)     ; Tibetan
(defconstant $smMongolian 27)   ; Mongolian
(defconstant $smGeez 28)        ; Geez/Ethiopic
(defconstant $smEthiopic 28)    ; Synonym for smGeez
(defconstant $smEastEurRoman 29); Synonym for smSlavic
(defconstant $smVietnamese 30)  ; Vietnamese
(defconstant $smExtArabic 31)   ; extended Arabic
(defconstant $smUninterp 32)    ; uninterpreted symbols, e.g. palette symbols
(defconstant $smKlingon 32)     ; Klingon

; Obsolete names for script systems (kept for backward compatibility)

(defconstant $smChinese 2)      ; (use smTradChinese or smSimpChinese)
(defconstant $smRussian 7)      ; (old name for smCyrillic)

;  smMaldivian = 25;         (no more smMaldivian!)

(defconstant $smAmharic 28)     ; (old name for smGeez)
(defconstant $smSlavic 29)      ; (old name for smEastEurRoman)
(defconstant $smSindhi 31)      ; (old name for smExtArabic)

;  Language Codes 

(defconstant $langEnglish 0)    ;  smRoman script 
(defconstant $langFrench 1)     ;  smRoman script 
(defconstant $langGerman 2)     ;  smRoman script 
(defconstant $langItalian 3)    ;  smRoman script 
(defconstant $langDutch 4)      ;  smRoman script 
(defconstant $langSwedish 5)    ;  smRoman script 
(defconstant $langSpanish 6)    ;  smRoman script 
(defconstant $langDanish 7)     ;  smRoman script 
(defconstant $langPortuguese 8) ;  smRoman script 
(defconstant $langNorwegian 9)  ;  smRoman script 
(defconstant $langHebrew 10)    ;  smHebrew script 
(defconstant $langJapanese 11)  ;  smJapanese script 
(defconstant $langArabic 12)    ;  smArabic script 
(defconstant $langFinnish 13)   ;  smRoman script 
(defconstant $langGreek 14)     ;  smGreek script 
(defconstant $langIcelandic 15) ;  extended Roman script 
(defconstant $langMaltese 16)   ;  extended Roman script 
(defconstant $langTurkish 17)   ;  extended Roman script 
(defconstant $langCroatian 18)  ;  Serbo-Croatian in extended Roman script 
(defconstant $langTradChinese 19);  Chinese in traditional characters 
(defconstant $langUrdu 20)      ;  smArabic script 
(defconstant $langHindi 21)     ;  smDevanagari script 
(defconstant $langThai 22)      ;  smThai script 
(defconstant $langKorean 23)    ;  smKorean script 
(defconstant $langLithuanian 24);  smEastEurRoman script 
(defconstant $langPolish 25)    ;  smEastEurRoman script 
(defconstant $langHungarian 26) ;  smEastEurRoman script 
(defconstant $langEstonian 27)  ;  smEastEurRoman script 
(defconstant $langLettish 28)   ;  smEastEurRoman script 
(defconstant $langLatvian 28)   ;  Synonym for langLettish 
(defconstant $langLapponian 29) ;  extended Roman script 
(defconstant $langLappish 29)   ;  Synonym for langLapponian 
(defconstant $langFaeroese 30)  ;  smRoman script 
(defconstant $langFarsi 31)     ;  smArabic script 
(defconstant $langPersian 31)   ;  Synonym for langFarsi 
(defconstant $langRussian 32)   ;  smCyrillic script 
(defconstant $langSimpChinese 33);  Chinese in simplified characters 
(defconstant $langFlemish 34)   ;  smRoman script 
(defconstant $langIrish 35)     ;  smRoman script 
(defconstant $langAlbanian 36)  ;  smRoman script 
(defconstant $langRomanian 37)  ;  smEastEurRoman script 
(defconstant $langCzech 38)     ;  smEastEurRoman script 
(defconstant $langSlovak 39)    ;  smEastEurRoman script 
(defconstant $langSlovenian 40) ;  smEastEurRoman script 
(defconstant $langYiddish 41)   ;  smHebrew script 
(defconstant $langSerbian 42)   ;  Serbo-Croatian in smCyrillic script 
(defconstant $langMacedonian 43);  smCyrillic script 
(defconstant $langBulgarian 44) ;  smCyrillic script 
(defconstant $langUkrainian 45) ;  smCyrillic script 
(defconstant $langByelorussian 46);  smCyrillic script 
(defconstant $langUzbek 47)     ;  smCyrillic script 
(defconstant $langKazakh 48)    ;  smCyrillic script 
(defconstant $langAzerbaijani 49);  Azerbaijani in smCyrillic script (USSR) 
(defconstant $langAzerbaijanAr 50);  Azerbaijani in smArabic script (Iran) 
(defconstant $langArmenian 51)  ;  smArmenian script 
(defconstant $langGeorgian 52)  ;  smGeorgian script 
(defconstant $langMoldavian 53) ;  smCyrillic script 
(defconstant $langKirghiz 54)   ;  smCyrillic script 
(defconstant $langTajiki 55)    ;  smCyrillic script 
(defconstant $langTurkmen 56)   ;  smCyrillic script 
(defconstant $langMongolian 57) ;  Mongolian in smMongolian script 
(defconstant $langMongolianCyr 58);  Mongolian in smCyrillic script 
(defconstant $langPashto 59)    ;  smArabic script 
(defconstant $langKurdish 60)   ;  smArabic script 
(defconstant $langKashmiri 61)  ;  smArabic script 
(defconstant $langSindhi 62)    ;  smExtArabic script 
(defconstant $langTibetan 63)   ;  smTibetan script 
(defconstant $langNepali 64)    ;  smDevanagari script 
(defconstant $langSanskrit 65)  ;  smDevanagari script 
(defconstant $langMarathi 66)   ;  smDevanagari script 
(defconstant $langBengali 67)   ;  smBengali script 
(defconstant $langAssamese 68)  ;  smBengali script 
(defconstant $langGujarati 69)  ;  smGujarati script 
(defconstant $langPunjabi 70)   ;  smGurmukhi script 
(defconstant $langOriya 71)     ;  smOriya script 
(defconstant $langMalayalam 72) ;  smMalayalam script 
(defconstant $langKannada 73)   ;  smKannada script 
(defconstant $langTamil 74)     ;  smTamil script 
(defconstant $langTelugu 75)    ;  smTelugu script 
(defconstant $langSinhalese 76) ;  smSinhalese script 
(defconstant $langBurmese 77)   ;  smBurmese script 
(defconstant $langKhmer 78)     ;  smKhmer script 
(defconstant $langLao 79)       ;  smLaotian script 
(defconstant $langVietnamese 80);  smVietnamese script 
(defconstant $langIndonesian 81);  smRoman script 
(defconstant $langTagalog 82)   ;  smRoman script 
(defconstant $langMalayRoman 83);  Malay in smRoman script 
(defconstant $langMalayArabic 84);  Malay in smArabic script 
(defconstant $langAmharic 85)   ;  smEthiopic script 
(defconstant $langTigrinya 86)  ;  smEthiopic script 
(defconstant $langGalla 87)     ;  smEthiopic script 
(defconstant $langOromo 87)     ;  Synonym for langGalla 
(defconstant $langSomali 88)    ;  smRoman script 
(defconstant $langSwahili 89)   ;  smRoman script 
(defconstant $langRuanda 90)    ;  smRoman script 
(defconstant $langRundi 91)     ;  smRoman script 
(defconstant $langChewa 92)     ;  smRoman script 
(defconstant $langMalagasy 93)  ;  smRoman script 
(defconstant $langEsperanto 94) ;  extended Roman script 
(defconstant $langWelsh 128)    ;  smRoman script 
(defconstant $langBasque 129)   ;  smRoman script 
(defconstant $langCatalan 130)  ;  smRoman script 
(defconstant $langLatin 131)    ;  smRoman script 
(defconstant $langQuechua 132)  ;  smRoman script 
(defconstant $langGuarani 133)  ;  smRoman script 
(defconstant $langAymara 134)   ;  smRoman script 
(defconstant $langTatar 135)    ;  smCyrillic script 
(defconstant $langUighur 136)   ;  smArabic script 
(defconstant $langDzongkha 137) ;  (lang of Bhutan) smTibetan script 
(defconstant $langJavaneseRom 138);  Javanese in smRoman script 
(defconstant $langSundaneseRom 139);  Sundanese in smRoman script 

;  Obsolete names, kept for backward compatibility 

(defconstant $langPortugese 8)  ;  old misspelled version, kept for compatibility 
(defconstant $langMalta 16)     ;  old misspelled version, kept for compatibility 
(defconstant $langYugoslavian 18);  (use langCroatian, langSerbian, etc.) 
(defconstant $langChinese 19)   ;  (use langTradChinese or langSimpChinese) 

;  Regional version codes 

(defconstant $verUS 0)
(defconstant $verFrance 1)
(defconstant $verBritain 2)
(defconstant $verGermany 3)
(defconstant $verItaly 4)
(defconstant $verNetherlands 5)
(defconstant $verFrBelgiumLux 6);  French for Belgium & Luxembourg 
(defconstant $verSweden 7)
(defconstant $verSpain 8)
(defconstant $verDenmark 9)
(defconstant $verPortugal 10)
(defconstant $verFrCanada 11)
(defconstant $verNorway 12)
(defconstant $verIsrael 13)
(defconstant $verJapan 14)
(defconstant $verAustralia 15)
(defconstant $verArabic 16)     ;  synonym for verArabia 
(defconstant $verFinland 17)
(defconstant $verFrSwiss 18)    ;  French Swiss 
(defconstant $verGrSwiss 19)    ;  German Swiss 
(defconstant $verGreece 20)
(defconstant $verIceland 21)
(defconstant $verMalta 22)
(defconstant $verCyprus 23)
(defconstant $verTurkey 24)
(defconstant $verYugoCroatian 25);  Croatian system for Yugoslavia 
(defconstant $verIndiaHindi 33) ;  Hindi system for India 
(defconstant $verPakistan 34)
(defconstant $verLithuania 41)
(defconstant $verPoland 42)
(defconstant $verHungary 43)
(defconstant $verEstonia 44)
(defconstant $verLatvia 45)
(defconstant $verLapland 46)
(defconstant $verFaeroeIsl 47)
(defconstant $verIran 48)
(defconstant $verRussia 49)
(defconstant $verIreland 50)    ;  English-language version for Ireland 
(defconstant $verKorea 51)
(defconstant $verChina 52)
(defconstant $verTaiwan 53)
(defconstant $verThailand 54)

(defconstant $minCountry #$VERUS)
(defconstant $maxCountry #$VERTHAILAND)

; Obsolete region code names, kept for backward compatibility

(defconstant $verBelgiumLux 6)  ;  (use verFrBelgiumLux instead, less ambiguous) 
(defconstant $verArabia 16)
(defconstant $verYugoslavia 25) ;  (use verYugoCroatian instead, less ambiguous) 
(defconstant $verIndia 33)      ;  (use verIndiaHindi instead, less ambiguous) 

;  Calendar Codes 

(defconstant $calGregorian 0)
(defconstant $calArabicCivil 1)
(defconstant $calArabicLunar 2)
(defconstant $calJapanese 3)
(defconstant $calJewish 4)
(defconstant $calCoptic 5)
(defconstant $calPersian 6)

;  Integer Format Codes 

(defconstant $intWestern 0)
(defconstant $intArabic 1)
(defconstant $intRoman 2)
(defconstant $intJapanese 3)
(defconstant $intEuropean 4)
(defconstant $intOutputMask #X8000)

;  CharByte byte types 

(defconstant $smSingleByte 0)
(defconstant $smFirstByte -1)
(defconstant $smLastByte 1)
(defconstant $smMiddleByte 2)

;  CharType field masks 

(defconstant $smcTypeMask #XF)
(defconstant $smcReserved #XF0)
(defconstant $smcClassMask #XF00)
(defconstant $smcOrientationMask #X1000); two-byte script glyph orientation
(defconstant $smcRightMask #X2000)
(defconstant $smcUpperMask #X4000)
(defconstant $smcDoubleMask #X8000)

;  Basic CharType character types 

(defconstant $smCharPunct #X0)
(defconstant $smCharAscii #X1)
(defconstant $smCharEuro #X7)
(defconstant $smCharExtAscii #X7);  More correct synonym for smCharEuro 

;  Additional CharType character types for script systems 

(defconstant $smCharKatakana #X2); Japanese Katakana
(defconstant $smCharHiragana #X3); Japanese Hiragana
(defconstant $smCharIdeographic #X4); Hanzi, Kanji, Hanja
(defconstant $smCharTwoByteGreek #X5); 2-byte Greek in Far East systems
(defconstant $smCharTwoByteRussian #X6); 2-byte Cyrillic in Far East systems
(defconstant $smCharBidirect #X8); Arabic/Hebrew
(defconstant $smCharContextualLR #X9); Contextual left-right: Thai, Indic scripts
(defconstant $smCharNonContextualLR #XA); Non-contextual left-right: Cyrillic, Greek
(defconstant $smCharHangul #XC) ; Korean Hangul
(defconstant $smCharJamo #XD)   ; Korean Jamo
(defconstant $smCharBopomofo #XE); Chinese Bopomofo

;  old names for some of above, for backward compatibility 

(defconstant $smCharFISKana #X2); Katakana
(defconstant $smCharFISGana #X3); Hiragana
(defconstant $smCharFISIdeo #X4); Hanzi, Kanji, Hanja
(defconstant $smCharFISGreek #X5); 2-byte Greek in Far East systems
(defconstant $smCharFISRussian #X6); 2-byte Cyrillic in Far East systems

;  CharType classes for punctuation (smCharPunct) 

(defconstant $smPunctNormal #X0)
(defconstant $smPunctNumber #X100)
(defconstant $smPunctSymbol #X200)
(defconstant $smPunctBlank #X300)

;  Additional CharType classes for punctuation in two-byte systems 

(defconstant $smPunctRepeat #X400);  repeat marker 
(defconstant $smPunctGraphic #X500);  line graphics 

;  CharType Katakana and Hiragana classes for two-byte systems 

(defconstant $smKanaSmall #X100); small kana character
(defconstant $smKanaHardOK #X200); can have dakuten
(defconstant $smKanaSoftOK #X300); can have dakuten or han-dakuten

;  CharType Ideographic classes for two-byte systems 

(defconstant $smIdeographicLevel1 #X0); level 1 char
(defconstant $smIdeographicLevel2 #X100); level 2 char
(defconstant $smIdeographicUser #X200); user char

;  old names for above, for backward compatibility 

(defconstant $smFISClassLvl1 #X0); level 1 char
(defconstant $smFISClassLvl2 #X100); level 2 char
(defconstant $smFISClassUser #X200); user char

;  CharType Jamo classes for Korean systems 

(defconstant $smJamoJaeum #X0)  ; simple consonant char
(defconstant $smJamoBogJaeum #X100); complex consonant char
(defconstant $smJamoMoeum #X200); simple vowel char
(defconstant $smJamoBogMoeum #X300); complex vowel char

;  CharType glyph orientation for two-byte systems 

(defconstant $smCharHorizontal #X0);  horizontal character form, or for both 
(defconstant $smCharVertical #X1000);  vertical character form 

;  CharType directions 

(defconstant $smCharLeft #X0)
(defconstant $smCharRight #X2000)

;  CharType case modifers 

(defconstant $smCharLower #X0)
(defconstant $smCharUpper #X4000)

;  CharType character size modifiers (1 or multiple bytes). 

(defconstant $smChar1byte #X0)
(defconstant $smChar2byte #X8000)

;  TransliterateText target types for Roman 

(defconstant $smTransAscii 0)   ; convert to ASCII
(defconstant $smTransNative 1)  ; convert to font script
(defconstant $smTransCase #XFE) ; convert case for all text
(defconstant $smTransSystem #XFF); convert to system script

;  TransliterateText target types for two-byte scripts 

(defconstant $smTransAscii1 2)  ; 1-byte Roman
(defconstant $smTransAscii2 3)  ; 2-byte Roman
(defconstant $smTransKana1 4)   ; 1-byte Japanese Katakana
(defconstant $smTransKana2 5)   ; 2-byte Japanese Katakana
(defconstant $smTransGana2 7)   ; 2-byte Japanese Hiragana (no 1-byte Hiragana)
(defconstant $smTransHangul2 8) ; 2-byte Korean Hangul
(defconstant $smTransJamo2 9)   ; 2-byte Korean Jamo
(defconstant $smTransBopomofo2 10); 2-byte Chinese Bopomofo

;  TransliterateText target modifiers 

(defconstant $smTransLower #X4000); target becomes lowercase
(defconstant $smTransUpper #X8000); target becomes uppercase

;  TransliterateText resource format numbers 

(defconstant $smTransRuleBaseFormat 1); Rule based trsl resource format 
(defconstant $smTransHangulFormat 2); Table based Hangul trsl resource format

;  TransliterateText property flags 

(defconstant $smTransPreDoubleByting 1); Convert all text to double byte before transliteration
(defconstant $smTransPreLowerCasing 2); Convert all text to lower case before transliteration

;  TransliterateText source mask - general 

(defconstant $smMaskAll #XFFFFFFFF); Convert all text

;  TransliterateText source masks 

(defconstant $smMaskAscii #X1)  ; 2^smTransAscii
(defconstant $smMaskNative #X2) ; 2^smTransNative

;  TransliterateText source masks for two-byte scripts 

(defconstant $smMaskAscii1 #X4) ; 2^smTransAscii1
(defconstant $smMaskAscii2 #X8) ; 2^smTransAscii2
(defconstant $smMaskKana1 #X10) ; 2^smTransKana1
(defconstant $smMaskKana2 #X20) ; 2^smTransKana2
(defconstant $smMaskGana2 #X80) ; 2^smTransGana2
(defconstant $smMaskHangul2 #X100); 2^smTransHangul2
(defconstant $smMaskJamo2 #X200); 2^smTransJamo2
(defconstant $smMaskBopomofo2 #X400); 2^smTransBopomofo2

;  Result values from GetSMVariable, SetSMVariable, GetScriptVariable and SetScriptVariable calls. 

(defconstant $smNotInstalled 0) ; routine not available in script
(defconstant $smBadVerb -1)     ; Bad verb passed to a routine
(defconstant $smBadScript -2)   ; Bad script code passed to a routine

;  Values for script redraw flag. 

(defconstant $smRedrawChar 0)   ; Redraw character only
(defconstant $smRedrawWord 1)   ; Redraw entire word (2-byte systems)
(defconstant $smRedrawLine -1)  ; Redraw entire line (bidirectional systems)

;  GetSMVariable and SetSMVariable verbs 

(defconstant $smVersion 0)      ; Script Manager version number
(defconstant $smMunged 2)       ; Globals change count
(defconstant $smEnabled 4)      ; Count of enabled scripts, incl Roman
(defconstant $smBidirect 6)     ; At least one bidirectional script
(defconstant $smFontForce 8)    ; Force font flag
(defconstant $smIntlForce 10)   ; Force intl flag
(defconstant $smForced 12)      ; Script was forced to system script
(defconstant $smDefault 14)     ; Script was defaulted to Roman script
(defconstant $smPrint 16)       ; Printer action routine
(defconstant $smSysScript 18)   ; System script
(defconstant $smLastScript 20)  ; Last keyboard script
(defconstant $smKeyScript 22)   ; Keyboard script
(defconstant $smSysRef 24)      ; System folder refNum
(defconstant $smKeyCache 26)    ; obsolete
(defconstant $smKeySwap 28)     ; Swapping table handle
(defconstant $smGenFlags 30)    ; General flags long
(defconstant $smOverride 32)    ; Script override flags
(defconstant $smCharPortion 34) ; Ch vs SpExtra proportion

;  New for System 7.0: 

(defconstant $smDoubleByte 36)  ; Flag for double-byte script installed
(defconstant $smKCHRCache 38)   ; Returns pointer to KCHR cache
(defconstant $smRegionCode 40)  ; Returns current region code (verXxx)
(defconstant $smKeyDisableState 42); Returns current keyboard disable state

;  GetScriptVariable and SetScriptVariable verbs.
; Note: Verbs private to script systems are negative, while
; those general across script systems are non-negative. 

(defconstant $smScriptVersion 0); Script software version
(defconstant $smScriptMunged 2) ; Script entry changed count
(defconstant $smScriptEnabled 4); Script enabled flag
(defconstant $smScriptRight 6)  ; Right to left flag
(defconstant $smScriptJust 8)   ; Justification flag
(defconstant $smScriptRedraw 10); Word redraw flag
(defconstant $smScriptSysFond 12); Preferred system font
(defconstant $smScriptAppFond 14); Preferred Application font
(defconstant $smScriptBundle 16); Beginning of itlb verbs
(defconstant $smScriptNumber 16); Script itl0 id
(defconstant $smScriptDate 18)  ; Script itl1 id
(defconstant $smScriptSort 20)  ; Script itl2 id
(defconstant $smScriptFlags 22) ; flags word
(defconstant $smScriptToken 24) ; Script itl4 id
(defconstant $smScriptEncoding 26); id of optional itl5, if present
(defconstant $smScriptLang 28)  ; Current language for script
(defconstant $smScriptNumDate 30); Script Number/Date formats.
(defconstant $smScriptKeys 32)  ; Script KCHR id
(defconstant $smScriptIcon 34)  ; ID # of SICN or kcs#/kcs4/kcs8 suite
(defconstant $smScriptPrint 36) ; Script printer action routine
(defconstant $smScriptTrap 38)  ; Trap entry pointer
(defconstant $smScriptCreator 40); Script file creator
(defconstant $smScriptFile 42)  ; Script file name
(defconstant $smScriptName 44)  ; Script name

;  There is a hole here for old Kanji private verbs 46-76 
; 
;  New for System 7.0: 

(defconstant $smScriptMonoFondSize 78); default monospace FOND (hi) & size (lo)
(defconstant $smScriptPrefFondSize 80); preferred FOND (hi) & size (lo)
(defconstant $smScriptSmallFondSize 82); default small FOND (hi) & size (lo)
(defconstant $smScriptSysFondSize 84); default system FOND (hi) & size (lo)
(defconstant $smScriptAppFondSize 86); default app FOND (hi) & size (lo)
(defconstant $smScriptHelpFondSize 88); default Help Mgr FOND (hi) & size (lo)
(defconstant $smScriptValidStyles 90); mask of valid styles for script
(defconstant $smScriptAliasStyle 92); style (set) to use for aliases

;  Special script code values for International Utilities 

(defconstant $iuSystemScript -1);  <obsolete>  system script 
(defconstant $iuCurrentScript -2);  <obsolete>  current script (for font of grafPort) 

;  Negative verbs for KeyScript 

(defconstant $smKeyNextScript -1);  Switch to next available script 
(defconstant $smKeySysScript -2);  Switch to the system script 
(defconstant $smKeySwapScript -3);  Switch to previously-used script 

;  New for System 7.0: 

(defconstant $smKeyNextKybd -4) ;  Switch to next keyboard in current keyscript 
(defconstant $smKeySwapKybd -5) ;  Switch to previously-used keyboard in current keyscript 

(defconstant $smKeyDisableKybds -6);  Disable keyboards not in system or Roman script 
(defconstant $smKeyEnableKybds -7);  Re-enable keyboards for all enabled scripts 
(defconstant $smKeyToggleInline -8);  Toggle inline input for current keyscript 
(defconstant $smKeyToggleDirection -9);  Toggle default line direction (TESysJust) 
(defconstant $smKeyNextInputMethod -10);  Switch to next input method in current keyscript 
(defconstant $smKeySwapInputMethod -11);  Switch to last-used input method in current keyscript 

(defconstant $smKeyDisableKybdSwitch -12);  Disable switching from the current keyboard 

(defconstant $smKeySetDirLeftRight -15);  Set default line dir to left-right, align left 
(defconstant $smKeySetDirRightLeft -16);  Set default line dir to right-left, align right 
(defconstant $smKeyRoman -17)   ;  Set keyscript to Roman. Does nothing if Roman-only
; 										system, unlike KeyScript(smRoman) which forces
; 										an update to current default Roman keyboard 

;  Bits in the smScriptFlags word
; (bits above 8 are non-static) 

(defconstant $smsfIntellCP 0)   ; Script has intelligent cut & paste
(defconstant $smsfSingByte 1)   ; Script has only single bytes
(defconstant $smsfNatCase 2)    ; Native chars have upper & lower case
(defconstant $smsfContext 3)    ; Script is contextual
(defconstant $smsfNoForceFont 4); Script will not force characters
(defconstant $smsfB0Digits 5)   ; Script has alternate digits at B0-B9
(defconstant $smsfAutoInit 6)   ; Auto initialize the script
(defconstant $smsfUnivExt 7)    ; Script is handled by universal extension
(defconstant $smsfSynchUnstyledTE 8); Script synchronizes for unstyled TE
(defconstant $smsfForms 13)     ; Uses contextual forms for letters
(defconstant $smsfLigatures 14) ; Uses contextual ligatures
(defconstant $smsfReverse 15)   ; Reverses native text, right-left

;  Bits in the smGenFlags long.
; First (high-order) byte is set from itlc flags byte. 

(defconstant $smfShowIcon 31)   ; Show icon even if only one script
(defconstant $smfDualCaret 30)  ; Use dual caret for mixed direction text
(defconstant $smfNameTagEnab 29); Reserved for internal use
(defconstant $smfUseAssocFontInfo 28); Use the associated font info for FontMetrics calls 

;  Roman script constants 
; 
;  The following are here for backward compatibility, but should not be used. 
;  This information should be obtained using GetScript. 

(defconstant $romanSysFond #X3FFF); system font id number
(defconstant $romanAppFond 3)   ; application font id number
(defconstant $romanFlags #X7)   ; roman settings

;  Script Manager font equates. 

(defconstant $smFondStart #X4000); start from 16K
(defconstant $smFondEnd #XC000) ; past end of range at 48K

;  Miscellaneous font equates. 

(defconstant $smUprHalfCharSet #X80); first char code in top half of std char set

;  Character Set Extensions 

(defconstant $diaeresisUprY #XD9)
(defconstant $fraction #XDA)
(defconstant $intlCurrency #XDB)
(defconstant $leftSingGuillemet #XDC)
(defconstant $rightSingGuillemet #XDD)
(defconstant $fiLigature #XDE)
(defconstant $flLigature #XDF)
(defconstant $dblDagger #XE0)
(defconstant $centeredDot #XE1)
(defconstant $baseSingQuote #XE2)
(defconstant $baseDblQuote #XE3)
(defconstant $perThousand #XE4)
(defconstant $circumflexUprA #XE5)
(defconstant $circumflexUprE #XE6)
(defconstant $acuteUprA #XE7)
(defconstant $diaeresisUprE #XE8)
(defconstant $graveUprE #XE9)
(defconstant $acuteUprI #XEA)
(defconstant $circumflexUprI #XEB)
(defconstant $diaeresisUprI #XEC)
(defconstant $graveUprI #XED)
(defconstant $acuteUprO #XEE)
(defconstant $circumflexUprO #XEF)
(defconstant $appleLogo #XF0)
(defconstant $graveUprO #XF1)
(defconstant $acuteUprU #XF2)
(defconstant $circumflexUprU #XF3)
(defconstant $graveUprU #XF4)
(defconstant $dotlessLwrI #XF5)
(defconstant $circumflex #XF6)
(defconstant $tilde #XF7)
(defconstant $macron #XF8)
(defconstant $breveMark #XF9)
(defconstant $overDot #XFA)
(defconstant $ringMark #XFB)
(defconstant $cedilla #XFC)
(defconstant $doubleAcute #XFD)
(defconstant $ogonek #XFE)
(defconstant $hachek #XFF)

;  TokenType values 

(defconstant $tokenIntl 4)      ; the itl resource number of the tokenizer
(defconstant $tokenEmpty -1)    ; used internally as an empty flag
(defconstant $tokenUnknown 0)   ; chars that do not match a defined token type
(defconstant $tokenWhite 1)     ; white space
(defconstant $tokenLeftLit 2)   ; literal begin
(defconstant $tokenRightLit 3)  ; literal end
(defconstant $tokenAlpha 4)     ; alphabetic
(defconstant $tokenNumeric 5)   ; numeric
(defconstant $tokenNewLine 6)   ; new line
(defconstant $tokenLeftComment 7); open comment
(defconstant $tokenRightComment 8); close comment
(defconstant $tokenLiteral 9)   ; literal
(defconstant $tokenEscape 10)   ; character escape (e.g. '\' in "\n", "\t")
(defconstant $tokenAltNum 11)   ; alternate number (e.g. $B0-B9 in Arabic,Hebrew)
(defconstant $tokenRealNum 12)  ; real number
(defconstant $tokenAltReal 13)  ; alternate real number
(defconstant $tokenReserve1 14) ; reserved
(defconstant $tokenReserve2 15) ; reserved
(defconstant $tokenLeftParen 16); open parenthesis
(defconstant $tokenRightParen 17); close parenthesis
(defconstant $tokenLeftBracket 18); open square bracket
(defconstant $tokenRightBracket 19); close square bracket
(defconstant $tokenLeftCurly 20); open curly bracket
(defconstant $tokenRightCurly 21); close curly bracket
(defconstant $tokenLeftEnclose 22); open guillemet
(defconstant $tokenRightEnclose 23); close guillemet
(defconstant $tokenPlus 24)
(defconstant $tokenMinus 25)
(defconstant $tokenAsterisk 26) ; times/multiply
(defconstant $tokenDivide 27)
(defconstant $tokenPlusMinus 28); plus or minus symbol
(defconstant $tokenSlash 29)
(defconstant $tokenBackSlash 30)
(defconstant $tokenLess 31)     ; less than symbol
(defconstant $tokenGreat 32)    ; greater than symbol
(defconstant $tokenEqual 33)
(defconstant $tokenLessEqual2 34); less than or equal, 2 characters (e.g. <=)
(defconstant $tokenLessEqual1 35); less than or equal, 1 character
(defconstant $tokenGreatEqual2 36); greater than or equal, 2 characters (e.g. >=)
(defconstant $tokenGreatEqual1 37); greater than or equal, 1 character
(defconstant $token2Equal 38)   ; double equal (e.g. ==)
(defconstant $tokenColonEqual 39); colon equal
(defconstant $tokenNotEqual 40) ; not equal, 1 character
(defconstant $tokenLessGreat 41); less/greater, Pascal not equal (e.g. <>)
(defconstant $tokenExclamEqual 42); exclamation equal, C not equal (e.g. !=)
(defconstant $tokenExclam 43)   ; exclamation point
(defconstant $tokenTilde 44)    ; centered tilde
(defconstant $tokenComma 45)
(defconstant $tokenPeriod 46)
(defconstant $tokenLeft2Quote 47); open double quote
(defconstant $tokenRight2Quote 48); close double quote
(defconstant $tokenLeft1Quote 49); open single quote
(defconstant $tokenRight1Quote 50); close single quote
(defconstant $token2Quote 51)   ; double quote
(defconstant $token1Quote 52)   ; single quote
(defconstant $tokenSemicolon 53)
(defconstant $tokenPercent 54)
(defconstant $tokenCaret 55)
(defconstant $tokenUnderline 56)
(defconstant $tokenAmpersand 57)
(defconstant $tokenAtSign 58)
(defconstant $tokenBar 59)      ; vertical bar
(defconstant $tokenQuestion 60)
(defconstant $tokenPi 61)       ; lower-case pi
(defconstant $tokenRoot 62)     ; square root symbol
(defconstant $tokenSigma 63)    ; capital sigma
(defconstant $tokenIntegral 64) ; integral sign
(defconstant $tokenMicro 65)
(defconstant $tokenCapPi 66)    ; capital pi
(defconstant $tokenInfinity 67)
(defconstant $tokenColon 68)
(defconstant $tokenHash 69)     ; e.g. #
(defconstant $tokenDollar 70)
(defconstant $tokenNoBreakSpace 71); non-breaking space
(defconstant $tokenFraction 72)
(defconstant $tokenIntlCurrency 73)
(defconstant $tokenLeftSingGuillemet 74)
(defconstant $tokenRightSingGuillemet 75)
(defconstant $tokenPerThousand 76)
(defconstant $tokenEllipsis 77)
(defconstant $tokenCenterDot 78)
(defconstant $tokenNil 127)
(defconstant $delimPad -2)

;  obsolete, misspelled token names kept for backward compatibility 

(defconstant $tokenTilda 44)
(defconstant $tokenCarat 55)

;  Table selectors for GetItlTable 

(defconstant $smWordSelectTable 0);  get word select break table from 'itl2' 
(defconstant $smWordWrapTable 1);  get word wrap break table from 'itl2' 
(defconstant $smNumberPartsTable 2);  get default number parts table from 'itl4' 
(defconstant $smUnTokenTable 3) ;  get unToken table from 'itl4' 
(defconstant $smWhiteSpaceList 4);  get white space list from 'itl4' 

(defconstant $iuWordSelectTable 0);  <obsolete>  get word select break table from 'itl2' 
(defconstant $iuWordWrapTable 1);  <obsolete>  get word wrap break table from 'itl2' 
(defconstant $iuNumberPartsTable 2);  <obsolete>  get default number parts table from 'itl4' 
(defconstant $iuUnTokenTable 3) ;  <obsolete>  get unToken table from 'itl4' 
(defconstant $iuWhiteSpaceList 4);  <obsolete>  get white space list from 'itl4' 

(def-mactype :TOKENRESULTS (find-mactype :UNSIGNED-BYTE))
(defconstant $tokenOK 0)
(defconstant $tokenOverflow 1)
(defconstant $stringOverflow 2)
(defconstant $badDelim 3)
(defconstant $badEnding 4)
(defconstant $crash 5)

(defrecord CharByteTable (array (ARRAY :SIGNED-BYTE 256)))

(def-mactype :TOKENTYPE (find-mactype :SIGNED-INTEGER))
(defrecord DelimType (array (ARRAY :SIGNED-INTEGER 2)))
(defrecord CommentType (array (ARRAY :SIGNED-INTEGER 4)))

(def-mactype :TOKENRECPTR (find-mactype :POINTER))
(defrecord TokenRec 
   (theToken :SIGNED-INTEGER)
   (position :POINTER)          ; pointer into original source
   (length :SIGNED-LONG)        ; length of text in original source
   (stringPosition (:POINTER (:STRING 255))); Pascal/C string copy of identifier
   )

(def-mactype :TOKENBLOCKPTR (find-mactype :POINTER))
(defrecord TokenBlock 
   (source :POINTER)            ; pointer to stream of characters
   (sourceLength :SIGNED-LONG)  ; length of source stream
   (tokenList :POINTER)         ; pointer to array of tokens
   (tokenLength :SIGNED-LONG)   ; maximum length of TokenList
   (tokenCount :SIGNED-LONG)    ; number tokens generated by tokenizer
   (stringList :POINTER)        ; pointer to stream of identifiers
   (stringLength :SIGNED-LONG)  ; length of string list
   (stringCount :SIGNED-LONG)   ; number of bytes currently used
   (doString :BOOLEAN)          ; make strings & put into StringList
   (doAppend :BOOLEAN)          ; append to TokenList rather than replace
   (doAlphanumeric :BOOLEAN)    ; identifiers may include numeric
   (doNest :BOOLEAN)            ; do comments nest?
   (leftDelims (:ARRAY :SIGNED-INTEGER 2))
   (rightDelims (:ARRAY :SIGNED-INTEGER 2))
   (leftComment (:ARRAY :SIGNED-INTEGER 4))
   (rightComment (:ARRAY :SIGNED-INTEGER 4))
   (escapeCode :SIGNED-INTEGER) ; escape symbol code
   (decimalCode :SIGNED-INTEGER)
   (itlResource :HANDLE)        ; handle to itl4 resource of current script
   (reserved (:ARRAY :SIGNED-LONG 8)); must be zero!
   )


(deftrap _fontscript nil
   (:stack :signed-integer)
   (:stack-trap #xA8B5 ((+ (ash 33280 16) 0) :signed-longint)))

(deftrap _intlscript nil
   (:stack :signed-integer)
   (:stack-trap #xA8B5 ((+ (ash 33280 16) 2) :signed-longint)))

(deftrap _keyscript ((code :signed-integer))
   nil
   (:stack-trap #xA8B5 code ((+ (ash 32770 16) 4) :signed-longint)))

(deftrap _charbyte ((textbuf :pointer) (textoffset :signed-integer))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 textbuf textoffset ((+ (ash 33286 16) 16) :signed-longint)))

(deftrap _chartype ((textbuf :pointer) (textoffset :signed-integer))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 textbuf textoffset ((+ (ash 33286 16) 18) :signed-longint)))

(deftrap _transliterate ((srchandle :handle) (dsthandle :handle) (target :signed-integer) (srcmask :signed-long))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 srchandle dsthandle target srcmask ((+ (ash 33294 16) 24) :signed-longint)))

(deftrap _parsetable ((table (:pointer :charbytetable)))
   (:stack :boolean)
   (:stack-trap #xA8B5 table ((+ (ash 33284 16) 34) :signed-longint)))

(deftrap _getsysdirection nil
   (:no-trap :signed-integer)
   (:no-trap (%get-signed-word (%int-to-ptr 2988))))

(deftrap _getsysjust nil
   (:no-trap :signed-integer)
   (:no-trap (%get-signed-word (%int-to-ptr 2988))))

(deftrap _setsysdirection ((newjust :signed-integer))
   nil
   (:no-trap (%put-word (%int-to-ptr 2988) newjust)))

(deftrap _setsysjust ((newjust :signed-integer))
   nil
   (:no-trap (%put-word (%int-to-ptr 2988) newjust)))

(deftrap _intltokenize ((tokenparam (:pointer :tokenblock)))
   (:stack :unsigned-byte)
   (:stack-trap #xA8B5 tokenparam ((+ (ash 33284 16) 65530) :signed-longint)))

(deftrap _fonttoscript ((fontnumber :signed-integer))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 fontnumber ((+ (ash 33282 16) 6) :signed-longint)))

(deftrap _font2script ((fontnumber :signed-integer))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 fontnumber ((+ (ash 33282 16) 6) :signed-longint)))

(deftrap _getsmvariable ((selector :signed-integer))
   (:stack :signed-long)
   (:stack-trap #xA8B5 selector ((+ (ash 33794 16) 8) :signed-longint)))

(deftrap _getenvirons ((verb :signed-integer))
   (:stack :signed-long)
   (:stack-trap #xA8B5 verb ((+ (ash 33794 16) 8) :signed-longint)))

(deftrap _setsmvariable ((selector :signed-integer) (param :signed-long))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 selector param ((+ (ash 33286 16) 10) :signed-longint)))

(deftrap _setenvirons ((verb :signed-integer) (param :signed-long))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 verb param ((+ (ash 33286 16) 10) :signed-longint)))

(deftrap _getscriptvariable ((script :signed-integer) (selector :signed-integer))
   (:stack :signed-long)
   (:stack-trap #xA8B5 script selector ((+ (ash 33796 16) 12) :signed-longint)))

(deftrap _getscript ((script :signed-integer) (verb :signed-integer))
   (:stack :signed-long)
   (:stack-trap #xA8B5 script verb ((+ (ash 33796 16) 12) :signed-longint)))

(deftrap _setscriptvariable ((script :signed-integer) (selector :signed-integer) (param :signed-long))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 script selector param ((+ (ash 33288 16) 14) :signed-longint)))

(deftrap _setscript ((script :signed-integer) (verb :signed-integer) (param :signed-long))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 script verb param ((+ (ash 33288 16) 14) :signed-longint)))

;   New for 7.1  


(deftrap _getscriptutilityaddress ((selector :signed-integer) (before :boolean) (script :signed-integer))
   (:stack :pointer)
   (:stack-trap #xA8B5 selector before script ((+ (ash 50180 16) 56) :signed-longint)))

(deftrap _setscriptutilityaddress ((selector :signed-integer) (before :boolean) (routineaddr :pointer) (script :signed-integer))
   nil
   (:stack-trap #xA8B5 selector before routineaddr script ((+ (ash 49160 16) 58) :signed-longint)))

(deftrap _getscriptqdpatchaddress ((trapnum :signed-integer) (before :boolean) (forprinting :boolean) (script :signed-integer))
   (:stack :pointer)
   (:stack-trap #xA8B5 trapnum before forprinting script ((+ (ash 50182 16) 60) :signed-longint)))

(deftrap _setscriptqdpatchaddress ((trapnum :signed-integer) (before :boolean) (forprinting :boolean) (routineaddr :pointer) (script :signed-integer))
   nil
   (:stack-trap #xA8B5 trapnum before forprinting routineaddr script ((+ (ash 49162 16) 62) :signed-longint)))


(deftrap _characterbytetype ((textbuf :pointer) (textoffset :signed-integer) (script :signed-integer))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 textbuf textoffset script ((+ (ash 49670 16) 16) :signed-longint)))

(deftrap _charactertype ((textbuf :pointer) (textoffset :signed-integer) (script :signed-integer))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 textbuf textoffset script ((+ (ash 49670 16) 18) :signed-longint)))

(deftrap _transliteratetext ((srchandle :handle) (dsthandle :handle) (target :signed-integer) (srcmask :signed-long) (script :signed-integer))
   (:stack :signed-integer)
   (:stack-trap #xA8B5 srchandle dsthandle target srcmask script ((+ (ash 49678 16) 24) :signed-longint)))

(deftrap _fillparsetable ((table (:pointer :charbytetable)) (script :signed-integer))
   (:stack :boolean)
   (:stack-trap #xA8B5 table script ((+ (ash 49668 16) 34) :signed-longint)))

;   Moved from packages.p  


(deftrap _getintlresource ((theid :signed-integer))
   (:stack :handle)
   (:stack-trap #xA9ED theid (6 :signed-integer)))

(deftrap _iugetintl ((theid :signed-integer))
   (:stack :handle)
   (:stack-trap #xA9ED theid (6 :signed-integer)))

(deftrap _iusetintl ((refnum :signed-integer) (theid :signed-integer) (intlhandle :handle))
   nil
   (:stack-trap #xA9ED refnum theid intlhandle (8 :signed-integer)))

(deftrap _clearintlresourcecache nil
   nil
   (:stack-trap #xA9ED (24 :signed-integer)))

(deftrap _iuclearcache nil
   nil
   (:stack-trap #xA9ED (24 :signed-integer)))


(deftrap _getintlresourcetable ((script :signed-integer) (tablecode :signed-integer) (itlhandle (:pointer :handle)) (offset (:pointer :signed-long)) (length (:pointer :signed-long)))
   nil
   (:stack-trap #xA9ED script tablecode itlhandle offset length (36 :signed-integer)))

(deftrap _iugetitltable ((script :signed-integer) (tablecode :signed-integer) (itlhandle (:pointer :handle)) (offset (:pointer :signed-long)) (length (:pointer :signed-long)))
   nil
   (:stack-trap #xA9ED script tablecode itlhandle offset length (36 :signed-integer)))

; $ENDC                         ;  UsingScript 

; $IFC NOT UsingIncludes

; $ENDC


(export '($CRASH $BADENDING $BADDELIM $STRINGOVERFLOW $TOKENOVERFLOW $TOKENOK
          $IUWHITESPACELIST $IUUNTOKENTABLE $IUNUMBERPARTSTABLE
          $IUWORDWRAPTABLE $IUWORDSELECTTABLE $SMWHITESPACELIST $SMUNTOKENTABLE
          $SMNUMBERPARTSTABLE $SMWORDWRAPTABLE $SMWORDSELECTTABLE $TOKENCARAT
          $TOKENTILDA $DELIMPAD $TOKENNIL $TOKENCENTERDOT $TOKENELLIPSIS
          $TOKENPERTHOUSAND $TOKENRIGHTSINGGUILLEMET $TOKENLEFTSINGGUILLEMET
          $TOKENINTLCURRENCY $TOKENFRACTION $TOKENNOBREAKSPACE $TOKENDOLLAR
          $TOKENHASH $TOKENCOLON $TOKENINFINITY $TOKENCAPPI $TOKENMICRO
          $TOKENINTEGRAL $TOKENSIGMA $TOKENROOT $TOKENPI $TOKENQUESTION
          $TOKENBAR $TOKENATSIGN $TOKENAMPERSAND $TOKENUNDERLINE $TOKENCARET
          $TOKENPERCENT $TOKENSEMICOLON $TOKEN1QUOTE $TOKEN2QUOTE
          $TOKENRIGHT1QUOTE $TOKENLEFT1QUOTE $TOKENRIGHT2QUOTE $TOKENLEFT2QUOTE
          $TOKENPERIOD $TOKENCOMMA $TOKENTILDE $TOKENEXCLAM $TOKENEXCLAMEQUAL
          $TOKENLESSGREAT $TOKENNOTEQUAL $TOKENCOLONEQUAL $TOKEN2EQUAL
          $TOKENGREATEQUAL1 $TOKENGREATEQUAL2 $TOKENLESSEQUAL1 $TOKENLESSEQUAL2
          $TOKENEQUAL $TOKENGREAT $TOKENLESS $TOKENBACKSLASH $TOKENSLASH
          $TOKENPLUSMINUS $TOKENDIVIDE $TOKENASTERISK $TOKENMINUS $TOKENPLUS
          $TOKENRIGHTENCLOSE $TOKENLEFTENCLOSE $TOKENRIGHTCURLY $TOKENLEFTCURLY
          $TOKENRIGHTBRACKET $TOKENLEFTBRACKET $TOKENRIGHTPAREN $TOKENLEFTPAREN
          $TOKENRESERVE2 $TOKENRESERVE1 $TOKENALTREAL $TOKENREALNUM
          $TOKENALTNUM $TOKENESCAPE $TOKENLITERAL $TOKENRIGHTCOMMENT
          $TOKENLEFTCOMMENT $TOKENNEWLINE $TOKENNUMERIC $TOKENALPHA
          $TOKENRIGHTLIT $TOKENLEFTLIT $TOKENWHITE $TOKENUNKNOWN $TOKENEMPTY
          $TOKENINTL $HACHEK $OGONEK $DOUBLEACUTE $CEDILLA $RINGMARK $OVERDOT
          $BREVEMARK $MACRON $TILDE $CIRCUMFLEX $DOTLESSLWRI $GRAVEUPRU
          $CIRCUMFLEXUPRU $ACUTEUPRU $GRAVEUPRO $APPLELOGO $CIRCUMFLEXUPRO
          $ACUTEUPRO $GRAVEUPRI $DIAERESISUPRI $CIRCUMFLEXUPRI $ACUTEUPRI
          $GRAVEUPRE $DIAERESISUPRE $ACUTEUPRA $CIRCUMFLEXUPRE $CIRCUMFLEXUPRA
          $PERTHOUSAND $BASEDBLQUOTE $BASESINGQUOTE $CENTEREDDOT $DBLDAGGER
          $FLLIGATURE $FILIGATURE $RIGHTSINGGUILLEMET $LEFTSINGGUILLEMET
          $INTLCURRENCY $FRACTION $DIAERESISUPRY $SMUPRHALFCHARSET $SMFONDEND
          $SMFONDSTART $ROMANFLAGS $ROMANAPPFOND $ROMANSYSFOND
          $SMFUSEASSOCFONTINFO $SMFNAMETAGENAB $SMFDUALCARET $SMFSHOWICON
          $SMSFREVERSE $SMSFLIGATURES $SMSFFORMS $SMSFSYNCHUNSTYLEDTE
          $SMSFUNIVEXT $SMSFAUTOINIT $SMSFB0DIGITS $SMSFNOFORCEFONT
          $SMSFCONTEXT $SMSFNATCASE $SMSFSINGBYTE $SMSFINTELLCP $SMKEYROMAN
          $SMKEYSETDIRRIGHTLEFT $SMKEYSETDIRLEFTRIGHT $SMKEYDISABLEKYBDSWITCH
          $SMKEYSWAPINPUTMETHOD $SMKEYNEXTINPUTMETHOD $SMKEYTOGGLEDIRECTION
          $SMKEYTOGGLEINLINE $SMKEYENABLEKYBDS $SMKEYDISABLEKYBDS
          $SMKEYSWAPKYBD $SMKEYNEXTKYBD $SMKEYSWAPSCRIPT $SMKEYSYSSCRIPT
          $SMKEYNEXTSCRIPT $IUCURRENTSCRIPT $IUSYSTEMSCRIPT $SMSCRIPTALIASSTYLE
          $SMSCRIPTVALIDSTYLES $SMSCRIPTHELPFONDSIZE $SMSCRIPTAPPFONDSIZE
          $SMSCRIPTSYSFONDSIZE $SMSCRIPTSMALLFONDSIZE $SMSCRIPTPREFFONDSIZE
          $SMSCRIPTMONOFONDSIZE $SMSCRIPTNAME $SMSCRIPTFILE $SMSCRIPTCREATOR
          $SMSCRIPTTRAP $SMSCRIPTPRINT $SMSCRIPTICON $SMSCRIPTKEYS
          $SMSCRIPTNUMDATE $SMSCRIPTLANG $SMSCRIPTENCODING $SMSCRIPTTOKEN
          $SMSCRIPTFLAGS $SMSCRIPTSORT $SMSCRIPTDATE $SMSCRIPTNUMBER
          $SMSCRIPTBUNDLE $SMSCRIPTAPPFOND $SMSCRIPTSYSFOND $SMSCRIPTREDRAW
          $SMSCRIPTJUST $SMSCRIPTRIGHT $SMSCRIPTENABLED $SMSCRIPTMUNGED
          $SMSCRIPTVERSION $SMKEYDISABLESTATE $SMREGIONCODE $SMKCHRCACHE
          $SMDOUBLEBYTE $SMCHARPORTION $SMOVERRIDE $SMGENFLAGS $SMKEYSWAP
          $SMKEYCACHE $SMSYSREF $SMKEYSCRIPT $SMLASTSCRIPT $SMSYSSCRIPT
          $SMPRINT $SMDEFAULT $SMFORCED $SMINTLFORCE $SMFONTFORCE $SMBIDIRECT
          $SMENABLED $SMMUNGED $SMVERSION $SMREDRAWLINE $SMREDRAWWORD
          $SMREDRAWCHAR $SMBADSCRIPT $SMBADVERB $SMNOTINSTALLED
          $SMMASKBOPOMOFO2 $SMMASKJAMO2 $SMMASKHANGUL2 $SMMASKGANA2
          $SMMASKKANA2 $SMMASKKANA1 $SMMASKASCII2 $SMMASKASCII1 $SMMASKNATIVE
          $SMMASKASCII $SMMASKALL $SMTRANSPRELOWERCASING
          $SMTRANSPREDOUBLEBYTING $SMTRANSHANGULFORMAT $SMTRANSRULEBASEFORMAT
          $SMTRANSUPPER $SMTRANSLOWER $SMTRANSBOPOMOFO2 $SMTRANSJAMO2
          $SMTRANSHANGUL2 $SMTRANSGANA2 $SMTRANSKANA2 $SMTRANSKANA1
          $SMTRANSASCII2 $SMTRANSASCII1 $SMTRANSSYSTEM $SMTRANSCASE
          $SMTRANSNATIVE $SMTRANSASCII $SMCHAR2BYTE $SMCHAR1BYTE $SMCHARUPPER
          $SMCHARLOWER $SMCHARRIGHT $SMCHARLEFT $SMCHARVERTICAL
          $SMCHARHORIZONTAL $SMJAMOBOGMOEUM $SMJAMOMOEUM $SMJAMOBOGJAEUM
          $SMJAMOJAEUM $SMFISCLASSUSER $SMFISCLASSLVL2 $SMFISCLASSLVL1
          $SMIDEOGRAPHICUSER $SMIDEOGRAPHICLEVEL2 $SMIDEOGRAPHICLEVEL1
          $SMKANASOFTOK $SMKANAHARDOK $SMKANASMALL $SMPUNCTGRAPHIC
          $SMPUNCTREPEAT $SMPUNCTBLANK $SMPUNCTSYMBOL $SMPUNCTNUMBER
          $SMPUNCTNORMAL $SMCHARFISRUSSIAN $SMCHARFISGREEK $SMCHARFISIDEO
          $SMCHARFISGANA $SMCHARFISKANA $SMCHARBOPOMOFO $SMCHARJAMO
          $SMCHARHANGUL $SMCHARNONCONTEXTUALLR $SMCHARCONTEXTUALLR
          $SMCHARBIDIRECT $SMCHARTWOBYTERUSSIAN $SMCHARTWOBYTEGREEK
          $SMCHARIDEOGRAPHIC $SMCHARHIRAGANA $SMCHARKATAKANA $SMCHAREXTASCII
          $SMCHAREURO $SMCHARASCII $SMCHARPUNCT $SMCDOUBLEMASK $SMCUPPERMASK
          $SMCRIGHTMASK $SMCORIENTATIONMASK $SMCCLASSMASK $SMCRESERVED
          $SMCTYPEMASK $SMMIDDLEBYTE $SMLASTBYTE $SMFIRSTBYTE $SMSINGLEBYTE
          $INTOUTPUTMASK $INTEUROPEAN $INTJAPANESE $INTROMAN $INTARABIC
          $INTWESTERN $CALPERSIAN $CALCOPTIC $CALJEWISH $CALJAPANESE
          $CALARABICLUNAR $CALARABICCIVIL $CALGREGORIAN $VERINDIA
          $VERYUGOSLAVIA $VERARABIA $VERBELGIUMLUX $MAXCOUNTRY $MINCOUNTRY
          $VERTHAILAND $VERTAIWAN $VERCHINA $VERKOREA $VERIRELAND $VERRUSSIA
          $VERIRAN $VERFAEROEISL $VERLAPLAND $VERLATVIA $VERESTONIA $VERHUNGARY
          $VERPOLAND $VERLITHUANIA $VERPAKISTAN $VERINDIAHINDI $VERYUGOCROATIAN
          $VERTURKEY $VERCYPRUS $VERMALTA $VERICELAND $VERGREECE $VERGRSWISS
          $VERFRSWISS $VERFINLAND $VERARABIC $VERAUSTRALIA $VERJAPAN $VERISRAEL
          $VERNORWAY $VERFRCANADA $VERPORTUGAL $VERDENMARK $VERSPAIN $VERSWEDEN
          $VERFRBELGIUMLUX $VERNETHERLANDS $VERITALY $VERGERMANY $VERBRITAIN
          $VERFRANCE $VERUS $LANGCHINESE $LANGYUGOSLAVIAN $LANGMALTA
          $LANGPORTUGESE $LANGSUNDANESEROM $LANGJAVANESEROM $LANGDZONGKHA
          $LANGUIGHUR $LANGTATAR $LANGAYMARA $LANGGUARANI $LANGQUECHUA
          $LANGLATIN $LANGCATALAN $LANGBASQUE $LANGWELSH $LANGESPERANTO
          $LANGMALAGASY $LANGCHEWA $LANGRUNDI $LANGRUANDA $LANGSWAHILI
          $LANGSOMALI $LANGOROMO $LANGGALLA $LANGTIGRINYA $LANGAMHARIC
          $LANGMALAYARABIC $LANGMALAYROMAN $LANGTAGALOG $LANGINDONESIAN
          $LANGVIETNAMESE $LANGLAO $LANGKHMER $LANGBURMESE $LANGSINHALESE
          $LANGTELUGU $LANGTAMIL $LANGKANNADA $LANGMALAYALAM $LANGORIYA
          $LANGPUNJABI $LANGGUJARATI $LANGASSAMESE $LANGBENGALI $LANGMARATHI
          $LANGSANSKRIT $LANGNEPALI $LANGTIBETAN $LANGSINDHI $LANGKASHMIRI
          $LANGKURDISH $LANGPASHTO $LANGMONGOLIANCYR $LANGMONGOLIAN
          $LANGTURKMEN $LANGTAJIKI $LANGKIRGHIZ $LANGMOLDAVIAN $LANGGEORGIAN
          $LANGARMENIAN $LANGAZERBAIJANAR $LANGAZERBAIJANI $LANGKAZAKH
          $LANGUZBEK $LANGBYELORUSSIAN $LANGUKRAINIAN $LANGBULGARIAN
          $LANGMACEDONIAN $LANGSERBIAN $LANGYIDDISH $LANGSLOVENIAN $LANGSLOVAK
          $LANGCZECH $LANGROMANIAN $LANGALBANIAN $LANGIRISH $LANGFLEMISH
          $LANGSIMPCHINESE $LANGRUSSIAN $LANGPERSIAN $LANGFARSI $LANGFAEROESE
          $LANGLAPPISH $LANGLAPPONIAN $LANGLATVIAN $LANGLETTISH $LANGESTONIAN
          $LANGHUNGARIAN $LANGPOLISH $LANGLITHUANIAN $LANGKOREAN $LANGTHAI
          $LANGHINDI $LANGURDU $LANGTRADCHINESE $LANGCROATIAN $LANGTURKISH
          $LANGMALTESE $LANGICELANDIC $LANGGREEK $LANGFINNISH $LANGARABIC
          $LANGJAPANESE $LANGHEBREW $LANGNORWEGIAN $LANGPORTUGUESE $LANGDANISH
          $LANGSPANISH $LANGSWEDISH $LANGDUTCH $LANGITALIAN $LANGGERMAN
          $LANGFRENCH $LANGENGLISH $SMSINDHI $SMSLAVIC $SMAMHARIC $SMRUSSIAN
          $SMCHINESE $SMKLINGON $SMUNINTERP $SMEXTARABIC $SMVIETNAMESE
          $SMEASTEURROMAN $SMETHIOPIC $SMGEEZ $SMMONGOLIAN $SMTIBETAN
          $SMSIMPCHINESE $SMARMENIAN $SMGEORGIAN $SMLAOTIAN $SMTHAI $SMKHMER
          $SMBURMESE $SMSINHALESE $SMMALAYALAM $SMKANNADA $SMTELUGU $SMTAMIL
          $SMBENGALI $SMORIYA $SMGUJARATI $SMGURMUKHI $SMDEVANAGARI $SMRSYMBOL
          $SMCYRILLIC $SMGREEK $SMHEBREW $SMARABIC $SMKOREAN $SMTRADCHINESE
          $SMJAPANESE $SMROMAN $SMALLSCRIPTS $SMCURRENTSCRIPT $SMSYSTEMSCRIPT))
(provide-interface 'new script)