;; file PlaySound.lisp
;; asynchronous call to the old sound-driver's square wave synthesizer.
;; this will work on any and every macintosh in existance today.
;;
;; Copyright (c) 1993 by John Montbriand. All Rights Reserved.
;; you may re-distribute this file as you see fit so long
;; as this notice remains intact.
 
 
;; playit uses the square wave synthesizer to play a list of sounds.
;; note: this is equivalent to a call to StartSound in the
;; older 64k ROM interface which appears to have been dropped
;; from the current interfaces.
;;   - triplets is a list of (frequency amplitude duration)'s
;;   - frequency is an integer between 0 and 65535. the actual frequency
;;     is given by the following relationship:
;;        Hz = 783360 / frequency
;;   - amplitude is an integer between 0 and 255 (0's the lowest, 255's
;;     the highest).
;;   - duration is the number of system ticks (60'ths of seconds) that
;;     the sound should be played for.
;; the above info can be found in older the sound manager chapters
;; in older versions of IM.
(defun playit (triplets)
  (let ((buf (#_NewPtr (+ 8 (* 6 (length triplets)))))
        (offset 2))
    (unless (%null-ptr-p buf)
        (%put-word buf -1 0)                ; swMode
        (dolist (trip triplets)
          (%put-word buf (car trip) offset)         ; frequency
          (%put-word buf (cadr trip) (+ 2 offset))  ; amplitude
          (%put-word buf (caddr trip) (+ 4 offset)) ; duration
          (setq offset (+ 6 offset)))
        (%put-word buf 0 offset)            ; a zero element
        (%put-word buf 0 (+ 2 offset))
        (%put-word buf 0 (+ 4 offset))
        (setq offset (+ 6 offset))
        (rlet ((pb :ParamBlockRec
                   :ioCompletion (%null-ptr)
                   :ioVRefNum   0
                   :ioRefNum    -4          ; the sound driver
                   :ioBuffer    buf
                   :ioReqCount  offset
                   :ioPosOffset 0))
          (#_PBWrite :async pb)
          (do () ((<= (rref pb ParamBlockRec.ioResult) 0)) 
            (event-dispatch)))
        (#_DisposePtr buf))))
 
#|
;; example usage (twilight zone theme):
 
(playit `((396 127 5) (0 0 2)
          (371 156 10) (0 0 2)
          (396 180 10) (0 0 2)
          (494 175 10) (0 0 2)
          
          (396 127 10) (0 0 2)
          (371 156 10) (0 0 2)
          (396 180 10) (0 0 2)
          (494 175 10)
          
          (396 127 10) (0 0 2)
          (371 156 10) (0 0 2)
          (396 180 10) (0 0 2)
          (494 170 10)))
 
 
;; morse code generating 6 dits per second
(setq dah '((0 127 2) (492 127 6) (0 127 2)))
(setq dit '((0 127 5) (492 127 1) (0 127 4)))
(setq space '((0 127 10)))
(setq end_mssg (append dit dah dit dah dit))
 
(setq john (append dit dah dah dah space dah dah dah space dit dit dit
                   dit space dah dit))
(setq montbriand (append dah dah space dah dah dah space dah dit space dah
                         space dah dit dit dit space dit dah dit space dit
                         dit space dit dah space dah dit space dah dit dit space))
 
;; the author's name in morse code:
(playit (append space john space montbriand space end_mssg))
 
|#
 
;; end of file PlaySound.lisp

