;;; -*- Mode:Common-Lisp; Package:Yes-Way; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************


;;; This file contains site-specific initializations.  You should set the
;;; following vars before you build YW at any new site.

(defvar *site-specific-bboard-source-host* "HPP.Stanford.Edu"
"The host on which bboards are read."
)

(defvar *imap-server-hosts-default-host-first* '("HPP" "Knife")
"A list of the names of the hosts that are IMAP servers.  The default
host should be first in this list.
"
)

(defvar *site-specific-default-bboard* "SU-ETC"
"The default bboard for this site.  Note:  this bboard should be resident on
*site-specific-bboard-source-host*.
"
)

(defvar *site-specific-default-mailbox-file-type* "TXT"
"The default type for all mailboxes on this site."
)

(defvar *site-specific-bboard-source-directory* '("VAR" "SPOOL" "BBOARD")
"The directory spec for the bboard directory on
*site-specific-bboard-source-host*.  Should be a list in interchange case.
"
)

(defvar *site-specific-nntp-server-host* "Morrow.Stanford.Edu"
"The host on which to read your Net News."
)

(defvar yw-zwei:*hosts-to-canonicalize-into*
	'((("nil"
	    "sumex" "sumex-aim"
            "sumex.stanford.edu"
            "ksl" "ksl.stanford.edu"
	    "hpp" "hpp.stanford.edu"
	    "knife" "knife.stanford.edu"
	    "camis" "camis.stanford.edu"
	    "hpp-ipc-2"
	   )
	   "Sumex-Aim.Stanford.Edu"
	  )
	 )
)