;;; -*- Mode:Common-Lisp; Package:IMAP; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************


(yw:defreset-var *all-mailbox-name-translations*
  `(("INBOX" ,(fs:make-pathname :Name "MAIL"
				:Type "TXT"
				:Defaults (fs:user-homedir)
	      )
    )
   )
"An alist that maps mailbox logical names to pathnames."
)


(defvar *all-server-special-variables* nil
"The list of all special variables bound by the server."
)

(defconstant *IMAP.Port* 143 "TCP port the IMAP server listens on.")

(defvar *Imap-Server-Supported-Versions*
	(list (make-protocol-version :Major 2 :Minor 0)
	      (make-protocol-version
		:Major 3
		:Minor 0
		:Supported-Features '(
				      :Add.Message
				      :Auto.Set.Seen
;				      :Eight.Bit.Transparent ;;; {!!!!}
				      :Encoding
				      :Indexable.Fields
				      :New.Mail.Notify
				      :Renumber
				      :Send
				      :Set.Eol
				      :Tagged.Solicited
				      :Wildcard.Searches ;;; {!!!!} Experimental
				     )
		:Default-Features   '(:Tagged.Solicited)
              )
	)
"An Alist that maps version numbers to the set of features supported."
)

(Defun find-version (major minor)
"returns a version object for the given major and minor version numbers."
  (find-if #'(lambda (x)
	       (and  (equal (protocol-version-major x) major)
		     (equal (protocol-version-minor x) minor)
	       )
	     )
	   *imap-server-supported-versions*
  )
)

(defvar *imap2-version* (find-version 2 0)
"The version for IMAP2."
)

(defvar *imap3-version* (find-version 3 0)
"The version for IMAP3."
)

(defvar *server-default-version* (find-version 2 0)
"The default version for IMAP service."
)

(yw:defreset-var *bboard-source-path*
  (make-pathname :Host "LM"
		 :Directory '("MAILER" "BBOARD")
		 :Name :Wild
		 :Type :Wild
		 :Version :Newest
   )
"The directory in which we keep our bboards."
)

(defvar *imap-server-new-mail-check-interval* 30
 "The delay before the server checls for new mail in seconds."
)


;-------------------------------------------------------------------------------

;;; NNTP stuff. (this doesn't really have anything to do with the server.

(defconstant yw:*NNTP-Port* 119 "TCP port the NNTP server listens on.")

;;; Define logical contact for NNTP.
(net:define-logical-contact-name "Generic-NNTP" `((:Tcp ,yw:*NNTP-Port*)))

