;;; -*- Mode:Common-Lisp; Package:IMAP; Base:10 -*-

;;; **********************************************************************
;;; Copyright (c) 1990 Stanford University.
;;; This code was written by James Rice.
;;; Copyright is held by Stanford University except where code has been
;;; modified from TI source code.  In these cases TI code is marked with
;;; a suitable comment.

;;; All Stanford Copyright code is in the public domain.  This code may be
;;; distributed and used without restriction as long as this copyright
;;; notice is included and no fee is charged.  This can be thought of as
;;; being equivalent to the Free Software Foundation's Copyleft policy.

;;; TI source code may only be distributed to users who hold valid TI
;;; software licenses.

;;; The development of this software was assisted by the following grants:
;;; Biomedical Research Technology Program of the National Institutes
;;; of Health under grant RR-00785
;;; Information Systems Technologies office of the Defense Advanced
;;; Research Projects Agency under contract N00039-86-C0033.

;;; **********************************************************************

(defstruct-safe (mail-file :Named)
"The defstruct that represents mailboxes for the server."
  (messages (make-array 1000 :Adjustable t :Fill-Pointer t)) ;;; The messages.
  (name nil) ;;; The name of the mailbox
  (file-length 0) ;;; The length in ytes of the mailbox.
  (last-written-date nil) ;;; The last write date of the mailbox.
  (lock (yw:make-an-imap-lock)) ;;; A lock used for write locking.
  (format nil) ;;; The format of the mailbox, e.g. :YW.
  (keywords nil) ;;; The keywords for the mailbox, e.g. (:Foo :bar)
  (read-only-p nil) ;;; True if the mailbox has been made readonly.
  modified-p        ;;; Is true if the mailbox has been modified.
)

(defstruct-safe (message :Named)
"The representation of a message for the server."
  envelope ;;; The envelope of the message
  header ;;; A substring for the message rfc822.header
  body ;;; A substring for the message rfc822.text
  length ;;; rfc822.length of the message
  flags ;;; The flag list in the form '((:\seen t) (:\deleted nil) ..(keyw1..))
  internal-date ;;; The internal date
  whole-message ;;; A string for the whole of the message.  Maybe a substring of
                ;;; the mail file.
  parsed-header ;;; The header object for this header.
  (parsed-body :Unbound) ;;; The body when it has been parsed wrt an Encoding.
  rfc822-string ;;; The RFC822 equivalent text for this message.
)

(defun (:Property Message named-structure-invoke)
       (message-name thing &Rest arguments)
"A print method for messages."
  (ignore thing)
  (ecase message-name
    (:Print-Self (format (first arguments) "#<Message ???>"))
    (:Which-Operations '(:Which-Operations :Print-Self))
  )
)


(defstruct-safe (protocol-version :Named)
  "The representation of a version of the protocol."
  major ;;; The major version number
  minor ;;; The minor version-number
  supported-features ;;; The list of fearures supported in this protocol version
  default-features ;;; The default features enabled in this version.
)