1;;; -*- Mode: Common-Lisp; Package: SPELLER; Fonts: cptfont,cptfontb; Base: 10 -*-*
				    
1;;;
;;; Copyright (c) 1987 Douglas Johnson.  All rights reserved. 
;;; Copyright (c) 1985 Douglas Johnson.  All rights reserved. 
;;;*




(DEFVAR *MAIN-DICTIONARY* :UNBOUND
1   "Main dictionary"*
   ) 


(DEFVAR *CURRENT-DOCUMENT* :UNBOUND
1   "Currently active document."*
   ) 


(DEFVAR *TEMPORARY-HASH* :UNBOUND
1   "Temporary hash table to use while loading or dumping."*
   ) 


(DEFVAR *DICTIONARY-LOCK* ()
1   "Dictionary2 loading lock*"*
   ) 


;(DEFUN EDITOR-INIT-SPELLER ()
;1  "ZWEI interface to initialize spelling checking."*
;  (UNLESS (BOUNDP '*MAIN-DICTIONARY*);1if main dictionary not loaded*
;    (LET ((DICTIONARY (MAKE-INSTANCE 'DICTIONARY :NAME "Main")))
;      (ZWEI::TYPEIN-LINE "Loading Main Dictionary...")
;      (WITH-LOCK (*DICTIONARY-LOCK*);1get the dictionary lock*
;	 (UNLESS (BOUNDP '*MAIN-DICTIONARY*);1check again to make sure*
;	   (SEND DICTIONARY :LOAD SPELL-HASH-FILE-NAME)
;	   (SETQ *MAIN-DICTIONARY* DICTIONARY)))))
;  (UNLESS (BOUNDP '*CURRENT-DOCUMENT*)
;    (SETQ *CURRENT-DOCUMENT* (MAKE-INSTANCE 'DOCUMENT-DICTIONARY :NAME "Default"))
;    (SEND *CURRENT-DOCUMENT* :ADD-DICTIONARY *MAIN-DICTIONARY*)
;    (SEND *CURRENT-DOCUMENT* :ADD-DICTIONARY (MAKE-INSTANCE 'DICTIONARY :NAME "Local"))))

(DEFUN EDITOR-INIT-SPELLER ()
1  "ZWEI interface to initialize spelling checking."*
;;; Modded by JPR to define the global document.
  (UNLESS (and (BOUNDP '*MAIN-DICTIONARY*) *MAIN-DICTIONARY*);1if main dictionary not loaded*
    (LET ((DICTIONARY (MAKE-INSTANCE 'DICTIONARY :NAME "Main")))
      (ZWEI::TYPEIN-LINE "Loading Main Dictionary...")
      (WITH-LOCK (*DICTIONARY-LOCK*);1get the dictionary lock*
	 (UNLESS (BOUNDP '*MAIN-DICTIONARY*);1check again to make sure*
	   (SEND DICTIONARY :LOAD SPELL-HASH-FILE-NAME)
	   (SETQ *MAIN-DICTIONARY* DICTIONARY)))))
  (UNLESS (and (BOUNDP '*CURRENT-DOCUMENT*) *CURRENT-DOCUMENT*)
    (SETQ *CURRENT-DOCUMENT* (MAKE-INSTANCE 'DOCUMENT-DICTIONARY :NAME "Default"))
    (SEND *CURRENT-DOCUMENT* :ADD-DICTIONARY *MAIN-DICTIONARY*)
    (SEND *CURRENT-DOCUMENT* :ADD-DICTIONARY (MAKE-INSTANCE 'DICTIONARY :NAME "Local")))
  (unless (and (boundp 'zwei:*global-document*) zwei:*global-document*)
    (setq zwei:*global-document* *CURRENT-DOCUMENT*)))


(DEFUN INIT-SPELLER ()
1  "Initialize spelling checking."*
  (UNLESS (BOUNDP '*MAIN-DICTIONARY*);1if main dictionary not loaded*
    (LET ((DICTIONARY (MAKE-INSTANCE 'DICTIONARY :NAME "Main")))
      (WITH-LOCK (*DICTIONARY-LOCK*);1get the dictionary lock*
	 (UNLESS (BOUNDP '*MAIN-DICTIONARY*);1check again to make sure*
	   (IGNORE-ERRORS (SEND DICTIONARY :LOAD SPELL-HASH-FILE-NAME)
	      (SETQ *MAIN-DICTIONARY* DICTIONARY))))))) 


(DEFUN WORD-CHECKABLE-P (WORD)
  "True if a word is reasonable to check."
  (1and* (<= (LENGTH WORD) '#,(ARRAY-TOTAL-SIZE *STRING*))
       (1loop* for char being the array-elements of word
	      never (sys:whitespacep char))))

;;;  Modified this to realize that FOO'S is one word, but ``FOO'' is the word FOO instead of the word FOO''
;;;  This makes it lose on FOOS' but I can live with that.
;;;   Jamie Zawinski.

(DEFUN EDITOR-CHECK-WORD-P (WORD)
  "ZWEI interface to check if WORD is correctly spelled.  WORD assumed to contain only a-z and ' ."
  (setq word (string-trim "'" word))
  (LET ((LEN (LENGTH WORD)))
    (IF (EQL 1 LEN);accept all single letters
      T
      (WHEN (<= LEN '#,(ARRAY-TOTAL-SIZE *STRING*));reject very long words
	(SETF (FILL-POINTER *STRING*) LEN)
	(DOTIMES (I LEN)
	   (SETF (AREF *STRING* I) (CHAR-DOWNCASE (AREF WORD I))));remove case and fonts from word
	(CHECK-WORD-P *STRING*)))))


(DEFSUBST CHECK-ROOT-WORD-P (WORD SUFFIX)
1  "Checks to see if WORD is a correctly spelled word.  If SUFFIX
  is not nil, it checks to see if suffix is valid for this word."*
  (SEND *CURRENT-DOCUMENT* :GET-ROOT-WORD WORD SUFFIX)) 


(DEFUN CHECK-WORD-P (WORD)
1  "Checks to see if word is correctly spelled."*
  (COND
    ((CHECK-ROOT-WORD-P WORD ()))
    ((CHECK-SUFFIXES-P WORD)))) 








  

1;;;************************************************************************************************
;;;                                                                                               *
;;;                                                                                               *
;;;                    The following routines build and manipulate dictionaries.                  *
;;;                                                                                               *
;;;                                                                                               *
;;;************************************************************************************************                                                                        *






(DEFSUBST ADD-WORD (WORD &OPTIONAL SUFFIXES)
1  "Adds WORD and SUFFIXES to the speller's internal hash table."*
  (SEND *MAIN-DICTIONARY* :ADD-WORD WORD SUFFIXES)) 



(DEFSUBST ADD-LOCAL-WORD (WORD &OPTIONAL SUFFIXES)
1  "Adds WORD and SUFFIXES to the speller's local hash table."*
  (SEND *CURRENT-DOCUMENT* :ADD-WORD "Local" WORD SUFFIXES)) 



(DEFFLAVOR DICTIONARY
	   ((SPELL-HASH (MAKE-HASH-TABLE :test #'equal))
	    (PATH SPELL-HASH-FILE-NAME)
	    (NAME "Main"))
	   ()
	    ;;; 1This is the flavor for basic dictionaries.*
  :INITTABLE-INSTANCE-VARIABLES
  :GETTABLE-INSTANCE-VARIABLES) 


(DEFMETHOD (DICTIONARY :LOOKUP) (WORD SUFFIX)
1  "Looks up WORD in the dictionary.  If SUFFIX is* 
1   not nil, it will check to see if the word has SUFFIX as a valid
   suffix.  Returns nil if WORD not found or SUFFIX not valid."*
  (LET ((S (GETHASH WORD SPELL-HASH)))
    (IF S
      (IF SUFFIX
	(NUMBERP
	 (SEARCH (THE STRING (STRING SUFFIX)) (THE STRING (STRING S)) :TEST #'CHAR-EQUAL))
	T)))) 


;(DEFMETHOD (DICTIONARY :LOAD) (&OPTIONAL (PATHNAME PATH))
;1  "Loads a dictionary from PATHNAME if specified."*
;  (SETQ PATH PATHNAME)
;  (LOAD PATHNAME () () () T)
;  (SETQ SPELL-HASH *TEMPORARY-HASH*)) 

(DEFMETHOD (DICTIONARY :LOAD) (&OPTIONAL (PATHNAME PATH))
  "Loads a dictionary from PATHNAME if specified."
  ;;; Modified by JPR so that dictionary names are also loaded along with
  ;;; the spell hashes.
  (SETQ PATH PATHNAME)
  (LOAD PATHNAME () () () T)
  (SETQ SPELL-HASH (if (consp *TEMPORARY-HASH*)
		       (first *TEMPORARY-HASH*)
		       *TEMPORARY-HASH*
		   )
  )
  (setq name (if (consp *TEMPORARY-HASH*)
		 (second *TEMPORARY-HASH*)
		 name
	     )
  )
)


;(DEFMETHOD (DICTIONARY :DUMP) (&OPTIONAL (PATHNAME PATH))
;1  "Dumps the dictionary to the specified pathname."*
;  (LET ((*TEMPORARY-HASH* SPELL-HASH))
;    (COMPILER:FASD-SYMBOL-VALUE PATHNAME '*TEMPORARY-HASH*))) 


(DEFMETHOD (DICTIONARY :DUMP) (&OPTIONAL (PATHNAME PATH))
  "Dumps the dictionary to the specified pathname."
  ;;; Modified by JPR so that dictionary names are also saved along with
  ;;; the spell hashes.
  (LET ((*TEMPORARY-HASH* (list SPELL-HASH name)))
    (COMPILER:FASD-SYMBOL-VALUE PATHNAME '*TEMPORARY-HASH*)))


(defmethod (DICTIONARY :print-self) (stream depth slashify)
"A print method for documents."
;;; By JPR.
  (ignore depth slashify)
  (format stream "#<Dictionary ~A>" name)
)


(defmethod (dictionary :read-only-p) ()
"True if this Self is a read-only dictionary."
;;; By JPR.
  (member name speller:*read-only-dictionary-names* :test #'string-equal)
)


(defmethod (dictionary :modified-p) ()
"True if Self has been modified."
;;; By JPR.
  (member self *modified-dictionaries*)
)


(defmethod (dictionary :unmod-yourself) (&optional (notify-p nil))
"Unmodifies a dictionary."
;;; By JPR.
  (setq *modified-dictionaries*
	(remove self *modified-dictionaries*)
  )
  (if notify-p
      (zwei:typein-line "Dictionary \"~A\" marked as unmodified." name)
      nil
  )
)


(defmethod (dictionary :save-yourself) ()
"Saves a dictionary."
;;; By JPR.
  (if (send self :read-only-p)
      (zwei:barf
	"Dictionary \"~A\" is a read-only dictionary.  You cannot save it."
	name
      )
      nil
  )
  (if (string-equal speller::spell-hash-file-name path)
      (setq path
	    (send (zwei:read-pathname "To file:" (zwei:default-dict-path))
		  :string-for-printing
	    )
      )
      nil
  )
  (send self :unmod-yourself)
  (send self :dump)
  (zwei:typein-line "Dictionary \"~A\" Saved." name)
)


(defmethod (dictionary :maybe-save-yourself) ()
"Saves Self if it needs to be saved."
;;; By JPR.
  (if (and (send self :modified-p)
	   (with-timeout (3600 (format *query-io* " - timeout proceeding") t)
	     (y-or-n-p "Save ~A? [Timeout 1 Min -> yes]" name)
	   )
      )
      (send self :save-yourself)
      nil
  )
)


(defmethod (dictionary :name-for-display) (max-size)
"A name for Self truncated suitably."
;;; By JPR.
  (if (<= (length name) max-size)
      name
      (values (string-append (subseq name 0 (- max-size 2)) " ") t)
  )
)


(DEFMETHOD (DICTIONARY :ADD-WORD) (WORD &OPTIONAL (SUFFIX NIL))
  "Adds WORD to the dictionary with valid SUFFIXes.  Returns WORD."
  ;;; Modded by JPR to record modified dictionaries.
  ;;; Modded by JWZ to not put NIL into the dictionary as suffix data - use emptystring instead.
  (SETF (GETHASH (STRING-DOWNCASE WORD) SPELL-HASH) (if suffix (STRING-DOWNCASE SUFFIX) ""))
  (pushnew self *modified-dictionaries*)
  WORD)

(DEFMETHOD (DICTIONARY :DELETE-WORD) (WORD)
1  "Deletes WORD from the dictionary*.  1Returns nil if word was 
   not* 1present*."
  (REMHASH (STRING-DOWNCASE WORD) SPELL-HASH)) 


(DEFFLAVOR DOCUMENT-DICTIONARY
	   ((DICTIONARY-LIST NIL);1list of active dictionaries*
	    (NAME "");1document name*
	    (PATHNAME ""));1document pathname*
	   ()
  :GETTABLE-INSTANCE-VARIABLES
  :INITABLE-INSTANCE-VARIABLES
  ;;; Added by JPR; 21 Jan 88.
  :Settable-instance-variables) 


;(DEFMETHOD (DOCUMENT-DICTIONARY :ADD-DICTIONARY) (DICTIONARY)
;1  "Adds a dictionary to the document's dictionary."*
;  (PUSH DICTIONARY DICTIONARY-LIST)) 


(DEFMETHOD (DOCUMENT-DICTIONARY :ADD-DICTIONARY) (DICTIONARY)
  "Adds a dictionary to the document's dictionary."
;;; Modded by JPR to prevent multiple additions of the same dictionary.
  (PUSHnew DICTIONARY DICTIONARY-LIST))


(DEFMETHOD (DOCUMENT-DICTIONARY :remove-DICTIONARY) (DICTIONARY)
  "Removes a dictionary from the document's dictionary."
;;; By JPR.
  (setq DICTIONARY-LIST (remove DICTIONARY DICTIONARY-LIST)))

(DEFMETHOD (DOCUMENT-DICTIONARY :GET-ROOT-WORD) (WORD SUFFIX)
1  "Checks to see if WORD is a correctly spelled word.  If SUFFIX
  is not nil, it checks to see if suffix is valid for this word."*
  (DOLIST (DICTIONARY DICTIONARY-LIST)
    (WHEN (SEND DICTIONARY :LOOKUP WORD SUFFIX)
      (RETURN T)))) 


;(DEFMETHOD (DOCUMENT-DICTIONARY :ADD-WORD) (DICTIONARY-NAME WORD SUFFIX)
;1  "Adds WORD with SUFFIXes to DICTIONARY-NAME."*
;  (DOLIST (DICTIONARY DICTIONARY-LIST)
;    (WHEN (STRING-EQUAL DICTIONARY-NAME (SEND DICTIONARY :NAME))
;      (SEND DICTIONARY :ADD-WORD WORD SUFFIX)
;      (RETURN (VALUES))))) 
 	     

;;; Added by JPR 21 Jan 88
(defconstant no-dictionary-choices
   '(((:Skip "Skip.") #\S #\space)
     ((:Add "Add.") #\A)
     ((:Add-global "Add Global.") #\G)
    )
    "Choices-list for fquery within query-no-dictionary."
)

;;; Added by JPR 21 Jan 88
(defconstant no-dictionary-query-string
 "
  Type: S - to Skip this word, A - to Add a dictionary to this buffer,
        G - to add a Global dictionary to this buffer:"
)

(defun menu-no-dictionary ()
;;; Added by JPR 21 Jan 88
  (or (1prog1* (w:menu-choose '(("Skip" :value :Skip)
			       ("Add Dictionary" :value :Add)
			       ("Add Global Dictionary" :value :add-global)
			      )
			     :Columns 1
			     :Label "No local dictionary for this buffer do what? "
	      )
	      (1send* zwei:*window* :Mouse-Select) ;; JPR.  Menu tends to deselect us.
      )
      :Skip
  )
)

(defun query-no-dictionary ()
;;; Added by JPR 21 Jan 88
  (fquery `(:choices ,no-dictionary-choices
		     :help-function
		     (,(if (fboundp 'common-lisp-on-p)
			   (if (common-lisp-on-p)
			       'lambda
			       'global:lambda)  
			   'lambda) 
		      (stream &rest ignore)
		      (princ no-dictionary-query-string
			     stream))
		     :clear-input t
		     :fresh-line nil
		     :select T)
	  "
No local dictionary for this buffer do what? "
  )
)


(DEFMETHOD (DOCUMENT-DICTIONARY :ADD-WORD) (DICTIONARY-NAME WORD SUFFIX)
  "Adds WORD with SUFFIXes to DICTIONARY-NAME."
  ;;; Modded by JPR to support multiple local dictionaries.
  (let ((real-dict (or (and zwei:*selected-local-dictionary*
			    (send zwei:*selected-local-dictionary* :name))
		       (zwei:get-local-dict-name dictionary-name))))
    (loop for dictionary in dictionary-list
	  when (STRING-EQUAL
		 (or (and zwei:*selected-local-dictionary*
			  (send zwei:*selected-local-dictionary* :name))
		     real-dict)
		 (SEND DICTIONARY :NAME))
	  do (progn (SEND DICTIONARY :ADD-WORD WORD SUFFIX)
		    (zwei:typein-line "\"~A\" added to dictionary \"~A\""
			  (string-capitalize word) (send DICTIONARY :name))
		    (RETURN (VALUES)))
	  finally (case (if *prompt-in-minibuffer* (query-no-dictionary) (menu-no-dictionary))
		    (:Skip (zwei:typein-line "Ignoring \"~A\"." word))
		    (:Add (zwei:com-add-dictionary-to-buffer)
			  (send self :add-word dictionary-name word suffix)
		    )
		    (:Add-global (zwei:com-add-global-dictionary)
				 (send self :add-word dictionary-name word suffix)
    		    )
		    (Otherwise (beep))
		  )
    )
  )
)

(defmethod (DOCUMENT-DICTIONARY :print-self) (stream depth slashify)
"A print method for documents."
;;; By JPR
  (ignore depth slashify)
  (format stream "#<Document ~A ~A>" (send self :name)
	  (mapcar #'first
		  (zwei:dictionary-name-alist
		    speller:*read-only-dictionary-names* self
		  )
	  )
  )
)

;(DEFUN BUILDER (INPUT-FILE OUTPUT-FILE)
;1  "This function builds a dictionary from a text input file.*
;1   The input file 2has lines of* the form WORDMODIFIERMODIFIER...*
;1   Where MODIFIER is one of the letters V N X H Y G J D T R X S P M* 1Z*
;1   The letters designate legal suffixes as defined above."*
;  (WITH-OPEN-FILE (INPUT INPUT-FILE :DIRECTION :INPUT :CHARACTERS :DEFAULT)
;    (LET ((INSTRING (MAKE-ARRAY 80 :TYPE :ART-STRING))
;	  (SUFFIX-LIST '(""))
;	  (DICT (MAKE-INSTANCE 'DICTIONARY :PATH OUTPUT-FILE)))
;      (DO ((EOF NIL));loop until end-of-file
;	   ;;                on EOF, write out hash table
;	  (EOF
;	   (SEND DICT :DUMP))
;	(MULTIPLE-VALUE-SETQ (INSTRING EOF);read next line
;	  (SEND INPUT :LINE-IN))
;	(IF INSTRING;if line is not empty
;	  (MULTIPLE-VALUE-BIND (WORD SUFFIXES)
;	    (BUILD-GET-WORD INSTRING);extract word
;	    (LET ((S1 (CAR (MEMBER SUFFIXES SUFFIX-LIST :TEST #'STRING-EQUAL))))
;	      (IF S1
;		(SEND DICT :ADD-WORD WORD S1)
;		(BLOCK ()
;		  (APPEND SUFFIX-LIST (LIST SUFFIXES))
;		  (SEND DICT :ADD-WORD WORD SUFFIXES);add it
;		  ()))))))))) 

(DEFUN BUILDER (INPUT-FILE OUTPUT-FILE &optional (name nil))
  "This function builds a dictionary from a text input file.
   The input file has lines of the form WORDMODIFIERMODIFIER...
   Where MODIFIER is one of the letters V N X H Y G J D T R X S P M Z
   The letters designate legal suffixes as defined above."
  ;;; Modded by JPR so that Input-File can be a stream as well as a path.
  ;;; Name arg added by JPR so that dictionary names can be saved too.
  (flet ((body (input)
	  (LET ((INSTRING (MAKE-ARRAY 80 :TYPE :ART-STRING))
		(SUFFIX-LIST '(""))
		(DICT (MAKE-INSTANCE 'DICTIONARY :PATH OUTPUT-FILE)))
	    (if name
		(send dict :set-name name))
	    (DO ((EOF NIL));loop until end-of-file
		;;                on EOF, write out hash table
		(EOF
		  (SEND DICT :DUMP))
	      (MULTIPLE-VALUE-SETQ (INSTRING EOF);read next line
		(SEND INPUT :LINE-IN))
	      (IF INSTRING;if line is not empty
		  (MULTIPLE-VALUE-BIND (WORD SUFFIXES)
		      (BUILD-GET-WORD INSTRING);extract word
		    (LET ((S1 (CAR (MEMBER SUFFIXES SUFFIX-LIST
					   :TEST #'STRING-EQUAL))))
		      (IF S1
			  (SEND DICT :ADD-WORD WORD S1)
			  (BLOCK ()
			    (APPEND SUFFIX-LIST (LIST SUFFIXES))
			    (SEND DICT :ADD-WORD WORD SUFFIXES);add it
			    ())))))))))
    (if (typep input-file 'stream)
	(body input-file)
	(WITH-OPEN-FILE
	  (INPUT INPUT-FILE :DIRECTION :INPUT :CHARACTERS :DEFAULT)
	  (body input)))))


(DEFUN BUILD-GET-WORD (STRING)
1  "Extracts a word and it's modifiers from the dictionary text file.
  Returns two values.  The first is the word, the second is a string
  containing suffix modifiers."*
  (LET* ((ALPHAS "ABCDEFGHIJKLMNOPQRSTUVWXYZ'") (END (STRING-SEARCH-NOT-SET ALPHAS STRING)))1;find first non-alphabetic*
    (IF (NULL END)1;if no non-alphabetics*
      (VALUES STRING "")1;return whole string*
      (VALUES (SUBSEQ (STRING STRING) 0 END)1;else return word*
	      (STRING-DELETE-NOT STRING "VNXHYGJDTRXSPMZ" END)))))  ;and the modifiers



(PROCESS-RUN-FUNCTION "2initialize-speller"*
		      'INIT-SPELLER) 
