;;; -*- 1Mode: Common-Lisp; Package: SPELLER; Fonts: cptfont,cptfontb; Base: 10 -*-

;;;
;;; Copyright (c) 1987 Douglas Johnson.  All rights reserved. 
;;; Copyright (c) 1985 Douglas Johnson.  All rights reserved. 
;;;

;;;************************************************************************************************
;;;                                                                                               *
;;;                                                                                               *
;;;                This is a collection of utility routines for the speller.                      *
;;;                                                                                               *
;;;                                                                                               *
;;;************************************************************************************************                                                                        *



(DEFUN STRING-DELETE-NOT (STRING CHARS &OPTIONAL (START 0) (LAST (LENGTH STRING)))
  "Returns a string that is STRING with all characters that are not part of 
   CHARS removed.  The removal will start with START and end with LAST.  
   The portion of the string before start is ignored."
  (LET ((END (STRING-SEARCH-NOT-SET CHARS STRING START LAST)))
    (COND
      ((NULL STRING) "");string is empty -- return empty
      ((NULL END) (SUBSEQ (STRING STRING) START LAST));string has no wrong characters left
      (T
       (STRING-APPEND (SUBSEQ (STRING STRING) START END);delete wrong characters and recurse
		      (STRING-DELETE-NOT STRING CHARS (1+ END) LAST)))))) 	


(DEFSUBST GET-CHAR (STRING POS)
  "Extracts a character at position POS (zero origin)
   from a string STRING."
  (CHAR STRING POS)) 


(DEFSUBST PUT-CHAR (STRING POS CHAR)
  "Inserts CHAR at position POS (zero origin) into STRING."
  (SETF (AREF STRING POS) CHAR)) 


(DEFSUBST VOWEL-CHAR-P (CHAR)
  "Returns non-nil if CHAR is a vowel."
  (POSITION CHAR "aeiou" :TEST
	    #'CHAR-EQUAL)) 

(DEFSUBST VOWEL-P (STRING N)
  "Returns non-nil if the Nth character of STRING is a vowel."
  (VOWEL-CHAR-P (GET-CHAR STRING N))) 


(DEFSUBST STRING-END-EQUAL (WORD END)
  "Checks to see if WORD ends in the string END.  
   Returns nil if it doesn't"
  (LET* ((LENGTH-END (LENGTH END))
	 (LENGTH-DIFFERENCE (- (LENGTH WORD) LENGTH-END)))
    (WHEN (>= LENGTH-DIFFERENCE 0)
      (STRING-EQUAL WORD END  :START1 LENGTH-DIFFERENCE)))) 


(DEFSUBST CHECK-DELIMITERS (CHAR)
  "Returns non-nil if CHAR is a delimiter defined in the 
    string DELIMITERS."
  (POSITION CHAR " '():;?." :TEST
	    #'CHAR-EQUAL)) 


(DEFSUBST STRING-COPY (STRING)
  "Returns a copy of STRING."
  (STRING-APPEND STRING)) 

(DEFSUBST NSTRING-MOVE (FROM TO)
  "Moves the string in FROM to TO via a distructive copy.
   TO must have a fill pointer.  Returns TO."
  (LET ((LENGTH (LENGTH FROM)))
    (WHEN (> LENGTH (ARRAY-TOTAL-SIZE TO))
      (FERROR () "Destination string shorter than source string in NSTRING-MOVE"))
    (SETF (FILL-POINTER TO) LENGTH)
    (DOTIMES (I LENGTH)
       (SETF (AREF TO I) (AREF FROM I))))
  TO) 


(DEFSUBST NSUB-STRING (FROM START END TO)
  "Copies the substring in FROM bounded by START and END
   to TO via a distructive copy. TO must have a fill pointer.
   Returns TO."
  (LET ((LENGTH (- END START)))
    (WHEN (> LENGTH (ARRAY-TOTAL-SIZE TO))
      (FERROR () "Destination string shorter than source string in NSUBSTRING"))
    (SETF (FILL-POINTER TO) LENGTH)
    (DO ((I 0 (1+ I))
	 (J START (1+ J)))
	((= J END))
       (SETF (AREF TO I) (AREF FROM J))))
  TO) 


(DEFSUBST NSTRING-APPEND (TO FROM)
  "Adds the string in FROM TO via a distructive copy.
   TO must have a fill pointer. Returns TO."
  (LET ((FROM-LENGTH (LENGTH FROM))
	(TO-LENGTH (LENGTH TO)))
    (WHEN (> (+ TO-LENGTH FROM-LENGTH) (ARRAY-TOTAL-SIZE TO))
      (FERROR () "Destination string shorter than source string in NSTRING-APPEND"))
    (INCF (FILL-POINTER TO) FROM-LENGTH)
    (DO ((I TO-LENGTH (1+ I))
	 (J 0 (1+ J)))
	((= J FROM-LENGTH))
       (SETF (AREF TO I) (AREF FROM J))))
  TO) 
						

(DEFVAR *STRING* (MAKE-ARRAY 40 :ELEMENT-TYPE 'STRING-CHAR :FILL-POINTER 0)
   "A temporary string to hold words while being changed.") 


(DEFVAR *STRING1* (MAKE-ARRAY 40 :ELEMENT-TYPE 'STRING-CHAR :FILL-POINTER 0)
   "A temporary string to hold words while being changed.") 


