;;;-*- Mode:Common-Lisp;Fonts:(CPTFONT hl10 CPTFONTI CPTFONTI cptfontB);Base:10 -*-
;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (b)(3)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1988,  Texas Instruments Incorporated. All rights reserved.

;;;This demonstrates a simple RPC application. A server is established on
;;;the Mac for evaluating simple arithmetic expressions.
;;; On the Explorer, the user is prompted for such an expression and it is 
;;;passed to the mac as a string. The Mac evaluates it and 
;;; displays the answer. The mac side prompts the user for an expression
;;;and it is passed back to the Explorer as the return 
;;; value. That expression is evaluated by the Explorer and the result is displayed.

(DEFFLAVOR explorer-RPC-flashcard		      ;window  for Explorer output
	   ()
	   (w:window w:stream-mixin w:box-label-mixin )
  )
(DEFVAR expr-string "3 * 2")			       ;default arithmetic expression
(DEFVAR  *exp* nil)
(DEFVAR *string-from-mac*			      ;value returned from mac goes here
	(make-array 30 :type :art-string
					     :initial-element (CHARACTER 0)))

(DEFCONSTANT  *e2m-program-number*     #x20000019) 
(DEFCONSTANT  *version-number*              1)
(DEFCONSTANT  *procedure-number*            1)
 
(DEFUN  callmac (expression)
"Pass the string containing the arithmetic expression to the mac
  for evaluation."
  (LET ((rpc:*callrpc-retrys* 1)		       ;one retry is enough here
	(rpc:*callrpc-timeout* 60))		       ;60 second timout
    (format *exp* "~%Sending data to Mac: ~a" expression)
    (CALLRPC 'mac
	     *e2m-program-number*
	     *version-number*   
	     *procedure-number*
	     :xdr-string			       ;type passed to mac
	     expression				       ;value passed to mac
	     :xdr-string			       ;type passed from mac
	     *string-from-mac*			       ;value returned from mac
	     )
    ))

(DEFUN flashcards ()
  "reads an arithmetic expression in one window and passes the result to another"

  (rpc:clear-port-map-cache :micronet)		       ;This prevents a delay the first time callrpc 
						       ; is executed. Due to RPC using an old 
						       ; micronet port number which always 
						       ; a failure and retry on the first RPC call after
						       ; after server registration.
  (UNLESS *exp*
    (SETF *exp* (MAKE-INSTANCE 'explorer-rpc-flashcard ;instantiate the window, if needed
			       :width 230
			       :height 150
			       :label '(:top :centered
					     :string "Explorer RPC Flashcard"
					     :font fonts:hl12b)
			       :font-map '(fonts:hl12 fonts:hl12b)
			       :borders 2)))
  
  (SEND *exp* :expose-near '(:point 0 400))	       ;expose in lower left corner
  (send *exp* :clear-screen)  
  (CONDITION-CASE (abort-signal)
      (DO-FOREVER				       ;keep doing it until user clicks ABORT
	(w:choose-variable-values		       ;prompt user
	  '((expr-string "Arithmetic expression" :string))
	  :label "Explorer RPC Flashcards input"
	  :near-mode '(:point 10 400)
	  :margin-choices '(("Abort" (abort-action)))
	  )
	
	(callmac expr-string)			       ;Use RPC to send user's response 
						       ; to the mac

						       ;extract string up to null character
	(LET ((expr-from-mac (subseq *string-from-mac* 0
				     (position (character 0) *string-from-mac*))))
	  (send *exp* :clear-screen)
	  (format *exp* "~%~%Received from Mac and evaluated:")
	  (format *exp* "~%~a = " expr-from-mac)
	  (format *exp* "~a" (do-arithmetic expr-from-mac))    ;evaluate input from mac
	  )					       ;end let
	(FILL *string-from-mac* (CHARACTER 0))	       ;clear it for the next one
	(SLEEP 2)
	)					       ;end do-forever
    (eh:*abort-object* (RETURN-FROM flashcards t))     ;end loop on this condition    
    )						       ;end condition case
  )

(DEFUN abort-action ()
  (SEND *exp* :clear-screen)
  (SEND *exp* :set-current-font fonts:hl12b)
  (SEND *exp* :string-out-x-y-centered-explicit "Flashcards Terminated")
  (SEND *exp* :set-current-font fonts:hl12)
  (SIGNAL-CONDITION eh:*abort-object*)
  )

(DEFUN do-arithmetic (str)
  "evaluate the arithmetic expression"
  (MULTIPLE-VALUE-BIND (operator operator-index)
      (read-operator-from-string str)		       ;extract operator
    (COND					       ;check for each kind of operation
      ((CHAR-EQUAL operator #\+)
		   (+ (read-integer-from-string str :start 0)
		      (read-integer-from-string str :start (+ operator-index 1))))
      ((CHAR-EQUAL operator #\-)
		   (- (read-integer-from-string str :start 0)
		      (read-integer-from-string str :start (+ operator-index 1))))
      ((CHAR-EQUAL operator #\*)
		   (* (read-integer-from-string str :start 0)
		      (read-integer-from-string str :start (+ operator-index 1))))
      ((CHAR-EQUAL operator #\/)
                   (FLOAT (/ (read-integer-from-string str :start 0)
		      (read-integer-from-string str :start (+ operator-index 1)))))
      ((CHAR-EQUAL operator #\!)
                   (factorial (read-integer-from-string str :start 0)))

      )
    )
  )

(DEFUN factorial (n)
  "recursively compute factorial"
  (IF (OR (= n 1)
	  (= n 0))
      1						       
      (* n (factorial (- n 1)))
      )
  )

(DEFUN blankp (CHAR)
  "returns T if char is a blank"
  (CHAR-EQUAL char #\space))

(DEFUN skip-blanks (str &key (start 0))
  "skips blank chars and returns index of first non-blank char"
  (MULTIPLE-VALUE-BIND (element index)
      (FIND-IF-NOT #'blankp str :start start)
    (VALUES index element)
    ))

(DEFUN read-integer-from-string (str &key (start 0) )
  "convert a number in a string to the integer it represents"
  (LET ((num1 0)				       ;accumulates the integer
	(non-blank (skip-blanks str :start start)))

    (DO ((COUNT non-blank (1+ count))		       ;loop building the integer
	 )
	((OR
	   (>= count (LENGTH str))
	  (delimeterp (ELT str count))		       ;until delimeter is found
	  ))
						       ;build integer
      (SETF num1 (+ (* num1 10) (- (CHAR-INT (ELT str  count)) #x30)))
	 )					       ;end of do
    (VALUES num1 )				       ;return the integer
    ))

(DEFUN delimeterp (CHAR)
  "returns T if char is a delimeter"
  (OR (operatorp char)
      (CHAR-EQUAL char #\space))
  )

(DEFUN operatorp (CHAR)
  "returns T if char is an arithmetic operator"
  (COND 
    ((CHAR-EQUAL char #\+) t)
    ((CHAR-EQUAL char #\-) t)
    ((CHAR-EQUAL char #\*) t)
    ((CHAR-EQUAL char #\/) t)
    ((CHAR-EQUAL char #\!) t)
    ))

(DEFUN read-operator-from-string (str &key (start 0))
  "Returns the operator character and its index"
  (FIND-IF #'operatorp str :start start))

;;; ***END OF FILE ***
