;;; -*- Mode:Lisp; Syntax: Common-Lisp; Package: ZWEI; Base: 10; Patch-File: T -*-

;;; Picked up from Info-TI-Explorer from Mark Kolb

;;;  A hack to the Explorer Control-Mouse-M (a.k.a. Mouse-M-2, a.k.a. Shift-Mouse-M) click to mimic the
;;;  same "copy-to-point" action on the Symbolics.  Appears to works for all kinds of Lisp forms, and will
;;;  even copy into the minibuffer.

;;;  Note that since I haven't been able to find the stuff that implements ZMACS mouse clicks,
;;;  I'm just going to patch the appropriate functions.

;;;  To use this feature, include the form (ZWEI:SET-NEW-M2-DEFINITION) in your LOGIN-INIT file.
;;;  The original binding is automatically restored when you logout.


(defprop com-mouse-copy-thing "Copy to point" :mouse-short-documentation)

(defmacro inside-zmacs ((frame &optional (window nil)) &body body)
"Executes Body in an environment which makes it think that it is being
called from within Zmacs.  All Zmacs specials are bound to some suitable value.
"
 `(let ((.frame. ,frame))
       (declare (unspecial .frame.))
       (let ((.window. (or ,window (first (send .frame. :Inferiors)))))
	    (declare (unspecial .window.))
	    (let-if .window.
		    ((zwei:*window* .window.))
		    (funcall (send .frame. :editor-closure)
			     #'(lambda () ,@body)
		    )
	    )
       )
  )
)

(defmacro inside-all-zmacs (&body body)
 `(loop for win in Zwei::*All-Zmacs-Windows* do
	(Inside-Zmacs ((send win :Superior)) ,@body)
  )
)

(defun mouse-copy-less-p (x y)
  (or (and (send (tv:sheet-superior x) :Exposed-P)
	   (not (send (tv:sheet-superior y) :Exposed-P))
      )
      (and (not (send (tv:sheet-superior x) :Exposed-P))
	   (not (send (tv:sheet-superior y) :Exposed-P))
	   (string-lessp (format nil "~S" x) (format nil "~S" y))
      )
  )
)

(defun best-zmacs-mouse-copy-windows ()
  (let ((windows
	  (loop for win in Zwei::*All-Zmacs-Windows*
		when (window-mark-p win) collect win
	  )
	)
       )
       (if windows
	   (let ((sorted
		  (sort windows 'mouse-copy-less-p
		  )
		 )
		)
	        sorted
	   )
	   nil
       )
  )
)

(defun query-about-copy-from-window (window?)
  (let ((bp1 (Inside-Zmacs ((send window? :Superior) window?) (point)))
	(bp2 (Inside-Zmacs ((send window? :Superior) window?) (mark)))
	(name (Inside-Zmacs ((send window? :Superior) window?)
		(send *interval* :name)
	      )
	)
       )
       (y-or-n-p "Copy region ~S to ~S from ~A"
		 (bp-line (if (bp-< bp1 bp2) bp1 bp2))
		 (bp-line (if (bp-< bp1 bp2) bp2 bp1))
		 name
       )
  )
)

(defvar *mouse-copy-thing-looks-in-other-windows* nil)

(defcom com-mouse-copy-thing "Copy the thing you are pointing at to the current point." (sm)
  (let ((windows (and *mouse-copy-thing-looks-in-other-windows*
		      (best-zmacs-mouse-copy-windows))))
       (let ((window? (find-if #'Query-About-Copy-From-Window windows)))
	    (if window?
		(let* ((*last-command-type* 'history)
		       ;;;  To make sure we don't append the
		       ;;;  COM-SAVE-REGION stuff.
		       (point (window-point *window*))
		       (original-bp (copy-bp point))
		      )
		      (Inside-Zmacs ((send window? :Superior) window?)
			(com-save-region)
		      )
		      (move-to-bp original-bp)
		      (yank-for-mouse-copy-thing)
		      dis-text
		)
		(let* ((*kill-interval-smarts* t)
		       (*last-command-type* 'history)
		       ;;;  To make sure we don't append the
		       ;;;  COM-SAVE-REGION stuff.
		       (point (window-point *window*))
		       (original-bp (copy-bp point))
		      )
		      (com-mouse-mark-thing)
		      (com-save-region)
		      (move-to-bp original-bp)
		      (yank-for-mouse-copy-thing)
		      (com-abort-at-top-level)
		        ;  This gets rid of the marked region.
		      dis-text
		)
	    )
       )
  )
)

(defun get-mouse-copy-yank-item ()
  "Returns the top node off of the *KILL-HISTORY*, with the side effect of removing it from the history."
  (let ((the-item (history-element-set-yank-pointer *kill-history* nil)))
    (delete-from-history the-item *kill-history*)
    the-item))

(defun yank-for-mouse-copy-thing ()
  "Called by COM-MOUSE-COPY-THING to insert the text into either the editing buffer or the mini-buffer."
  (if *mini-buffer-command-in-progress*
      (yank-for-mouse-copy-into-mini-buffer)
      (yank-for-mouse-copy-into-buffer)))

(defun yank-for-mouse-copy-into-buffer ()
  (let* ((editing-window *window*)
	 (the-point (window-point editing-window))
	 (the-mark (window-mark editing-window))
	 (item-to-yank (get-mouse-copy-yank-item))
	 (spaces-before '(#\Space #\Tab #\Newline #\' #\` #\())
	 (spaces-after '(#\Space #\Tab #\Newline #\))))
    (unless (member (bp-char-before the-point) spaces-before :test #'char-equal)
      (move-bp the-mark the-point)
      (move-bp the-point (insert-thing the-point #\Space)))
    (move-bp the-mark the-point)
    (move-bp the-point (insert-thing the-point item-to-yank))
    (unless (member (bp-char the-point) spaces-after :test #'char-equal)
      (move-bp the-mark the-point)
      (move-bp the-point (insert-thing the-point #\Space)))))

(defun yank-for-mouse-copy-into-mini-buffer ()
  (let* ((editing-window *mini-buffer-window*)
	 (the-point (window-point editing-window))
	 (spaces-before '(#\Space #\Tab #\Newline #\' #\` #\())
	 (spaces-after '(#\Space #\Tab #\Newline #\))))
    (unless (member (bp-char-before the-point) spaces-before :test #'char-equal)
      (send editing-window :force-kbd-input #\Space))
    (send editing-window :force-kbd-input #\Control-Y)
    (unless (member (bp-char the-point) spaces-after :test #'char-equal)
      (send editing-window :force-kbd-input #\Space))
    (send editing-window :refresh)))



;;;  Code for implementing this new definition, without losing the old definition.

(comment					;;;  This is what I would have liked to have done!
  (set-comtab *zmacs-comtab* '(#\Mouse-M-2 com-mouse-copy-thing)))

(defvar .original-m2-definition. nil)
(defvar .original-m2-documentation-property. nil)
(defvar .original-m2-who-line-documentation. nil)
(defvar .m2-definition-usurpedp. nil
  "Flag which indicates whether or not the editor binding of Mouse-M-2 has been usurped.")

(when (and (null .original-m2-definition.)
	   (null .m2-definition-usurpedp.))
  (setq .original-m2-definition. #'com-mouse-kill-yank
	.original-m2-documentation-property. (get 'com-mouse-kill-yank 'si:documentation-property)
	.original-m2-who-line-documentation. (get 'com-mouse-kill-yank ':mouse-short-documentation)))

(defun update-mouse-documentation ()
  "Makes sure that the mouse documentation line for the editor is updated, whether or not the editor is currently in use."
  (if (boundp '*window*) (set-mouse-documentation)
      (let ((zmacs-frame (tv:find-window-of-flavor 'zwei:zmacs-frame)))
	(when zmacs-frame
	  (let* ((closure (send zmacs-frame :editor-closure))
		 (*window* (symeval-in-closure closure '*window*))
		 (*comtab* (symeval-in-closure closure '*comtab*)))
	    (set-mouse-documentation))))))

(defun restore-m2-definition ()
  (let ((inhibit-fdefine-warnings t)) (deff com-mouse-kill-yank .original-m2-definition.))
  (setf (get 'com-mouse-kill-yank 'si:documentation-property) .original-m2-documentation-property.)
  (setf (get 'com-mouse-kill-yank ':mouse-short-documentation) .original-m2-who-line-documentation.)
  (setq .m2-definition-usurpedp. nil)
  (update-mouse-documentation))

(defun set-new-m2-definition ()
  "Changes the binding of Mouse-Middle-2 in Zmacs to perform Copy-to-Point, a la Symbolics.
The original binding is restored upon logging out."
  (declare (special logout-list))
  (let ((inhibit-fdefine-warnings t)) (deff com-mouse-kill-yank 'com-mouse-copy-thing))
  (setf (get 'com-mouse-kill-yank 'si:documentation-property)
	'(function "Copy the thing you are pointing at to the current point.
Note that the definition of COM-MOUSE-KILL-YANK has been usurped so
that Control-Mouse-M (a.k.a. Mouse-M-2) will perform the copy operation."))
  (setf (get 'com-mouse-kill-yank ':mouse-short-documentation) "Copy to point")
  (setq .m2-definition-usurpedp. t)
  (update-mouse-documentation)
  (pushnew '(restore-m2-definition) logout-list)	;;  To restore the original defintion
  )
