;;; -*- Mode:Common-Lisp; Package:TV; Base:10; Fonts:(TVFONT TR10 HL10 TR10I TR10B) -*-

;-------------------------------------------------------------------------------

(1defflavor* callers-vertex () (4function-vertex*))

(1defmethod* (2Callers-Vertex* :get-real-function) (from)
  (get-caller from)
)

(1defvar* *inheritors* nil)
(1defvar* *inherited* nil)
(1defvar* *callers-package* nil)
(1defvar* 2*Default-Callers-Graph-Depth** 1)

(1defvar* 2*Graph-Call*ers2-Item-Type-Alist**
  '((3:Vertex* 2Edit-Graphed-Function*
	     "L: Edit this object; M: Drag object; Sh-M/M2: Overview; R: Menu of operations"
	     ("Graph this Node" 3:Value* 2Maybe-Graph-Callers* 3:Documentation*
	      "Start a new grapher whose top node is this object."
	     )
	     ("Extend this Node" 3:Value* 2Grapher-Entend-*Callers-2Graph*
	      3:Documentation* "Extend the graph below this node."
	     )
	     ("Inspect" 3:Value* 2Graph-Calls-Inspect* 3:Documentation*
	      "Inspect this object."
	     )
	     ("Edit" 3:Value* 2Edit-Graphed-Function* 3:Documentation*
	      "Edit the source code definition of this object."
	     )
	     ("Trace" 3:Value* Trace-function-command 3:Documentation*
	      "Trace this function."
	     )
	     ("Graph calls" 3:Value* 2Maybe-Graph-Function* 3:Documentation*
	      "Show a graph of the functions called by this one."
	     )
	     ("Elide"   3:Value* 4collapse* 3:Documentation*
	      "Elide this object."
	     )
	     ("Elide Children"   3:Value* 4collapse-children*
	      3:Documentation* "Elide the children of this object."
	     )
	     ("UnElide Children" 3:Value* 4expand-children*
	      3:Documentation* "UnElide the children of this object."
	     )
    )
    (3:Edge* nil
     "R: Menu of operations"
     ("Elide"   3:Value* remove-edge 3:Documentation* "Elide this edge.")
     ("Elide Edge and Children"   3:Value* 4collapse*
      3:Documentation* "Elide this edge and its children."
     )
    )
   )
"An item type alist for call tree grapher.  To add new right button menu
entries simply add the relevant menu item to the list after the third element of
the list for the relevant item type.
"
)

(1defvar* 2*Call*ers2-Grapher-Mouse-R-Menu-Items**
  '(("Variables" 3:Value* :2Set-Graph-Call*er2s-Variables* 3:Documentation*
     "Set sundry variables for the call tree grapher."
    )
    ("3Create ZMACS Diagram*" :value :grapher-create-zmacs-diagram
     3:Documentation*
     "3Create a Zmacs Diagram Line representing this graph in an editor buffer.*"
    )
   )
"The menu items that are used for the menu that gets popped up by right
 clicking on the background of the call grapher.
"
)

(1setf* (1get* '2Callers* :right-button-menu-items)
     '2*Call*ers2-Grapher-Mouse-R-Menu-Items**
)

(1defmethod* (2Stand-Alone-Grapher* 3:Set-Graph-Call*er3s-Variables*) (x y)
"Sets up sundry instance variables of the call grapher for use larer on by
 popping up a menu.
"
  (1ignore* x y)
  (4assign-using-menu*
    (((1get* 4self* 'depth) "Depth" 3:Fixnum*)
     (*callers-package* "Callers from Package" 3:String-Or-Nil*)
     (*inheritors* "Inheritors" 3:Boolean*)
     (*inherited* "Inherited" 3:Boolean*)
     ((1get* 4self* '2Print-Package*) "Package" 3:String-Or-Nil*)
     ((get 4self* '2Orientation*)
      "Orientation" 3:Assoc*
      (1list* (1cons* "Horizontal" 3:Horizontal*)
	   (1cons* "Vertical"   3:Vertical*)
      )
     )
     ((1get* 4self* '2Tree-P*)
      "Tree or Graph plot" 3:Assoc*
      (1list* (1cons* "Tree" t) (1cons* "Graph" nil))
     )
     ((1get* 4self* '2Grapher-Selection-Mode*)
      "Grapher selection mode." 3:Assoc*
	(1list* (1cons* "Use an existing one" 3:Existing*)
	     (1cons* "Create a new one" 3:New*)
	     (1cons* "Ask" 3:Ask*)
	)
     )
    )
    3:Label* "Set a callers grapher variables."
  )
  (1send* self 3:Set-Graph-Behaviour-Changed* t)
  (1set*f (1get* 4self* '2Print-Package*)
        (1string-upcase* (1string* (1get* 4self* '2Print-Package*)))
  )
  (1setq* 2*Callers-Package**
        (1Read-from-string* (1string-upcase* (1string* *callers-package*)))
  )
)

(1defstruct*-safe (caller 3:Named*) caller names how)

(1defun* (3:Property* 2Caller* named-structure-invoke) (op 2Caller* &rest args)
  (1ecase* op
    (3:Which-Operations* '(3:Which-Operations* 3:Print-Self*))
    (3:Print-Self* (1format* (1first* args) "#<~A ~S>" (1type-of* 2Caller*)
			 (2Get-Caller* 2Caller*)
		 )
    )
  )
)

(1Defun* 2Extend-*Callers-2Graph-For* (1function* &optional (on 3:From-Resource*))
"Extends the graph on window On below the function Function."
  (1let* ((2*Default-Call*ers2-Graph-Depth** 1))
      (2Graph-Callers* (4find-vertex-for* (get-caller function) on) on 3:Default*)
  )
)

(1defun* 2Grapher-Entend-*Callers-2Graph* (1function* 4window* vertex)
"Extends the graph for the current node."
  (1ignore* 4vertex*)
  (2Extend-*Callers-2Graph-For* function window)
)

(1defmethod* 4coerce-to-node* ((x caller))
  (1if* (1rest* (2Caller-Names* x)) ;; more than one name.
      (4coerce-to-node* (caller-caller x))
      (2Coerce-To-Node* (1first* (2Caller-Names* x)))
  )
)

(1defun* get-caller (of)
"Returns a list of interesting caller names."
  (1function-name* (4coerce-to-node* of))
)

(1defun* get-caller-for-children (of)
"Returns a list of interesting caller names."
  (1let* ((coerced (4coerce-to-node* of)))
      (1let* ((name
	      (1function-name*
		(1if* (1typep* coerced 'caller) (caller-caller coerced) coerced)
	      )
	    )
	   )
	   (1if* (1consp* name)
	      (1case* (1first* name)
		(3:Property*
		 (1if* (1equal* 3:Previous-Definition* (1third* name))
		     nil
		     (1list* (1second* name) (1third* name))
		 )
		)
		(3:Method* (1list* (1first* (1last* name))))
		(clos:method (1list* (second name)))
		(otherwise (1rest* name))
	      )
	      nil
	      (1list* name)
	   )
      )
  )
)

(1defun* 2Get-Reasonable-Package* (of)
  (1let* ((of (2Get-Caller* of)))
      (1etypecase* of
	(symbol (1symbol-package* of))
	(1cons* (1if* (4fdefinition-safe* of)
		  (1symbol-package* (1second* of))
		  (1ferror* nil "Cannot find the package of ~S" of)
	      )
	)
      )
  )
)

(1defvar* *callers-hash-table* (1make-hash-table* 3:Test* #'1equal*))

(1defun* remember-callers (caller callee how)
  (1ignore* callee)
  (1let* ((2Caller* (4remove-internals* 2Caller*)))
      (1let* ((real-callers (list caller)));(2Get-Caller-For-Children* caller)))
	  (1loop* for call in real-callers
		when (1or* (symbolp call) (1consp* call))
		do
		(1let* ((entry
			(1or* (1gethash* (1list* call how) 2*Callers-Hash-Table**)
			    (1progn*
			      (1setf* (1gethash* (1list* call how)
					     2*Callers-Hash-Table**
				    )
				    (2Make-Caller*
				      3:Caller* call 3:Names* nil 3:How* nil
				    )
			      )
			    )
			)
		      )
		     )
		     (1let* ((how-entry
			     (1or* (1assoc* how (2Caller-How* entry))
				 (1push* (1list* how) (2Caller-How* entry))
			     )
			   )
			  )
		          (1pushnew* 2Caller* (1rest* how-entry))
		     )
		     (1pushnew* caller (2Caller-Names* entry))
		)
	  )
      )
  )
)

(1defun* callers (of-this-thing)
  (1let* ((of-thing (get-caller-for-children of-this-thing)))
      (1if* of-thing
	 (1let* ((existing
		 (1loop* for 2Caller* in of-thing
		       for 2Callers*
		       = (si:function-spec-get caller 3:Callers* :not-computed)
		       when (1equal* 3:Not-computed* 2Callers*)
		       do (1return* 3:Not-computed*)
		       append 2Callers*
		 )
	      )
	     )
	     (1if* (1equal* 3:Not-computed* existing)
		 (1progn*
		   (1clrhash* 2*Callers-Hash-Table**)
		   (1Loop* for 2Caller* in of-thing
			  when (1equal* 3:Not-computed*
				       (si:function-spec-get
					 (1first* of-thing) 3:Callers* 3:Not-computed*
				       )
			       )
			  do
		     (sys:find-callers-of-symbols
		       of-thing
		       (1or* *callers-package*
			   (2Get-Reasonable-Package* (2Get-Caller* of-this-thing))
		       )
		       'remember-callers
		       *inheritors* *inherited*
		     )
		     (1let* ((actual-callers
			     (1maphash-return* #'(lambda (1ignore* 4value*) 4value*)
					       2*Callers-Hash-Table**
			     )
			  )
			 )
			 (si:function-spec-putprop
			   caller (remove-duplicates actual-callers :test #'eq)
			   3:Callers*
			 )
		     )
		     (si:function-spec-get caller 3:Callers*)
		   )
		   (2Callers* of-this-thing)
		 )
		 existing
	     )
	 )
	 Nil
      )
  )
)

(1defun* simple-print-caller (caller)
  (4simple-print-fef* (2Get-Caller* caller))
)

(defun get-caller-package (x)
  (if (symbolp x)
      (symbol-package x)
      (if (consp x)
	  (case (first x)
	    ((:internal clos:method) (get-caller-package (second x)))
	    (:method (get-caller-package (second x)))
	    (otherwise *package*) ;;; Punt
	  )
	  (get-caller-package (function-name x))
      )
  )
)

(1defun* 2Graph-Callers* (thing &optional (on 3:From-Resource*) (label nil))
"Graphs the functions called by Function on grapher window On (when defaulted
 it allocates a new window from a resource).  Label is printed at the bottom
 of the window.  Function can be either the name of a function or a Object.  If
 the display gets too complicated then it can be filtered by sundry filter
 functions.  These can be selected either by using the right button menus in
 grapher windows or by calling the function tv:Select-Grapher-Filters.  In
 your login file you can set the variable tv:*Selected-Filters* to a list of
 the names of the filter functions that you want.  For information on writing
 your own filter functions please look at the documentation/definition of
 tv:*Filter-Items*.
"
  (1let* ((object (get-caller thing)))
      (let ((*callers-package* (get-caller-package object)))
	   (1if* (1and* (1typep* thing '4vertex*)
		    (1send* thing 3:Child-Edges*)
	      )
	      thing
	      (1let* ((4window*
		     (4plot-a-graph*
		       object
		       3:On* on
		       3:Child-Function* '2Callers*
		       :edge-initargs '(:reverse-arrowhead-p t)
		       3:Print-Function* '2Simple-Print-Caller*
		       3:Vertex-Flavor* '2Callers-Vertex*
		       3:Item-Type-Alist* 2*Graph-Callers-Item-Type-Alist**
		       3:Depth* (1if* (1typep* on '4stand-alone-grapher*)
				  (multiple-value-bind (res ?) (get on 3:Depth*)
				      (if ? res 2*Default-Callers-Graph-Depth**)
				  )
				  2*Default-Callers-Graph-Depth**
			      )
		       3:Orientation* (1if* (1typep* on '4stand-alone-grapher*)
				       (or (get on 3:Orientation*)
					   4*graph-calls-orientation**
				       )
				       4*graph-calls-orientation**
				   )
		       3:Tree-P* (1if* (1typep* on '4stand-alone-grapher*)
				   (multiple-value-bind (res ?) (get on 3:Tree-P*)
				     (if ? res 4*graph-calls-plot-trees-p**)
				   )
				   4*graph-calls-plot-trees-p**
			       )
		       3:Resource* '4stand-alone-graphers*
		       3:Dont-Graph-If-Already-Graphing-This-Node* t
		       3:Label* (1or* label
				  (1format* nil "~S's callers." (get-caller thing))
			      )
		     )
		   )
		  )
		  4window*
	      )
	  )
      )
  )
)



(1defun* 2Inspect-Graph-Callers* (1thing* &optional ignore)
"Graphs the callers of a thing.  This is called from the inspector and
 such-like.  Thing is ignored.  A background process is spun off to do this
 so that selection problems are avoided.
"
  (1process-run-function*
    '(3:Name* "Expose Grapher" 3:Priority* -1)
    #'(lambda (1thing* expose-p)
	(1let* ((4*force-exposure** expose-p))
	    (1declare* (1special* 4*force-exposure**))
	    (2Graph-Call*ers thing
			 (2Get-A-Grapher-Window*
			   2*Grapher-Selection-Mode**
			   '2Stand-Alone-Graphers*
			 )
	    )
	)
      )
      Thing 4*force-exposure**
  )
)

(defun inspect-graph-callers-p (name &optional (thing nil))
"Is true if Name names a function which we can graph.  Thing is ignored."
  (ignore thing)
  (or (symbolp name)
      (1and* (1consp* name) (4fdefinition-safe* name))
      (compiled-function-p name)
  )
)

(1defun* maybe-graph-callers (object &optional (thing nil) &rest ignore)
"Graphs Function in a grapher if it knows how to."
  (1if* (inspect-graph-callers-p object thing)
      (2Inspect-Graph-Callers* object thing)
      (tv:notify tv:selected-window "Could not graph callers of ~S." object)
  )
)
