;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-
;;; Patch file for KSL-PATCHES version 10.5
;;; Reason: SPR 171: Allow suppression of LISP package and top-level-atom warnings.
;;; Written 12-Feb-91 03:08:27 by acuff,
;;; while running on KSL-Mac-62 from band KSLA
;;; With SYSTEM 6.41, GC 6.7, VIRTUAL-MEMORY 6.3, MICRONET 6.0, MICRONET-COMM 6.4,
;;;  DISK-IO 6.4, DISK-LABEL 6.1, BASIC-PATHNAME 6.5, MAC-PATHNAME 6.0, NETWORK-SUPPORT-COLD 6.2,
;;;  BASIC-NAMESPACE 6.8, BASIC-FILE 6.15, RPC 6.2, NFS-MX 6.9, EH 6.8, MAKE-SYSTEM 6.5,
;;;  MEMORY-AUX 6.0, COMPILER 6.18, TV 6.32, NVRAM 6.4, UCL 6.1, INPUT-EDITOR 6.1,
;;;  MACTOOLBOX 2.25, METER 6.2, ZWEI 6.28, DEBUG-TOOLS 6.5, WINDOW-MX 6.12, PRINTER 6.8,
;;;  MAC-PRINTER-TYPES 6.2, CLIPBOARD 6.1, TI-CLOS 6.53, CLEH 6.5, NETWORK-PATHNAME 6.2,
;;;  NETWORK-NAMESPACE 6.1, DATALINK 6.0, CHAOSNET 6.9, NETWORK-SUPPORT 6.1, NETWORK-SERVICE 6.3,
;;;  DATALINK-DISPLAYS 6.0, MX-DATALINK 6.1, NAMESPACE-EDITOR 6.7, IP 3.65, NFS-MX-SERVER 6.0,
;;;  MX-SERIAL 6.2, PRINTER-TYPES 6.2, IMAGEN 6.1, MAIL-DAEMON 6.6, MAIL-READER 6.9,
;;;  TELNET 6.1, VT100 6.0, STREAMER-TAPE 6.6, DECNET 1.72, VISIDOC 6.7, PROFILE 6.3,
;;;  Experimental KSL-PATCHES 10.3,  microcode 195, Band Name: 6.1(41), KSL9 10.2,
;;;  17-Jan

#!C
; From file PATCHES-9.LISP#> SYS-PATCHES; KSL-EXP-7:
#10R USER#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "USER"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "KSLx: SYS-PATCHES; PATCHES-9.#"


(defvar compiler:*warn-when-not-using-lisp-package* t
  "When non-NIL warnings will be issued when a file is compiled that is in
Common Lisp mode but doesn't use the LISP package.")

(advise (:within compiler:compile-stream compiler:warn)
	:around :control-cl-warning nil
  (unless (and (not compiler:*warn-when-not-using-lisp-package*)
	       (eq (first arglist) 'compiler:common-lisp-on-p)
	       (eq (second arglist) :implausible))
    :do-it))

(defvar compiler:*warn-of-atoms-at-top-level* t
  "When non-NIL warnings will be issued when an ATOM appears at top level in
a file to be loaded.")

(advise (:within compiler:compile-stream compiler:warn)
	:around :control-atom-warning nil
  (unless (and (not compiler:*warn-of-atoms-at-top-level*)
	       (eq (first arglist) 'compiler:atom-at-top-level)
	       (eq (second arglist) :implausible))
    :do-it))
 
))
