;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-
;;; Written 14-Jan-91 11:19:38 by acuff,
;;; Reason: SPR 169: Don't cons garbage windows in Zmacs
;;; while running on KSL-Mac-62 from band KSL9
;;; With SYSTEM 6.41, GC 6.7, VIRTUAL-MEMORY 6.3, MICRONET 6.0, MICRONET-COMM 6.4,
;;;  DISK-IO 6.4, DISK-LABEL 6.1, BASIC-PATHNAME 6.5, MAC-PATHNAME 6.0, NETWORK-SUPPORT-COLD 6.2,
;;;  BASIC-NAMESPACE 6.8, BASIC-FILE 6.15, RPC 6.2, NFS-MX 6.9, EH 6.8, MAKE-SYSTEM 6.5,
;;;  MEMORY-AUX 6.0, COMPILER 6.18, TV 6.32, NVRAM 6.4, UCL 6.1, INPUT-EDITOR 6.1,
;;;  MACTOOLBOX 2.25, METER 6.2, ZWEI 6.28, DEBUG-TOOLS 6.5, WINDOW-MX 6.12, PRINTER 6.8,
;;;  MAC-PRINTER-TYPES 6.2, CLIPBOARD 6.1, TI-CLOS 6.53, CLEH 6.5, NETWORK-PATHNAME 6.2,
;;;  NETWORK-NAMESPACE 6.1, DATALINK 6.0, CHAOSNET 6.9, NETWORK-SUPPORT 6.1, NETWORK-SERVICE 6.3,
;;;  DATALINK-DISPLAYS 6.0, MX-DATALINK 6.1, NAMESPACE-EDITOR 6.7, IP 3.65, NFS-MX-SERVER 6.0,
;;;  MX-SERIAL 6.2, PRINTER-TYPES 6.2, IMAGEN 6.1, MAIL-DAEMON 6.6, MAIL-READER 6.9,
;;;  TELNET 6.1, VT100 6.0, STREAMER-TAPE 6.6, DECNET 1.72, VISIDOC 6.7, PROFILE 6.3,
;;;  Experimental KSL-PATCHES 10.1,  microcode 195, Band Name: 6.1(41), KSL9 10.0,
;;;  16-Nov

#!C
; From file PATCHES-9.LISP#> SYS-PATCHES; KSL-EXP-7:
#10R USER#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "USER"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "KSLx: SYS-PATCHES; PATCHES-9.#"


TV:
(DEFUN CHECK-DEACTIVATED-WINDOW-RESOURCE (IGNORE WINDOW IN-USE-P &REST args) 
  ;; RDA 1/14/91 remove SUPERIOR arg; get it from ARGS
  ;; may 06/11/90 added superior 
  ;;;check the resource to insure it has the right attributes for the screen
  ;;;it is going to be displayed on. 
  (let ((superior (first (last args))))
    (AND (NOT IN-USE-P)
	 (EQ superior (tv:sheet-get-screen window)) ;; may 06/11/90 superior was w:default-screen
	 (NOT (MEMBER WINDOW (SHEET-INFERIORS (SHEET-SUPERIOR WINDOW)) :TEST #'EQ))
	 (SHEET-CAN-GET-LOCK WINDOW))))

TV:
(DEFUN CHECK-DEEXPOSED-WINDOW-RESOURCE   (IGNORE WINDOW IN-USE-P &REST args)
  ;; RDA 1/14/91 remove SUPERIOR arg; get it from ARGS
  ;; may 06/11/90 added superior
  (let ((superior (first (last args))))
    (AND (NOT IN-USE-P)
	 ;;(or (not (mac-system-p))	;; may 07/10/89 
	 ;; Prevent using a resource if the superior is pointing to a DIFFERENT screen
	 (EQ superior (tv:sheet-get-screen window)) ;; may 06/11/90 superior was w:default-screen
	 (NOT (SHEET-EXPOSED-P WINDOW))
	 (SHEET-CAN-GET-LOCK   WINDOW))))

))
