;;; -*- Mode:Common-Lisp; Package:USER; Patch-file:T; Base:10 -*-

;;; This software developed by:
;;;	Rich Acuff
;;;	James Rice
;;;	except where noted
;;; at the Stanford University Knowledge Systems Lab in 1987-1989.
;;;
;;; This work was supported in part by:
;;;	NIH Grant 5 P41 RR00785-15

;;;----------------------------------------------------------------------
;;; Unless otherwise noted this code is modified code from Texas
;;; Instruments Incorporated.
;;; KSL's changes are noted by comment lines beginning with:
;;;	RDA:
;;;	JPR:
;;;	SN:
;;;	RH:
;;;	FritzM:
;;;  The following restrictions apply to the TI code:

;;; Your rights to use and copy Explorer System Software must be obtained
;;; directly by license from Texas Instruments Incorporated.  Unauthorized
;;; use is prohibited.

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1985-1989 Texas Instruments Incorporated. All rights reserved.
;;;----------------------------------------------------------------------

;;;  This is a file of patches used at Stanford KSL for Explorer system
;;;  Release 6, KSL Patches meta-version 9.

;;;  To use this file the logical directory KSLx:SYS-PATCHES; should be
;;;  defined and this file and it's associated files should reside
;;;  there.

;;;----------------------------------------------------------------------
;;;  The following patches are direct from TI.

;;; Remember system menus
(setf (get 'w:system-menu 'sys:no-memory) nil)

;;;  End of TI patches.
;;;----------------------------------------------------------------------

;;;SPR 38: Ghost box and rubber band rectangle specification
W:
(export '(*box-line-width* *use-rubber-bands?*
	  mouse-specify-rubber-band-rectangle
	  mouse-specify-rectangle-position)
	'w)

;;;----------------------------------------------------------------------

;;; Macro and functions from the KSL Window System Additions tool

W:
(defmacro with-mouse-sheet ((sheet) &body body)
  "Executes BODY with MOUSE-SHEET set to SHEET"
  `(let ((.old-mouse-sheet. mouse-sheet))
     (unwind-protect
	 (progn
	   (unless (eq mouse-sheet ,sheet) (mouse-set-sheet ,sheet))
	   ,@body
	   )
       (unless (eq .old-mouse-sheet. mouse-sheet)
	 (mouse-set-sheet .old-mouse-sheet.))
       )
     )
  )

W:
(defun left-down? (buttons)
  "Non-NIL if the left button is down in the button mask BUTTONS."
  (logtest 1 buttons))

W:
(defun middle-down? (buttons)
  "Non-NIL if the middle button is down in the button mask BUTTONS."
  (logtest 2 buttons))

W:
(defun right-down? (buttons)
  "Non-NIL if the right button is down in the button mask BUTTONS."
  (logtest 4 buttons))

;;;----------------------------------------------------------------------

;;; Control vars

W:(defvar *box-line-width* 2. "Width of lines drawn by DRAW-BOX.")
W:(defvar *use-rubber-bands?* t
  "Non-NIL means use rubber-band style rectangle selection")

;;;----------------------------------------------------------------------

;;; The functions.  They're bigger than I like, but there seems to be no
;;; help for it.

W:
(defun mouse-specify-rubber-band-rectangle
       (&optional left top right bottom
	(sheet mouse-sheet) (minimum-width 0) (minimum-height 0) abortable)
  "Ask user to specify a rectangle with the mouse.  First a box with edges
   of LEFT, TOP, RIGHT, and BOTTOM is used to position the top left
   corner.  Then a `rubber band' box is used, with the mouse pulling the
   lower right corner.  The right button can be used to switch between
   corners.  The rubber band won't get smaller than MINIMUM-WIDTH and
   MINIMUM-HIEGHT.

   Returns four values, the left, top, right, and bottom of the
   rectangle, all relative to SHEET.

   SHEET specifies the area within which we are allowed to act.
   If ABORTABLE is T, this can return NIL."
  (when (eq current-process mouse-process)
    (error "MOUSE-SPECIFY-RUBBER-BAND-RECTANGLE cannot be called in the mouse process"))
  (process-wait "Release Button" #'(lambda () (zerop mouse-last-buttons)))
  (unless (sheet-me-or-my-kid-p sheet mouse-sheet)
    (error "MOUSE-SPECIFY-RUBBER-BAND-RECTANGLE attempted on ~S which is not inferior of MOUSE-SHEET"
	   SHEET))
  (with-mouse-sheet (sheet)
    (unless (integerp left)			;Default these
      (psetq left mouse-x
	     top mouse-y
	     right (+ mouse-x 25)
	     bottom (+ mouse-y 25)))
    (with-mouse-grabbed
      ;; Get the initial position
      (setf (values left top right bottom)
	    (mouse-specify-rectangle-position
	      left top
	      (+ left 20)
	      (+ top 20)
	      abortable
	      "Set initial position"
	      )
	    )
      (mouse-standard-blinker)			;Reset this
      (if abortable
	  (setf who-line-mouse-grabbed-documentation
		'(:mouse-L-1 "Confirm this rectangle"
		  :mouse-M-1 "Abort the rectangle picking"
		  :mouse-R-1 "Hold to move to a different corner"))
	  (setf who-line-mouse-grabbed-documentation
		'(:mouse-L-1 "Confirm this rectangle"
		  :mouse-R-1 "Hold to move to a different corner"))
	  )
      (when (numberp left)			;not aborted?
	(rubber-band left top right bottom
		     minimum-width minimum-height abortable)
	)
      )
    )
  )

;;;Edited by Acuff                 4 Aug 88  17:59
W:
;;;Edited by Acuff                 4 Aug 88  18:05
(defun mouse-specify-rectangle-position
       (left top right bottom &optional abortable
	(mouse-left-doc "Position this rectangle") (sheet mouse-sheet))
  "Use the mouse to get a new position for a rectangle who's edges are LEFT,
   TOP, RIGHT, and BOTTOM on SHEET.  ABORTABLE non-NIL means the middle button
   aborts (return NIL).  MOUSE-LEFT-DOC is the who-line documentation for
   Mouse-L"
  (declare (values left top right bottom))
  (with-mouse-sheet (sheet)
    (with-mouse-grabbed
      ;; Create a mouse blinker box
      (mouse-set-blinker-definition :box-stay-inside-blinker 0 0 nil
				    :set-size (- right left)
				    (- bottom top))
;      (mouse-warp left top)
      (mouse-warp 0 0 t)		;Get the blinker to the mouse
      ;; Make the blinker visible.
      (blinker-set-visibility mouse-blinker t)
      (when abortable
	(setf who-line-mouse-grabbed-documentation
	      `(:mouse-M-1 "Aborts the positioning operation.")))
      (setf who-line-mouse-grabbed-documentation
	    (list* :mouse-L-1 mouse-left-doc
		   who-line-mouse-grabbed-documentation))
      ;; In case this was called in response to a mouse click, wait for
      ;; the buttons to be released.
      (process-wait "Release Button"
		    #'(lambda () (zerop mouse-last-buttons)))
      (let (buttons)
	;; Wait for the user to press a mouse button.
	(process-wait "Button"
		      #'(lambda ()
			  (not (zerop (setf buttons mouse-last-buttons)))))
	;; Remember width and heigth
	(setf right (- right left)
	      bottom (- bottom top))
	(setf (values left top)
	      (send mouse-blinker :read-cursorpos))
	(blinker-set-visibility mouse-blinker nil)
	(if (and abortable (middle-down? buttons))
	    (values nil)
	    (values left top (+ left right) (+ top bottom))
	    )
	)
      )
    )
  )

;;;Edited by Acuff                 3 Dec 87  10:05
;;;Edited by Acuff                 4 Aug 88  17:59
W:
;;;Edited by Acuff                 4 Aug 88  18:05
(defun rubber-band (left top right bottom
		    &optional min-x min-y
		      (abortable? t) (stop-when-down? t) (warp-mouse? t))
  "The heart of MOUSE-SPECIFY-RUBBER-BAND-RECTANGLE.  Starting with
   LEFT, TOP, RIGHT, and BOTTOM, use the mouse to specify a rectangle,
   keeping one corner `attached' to the mouse.  Uses MOUSE-SHEET, and
   should be called with the mouse grabbed.  Non-NIL ABORTABLE means
   Mouse-M causes NIL to be returned.  If STOP-WHEN-DOWN? is non-NIL
   then keep shaping until the left or the middle button goes down,
   otherwise stop when all buttons go up.  When WARP-MOUSE? is non-NIL
   the mouse is warped to (RIGHT, BOTTOM) first."
  (if stop-when-down?
      ;; Make sure there are no left over clicks
      (process-wait "Release Button"
		    #'(lambda () (zerop mouse-last-buttons)))
      ;; Stop now if there is no button down
      (when (zerop mouse-last-buttons) (return-from rubber-band nil)))
  (when warp-mouse? (mouse-warp right bottom))
  (lock-sheet (mouse-sheet)
    (loop with (left? top?) and x = right and y = bottom and buttons = 0
	  doing
	  ;; Draw our box
	  (draw-box left top right bottom alu-xor mouse-sheet)
	  ;; Wait for something to happen
	  (mouse-wait x y buttons)
	  ;; Checkpoint
	  (setq buttons mouse-last-buttons
		x mouse-x
		y mouse-y)
	  ;; Check for switching corners
	  (when (right-down? buttons)		
	    ;; Wait until the right button is up
	    (process-wait "Right button up"
		  #'(lambda () (not (right-down? mouse-last-buttons))))
	    ;; Change to dragging the corner nearest the mouse
	    (setq left? (if (< mouse-x (+ left (/ (- right left) 2))) t nil))
	    (setq top? (if (< mouse-y (+ top (/ (- bottom top) 2))) t nil))
;	    (mouse-warp (if left? left right) (if top? top bottom))
	    )
	  ;; Erase the old box
	  (draw-box left top right bottom alu-xor mouse-sheet)
	  ;; See what happened
	  (if (and abortable? (middle-down? buttons))	;Should abort?
	      (return nil)
	      ;; Else update our position
	      ;; First, swap sides if necessary
	      (when (and left? (> x right))
		(setq left? nil)
		(psetq left right right left) )
	      (when (and (not left?) (< x left))
		(setq left? t)
		(psetq left right right left))
	      (when (and top? (> y bottom))
		(setq top? nil)
		(psetq top bottom bottom top) )
	      (when (and (not top?) (< y top))
		(setq top? t)
		(psetq top bottom bottom top))
	      ;; Now update
	      (if left? (setq left x) (setq right x))
	      (if top? (setq top y) (setq bottom y))
	      ;; Check mins
	      (when (> min-x (- right left))
		;; Too small, make it the min
		(if left?
		    (setq left (- right min-x))
		    (setq right (+ left min-x)))
		)
	      (when (> min-y (- bottom top))
		(if top?
		    (setq top (- bottom min-y))
		    (setq bottom (+ top min-y)))
		)
	      )
	  ;; See if we should return
	  (if stop-when-down?
	      ;; check for a button
	      (when (or (left-down? buttons) (middle-down? buttons))
		(return (values left top right bottom)))
	      ;; check for up buttons
	      (when (zerop mouse-last-buttons)
		(return (values left top right bottom)))
	      )
	  )
    )
  )

;;;Edited by Acuff                 4 Aug 88  17:59
W:
;;;Edited by Acuff                 4 Aug 88  18:05
(defun draw-box (x0 y0 x1 y1 alu sheet)
  "Draw a box with the given edges on SHEET using ALU as the alu op.
   Figures out leftmost and topmost edge.  Need not be inside
   PREPARE-SHEET.  Uses *BOX-LINE-WIDTH*."
  (let ((left (min x0 x1))
	(right (max x0 x1))
	(top (min y0 y1))
	(bottom (max y0 y1)))
    (prepare-sheet (sheet)
      (%draw-box left top right bottom alu sheet))
    )
  )

;;;Edited by Acuff                 4 Aug 88  17:59
W:
(defun %draw-box (left top right bottom alu sheet)
  "Draw a box with the given edges on SHEET using ALU as the alu op.
   Must be inside PREPARE-SHEET.  Uses *BOX-LINE-WIDTH*."
  (check-arg *box-line-width* numberp "a number")
  (let ((inside-right (- right *box-line-width* -1)) ;FritzM. 3/29/91
	(inside-bottom (- bottom *box-line-width* -1))) ;FritzM. 3/29/91
    ;; Top
    (%draw-rectangle-clipped (- inside-right left) *box-line-width* left top alu sheet)
    ;; Right
    (%draw-rectangle-clipped *box-line-width* (- inside-bottom top) inside-right top alu sheet)
    (%draw-rectangle-clipped (- inside-right left) *box-line-width*
			     (+ left *box-line-width*) inside-bottom
			     alu sheet)
    (%draw-rectangle-clipped *box-line-width* (- inside-bottom top)
			     left (+ top *box-line-width*) alu sheet)
    )
  )

;;;----------------------------------------------------------------------

;;; Tie it in with the rest of the system

W:
(let ((compiler:compile-encapsulations-flag t))
     (advise mouse-specify-rectangle :around "Allow rubber banding" nil
       (if *use-rubber-bands?*
	   (apply #'mouse-specify-rubber-band-rectangle arglist)
	   :do-it
	   )
       )
)

;;;SPR 148: Point users to CL:ERROR
compiler:
(defun dbg-style (form)
  (declare (ignore form))			;RDA
  (warn :Debugger-Breakpoint
;	:IMPLAUSIBLE
	:obsolete				;RDA
;	"~s breakpoint in function ~s"
	"DBG is obsolete; use CL:BREAK"		;RDA
;	(car form)
;	si:object-warnings-object-name
	))

;RDA: cribbed from original DBG-STYLE
compiler:
(add-style-checker cl:break break-style)
compiler:
(defun break-style (form)
  (warn :Debugger-Breakpoint
	:IMPLAUSIBLE
	"~S breakpoint in function ~s"
	(car form)
	si:object-warnings-object-name))

#|| Now fixed
;;;SPR 158: Don't error resuming from the WDBG inside CL:BREAK
eh:
(defun call-restart-interactively  (restart &aux interactive-function)
  "Calls the interactive-function of restart in the erring stack group,
unless in window debugger.  Invokes the restart in the erring stack group."
  (declare (special *window-debugger-old-window* *error-sg* *current-frame*))
    (cond ((not *window-debugger-old-window*)
	   ;; regular debugger
	   ;; call interactive function and invoke restart in erring stack group
	   (sg-apply *error-sg* 
		     'cleh:invoke-restart-interactively `(,restart) nil nil))
	  (:else ;; in window debugger
	   ;; The restart interactive function uses stream *query-io*.
	   ;; When we are in the window-debugger mode in the EH-stack group,  *query-io* is the window debugger.
	   ;; If run interactive-function in ERRING-stack-group, *query-io* is  *terminal-io*-syn-stream -
	   ;; and we would attempt to typeout onto a stream that is not the window debugger 
	   ;; and is not currently selected/exposed.
	   ;; This normally is not a problem when in the regular debugger
	   ;; since the regular debusets *query-io* to the terminal-io stream of the erring stack-group
	   ;;
	   ;; Since we have a problem with typeout, we need to run interactive-function in eh-stack group.
	   ;; and then invoke the restart in erring stack group.
	   (if (setq interactive-function (cleh:restart-interactive-function restart))
	       (sg-apply *error-sg* 
			 'cleh:invoke-restart `(,restart ,@(funcall interactive-function)) nil nil)
	       (sg-apply *error-sg* 
			 ;;RDA: Removed NIL after RESTART since no arg should be passed
			 'cleh:invoke-restart `(,restart) nil nil)))))
||#

#|| Now fixed
;;;SPR 159: Make MULTIPLE-VALUE-PROG1 in a COND condition clause compile correctly.
compiler:
(DEFUN P2MULTIPLE-VALUE-PROG1 (TAIL DEST)
  ;;  4/21/86 CLM - Fix to prevent superfluous RETURN instruction
  ;;                from being generated.
  ;; 10/08/86 DNG - Fix to not use RETURN-N when only a single value pushed.
  ;; 01/16/87 CLM - Fix to handle unbinding of special variables if within a
  ;;                CATCH.
  (LET (SINGLE-VALUE-RETURN)
    (COND ((OR (EQ DEST 'D-RETURN)
	       (EQ M-V-TARGET 'RETURN-CATCH))
	   (SETQ SINGLE-VALUE-RETURN
		 (P2MV (CAR TAIL) 'D-PDL 'RETURN))
	   (UNLESS SINGLE-VALUE-RETURN
	     (SETQ M-V-TARGET NIL)) )
	  (M-V-TARGET
	   (UNLESS (P2MV (CAR TAIL) DEST M-V-TARGET)
	     (SETQ M-V-TARGET nil)))
	  (T (P2 (CAR TAIL)
		 (IF (EQ DEST 'D-LAST)
		     'D-PDL
		   DEST))))
    (DOLIST (FORM (CDR TAIL))
      (P2 FORM 'D-IGNORE))
    (IF (AND (EQ DEST 'D-RETURN)
	     (NOT SINGLE-VALUE-RETURN))
	(OUT-AUX 'RETURN-N)
      ;;RDA: Change WHEN to IF
      (if (MEMBER DEST '(D-RETURN D-LAST) :TEST #'EQ)
	(MOVE-RESULT-FROM-PDL DEST)
	;;RDA: When returning on value on the stack, make sure the flags are
	;;correct too.  This kludge pops and pushs the value that's already
	;;on the stack to reset the flags.
	(if (eq dest 'd-pdl)
	    (OUTI `(MOVE ,DEST PDL-POP)))
	))))
||#

;;;SPR 160: Don't garble long lines in TEXT-SCROLL-WINDOWs
(advise tv:scroll-redisplay-display-item :Around
        :Bind-Up-Compute-Motion-Round-Down nil
  (let ((tv:compute-motion-round-down t))
    (declare (special tv:compute-motion-round-down))
    :Do-It
    )
  )

(unless (find-package "MAC")
  (defpackage "MACINTOSH" (:nicknames "MAC" "MAC-WINDOWS") (:use "TICL" "LISP")))

;;;SPR 163: Don't error when BITBLTing medium sized bitmaps on the mX
mac:
(DEFUN send-bitblt (alu width height
		      from-window-id-or-array from-x from-y
		      to-window-id-or-array to-x to-y
		      &optional source-array
		      (source-from-x from-x) (source-from-y from-y)
		      restoration-p		       ; T iff a restoration of a bit array to Mac.
		      &aux source-height source-width replication)
  "Called iff the source and/or destination is on the Mac.  Mac sources and destinations
are ALWAYS the bitmaps of the windows associated with the window-ids, NEVER the
windows' graphPorts, i.e., screen-arrays.  All indirection is resolved before calling this
routine."
  (UNLESS (OR *ignore-commands-for-the-mac* (ZEROP width) (ZEROP height))
    (LET* ((inhibit-scheduling-flag t)    ; Protect big multi-copy copybits.
	   (add:*no-interrupt* inhibit-scheduling-flag))
      (dump-draw-char-cache)
      (SETF width (ABS width)
	    height (ABS height)
	    source-width width
	    source-height height)
      
      ;; find size of source to determine actual size for exp/mac transfer
      ;; if we have a source-array then we came from si:bitblt otherwise it
      ;; must be a bitarray cache handling problem
      (WHEN source-array
	(SETF source-height (ARRAY-DIMENSION source-array 0))
	(IF (FIXNUMP from-window-id-or-array)	       ; Mac-resident source
	    (SETF source-width (tv:sheet-width (AREF *all-windows-and-screens*
						     from-window-id-or-array))) 
	  (SETF source-width (ARRAY-DIMENSION source-array 1))))
      
           ;; If bitblt is not mac-to-mac, then we need to check the size of the bitblt to insure
           ;; that it is not larger than our largest acb
      (UNLESS (AND (NUMBERP from-window-id-or-array)
		   (NUMBERP to-window-id-or-array))
	(LET (max-lines lines)
	  
	  (IF (OR (< (- source-height source-from-y) height) (< (- source-width source-from-x) width))
	      (SETF replication t)
	    ;; else
	    (SETF source-height (MIN (- source-height source-from-y) height)
		  source-width (MIN (- source-width source-from-x) width)))
	  
	  (SETF max-lines (TRUNCATE (/ (- *bitblt-max-size* (* copybits-parms 2) 32)
				       (* (CEILING source-width 32.) 4))))
	  
	  
	  (WHEN (> source-height max-lines)
	    (LOOP
	      until (< height max-lines)
	      do
	      (SETF lines (MIN max-lines height))
	      (SEND *mac* :copybits
		    alu width lines
		    from-window-id-or-array from-x from-y
		    to-window-id-or-array to-x to-y
		    width lines nil (> (- height lines) 0)
		    restoration-p)
	      ;;RDA: Add MOD to make sure we're still in the source array
	      (SETF from-y (mod (+ from-y lines) source-height))
	      (SETF to-y (+ to-y lines))
	      (SETF height (- height lines)))
	    ;; now set source width, height so we don't scale the damn thing
	    (SETF source-width width)
	    (SETF source-height height))))
           
      (IF (> height 0)
	  (SEND *mac* :copybits
		alu width height
		from-window-id-or-array from-x from-y
		to-window-id-or-array to-x to-y
		source-width source-height replication nil
		restoration-p)))))

;;;SPR 165: Don't error getting CLASS-PRECEDENCE-LIST of STRUCTURE-CLASSes
(defmethod (clos:structure-class :class-precedence-list) ()
  (let ((super (clos:class-direct-superclasses self)))
    (cons self
	  (if super
	      (clos:class-precedence-list (first super))
	      (list (clos:find-class 't))))))

#|| Now fixed
;;;SPR 166: Don't error on (OUTPUT-STREAM-P *TERMINAL-IO*) in ZTOP mode
(defmethod (zwei:editor-stream-mixin :direction) ()
  :bidirectional)
||#


;;;SPR 167: Wait for the name server a while before putting up menu
name:
(defvar *times-to-retry-who-am-i* 4
  "Number of times to retry broadcasting for a namespace server before giving
the 'what should I do?' menu")
name:
(defvar *period-between-who-am-i-retries* 30
  "Number of seconds to sleep betwen who-am-i retries in order to give the
name server time to boot.")

name:
;;This must be called with *TIMES-RETRIED*
;;and *OLD-WINDOW-SYSTEM-CHOOSE-FUNCTION* set up.
(defun retry-first-choose-function (&rest args)
  (declare (special *times-retried* *old-WINDOW-SYSTEM-CHOOSE-FUNCTION*))
  (incf *times-retried*)
  (if (>= *times-retried* *times-to-retry-who-am-i*)
      ;;Time to put up the menu
      (apply *old-WINDOW-SYSTEM-CHOOSE-FUNCTION* args)
      ;;Try again...
      (progn
	(sleep *period-between-who-am-i-retries* "Await Nameserver")
	:retry)))

name:
(advise IDENTIFY-SELF :around "Retry WHO-AM-I" nil
  (let* ((*times-retried* 0)
	 (*old-WINDOW-SYSTEM-CHOOSE-FUNCTION* *WINDOW-SYSTEM-CHOOSE-FUNCTION*)
	 *WINDOW-SYSTEM-CHOOSE-FUNCTION*
	 )
    (declare (special *times-retried* *old-WINDOW-SYSTEM-CHOOSE-FUNCTION*))
    (setf *WINDOW-SYSTEM-CHOOSE-FUNCTION* 'retry-first-choose-function)
    :do-it))

;;;SPR 168: Call STREAM-INTO-BP correctly from COM-INSERT-FILE
zwei:
(DEFCOM COM-INSERT-FILE "Insert the contents of the specified file at point.
Reads a file name from the mini-buffer, and inserts the contents of that
file at point. Leaves mark at the end of inserted text, and point at the 
beginning, unless given an argument.  Acts like Yank (Control-Y) with respect
to the region." ()
  (POINT-PDL-PUSH (POINT) *WINDOW* NIL NIL)
  (MOVE-BP (MARK) (POINT))
  (SETQ *CURRENT-COMMAND-TYPE* :YANK)
  (LET ((PATHNAME (READ-DEFAULTED-AUX-PATHNAME "Insert file:")))
    (WITH-OPEN-FILE (STREAM PATHNAME :ERROR :RETRY)
      (LET* ((ATTRIBUTES (FS:EXTRACT-ATTRIBUTE-LIST STREAM))
	     (FONTS (GETF ATTRIBUTES :FONTS))
	     (START-POINT (COPY-BP (POINT))))
	(WITH-UNDO-SAVE ("Insert file" (POINT) (POINT) T)
	  (DBP START-POINT)
	  (MOVE-BP (POINT) (STREAM-INTO-BP STREAM
					   (POINT)

					   ;; pass T instead of a list
					   ;; FritzM. 1/10/91
					   (WHEN (OR (CDR FONTS)
						     (GETF ATTRIBUTES :DIAGRAM))
					     T)))

	  (IBP START-POINT)
	  (DOLIST (BP (LINE-BP-LIST (BP-LINE (POINT))))
	    (WHEN (AND (BP-= (POINT) BP)
		       (NEQ BP (POINT))
		       (EQ (BP-STATUS BP) :NORMAL))
	      (MOVE-BP BP START-POINT)))
	  (FIXUP-FONTS-INTERVAL FONTS START-POINT (POINT)))))
    (MAYBE-DISPLAY-DIRECTORY :READ PATHNAME))
  (OR *NUMERIC-ARG-P*
      (SWAP-BPS (POINT) (MARK)))
  DIS-TEXT) 

;;;SPR 169: Don't cons garbage windows in Zmacs
TV:
(DEFUN CHECK-DEACTIVATED-WINDOW-RESOURCE (IGNORE WINDOW IN-USE-P &REST args) 
  ;; RDA 1/14/91 remove SUPERIOR arg; get it from ARGS
  ;; may 06/11/90 added superior 
  ;;;check the resource to insure it has the right attributes for the screen
  ;;;it is going to be displayed on. 
  (let ((superior (first (last args))))
    (AND (NOT IN-USE-P)
	 (EQ superior (tv:sheet-get-screen window)) ;; may 06/11/90 superior was w:default-screen
	 (NOT (MEMBER WINDOW (SHEET-INFERIORS (SHEET-SUPERIOR WINDOW)) :TEST #'EQ))
	 (SHEET-CAN-GET-LOCK WINDOW))))

TV:
(DEFUN CHECK-DEEXPOSED-WINDOW-RESOURCE   (IGNORE WINDOW IN-USE-P &REST args)
  ;; RDA 1/14/91 remove SUPERIOR arg; get it from ARGS
  ;; may 06/11/90 added superior
  (let ((superior (first (last args))))
    (AND (NOT IN-USE-P)
	 ;;(or (not (mac-system-p))	;; may 07/10/89 
	 ;; Prevent using a resource if the superior is pointing to a DIFFERENT screen
	 (EQ superior (tv:sheet-get-screen window)) ;; may 06/11/90 superior was w:default-screen
	 (NOT (SHEET-EXPOSED-P WINDOW))
	 (SHEET-CAN-GET-LOCK   WINDOW))))

;;;SPR 170: Export NIL correctly.
SYS:
(Defmacro PARSE-STRING-ARGUMENT (string)
  `(IF (STRINGP ,string)
       (IF (EQ (ARRAY-TYPE ,string) 'ART-FAT-STRING)  ;; watch out for fonted strings
	   (STRING-REMOVE-FONTS ,string)
	   ,string)
       (STRING ,string)))

SYS:
(Defun EXPORT (symbols &OPTIONAL pkg)
  "Makes SYMBOLS external in package PKG.
If the symbols are not already present in PKG, they are imported first.
Error if this causes a name conflict in any package that USEs PKG."
  (LET ((pkg (PARSE-PACKAGE-ARGUMENT pkg))                          ;; verify package argument
	(export-list (IF (LISTP symbols) symbols (LIST symbols))))  ;; coerce <symbols> to a list
    (UNLESS (EVERY #'SYMBOLP export-list)                           ;; verify all are symbols - complain otherwise
	    (ERROR t "the export list contains non-symbols: ~s" (REMOVE-IF #'SYMBOLP export-list)))
    (LET ((real-export-list    ;; prepare to punt symbols already exported
	    (REMOVE-IF         ;;   -- this is worthwhile since files with 'exports' are often re-compiled
	      #'(Lambda (sym) 
		  (MULTIPLE-VALUE-BIND (csym found) 
		      (FIND-SYMBOL (symbol-name sym) pkg)
		    (AND (EQ found :external) (EQ sym csym))))
	      export-list))
	  (used-by-list (PACK-USED-BY-LIST pkg)))
      (TAGBODY try-next-sym
	  (DOLIST (sym real-export-list)
		  (WHEN used-by-list
			(LET ((set-of-directly-conflicting-symbols nil)
			      (set-of-inherited-conflicting-symbols nil)
			      (name (SYMBOL-NAME sym)))
			  (DOLIST (p used-by-list)     ;; for each package p using pkg
				  (MULTIPLE-VALUE-BIND (csym found)  ;; look for a conflict
				      (FIND-SYMBOL name p)
				    (WHEN (AND found
					       (NEQ sym csym) 
					       (NOT (MEMBER csym (pack-shadowing-symbols p) :test #'eq)))
					  (IF (EQ found :inherited)
					      (PUSH (CONS csym p) set-of-inherited-conflicting-symbols)
					      (PUSH (CONS csym p) set-of-directly-conflicting-symbols)))))
			  ;; Handle name conflicts
			  (COND ((AND set-of-directly-conflicting-symbols
				      set-of-inherited-conflicting-symbols)
				 (signal-proceed-case ((ignore) 'eh:name-conflict
						       (format t "~%Attempting to export ~s from the ~a package ~
would introduce the following name conflicts:" sym (package-name pkg))
						       sym	
						       (package-name pkg)
						       :export
						       (cons set-of-directly-conflicting-symbols
							     set-of-inherited-conflicting-symbols)
						       (progn (dolist (pair set-of-directly-conflicting-symbols)
								      (format t "~&~10t~s is present in the ~a package."
									      (car pair) (package-name (cdr pair))))
							      (dolist (pair set-of-inherited-conflicting-symbols)
								      (format t "~&~10t~? is accessible by inheritance ~
in the ~a package."
									      "~a:~a"
									      `(,(multiple-value-bind (ignore ignore pack)
										     (find-symbol (symbol-name (car pair))
												  (cdr pair))
										   (package-name pack))
										,(car pair))
									      (package-name (cdr pair))))))
						      (:export-both-conflict-types nil)
						      (:skip (go try-next-sym))
						      (:skip-all (return-from export t))))
				(set-of-directly-conflicting-symbols
				  (signal-proceed-case ((ignore) 'eh:name-conflict
							(format t "~%Attempting to export ~s from the ~a package ~
would introduce the following name conflicts:" sym (package-name pkg))
							sym	
							(package-name pkg)
							:export
							set-of-directly-conflicting-symbols
							(dolist (pair set-of-directly-conflicting-symbols)
								(format t "~&~10t~s is present in the ~a package."
									(car pair) (package-name (cdr pair)))))
						       (:export-present nil)
						       (:unintern-all nil)
						       (:shadow-all nil)
						       (:skip (go try-next-sym))
						       (:skip-all (return-from export t))))
				(set-of-inherited-conflicting-symbols
				  (signal-proceed-case ((ignore) 'eh:name-conflict
							(format t "~%Attempting to export ~s from the ~a package ~
would introduce the following name conflicts:" sym (package-name pkg))
							sym	
							(package-name pkg)
							:export
							set-of-inherited-conflicting-symbols
							(dolist (pair set-of-inherited-conflicting-symbols)
								(format t "~&~10t~? is accessible by inheritance ~
in the ~a package."
									"~a:~a"
									`(,(multiple-value-bind (ignore ignore pack)
									       (find-symbol (symbol-name (car pair))
											    (cdr pair))
									     (package-name pack))
									  ,(car pair))
									(package-name (cdr pair)))))
						       (:export-accessible-by-inheritance nil)
						       (:skip (go try-next-sym))
						       (:skip-all (return-from export t))))
				(t nil))
			  ))
		  ;; If we get here, then proceed with exporting <sym>.
		  ;RDA: Put SYM into a list when it's NIL
		  (IMPORT (or sym (list sym)) pkg)
		  (EXTERNALIZE sym pkg)
		  try-next-sym
		  ))
      t)))


;;;SPR 171: Allow suppression of LISP package and top-level-atom warnings.
(defvar compiler:*warn-when-not-using-lisp-package* t
  "When non-NIL warnings will be issued when a file is compiled that is in
Common Lisp mode but doesn't use the LISP package.")

(advise (:within compiler:compile-stream compiler:warn)
	:around :control-cl-warning nil
  (unless (and (not compiler:*warn-when-not-using-lisp-package*)
	       (eq (first arglist) 'compiler:common-lisp-on-p)
	       (eq (second arglist) :implausible))
    :do-it))

(defvar compiler:*warn-of-atoms-at-top-level* t
  "When non-NIL warnings will be issued when an ATOM appears at top level in
a file to be loaded.")

(advise (:within compiler:compile-stream compiler:warn)
	:around :control-atom-warning nil
  (unless (and (not compiler:*warn-of-atoms-at-top-level*)
	       (eq (first arglist) 'compiler:atom-at-top-level)
	       (eq (second arglist) :implausible))
    :do-it))

;;;SPR 172: Don't error when reading dotted list in read suppressed mode.
sys:
(defun internal-read-list (stream &optional character)
  (let* ((thelist nil)
	 (listtail (locf thelist))
	 (top-level-list top-level-list)
	 correspondence-entry)
    (when (and read-Check-Indentation  Last-Whitespace (Char= Last-Whitespace #\Cr)
	       (null *read-suppress*)) ;;we are truly reading, not skipping things 
      (If (Null Top-Level-List)
	  (unless (and (listp xr-list-so-far)	; PDC 8/7/86
		       (symbolp (car xr-list-so-far))
		       (get (car xr-list-so-far) 'may-surround-defun))
	  (progn 
	    (signal-proceed-case (() 'sys:missing-closeparen
				     "Open paren found in column zero; missing closeparens assumed.")
	      (:no-action))
	    (setf missing-close-paren t)
	    (unread-char #\( stream)
	    (setf xr-splice-p t)
	    (return-from internal-read-list nil)))))
    (setf last-whitespace nil)
    (setf missing-close-paren nil)
    (setf top-level-list nil)
    (when xr-correspondence-flag
      (unread-char character  stream)
      (setq correspondence-entry `(nil ,(funcall stream :read-bp)  ,@xr-correspondence))
      (setq xr-correspondence correspondence-entry) (read-char stream))
    (do ((firstchar (flush-whitespace stream) (flush-whitespace stream)))
	((char= firstchar #\))
	 (when xr-correspondence-flag (rplaca correspondence-entry thelist))
	 thelist)
      (when (char= firstchar #\.)
	    (let ((nextchar (internal-read-char stream t)))
	      ;;RDA: Don't get error because several reader macros which
	      ;;would result in one object if evaluated follow a dot when
	      ;;we're not evaluating the macros.  Add (UNLESS *READ-SUPPRESS*
	      (unless *read-suppress* 
		(cond ((token-delimiterp nextchar)
		       (cond ((eq listtail (locf thelist))
			      (cerror :no-action nil 'sys:read-error-1
				      "Nothing appears before . in list."))
			     ((whitespacep nextchar)
			      (setq nextchar (flush-whitespace stream))))
		       (rplacd listtail
			       (let* ((XR-LIST-SO-FAR ':AFTER-DOT)
				      (XR-SPLICE-P NIL)
				      (values (read-after-dot stream nextchar)))
				 (WHEN XR-SPLICE-P
				   (return XR-LIST-SO-FAR))
				 ;;return list containing last thing.
				 (car values)))
		       (when xr-correspondence-flag (rplaca correspondence-entry thelist))
		       (return thelist))
		      ;;put back nextchar so we can read it normally.
		      (t (unread-char  nextchar stream))))))
      ;;next thing is not an isolated dot.
      (let* ((XR-LIST-SO-FAR thelist)
	     (XR-SPLICE-P NIL)
	     (listobj (read-maybe-nothing stream firstchar)))
	(COND (XR-SPLICE-P
	       (SETQ theLIST XR-LIST-SO-FAR)
	       (SETQ listtail
		     (COND ((ATOM theLIST) (LOCF theLIST))
			   ( (LAST theLIST)))))
	;;allows the possibility that a comment was read.
	      (t (when listobj
		   (rplacd listtail listobj)
		   (setq listtail listobj)))))
      (when (and missing-close-paren (null top-level-list))
	(when xr-correspondence-flag (rplaca correspondence-entry thelist))
	(return thelist))
      )))

;;;SPR 173: Don't generate warnings re. mX functions on Explorer
(unless (sys:mx-p)
  (defun add:wait-port-ready (&rest ignore)
    (cerror "Go on"
	    "ADD:WAIT-PORT-READY shouldn't have been called on an Explorer."))
  (defun add:find-channel (&rest ignore)
    (cerror "Go on"
	    "ADD:FIND-CHANNEL shouldn't have been called on an Explorer.")))

;;;SPR 174: Get DST time offset right for Mac files on mX (RPC patch 6.4 from TI).
;; RPC patch 6.4 (unreleased as of 08/12/91)
;;;
;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-
;;; Written 08/12/91 11:23:09 by MARKY,
;;; Reason: Correct unix-lisp-ut and lisp-unix-up functions for timezones OTHER THAN "CST".
;;; while running on MX64 from band N928
;;; With SYSTEM 6.49, GC 6.10, VIRTUAL-MEMORY 6.3, MICRONET 6.0, MICRONET-COMM 6.4,
;;;  DISK-IO 6.5, DISK-LABEL 6.1, BASIC-PATHNAME 6.7, MAC-PATHNAME 6.0, NETWORK-SUPPORT-COLD 6.3,
;;;  BASIC-NAMESPACE 6.8, BASIC-FILE 6.15, RPC 6.3, NFS-MX 6.10, EH 6.8, MAKE-SYSTEM 6.5,
;;;  MEMORY-AUX 6.0, COMPILER 6.20, TV 6.37, NVRAM 6.5, UCL 6.1, INPUT-EDITOR 6.1,
;;;  MACTOOLBOX 2.32, METER 6.2, ZWEI 6.31, DEBUG-TOOLS 6.5, WINDOW-MX 6.17, PRINTER 6.9,
;;;  MAC-PRINTER-TYPES 6.3, CLIPBOARD 6.1, TI-CLOS 6.54, CLEH 6.5, NETWORK-PATHNAME 6.2,
;;;  NETWORK-NAMESPACE 6.1, DATALINK 6.0, CHAOSNET 6.9, NETWORK-SUPPORT 6.1, NETWORK-SERVICE 6.3,
;;;  DATALINK-DISPLAYS 6.0, MX-DATALINK 6.1, NAMESPACE-EDITOR 6.7, IP 3.67, NFS-MX-SERVER 6.0,
;;;  MX-SERIAL 6.2, PRINTER-TYPES 6.2, IMAGEN 6.1, MAIL-DAEMON 6.6, MAIL-READER 6.9,
;;;  TELNET 6.1, VT100 6.0, STREAMER-TAPE 6.8, DECNET 1.72, VISIDOC 6.7, PROFILE 6.3,
;;;   microcode 195, Band Name: microExplorer Network (9/28)

;;; SPR 22879. Fix lisp-unix-ut and unix-lisp-ut for timezones OTHER THAN "cst"

#!C
; From file MX-TIME-SKEW.LISP HD:NAGASE:MISC: MX64:
#10R REMOTE-PROCEDURE-CALL#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "REMOTE-PROCEDURE-CALL"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: NAGASE.MISC; MX-TIME-SKEW.#"


;;(DEFCONSTANT 0000GMT-1JAN04 (encode-universal-time 0 0 6 1 1 1904 0))
;;(DEFCONSTANT 0000GMT-1JAN04DST (encode-universal-time 0 0 5 1 1 1904 0))
(eval-when (compile load eval)
  (DEFparameter 0000GMT-1JAN04 (encode-universal-time 0 0 time:*timezone* 1 1 1904 0))
  (DEFparameter 0000GMT-1JAN04DST (encode-universal-time 0 0 (1- time:*timezone*) 1 1 1904 0))
  )

))

;; Must recompile functions below since former defconstants 0000GMT-1JAN04DST and 0000GMT-1JAN04 are imbedded in functions as numbers
#!C
; From file MX-TIME-SKEW.LISP HD:NAGASE:MISC: MX64:
#10R REMOTE-PROCEDURE-CALL#:
(lisp:COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "REMOTE-PROCEDURE-CALL"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: NAGASE.MISC; MX-TIME-SKEW.#"


;; may 08/12/91 Added
(defvar *old-timezone* time:*timezone* "Snapshot of time:*timezone* to use to also change 0000GMT-1JAN04DST")

;; may 08/12/91 Added
(defun update-timezone ()
  "Insure changes to time:*timezone* are also reflected in 0000GMT-1JAN04DST and 0000GMT-1JAN04"
  (unless (= *old-timezone* time:*timezone*)
    (setq 0000GMT-1JAN04 (encode-universal-time 0 0 time:*timezone* 1 1 1904 0))
    (setq 0000GMT-1JAN04DST (encode-universal-time 0 0 (1- time:*timezone*) 1 1 1904 0))
    (setq *old-timezone* time:*timezone*)))

;; may 08/12/91 Added
(eval-when (load eval)
  (update-timezone))

(DEFUN LISP-UNIX-UT (lisp-universal-time)
   "Convert LISP-UNIVERSAL-TIME (seconds since 0000GMT 1 January 1900) into
UNIX-style universal time (seconds since 0000GMT 1 January 1970)."
   (declare (values unix-universal-time))
   (when (si:addin-p)
     (update-timezone))	;; may 08/12/91 Added
   (let ((ut
	   (- lisp-universal-time
	      (COND ((si:addin-p) RPC:0000GMT-1JAN04)
		    (t RPC:0000GMT-1JAN70)))))
     (if (and (si:addin-p) (time:ut-daylight-savings-p lisp-universal-time)) ; DAB  05-01-89 Then check if it needs readjusting.
	 (- lisp-universal-time
	    0000GMT-1JAN04DST)			       ; DAB 04-18-89
	 UT)
      ))

(DEFUN UNIX-LISP-UT (unix-universal-time &optional (read-host si:local-host))
   "Convert UNIX-UNIVERSAL-TIME (seconds since 0000GMT 1 January 1970) into
Lisp universal time (seconds since 0000GMT 1 January 1900)."
   (declare (values lisp-universal-time))
   (when (si:addin-p)
     (update-timezone))	;; may 08/12/91 Added
   (let ((UT (+ unix-universal-time    ; DAB 04-18-89 First build the time without daylight savings.
		(IF (mac-host-p read-host)
		    0000GMT-1JAN04 
		    0000GMT-1JAN70))))
     (if (and (mac-host-p read-host) (time:ut-daylight-savings-p  UT)) ; DAB 04-18-89 Then check if it needs readjusting.
	      (+ unix-universal-time
		 0000GMT-1JAN04DST) ; DAB 04-18-89
	      UT))
   )

))
