;;; -*- Mode:Common-Lisp; Package:NETWORK-FILE-SYSTEM; Patch-file:T; Base:10 -*-

;;; This software developed by:
;;;	Rich Acuff
;;;	except where noted
;;; at the Stanford University Knowledge Systems Lab in 1987-1989.
;;;
;;; This work was supported in part by:
;;;	NIH Grant 5 P41 RR00785-15

;;;----------------------------------------------------------------------
;;; Unless otherwise noted this code is modified code from Texas
;;; Instruments Incorporated.
;;; KSL's changes are noted by comment lines beginning with:
;;;	RDA:
;;;  The following restrictions apply to the TI code:

;;; Your rights to use and copy Explorer System Software must be obtained
;;; directly by license from Texas Instruments Incorporated.  Unauthorized
;;; use is prohibited.

;;;                           RESTRICTED RIGHTS LEGEND

;;;Use, duplication, or disclosure by the Government is subject to
;;;restrictions as set forth in subdivision (c)(1)(ii) of the Rights in
;;;Technical Data and Computer Software clause at 52.227-7013.
;;;
;;;                     TEXAS INSTRUMENTS INCORPORATED.
;;;                              P.O. BOX 2909
;;;                           AUSTIN, TEXAS 78769
;;;                                 MS 2151
;;;
;;; Copyright (C) 1985-1989 Texas Instruments Incorporated. All rights reserved.
;;;----------------------------------------------------------------------

;;;  This is a file of patches used at Stanford KSL for Explorer system
;;;  Release 6's NFS, KSL Patches meta-version 9.

;;;  To use this file the logical directory KSL:SYS-PATCHES; should be
;;;  defined and this file and it's associated files should reside
;;;  there.

;;;No SPR: Merril Cornish supplied patch to not answer SUN broadcasts
RPC:
(DEFUN-METHOD PORT-MAP-DISPATCHER PORT-MAP-SERVER (svc-request stream)
   "Port Map Server procedure dispatcher function"
   (declare (values ignore))

   (flet
     ((GET-PMAP-ARGS-OR-RETURN ()
	;;Decodes PMAP-ARGS from STREAM stream or returns with decode error if it can't.
	(when (null (send stream :getargs :xdr-pmap (locf pmap-args)))
	  (send stream :svcerr-decode)
	  (return-from port-map-dispatcher))
	);get-pmap-args-or-return
        );flet-bindings

     (case (svc-req-procedure svc-request)
       (#.PMAPPROC-NULL		   ; case of null procedure, just return nothing
	(send stream :sendreply :xdr-void nil))

       
       (#.PMAPPROC-SET			   ; case of PMAP-SET procedure, return success-p
	(get-pmap-args-or-return)
	(send stream :sendreply :xdr-bool (pmap-set (aref pmap-args 0)   ;program
						    (aref pmap-args 1)   ;version
						    (aref pmap-args 2)   ;protocol
						    (aref pmap-args 3))));port
       
       (#.PMAPPROC-UNSET		   ; case of PMAP-UNSET, return success-p
	(get-pmap-args-or-return)
	(send stream :sendreply :xdr-bool (pmap-unset (aref pmap-args 0)   ;program
						      (aref pmap-args 1))));version

       
       (#.PMAPPROC-GETPORT		   ; case of PMAP-GETPORT, return port number or 0
	(get-pmap-args-or-return)
	(incf pmap-getport-queries-meter)
	(send stream :sendreply :xdr-unsigned
	      (or (getport pmap-args)
		  (progn (incf unsuccessful-pmap-getport-queries-meter)
			 0))))
       
       (#.PMAPPROC-DUMP		   ; case of PMAP-DUMP, return Port Map list
	(setf-meter  *pmap-entries-meter* (length *port-map-alist*))
	(send stream :sendreply :xdr-pmaplist
	      (mapcar #'(lambda (alist-pair)
			  ;; (first alist-pair) => (program version protocol-no)
			  ;; (rest alist-pair) => port
			  (vector (first  (first alist-pair))
				  (second (first alist-pair))
				  (third  (first alist-pair))
				  (rest   alist-pair)))
		      *port-map-alist*)))
       ;;RDA: Added as per Merril Cornish
       (#.PMAPPROC-CALLIT         ; case of PMAP-CALLIT
	(ignore))				       ;   do nothing, not even a reply
       (otherwise			   ; case of unsupported procedure, return error
	(send stream :svcerr-noproc))
       );case
       );flet
    );port-map-dispatcher
