;;; -*- Syntax: Zetalisp; Mode: LISP; Package: FILE-SYSTEM; Base: 8; Lowercase: Yes -*-

#||
LMI LispM pathname patch for Symbolics Lisp Machines.

Written April 1984 by Richard Lamson.

Requires release 5.0 or later.
Set the system type of any TI lisp machine host to TI-LISPM rather than 
LISPM.  Do this after you have loaded this patch.  You may need to
full-gc in order to make this work.

To avoid this problem, do NOT create the host object until AFTER you
have loaded the patch, and make it be TI-LISPM the first time.  You
should probably disk-save a world with this patch in it on every machine
before creating the host object.

||#

(setq *use-full-parser* t)			; TI violates QFile protocol

;;; Goes in SYS: Network; HOST.Lisp

(defflavor neti:host-TI-Lispm-mixin () (neti:no-device-host-mixin neti:pathname-host-mixin)
  (:required-flavors neti:host))

;;; Goes in SYS: IO; PATHST.Lisp

(defprop :TI-Lispm TI-Lispm-host neti:host-type-flavor)
(add-initialization "Add TI host" '(push ':TI-Lispm neti:all-system-types) '(:once))
(putprop :TI-Lispm '(:undelete) 'Attributes)	; ?? Don't know this is true, but can't hurt.


(defflavor TI-Lispm-host () (neti:host-TI-Lispm-mixin active-pathname-host neti:host))

;;; Goes in SYS: IO; FILE-ACCESS-PATHS.Lisp
(defmethod (:pathname-flavor TI-Lispm-host) () 'TI-Lispm-pathname)

(compile-flavor-methods TI-Lispm-host)

;;; Goes in SYS: IO; PATHST.Lisp
(defflavor TI-Lispm-pathname-mixin
	()
	(LMFS-mailbox-pathname-mixin	; Close enough for TI.
	 no-device-mixin hierarchical-directory-mixin both-cases-same-mixin)
  (:required-flavors pathname))

(defmethod (:system-type TI-Lispm-pathname-mixin) () :TI-Lispm)

(defmethod (:valid-name-p TI-Lispm-pathname-mixin) (spec)
  (or (memq spec '(nil :wild))
      (stringp spec)))

(defmethod (:valid-type TI-Lispm-pathname-mixin) (typ)
  (if (send self ':valid-type-p typ) typ
      (if (eq typ ':unspecific) ""
	  (send (send self ':new-canonical-type ':lisp) ':raw-type))))

(defmethod (:valid-version-p TI-Lispm-pathname-mixin) (spec)
  (or (memq spec '(nil :wild :oldest :newest))
      (and (fixp spec)
	   (< 0 spec 1_24.))))

(defmethod (:valid-directory-component-p TI-Lispm-pathname-mixin)(comp-name ignore)
  (or (stringp comp-name)
      (memq comp-name '(:wild :wild-inferiors))))

(defun-in-flavor (TI-Lispm-pathname-dname-string TI-Lispm-pathname-mixin) ()
  (cond ((eq directory ':wild) "**")
	((null directory) "")
	((listp directory)
	 (format nil "~{~A~^.~}" (mapcar #'(lambda (dir-name)
					     (selectq dir-name
					       (:wild "*")
					       (:wild-inferiors "**")
					       (otherwise dir-name)))
					 directory)))
	(t directory)))

(defun-in-flavor (TI-Lispm-pathname-ename-string
		   TI-Lispm-pathname-mixin) (suppress-newest)
  (let ((my-name (and name (string-or-wild self name)))
	(my-type (and type (string-or-wild self type)))
	(my-version (cond ((and suppress-newest (eq version :newest)) nil)
			  ((eq version :newest) ">")
			  ((numberp version) version)
			  (t (and version (string-or-wild self
							  version))))))
    (format nil "~@[~A~]~@[.~A~]~@[#~D~]"
	    my-name my-type my-version)))

(defun-in-flavor (TI-Lispm-string-or-wild TI-Lispm-pathname-mixin)
		 (thing)
  (select thing
    ((nil) nil)
    (:wild "*")
    (otherwise thing)))

(defun-in-flavor (TI-Lispm-pathname-pname-string TI-Lispm-pathname-mixin) (suppress-newest)
  (let ((dname (TI-Lispm-pathname-dname-string))
	(ename (TI-Lispm-pathname-ename-string suppress-newest)))
    (format nil "~A; ~A" dname ename)))

(defmethod (:string-for-printing TI-Lispm-pathname-mixin) ()
 (format nil "~A: ~A" (send host ':name-as-file-computer) (TI-Lispm-pathname-pname-string t)))

(defmethod (:string-for-host TI-Lispm-pathname-mixin) ()
  (TI-Lispm-pathname-pname-string nil))

(defmethod (:string-for-editor TI-Lispm-pathname-mixin) ()
  (format nil "~A ~A; ~A:" (TI-Lispm-pathname-ename-string t) (TI-Lispm-pathname-dname-string)
	  (send host ':name-as-file-computer)))

(defmethod (:string-for-directory TI-Lispm-pathname-mixin) ()
  (TI-Lispm-pathname-dname-string))

(defmethod (:string-for-DIRED TI-Lispm-pathname-mixin) ()
  (TI-Lispm-pathname-ename-string t))

(defmethod (:parse-directory-spec TI-Lispm-pathname-mixin) (input &optional (start 0) end)
  (cond ((or (listp input)
	     (memq input '(nil :wild)))
	 input)
	((not (stringp input)) (parse-pathname-error "Invalid TI pathname spec: ~S" input))
;	((not (string-search "." input)) (list input))
	(t (loop as index = (string-search "." input start end)
		 as dir-name = (substring input start (or index end))
		 collect (cond ((string-equal dir-name "*") :wild)
			       ((string-equal dir-name "**") :wild-inferiors)
			       (t dir-name))
		 while index
		 do (setq start (1+ index))))))

(defmethod (:parse-namestring TI-Lispm-pathname-mixin)
	   (ignore name-string &optional (start 0) end)
  (setq start (or (string-search-not-char #\SP name-string start end) start 0))
  (setq end (1+ (or (string-reverse-search-not-char #\SP name-string end start)

		    (and end (1- end))
		    (1- (string-length name-string)))))
  (let* ((semicolon-position (string-search-char #/; name-string start end))
	 (period-position (string-search-char #/. name-string
					      (or semicolon-position start) end))
	 (sharpsign-position (string-search-set '(#/# #/.) name-string
						 (or (if period-position (1+ period-position))
						     semicolon-position
						     start)
						 end))
	 dir-spec name-spec type-spec version-spec)
    (if (not semicolon-position)
	(setq semicolon-position start)
      (setq dir-spec (string-trim '(#\SP)
				  (substring name-string start semicolon-position)))
      (incf semicolon-position))
    (if (not sharpsign-position)
	(setq sharpsign-position end)
      (setq version-spec (string-trim '(#\SP) (substring name-string
							 (1+ sharpsign-position) end)))
      (cond ((or (string-equal version-spec "newest")
		 (string-equal version-spec ">"))
	     (setq version-spec :newest))
	    ((string-equal version-spec "oldest")
	     (setq version-spec :oldest))
	    (t (setq version-spec (parse-number version-spec 0 nil 10.))
	       (when (and (not (null version-spec)) (zerop version-spec))
		 (setq version-spec :newest)))))
    (if (not period-position)
	(setq period-position sharpsign-position)
      (setq type-spec (string-trim '(#\SP)
				   (substring name-string (1+ period-position)

					      sharpsign-position))))
    (setq name-spec (string-trim '(#\SP)
				 (substring name-string semicolon-position period-position)))
    (when (zerop (string-length name-spec)) (setq name-spec nil))
    (values :unspecific (send self :parse-directory-spec dir-spec)
	    name-spec type-spec version-spec)))

(defmethod (:character-needs-quoting-p TI-Lispm-pathname-mixin) (ch)
  (mem #'char-equal ch '(#\;
			 #\ #\sp #\. #\tab )))

(defmethod (:quote-character TI-Lispm-pathname-mixin) ()
  #//)

;;; This next method borrowed from lmfs-pathname-mixin
;;; Something must have changed in Genera 8.0
;;; John Delaney 1/30/91

(defmethod (:homedir TI-Lispm-pathname-mixin) ()
  (neti:pathname-host-get-pathname
    host
    ':unspecific	;Device always ':UNSPECIFIC in current syntax
    (list (send host ':host-user-id))	;Assume top-level directory
    nil nil nil nil nil nil))	;Other components NIL

(defflavor TI-Lispm-pathname
	()
	(TI-Lispm-pathname-mixin active-pathname-mixin remote-pathname))

(compile-flavor-methods TI-Lispm-pathname)
