;;; -*- Mode:Common-Lisp; Package:W; Base:10; Patch-file:T -*-

;; Patched to use the current default prompt when generating the SYMBOL-HELP keyboard map. ~Ziggy


(DEFUN DRAW-KEYBOARD-1 (&REST IGNORE &AUX LAST-X-POSITION )
  "Draw the initial keyboard layout as a window."
  (MOUSE-WARP  (TRUNCATE TV:MAIN-SCREEN-WIDTH 2) (TRUNCATE TV:MAIN-SCREEN-HEIGHT 2))
  (USING-RESOURCE (KEYBOARD-DRAWING-WINDOW KEYBOARD-DRAWING-WINDOW-FLAVOR)
    (SETF (SHEET-TRUNCATE-LINE-OUT-FLAG KEYBOARD-DRAWING-WINDOW) 0)
    (LET* ((OSW SELECTED-WINDOW)
	   (caller-font (send osw :current-font)))				; [Ziggy]
      (UNWIND-PROTECT
          (PROGN
            (EXPOSE-WINDOW-NEAR KEYBOARD-DRAWING-WINDOW '(:MOUSE))
	    (SETQ MOUSE-RECONSIDER T)
            (SEND KEYBOARD-DRAWING-WINDOW :SELECT)
            (SEND KEYBOARD-DRAWING-WINDOW :SET-CURSORPOS 0 0)
            (SEND KEYBOARD-DRAWING-WINDOW :CLEAR-EOF)
            (DOLIST (KEY KEYBOARD-KEYS)
                    (SETQ LAST-X-POSITION 
                          (DRAW-KEYBOARD-BOX (FIRST KEY) (SECOND KEY) (THIRD KEY) (FOURTH KEY) (FIFTH KEY)
                                    (IF (LISTP (SIXTH KEY))
                                        (+ LAST-X-POSITION KEYCAP-SPACING (CAR (SIXTH KEY)))
                                        ;;ELSE
                                        (SIXTH KEY))
                                    KEYBOARD-DRAWING-WINDOW
				    caller-font)))				; [Ziggy]
            (DRAW-LEGEND KEYBOARD-DRAWING-WINDOW caller-font)			; [Ziggy]
	    (WAIT-FOR-SYMBOL-HELP-RESPONSE KEYBOARD-DRAWING-WINDOW))
        (DELAYING-SCREEN-MANAGEMENT
          (SEND KEYBOARD-DRAWING-WINDOW :DEACTIVATE)
          (WHEN OSW (SEND OSW :SELECT NIL)))))))

(DEFUN DRAW-KEYBOARD-BOX (KEYCAP CHARACTER-SCAN-CODE CHARACTER BOX-TYPE ROW-NUMBER X-POSITION WINDOW 
			  &optional (caller-font (send window :current-font))	; [Ziggy]
			  &AUX SPACE-POSITION)
  "Draw a box representing a key and put the keycap label in the box.
Returns the X position of the right edge of the keycap."
  (LET* ((CURRENT-FONT      (SEND WINDOW :CURRENT-FONT))			; [Ziggy]
	 (LOCAL-FONT)
	 (OFF-CENTER-X)
	 (FONT-HEIGHT       (FONT-CHAR-HEIGHT caller-font));CURRENT-FONT))      ; [Ziggy]
         (KEY-DIMENSION     (ASSOC BOX-TYPE KEYBOARD-KEY-DIMENSIONS :TEST #'EQ))
         (BOX-WIDTH         (SECOND  KEY-DIMENSION))
         (BOX-HEIGHT        (THIRD   KEY-DIMENSION))
         (SHIFTED-CHAR      (AREF SI:KBD-TI-TABLE 1  CHARACTER-SCAN-CODE))
         (SYMBOL-CHAR       (AREF SI:KBD-TI-TABLE 2  CHARACTER-SCAN-CODE))
         (SYMBOL-SHIFT-CHAR (AREF SI:KBD-TI-TABLE 3  CHARACTER-SCAN-CODE))
         (LAST-X-POSITION   (+ X-POSITION BOX-WIDTH))
         (WINDOW-WIDTH      (SEND WINDOW :WIDTH))
         (Y-POSITION        (- (* (+ ROW-NUMBER (IF (> ROW-NUMBER 1) 1 0)) 50.)
                               (IF (> ROW-NUMBER 1) 20. 0)))
         (Y-CENTERED        (+ Y-POSITION (TRUNCATE (- BOX-HEIGHT
                                                       FONT-HEIGHT)
                                                    2))))
    ;; Correction factor for a font with no decenders.
    (WHEN (< LAST-X-POSITION WINDOW-WIDTH)
      (SEND WINDOW :DRAW-RECTANGLE
            X-POSITION Y-POSITION BOX-WIDTH BOX-HEIGHT 1 BLACK ALU-IOR NIL)
      (IF (SETQ SPACE-POSITION (POSITION #\SPACE KEYCAP :TEST #'CHAR=))
          (PROGN
            ;; We have 2 lines in the keycap.  Recompute y-centered to take 2
            ;; lines into account.
            (SETQ Y-CENTERED (+ Y-POSITION -2
                                (TRUNCATE (- BOX-HEIGHT
                                             (+ FONT-HEIGHT
						(FONT-BASELINE caller-font)));CURRENT-FONT))) ;[Zig]
                                          2)))
	    (WHEN (EQ BOX-TYPE 'LOCKING-BOX)
	      ;; Move down a little to make these keys slightly off-center
	      ;; in the Y direction.
	      (SETQ Y-CENTERED (+ Y-CENTERED 5)))
	    
	    (IF (> (LENGTH (SUBSEQ KEYCAP 0 SPACE-POSITION)) 1)	;on QWERTY part of keyboard?
		(SETF OFF-CENTER-X 3                               ;no
		      LOCAL-FONT CURRENT-FONT)
		(SETF OFF-CENTER-X 12                              ;yes
	              LOCAL-FONT caller-font));FONTS:TVFONT))      		; [Ziggy]
	    
            (SEND WINDOW :STRING-OUT-CENTERED-EXPLICIT
                  (SUBSEQ KEYCAP 0 SPACE-POSITION)
                  (+ OFF-CENTER-X X-POSITION)
		  Y-CENTERED
		   LAST-X-POSITION 
		  (+ Y-CENTERED 999.)
                  LOCAL-FONT TV:ALU-XOR)
            (SETQ Y-CENTERED (+ Y-CENTERED FONT-HEIGHT 2))
	   			
	    (SEND WINDOW :STRING-OUT-CENTERED-EXPLICIT     
		  (SUBSEQ KEYCAP (1+ SPACE-POSITION))
		  (+ OFF-CENTER-X X-POSITION) 
		  Y-CENTERED
		  LAST-X-POSITION 
		  (+ Y-CENTERED 999.)
		  LOCAL-FONT tv:ALU-XOR)
	    )
        ;;ELSE
	    (IF (= (LENGTH KEYCAP) 1)		;single char on keycap?
		(SETF LOCAL-FONT caller-font;FONTS:CPTFONT      ;yes  		; [Ziggy]
		      OFF-CENTER-X (IF (arrow-key-p keycap) 3 12))
		(SETF LOCAL-FONT current-FONT			;no
		      OFF-CENTER-X 3))
	    
	    (SEND WINDOW :STRING-OUT-CENTERED-EXPLICIT KEYCAP
              (+ OFF-CENTER-X X-POSITION) Y-CENTERED LAST-X-POSITION (+ Y-CENTERED 999.)
              LOCAL-FONT TV:ALU-XOR))
	  
            ;; Draw the symbol char for this key.
            (WHEN (AND SYMBOL-CHAR
                       (NOT (= SYMBOL-CHAR BAD-KEYBOARD-CHARACTER))
		       (NOT (= SYMBOL-CHAR #\CALL))	
                       (OR (NULL CHARACTER) (NOT (CHAR= SYMBOL-CHAR CHARACTER)))
                       (NOT (CHAR= SYMBOL-CHAR SHIFTED-CHAR)))
                  (SEND WINDOW :STRING-OUT-EXPLICIT
                        (FORMAT NIL "~C" SYMBOL-CHAR)
                        (+ X-POSITION 4)
                        (+ 23. Y-POSITION)
                        LAST-X-POSITION 
                        (+ Y-CENTERED 999.)
                        caller-font;FONTS:MEDFNB				; [Ziggy]
			TV:ALU-XOR))
            ;; Check for shifted symbol character.
            (WHEN (AND SYMBOL-SHIFT-CHAR
                       (NOT (= SYMBOL-SHIFT-CHAR BAD-KEYBOARD-CHARACTER))
                       (OR (NULL CHARACTER) (NOT (CHAR= SYMBOL-SHIFT-CHAR CHARACTER)))
                       (NOT (CHAR= SYMBOL-SHIFT-CHAR SHIFTED-CHAR)))
                  ;; Draw shift-symbol char for this key.
                  (SEND WINDOW :STRING-OUT-EXPLICIT
                        (FORMAT NIL "~C" SYMBOL-SHIFT-CHAR)
                        (+ X-POSITION 4)
                        (+ 3. Y-POSITION)
                        LAST-X-POSITION 
                        (+ Y-CENTERED 999.)
                        caller-font;FONTS:MEDFNB				; [Ziggy]
			TV:ALU-XOR)))
    
    (IF (= FONT-HEIGHT (FONT-BASELINE caller-font));CURRENT-FONT))		; [Ziggy]
	(SETQ FONT-HEIGHT (+ 2 FONT-HEIGHT)))
    (WHEN (EQ BOX-TYPE 'LOCKING-BOX)
      ;; Draw a circle in the upper right corner to represent the LED.
      (SEND WINDOW :DRAW-FILLED-CIRCLE
	    (- LAST-X-POSITION 9) (+ Y-POSITION 5) 3. BLACK TV:ALU-XOR 10 nil))
    ;;Record the information about the dimensions for this character.
    (WHEN CHARACTER
          (SETF (AREF KEYBOARD-CHARACTER-INFORMATION CHARACTER 1)      X-POSITION)       ; Left
          (SETF (AREF KEYBOARD-CHARACTER-INFORMATION CHARACTER 2)      Y-POSITION)       ; Top
          (SETF (AREF KEYBOARD-CHARACTER-INFORMATION CHARACTER 3) LAST-X-POSITION)       ; Right
          (SETF (AREF KEYBOARD-CHARACTER-INFORMATION CHARACTER 4) (+ Y-POSITION BOX-HEIGHT))     ; Bottom
          )
    LAST-X-POSITION))

(DEFUN DRAW-LEGEND (WINDOW caller-font)						; [Ziggy]
   "Draw the legend to explain what the layout is for the characters."
   (LET* ((MAX-Y (+ (LOOP FOR INDEX FROM 0 BELOW (ARRAY-DIMENSION KEYBOARD-CHARACTER-INFORMATION 0)
                              MAXIMIZE (OR (AREF KEYBOARD-CHARACTER-INFORMATION INDEX 4) 0))
                       50))
           (OLD-CURRENT-FONT     (SEND WINDOW :CURRENT-FONT))
           (X-CENTERED           (TRUNCATE (SHEET-WIDTH WINDOW) 2))
           (CHARACTER-SEPARATION 2)
           (LEGEND-ENTRY         (ASSOC "P" KEYBOARD-KEYS :TEST #'EQUAL))
           (BOX-TYPE             (FOURTH LEGEND-ENTRY))
           (KEY-DIMENSION        (ASSOC BOX-TYPE KEYBOARD-KEY-DIMENSIONS :TEST #'EQ))
           (BOX-WIDTH            (SECOND  KEY-DIMENSION))
           (BOX-HEIGHT           (THIRD   KEY-DIMENSION)))
      (DRAW-KEYBOARD-BOX (FIRST LEGEND-ENTRY) (SECOND LEGEND-ENTRY) 
                  NIL
                  BOX-TYPE (TRUNCATE MAX-Y 50)
                  X-CENTERED
                  WINDOW
		  caller-font)						; [Ziggy]
      (SEND WINDOW :SET-CURRENT-FONT 2)
      (LET ((ENHANCED-FONT (SEND WINDOW :CURRENT-FONT)))
         (SEND WINDOW :STRING-OUT-EXPLICIT "Key"
                (+ X-CENTERED BOX-WIDTH CHARACTER-SEPARATION 2)
                (+ MAX-Y BOX-HEIGHT (- (FONT-CHAR-HEIGHT ENHANCED-FONT)) -2)
                MOST-POSITIVE-FIXNUM MOST-POSITIVE-FIXNUM
                ENHANCED-FONT TV:ALU-XOR)
         
         (SEND WINDOW :STRING-OUT-EXPLICIT "SYMBOL character"
                (- X-CENTERED (SEND WINDOW :STRING-LENGTH "SYMBOL character") CHARACTER-SEPARATION)
                (+ MAX-Y BOX-HEIGHT (- (FONT-CHAR-HEIGHT ENHANCED-FONT)) 6)
                MOST-POSITIVE-FIXNUM MOST-POSITIVE-FIXNUM
                ENHANCED-FONT TV:ALU-XOR)
      
      (SEND WINDOW :STRING-OUT-EXPLICIT "SYMBOL-SHIFT character"
                (- X-CENTERED (SEND WINDOW :STRING-LENGTH "SYMBOL-SHIFT character") CHARACTER-SEPARATION)
                (+ MAX-Y (FONT-CHAR-HEIGHT ENHANCED-FONT) -2)
                MOST-POSITIVE-FIXNUM MOST-POSITIVE-FIXNUM
                ENHANCED-FONT TV:ALU-XOR))
      (SEND WINDOW :SET-CURRENT-FONT OLD-CURRENT-FONT)))

(DEFUN ARROW-KEY-P (KEY)
  "Returns T if KEY is an arrow key."
  (OR (EQUAL KEY "")
      (EQUAL KEY "")
      (EQUAL KEY "")
      (EQUAL KEY "")
      (EQUAL KEY "")				; [Ziggy]
      ))
