;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10; Fonts:(CPTFONT HL12B HL12I MEDFNB) -*-

(defflavor 4EXPLORER-NEWS*
	   ((newsgroup-component nil)
	    (interval nil))		;1T if the system is being initialized.  Used by the :after :select method.*
      (zmacs-buffer)
  :GETTABLE-INSTANCE-VARIABLES
  :SETTABLE-INSTANCE-VARIABLES
  :INITTABLE-INSTANCE-VARIABLES
  (:documentation "Explorer News window"))


(defmethod 4(EXPLORER-NEWS :AFTER :INIT*) (ignore)
  (setf interval self)
  (setq read-only-p t)
  (setq undo-status :dont)
  (setq saved-major-mode 'newsgroup-mode)
  (send self :set-attribute :mode 'newsgroup-mode)
  (setf (get self :dont-sectionize) t)
  (setf (get self 'zwei:inhibit-kill-buffer-cleanup) t)
  (redisplay-mode-line)
  (setq saved-mode-list nil)			;1prevent sticky minor modes from creeping in*
  (setq *en* self))


(defmethod 4(EXPLORER-NEWS :AFTER :SELECT*) (&rest ignore)
  (tv:mouse-wakeup)
  (must-redisplay *window* dis-text)
  (cond
    ((news-initialized-p)
     (reset-news-daemon :start))
    (t
     (condition-case (error-object)
	 (progn
	  (redisplay *window*)
	  (configure-news-menu)
	  (initialize-news)
	  (get-next-newsgroup)
	  (format *query-io* "~:|")
	  (newsgroup-prompt))
       (sys:abort (send self :kill))))))


(defmethod 4(EXPLORER-NEWS :AFTER :KILL*) (&rest ignore)
  (setf interval nil)
  (setf *en* nil))


(defun 4EN* ()
  (let ((zmacs-window (find-or-create-idle-zmacs-window 'com-en (if *en* (send *en* :interval)))))
    (w:await-window-exposure)
    (funcall zmacs-window :force-kbd-input '(:execute en1))
    (send zmacs-window :select)
    zmacs-window))


(defun 4EN1* ()
  "2Read news.*"
  (make-buffer-current (find-or-create-en-buffer)))


(defun 4FIND-OR-CREATE-EN-BUFFER* ()
  "2Return the buffer.*"
  (let (newbuf)
    (or (find-en-buffer)
	(progn (setq newbuf (make-instance 'explorer-news
					   :name "Explorer News"))
	       (send newbuf :activate)
	       newbuf))))


(defun 4EN-BUFFER-P* (object)
  "2T if OBJECT is an en buffer.*"
  (typep object 'explorer-news))


(defun 4FIND-EN-BUFFER* ()
  (dolist (buffer *zmacs-buffer-list*)
    (and (en-buffer-p buffer) (return buffer))))


;1;;*
;1;; Add to system key and system menu.*
;1;;*
;1;;I have to go through these steps to get the Explorer news program to show up in the system menu.*
(w:add-to-system-menu-column :programs "2Explorer News*"
			   '(en)
			   "2manage network news.*"
			   :sorted)
(w:delete-from-system-menu-column :programs "2Explorer News*")
(w:add-to-system-menu-column :programs "2Explorer News*"
			   '(en)
			   "2manage network news.*"
			   :sorted)
(format t "~2%Note:  Explorer news added to the system menu.")

(cond
  ((assoc #\N tv:*system-keys*)
   (format t "~%Warning:  System-N already bound.  Use the function (w:add-system-key #\\<char> '(zwei:en) \"\")~%to bind Explorer news to some other system key."))
  (t
						;1 Added "Explorer news" as print-name on system-key definition   -- JRG 10/20/88*
                                                ; Kludged to get by release 3 and release 4.  -- KRS 3/22/89
   (if (eq (send (car system:*defined-products* ) :send-if-handles :major-version) 3)
       (w:add-system-key #\N '(en) "Explorer news - manage network news." t)
       (w:add-system-key #\N '(en) "Explorer news - manage network news." t nil "Explorer News"))
   (format t "~%Note:  Explorer news bound to System-N.")))

(format t "~2%")

(compile-flavor-methods explorer-news)
