;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

;;; These bits was made for talkin'.
;;;
;;;
;;;  5 Nov 88  Jamie Zawinski   Created.


(export '(speak-number tock))


(defstruct (anglic-number (:conc-name "NUMBER-"))
  minus zero hundred
  ones
  teens
  tweens
  triads)

(defparameter *numbers*
	      (make-anglic-number
		:minus   'minus
		:zero    'zero
		:hundred 'hundred
		:ones    #(one two three four five six seven eight nine)
		:teens   #(ten eleven twelve thirteen fourteen fifteen sixteen seventeen eighteen nineteen)
		:tweens  #(twenty thirty forty fifty sixty seventy eighty ninety)
		:triads  #(thousand million billion trillion quadrillion quintillion sextillion septillion
			   octillion nonillion decillion undecillion duodecillion)
		)
  "An ANGLIC-NUMBER structure.")


(defun anglicize-number (number &optional (anglic-number *numbers*))
  "Returns a list of words, taken from the ANGLIC-NUMBER."
  (when (zerop number) (return-from ANGLICIZE-NUMBER (list (number-zero anglic-number))))
  (let* ((minusp (minusp number))
	 (results '())
	 (string (princ-to-string number))
	 (triad 0)
	 (numbase #.(char-code #\0)))
    (setq number (abs number))
    (do* ((j (length string) (- j 3)))
	 ((<= j 0))
      (let* ((i (max 0 (- j 3)))
	     (dif (- j i))
	     (c1 (if (= dif 3) (schar string (- j 3)) nil))
	     (c2 (if (> dif 1) (schar string (- j 2)) nil))
	     (c3 (schar string (- j 1))))
	(when (and (plusp triad)
		   (or (not (or (null c1) (char= c1 #\0)))
		       (not (or (null c2) (char= c2 #\0)))
		       (not (or (null c3) (char= c3 #\0)))))
	  (push (svref (number-triads anglic-number) (1- triad)) results))
	(incf triad)
	(cond ((and c2 (char= #\1 c2))
	       (push (svref (number-teens anglic-number)
			    (- (char-code c3) numbase))
		     results))
	      (t
	       (unless (or (null c3) (char= #\0 c3))
		 (push (svref (number-ones anglic-number)
			      (- (char-code c3) (1+ numbase)))
		       results))
	       (unless (or (null c2) (char= #\0 c2))
		 (push (svref (number-tweens anglic-number)
			      (- (char-code c2) (+ numbase 2)))
		       results))))
	(when (and c1 (char/= #\0 c1))
	  (push (number-hundred anglic-number) results)
	  (push (svref (number-ones anglic-number)
		       (- (char-code c1) #.(char-code #\1)))
		results))
	))
    (if minusp
	(cons (number-minus anglic-number) results)
	results)))


;;;; The sound code.


(defun play-sample-list (list)
  "Given a list of TV:SOUND-ARRAYs, play them."
  (tv::beep-stop-flash)
  (tv::with-real-time
    (tv::with-sound-enabled
      (dolist (array list)
	(dotimes (i (length array))
	  (let* ((sample (aref array i)))
	    (tv:speech sample)))))))


(defun speak-number (number)
  "Say the number in english."
  (let* ((words (anglicize-number number))
	 (samples (nsubstitute (get 'umm 'tv:sound-array) 'nil
			       (mapcar #'(lambda (x) (get x 'tv:sound-array))
				       words))))
    (play-sample-list samples)
    words))


(defun tock (&optional time)
  "Talking Clock."
  (multiple-value-bind (ig min hour) (decode-universal-time (or time (get-universal-time)))
    (declare (ignore ig))
    (cond ((> hour 12) (decf hour 12))
	  ((zerop hour) (setq hour 12)))
    (speak-number hour)
    (sleep 0.1)
    (cond ((zerop min)
	   (tv:play 'oclock))
	  (t
	   (when (< min 10) (tv:play 'oh))
	   (speak-number min))))
  (values))
