;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:ZWEI; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "*MAIL-APPEND1"*
;1;; The Append to File command for RMAIL.*
;1;; Written and maintained by Jamie Zawinski.*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;; * 2 Mar 891  Jamie Zawinski*	1 Created.*
;1;; 31 Mar 89  Jamie Zawinski *	1 It was looking up the fonts in the message buffer, instead of the appropriate subnode (this be wrong).*
;1;;*


;1;; To use, bind some key to *COM-APPEND-MAIL-MESSAGE-TO-FILE1 in **READ-MAIL-COMTAB*.


(defvar 4*append-message-divider** (string-append #\Return #\Page #\Return)
  "2What to place between messages written with COM-APPEND-MAIL-MESSAGE-TO-FILE.*")


(defvar 4*last-append-message-file** nil)


(defcom 4com-append-mail-message-to-file* "2Append the current message to a file.*" ()
  (let* ((buffer (typecase *interval*
		   (MAIL-FILE-BUFFER    *interval*)
		   (MAIL-SUMMARY-BUFFER (send *interval* :sequence-buffer))
		   (t (barf "3Not in headers or bodies buffer.*"))))
	 (message (aref (send buffer :message-array) (send buffer :current-message-index)))
	 (output-file (read-defaulted-pathname "3Append message to file: *"
					       (or *last-append-message-file*
						   (pathname-defaults *pathname-defaults* buffer))
					       nil :newest :write nil))
	 (exists (probe-file output-file))
	 (write-attribute-line (not exists))
	 (lines 0)
	 truename)
    (setq *last-append-message-file* output-file)
    (let* ((fonts (send message :get-attribute :fonts))) ;1 The 5message*, not the 5buffer*.  Careful!*
      (when exists
	(let* ((old-fonts (getf (fs:file-attribute-list exists) :FONTS)))
	  (unless (and (<= (length fonts) (length old-fonts))
		       (block OK
			 (mapc #'(lambda (x y)
				   (unless (string-equal x y) (return-from OK nil)))
			       fonts old-fonts)
			 t))
	    (if (fquery `(:beep t :clear-input t :choices ,sys:y-or-n-p-choices)
			"3The file \"~A\" exists, but does not have the same font list as this message.~%~*
			  3 The file has the font list ~:A, and the message has ~:A.~%~*
			  3 Do you want to save anyway? *"
			exists old-fonts fonts)
		(setq write-attribute-line t)
		(barf "3Aborted.*")))))
      (with-open-file (output-stream output-file :direction :output
						 :if-exists :append
						 :if-does-not-exist :create)
	(setq truename (send output-stream :truename))
	(when (and exists *append-message-divider*) (princ *append-message-divider* output-stream))
	(when write-attribute-line
	  (if fonts
	      (format output-stream "3-*- Mode:TEXT; Fonts:~A -*-~2%*" fonts)
	      (format output-stream "3-*- Mode:TEXT -*-~2%*")))
	(with-open-stream (input-stream (interval-stream buffer nil nil (not (null fonts))))
	  (do* ((line (read-line input-stream nil nil)
		      (read-line input-stream nil nil)))
	       ((null line))
	    (incf lines)
	    (write-string line output-stream)
	    (terpri output-stream)))))
    (if exists
	(format *query-io* "3~&Appended message to file ~A - ~D line~:P.*" truename lines)
	(format *query-io* "3~&Wrote message to file ~A - ~D line~:P.*" truename lines)))
  DIS-NONE)

