;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:FILE-SYSTEM; VSP:0; Fonts:(CPTFONT HL12 TR12I COURIER CPTFONT HL12B) -*-

;1;; File "3LOST-CONNECTION-HACK*"*
;1;;*
;1;; 5ChangeLog:**
;1;;*
;1;;     9 May 89*	1Jamie Zawinski*	1 Created.*
;1;;*



(defun 4clone-instance *(old-instance new-instance)
  "2Bash the contents of the instance variables on* NEW-INSTANCE2 to be EQ to the contents of the instance variables on* OLD-INSTANCE2.*"
  (check-type old-instance vanilla-flavor)
  (assert (and (typep new-instance (type-of old-instance))
	       (typep old-instance (type-of new-instance)))
	  () "3The two instances must be of the same type!*")
  
  (dolist (var-name (flavor-all-instance-variables (instance-flavor old-instance)))
    (set-in-instance new-instance var-name
		     (symeval-in-instance old-instance var-name)))
  new-instance)


(defun 4reopen-stream *(old-stream)
  "2If a remote file connection has died (i.e., the remote machine has rebooted) you can call this on your dead stream to bring it back to life.*"
  (let* ((old-position (file-position old-stream))
	 (new-stream (open (send old-stream :truename)
			   :direction    (send old-stream :direction)   ;1 Must be :input, right?*
			   :characters   (send old-stream :characters)
			   :element-type (send old-stream :element-type)
			   )))
    (file-position new-stream old-position)
    ;1;*
    ;1; Pretend we didn't open the new-stream.  Remove it from the file-state-sheet, and also*
    ;1; remove it from the Host object's open-streams list.*
    (send TV:WHO-LINE-FILE-STATE-SHEET :delete-stream new-stream)
    (let* ((host (pathname-host (send old-stream :pathname))))
      (setf (get host :open-streams) (delete new-stream (get host :open-streams))))
    
    (clone-instance new-stream old-stream)
    old-stream))
