;;; -*- Mode:Common-Lisp; Package:SYSTEM; Base:10 -*-

;;; Code to alter the low-level mapping of the TI keyboard.
;;; This is just a pretty interface over bashing the contents of SYS:KBD-TI-TABLE.
;;; Written by Jamie Zawinski.


(defun lookup-raw-code (char)
  "Given a character object, returns the raw scancode that produces it."
  (dotimes (i (array-dimension KBD-TI-TABLE 1))
    (dotimes (j (array-dimension KBD-TI-TABLE 0))
      (when (char= char (aref KBD-TI-TABLE j i))
	(return-from LOOKUP-RAW-CODE (values (aref KBD-TI-TABLE j i) j i))))))


(defun set-key-mapping (raw-code character
			&optional (repeats-p t)
				  (shifted-character (char-upcase character))
				  (symbol-character character)
				  (shifted-symbol-character (char-upcase symbol-character))
				  )
  "Given a raw scancode, alter what it produces.  BE CAREFUL."
  (check-type raw-code fixnum)
  (check-type character (or character null))
  (check-type shifted-character (or character null))
  (check-type symbol-character (or character null))
  (check-type shifted-symbol-character (or character null))
  (let* ((blank #o140000))
    (setq character (or character blank))
    (setq shifted-character (or shifted-character blank))
    (setq symbol-character (or symbol-character blank))
    (setq shifted-symbol-character (or shifted-symbol-character blank)))
  (setq repeats-p (if repeats-p 1 0))
  (setf (aref KBD-TI-TABLE 0 raw-code) character)
  (setf (aref KBD-TI-TABLE 1 raw-code) shifted-character)
  (setf (aref KBD-TI-TABLE 2 raw-code) symbol-character)
  (setf (aref KBD-TI-TABLE 3 raw-code) shifted-symbol-character)
  (setf (aref KBD-TI-TABLE 4 raw-code) 0)
  (setf (aref KBD-TI-TABLE 5 raw-code) repeats-p)
  raw-code)
