;;; -*- Mode: Common-Lisp; Package: NAME; Base: 10.; Patch-File: T -*-
;;; Patch file for STUB-RESOLVER version 2.5
;;; Reason: Delete duplicates from services list parsed from WKS records.
;;; This really exposes an incompatibility between DNS and Explorer networking - Explorers
;;; think hosts have the same services on all interfaces.
;;; Written 13-Mar-89 18:59:04 by Victor,
;;; while running on John Jameson from band LOD3
;;; With SYSTEM 4.61, VIRTUAL-MEMORY 4.4, EH 4.5, MAKE-SYSTEM 4.5, MICRONET 4.5, LOCAL-FILE 4.1,
;;;  BASIC-PATHNAME 4.12, NETWORK-SUPPORT-COLD 4.1, NAMESPACE 4.22, NETWORK-NAMESPACE 4.2,
;;;  DISK-IO 4.13, DISK-LABEL 4.0, BASIC-FILE 4.7, MAC-PATHNAME 4.5, NETWORK-PATHNAME 4.1,
;;;  COMPILER 4.13, TV 4.85, DATALINK 4.14, CHAOSNET 4.18, GC 4.3, MEMORY-AUX 4.0,
;;;  NVRAM 4.6, SYSLOG 4.0, STREAMER-TAPE 4.4, UCL 4.1, INPUT-EDITOR 4.0, METER 4.3,
;;;  ZWEI 4.18, DEBUG-TOOLS 4.2, NETWORK-SUPPORT 4.5, NETWORK-SERVICE 4.0, DATALINK-DISPLAYS 4.0,
;;;  FONT-EDITOR 4.0, SERIAL 4.0, PRINTER 4.8, PRINTER-TYPES 4.2, IMAGEN 4.0, SUGGESTIONS 4.0,
;;;  MAIL-DAEMON 4.7, MAIL-READER 4.6, TELNET 4.1, VT100 4.6, NAMESPACE-EDITOR 4.5,
;;;  PROFILE 4.4, VISIDOC 4.5, IP 3.19, RPC 4.14, NFS 3.2, Experimental NFS-PATCHES 2.8,
;;;  TI-PROLOG 2.11, GRAPHICS-WINDOW 4.1, GED 4.1, TREE 4.0, VISIDOC-SERVER 4.0, Experimental SYSTEM-PATCHES 3.121,
;;;  Experimental ICU-DOCS 12.1, Experimental SYSTEM-ENHANCEMENTS 19.1, Experimental TCP-IMAGEN 10.0,
;;;  Experimental NAME-DRAGON 4.1, Experimental TEXINFO 5.5, Experimental ICU-LIBRARY 14.0,
;;;  Experimental DOMAIN 5.0, Experimental STUB-RESOLVER 2.3,  microcode 534, Band Name: 4.61 w DNS & Prolog,
;;;  890104/Vic

#!C
; From file STUB-NAMESPACE.LISP#> ICU.NETWORK.DNS; JJ:
#10R NAME#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "NAME"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-NAMESPACE.#"


(defun make-services-from-ip-wks-records (list-of-wkses)
  (let ((services ()))
    (dolist (wks list-of-wkses (delete-duplicates services :test #'equal))
      (let ((protocol (case (dns:wks-ip-protocol wks)
			(6 :tcp)
			(17 :udp))))
	(when protocol
	  (dolist (port (dns:wks-ip-ports wks))
	    (let ((implementation
		    (case port
		      (:users :lispm-finger)
		      ((:ftp :telnet :smtp :supdup) port)
		      (:time :time-simple-msb)
		      (:finger :ascii-name))))
	      (when implementation
		(let ((medium (case implementation
				((:lispm-finger :ftp) protocol)
				((:time-simple-msb :time-simple) (case protocol
								   (:tcp :tcp-simple)
								   (:udp :udp)))
				((:telnet :smtp :supdup :ascii-name) (case protocol
								       (:tcp :tcp-stream)
								       (:udp :udp-stream)))))
		      (service (case implementation
				 (:ascii-name :show-users)
				 (:lispm-finger :lispm-finger)
				 ((:telnet :supdup) :login)
				 (:smtp :mail-to-user)
				 (:ftp :file)
				 ((:time-simple-msb :time-simple) :time))))
		  (when (and medium service)
		    (push (list service medium implementation) services)))))))))))

))
