;;; -*- Mode: Common-Lisp; Package: DOMAIN-NAME-SYSTEM; Base: 10.; Patch-File: T -*-
;;; Patch file for STUB-RESOLVER version 2.3
;;; Reason: Added a variable DNS:*CASE-OF-HOSTS-MATTER* to choose whether to try and
;;; canonicalize character case of hosts by looking up their IN-ADDR.ARPA PTR.
;;; Default T.
;;; Written 21-Feb-89 19:48:22 by Victor,
;;; while running on Jim Beam from band LOD3
;;; With SYSTEM 4.61, VIRTUAL-MEMORY 4.4, EH 4.5, MAKE-SYSTEM 4.5, MICRONET 4.5, LOCAL-FILE 4.1,
;;;  BASIC-PATHNAME 4.12, NETWORK-SUPPORT-COLD 4.1, NAMESPACE 4.22, NETWORK-NAMESPACE 4.2,
;;;  DISK-IO 4.13, DISK-LABEL 4.0, BASIC-FILE 4.7, MAC-PATHNAME 4.5, NETWORK-PATHNAME 4.1,
;;;  COMPILER 4.13, TV 4.85, DATALINK 4.14, CHAOSNET 4.18, GC 4.3, MEMORY-AUX 4.0,
;;;  NVRAM 4.6, SYSLOG 4.0, STREAMER-TAPE 4.4, UCL 4.1, INPUT-EDITOR 4.0, METER 4.3,
;;;  ZWEI 4.18, DEBUG-TOOLS 4.2, NETWORK-SUPPORT 4.5, NETWORK-SERVICE 4.0, DATALINK-DISPLAYS 4.0,
;;;  FONT-EDITOR 4.0, SERIAL 4.0, PRINTER 4.8, PRINTER-TYPES 4.2, IMAGEN 4.0, SUGGESTIONS 4.0,
;;;  MAIL-DAEMON 4.7, MAIL-READER 4.6, TELNET 4.1, VT100 4.6, NAMESPACE-EDITOR 4.5,
;;;  PROFILE 4.4, VISIDOC 4.5, IP 3.19, RPC 4.14, NFS 3.2, Experimental NFS-PATCHES 2.8,
;;;  TI-PROLOG 2.11, GRAPHICS-WINDOW 4.1, GED 4.1, TREE 4.0, VISIDOC-SERVER 4.0, Experimental SYSTEM-PATCHES 3.120,
;;;  Experimental ICU-DOCS 12.0, Experimental SYSTEM-ENHANCEMENTS 19.0, Experimental TCP-IMAGEN 10.0,
;;;  Experimental NAME-DRAGON 4.1, Experimental TEXINFO 5.5, Experimental ICU-LIBRARY 14.0,
;;;  Experimental DOMAIN 5.0, Experimental STUB-RESOLVER 2.1,  microcode 534, Band Name: 4.61 w DNS & Prolog,
;;;  890104/Vic

#!C
; From file STUB-RESOLVER.LISP#> ICU.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-RESOLVER.#"



(defvar *case-of-hosts-matter* t
  "Whether or not to try to canonicalize character case of objects (hosts).
I like setting it since the UNIX BIND implementation returns answers
with the case of the question instead of the case of the database entry.
You save one query (for another domain (IN-ADDR.ARPA.)), though.")

))

#!C
; From file STUB-RESOLVER.LISP#> ICU.NETWORK.DNS; JJ:
#10R DOMAIN-NAME-SYSTEM#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "DOMAIN-NAME-SYSTEM"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "DNS: DNS; STUB-RESOLVER.#"



(defun stub-canonicalize-case (name servers)
  (multiple-value-bind (addresses original-name)
      (stub-get-addresses-of-name name servers)
    (unless addresses
      (error "No addresses for ~s" name))
    (if (not *case-of-hosts-matter*)
	(values original-name
		addresses)
	(let ((names (stub-get-name-of-address (first addresses) servers)))
	  (values (or (first names) original-name)
		  addresses)))))


))
