;;; -*- Mode:Lisp; Syntax:Common-Lisp; Package:USER; Vsp:0; Fonts:(CPTFONT HL12 TR12I COURIER ADOBE-COURIER14B HL12B CPTFONTBI) -*-

;1;; File "3AREA-MANIPULATION*".*
;1;; Some code for getting information on the contents of memory areas.*
;1;;*

(defun stats-on-area (&rest areas)
  (let* ((type-alist '()))
    (sys:map-objects-in-area
      :area-list areas
      :analysis-function #'(lambda (object total-size boxed-size space-flag addr fwd-p)
			     (declare (ignore boxed-size space-flag addr fwd-p)
				      (optimize speed))
			     (let* ((type (type-of object))
				    cons)
			       (when (and (eq type 'STRING) (array-indirect-p object))
				 (setq type 'DISPLACED-STRING))
			       (setq cons (assoc type type-alist :test #'eq))
			       (cond (cons
				      (incf (car (cdr cons)))			; num-objects
				      (incf (cdr (cdr cons)) total-size))	; mem occupied
				     (t
				      (push (cons type (cons 1 total-size)) type-alist)))))
      )
    (format t "~&type:~20tnum:~30tspace:~2%")
    (dolist (cons type-alist)
      (format t "~&~S~20t~d~30t~d" (car cons) (car (cdr cons)) (cdr (cdr cons))))
    (values)))


(defun show-objects-of-type (type &rest areas)
  "Show all of the objects of the specified type in the specified areas.
  TYPE is the most restrictive type; that is, type = ARRAY will match things for which TYPE-OF returns ARRAY.
  Special hacks:
   T means all objects.
   DISPLACED-STRING means all displaced arrays of element type string-char.
   CDR-LIST means all cdr-coded list segments.
   NON-CDR-LIST means all non-cdr-coded conses."
  (let* ((*print-array* t)
	 (*print-length* 5)
	 (*print-circle* nil)
	 (*print-pretty* nil))
    (if (eq type 'T)
	(format t "~&type:~20t Size:~30t Object:")
	(format t "~&Size:~10t Object:"))
    (sys:map-objects-in-area
      :area-list areas
      :analysis-function #'(lambda (object total-size boxed-size space-flag addr fwd-p type)
			     (declare (ignore boxed-size space-flag addr fwd-p)
				      (optimize speed))
			     (let* ((obj-type (type-of object)))
			       (cond ((and (eq obj-type 'STRING) (array-indirect-p object))
				      (setq obj-type 'DISPLACED-STRING))
				     ((consp object)
				      (setq obj-type
					    (if (or (= (sys:%p-cdr-code object) sys:cdr-next)
						    (= (sys:%p-cdr-code object) sys:cdr-nil))
						'CDR-LIST
						'NON-CDR-LIST))))
			       (let* ((fstring (if (member type '(T CONS)) "~&~A~20t ~D~30t~S" "~*~&~D~10t~S")))
				 (when (and (consp object) (eq type 'CONS)) (setq type obj-type))
				 (when (or (eq type 'T) (eq type obj-type))
				   (format t fstring obj-type total-size object)))))
      :analysis-function-args (list type)))
  (values))

(defun dump-memory-of (object &optional size)
  "Just calls SYS:DUMP-MEMORY, but the number of words dumped defaults to the size of the object."
  (sys:dump-memory object :length (or size (sys:%structure-total-size object)) :bignum-is-dump-object t))

