;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10; Fonts:(CPTFONT HL12B HL12I MEDFNB) -*-


(defun 4EN-POSTNEWS* (template)
  (let ((fcn (get-mail-template-function template)))
    ;1; Put the window that called this template on the :return-to-window-after-send *
    ;1; property, so that we go back to that window after posting.*
    (putprop *en* *interval* :return-to-buffer-after-send)
    (when fcn
      (let ((zmacs-window (find-or-create-idle-zmacs-window '(com-article-meta-p))))
	(w:await-window-exposure)
	(send zmacs-window :force-kbd-input `(:execute  ,fcn))
	(send zmacs-window :select)))))


;1;;Kludged this up so I could handle posting a message to a newsgroup through something that looks like mail but isn't.*
(defminor 4COM-POSTNEWS-MODE* postnews "2Postnews*" 1
	  "Minor mode which can 2post a news buffer to a newsgroup.*"
	  ()
	  (set-comtab *mode-comtab* '(#\End  com-postnews
				      #\Abort com-news-exit
				      #\Help com-mail-mode-documentation
				      #\C-M-Y com-yank-news-message
				      #\mouse-r-1 com-mail-mode-general-mouse-menu 
				      )
		      '(("Send Mail" . com-send-mail)
			("Quit" . com-mail-mode-exit)
			("Delivery Status" . com-delivery-status)
			("Yank Message" . com-yank-news-message)
			("Yank Current Message" . com-yank-news-message)
			))
	  (set-mode-line-list (append (mode-line-list) '("  (END to mail -- ABORT to exit)"))))


(define-mail-template 4DEFAULT-POST-NEWS-MAIL-TEMPLATE* "Reply" :reply
  "Post to a news message."
  (let ((stream (interval-stream *interval*))
	(subject (get-header-field *mail-newsgroup-component* :subject t)))
    (format stream "From:        ~@[~a~]" (send (mail:default-from-address) :string-for-message))
    (format stream "~%Newsgroups:  ~@[~a~]" (or (get-header-field *mail-newsgroup-component* :followup-to t)
						(get-header-field *mail-newsgroup-component* :newsgroups t)
						(send *mail-newsgroup-component* :newsgroup-string)))
    (format stream "~%Subject:     ~@[~a~]" (if subject (format nil "RE: ~a" (strip-re-from-subject subject))))
    (if subject
	(format stream "~%In-reply-to: ~@[~a~]" (get-header-field *mail-newsgroup-component* :message-id t)))
    (format stream "~2%")
    (turn-on-mode 'postnews)
    (move-to-bp (send stream :read-bp))))


(defcom 4COM-POSTNEWS*
	""
	()
  (postnews-buffer (send *interval* :name))
  (com-news-exit)
  dis-none)


(defcom 4COM-NEWS-EXIT*
	""
	()
  (hide-mail-buffer *interval*)
  (let ((buffer (and (boundp '*en*) (get *en* :return-to-buffer-after-send))))
    (cond
      (buffer
       (make-buffer-current buffer))
      (t
       (send (previous-buffer *interval*) :select))))
  dis-none)