;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

;;; EN - Explorer news.  Subset of the Unix rn news reader.
;;;      Bound to SYSTEM-N (if not already bound) and the System menu.


(eval-when (load eval)
  (unless (find-package "NNTP")
	  (make-package "NNTP")))


(defsystem en
  (:name "Explorer News")
  (:pathname-default "en:en.zmacs;")
  (:module nntp-client ("nntp-client"))
  (:module definitions ("definitions"))
  (:module news-flavors ("news-flavors"))
  (:module news ("build-newsgroup-components" "news" "configure-news-menu" "en" "newsgroup-mode"
		 "article-mode" "posting" "mail" "summary"))
  (:module background ("background"))
  (:module window ("window"))
  (:module profile ("profile"))
  (:module debug ("debug"))
  (:compile-load definitions)
  (:compile-load nntp-client (:fasload definitions))
  (:compile-load news-flavors (:fasload definitions nntp-client))
  (:compile-load news (:fasload definitions nntp-client news-flavors))
  (:compile-load background (:fasload definitions nntp-client news-flavors news))
  (:compile-load window (:fasload definitions nntp-client news-flavors news background))
  (:compile-load profile (:fasload definitions nntp-client news-flavors news background window))
  (:compile-load debug (:fasload definitions nntp-client news-flavors news background window profile))
  )

