;;; -*- Mode:Common-Lisp; Package:ZWEI; Base:10; Fonts:(CPTFONT HL12B HL12I MEDFNB) -*-


(defun 4RESET-NEWS-DAEMON* (&optional (enable nil))
  "2Reset the news daemon. * 2T to reset, NIL to kill, :START to start if not
already running.*"
  
  (cond
    ;1;;Kill the news daemon.  Do not restart it.*
    ((null enable)
     (when *background-check-for-newnews*
       (when (typep *background-check-for-newnews* 'sys:process)
	 (send *background-check-for-newnews* :kill))
       (setq *background-check-for-newnews* nil)))

    ;1;;Start the news daemon if not already running.*
    ((equal enable :start)
     (unless (and *background-check-for-newnews*
		  (typep *background-check-for-newnews* 'sys:process)
		  (send *background-check-for-newnews* :active-p))
       (setq *background-check-for-newnews*
	     (process-run-function '(:name "News Daemon"
					   :restart-after-reset t
					   :priority -5
					   :restart-after-boot t)
				   #'background-check-for-newnews))))

    ;1;;Kill the news daemon and restart it.*
    (t
     (when *background-check-for-newnews*
       (when (typep *background-check-for-newnews* 'sys:process)
	 (send *background-check-for-newnews* :kill))
       (setq *background-check-for-newnews* nil))
     (setq *background-check-for-newnews*
	   (process-run-function '(:name "News Daemon"
					 :restart-after-reset t
					 :priority -5
					 :restart-after-boot t)
				 #'background-check-for-newnews)))))



(defun 4BACKGROUND-CHECK-FOR-NEWNEWS* ()
  "2Background check for new news daemon.*"
  
  (loop with last-wakeup-time do
	(when (news-initialized-p)
	  (condition-case (cond-obj)
	      (let ((newsgroups (check-for-newnews)))
		;1;;Notify the user???*
		(when newsgroups
		  (cond
		    ((equal *notify-newsgroup-list* t)
		     (tv:notify nil (format nil "New news.")))
		    ((dolist (item newsgroups nil)
		       (when (dolist (subitem *notify-newsgroup-list* nil)
			       (when (string-equal item subitem)
				 (return t)))
			 (return t)))
		     (tv:notify nil (format nil "New news."))))))
	    (error nil)))
	(setf last-wakeup-time (get-universal-time))
	(process-wait "News Sleep" #'(lambda (wakeup-time) (>= (get-universal-time) wakeup-time))
		      (max (+ (get-universal-time) (* 5 60))	;1Never loop faster than 5 minutes*
			   (+ last-wakeup-time (* 60 *background-check-for-newnews-interval*))))))


