/*
Copyright (c) 1991, 1992, 1993 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: declare-object.c,v 1.11 1994/02/09 19:41:24 janssen Exp $
*/

#include "m3.h"

static boolean FirstItem;

extern string iname(string name, Interface interface);
extern string procedure_name(Procedure m);

extern Class class_object();

static void DeclareMethodArgument (Argument a, Context context)
{
  if (FirstItem)
    FirstItem = FALSE;
  else
    fprintf (context->file, "; ");
  fprintf (context->file, "%s: %s", m3_argument_name(a), iname(M3_TYPE_NAME(a->type), a->type->interface));
}

static void ListExceptionName (Exception e, Context context)
{
  fprintf (context->file, ", %s", iname(M3_EXCEPTION_NAME(e), e->interface));
}

static void DeclareMethod (Procedure m, Context context)
{
  boolean oldFirst;

  fprintf (context->file, "    %s (", M3_SHORT_METHOD_NAME(m));
  oldFirst = FirstItem;  FirstItem = TRUE;
  list_enumerate (m->arguments, (EnumProc) DeclareMethodArgument, context);
  FirstItem = oldFirst;
  fprintf (context->file, ")");
  if (m->returnType != NULL AND type_basic_type(m->returnType) != void_Type)
    fprintf (context->file, ": %s", iname(M3_TYPE_NAME(m->returnType), m->returnType->interface));
  fprintf (context->file, " RAISES {IluBasics.Failed, Thread.Alerted");
  list_enumerate (m->exceptions, (EnumProc) ListExceptionName, context);
  fprintf (context->file, "};\n");
}

boolean IsCacheableMethod (Procedure m)
{
  enum PrimitiveTypes t = type_basic_type(m->returnType);

  return (m->functional && list_size(m->arguments) == 0
	  && (t == object_Type || t == enumeration_Type || t == byte_Type
	      || t == integer_Type || t == shortinteger_Type
	      || t == cardinal_Type || t == shortcardinal_Type
	      || t == real_Type || t == shortreal_Type
	      || t == character_Type || t == shortcharacter_Type));
}

void declare_object_type (Type type, Context c)
{
  Class od;
  string name;

  od = class_object(type);
  c->class = type;
  name = M3_SHORT_TYPE_NAME(type);

  fprintf (c->file, "\n\n(* declaration of M3 type \"%s\" from ILU class \"%s:%s\"  *)\n\n",
	   M3_TYPE_NAME(type), interface_name(type->interface), type_name(type));

  fprintf (c->file, "TYPE %s = %s OBJECT\n  METHODS\n", M3_SHORT_TYPE_NAME(type),
	   (list_size(od->superclasses) > 0) ? iname(M3_TYPE_NAME(list_car(od->superclasses)), ((Type)list_car(od->superclasses))->interface) : "Ilu.Object");

  list_enumerate (od->methods, (EnumProc) DeclareMethod, c);

  fprintf (c->file, "  OVERRIDES\n    ILU_Get_Type := ILU_Get_Type_%s\n  END;\n\n", name);

  fprintf (c->file, "PROCEDURE ILU_SBH_To_%s (sbh: TEXT; mostSpecificTypeID: TEXT := NIL): %s\n", name, name);
  fprintf (c->file, "  RAISES {IluBasics.Failed, Thread.Alerted};\n\n");

  fprintf (c->file, "PROCEDURE ILU_Get_Type_%s (self : Ilu.Object): Ilu.ObjectType;\n\n", name);

  fprintf (c->file, "PROCEDURE ILU_Qua_%s (x: Ilu.Object): %s;\n\n",
	   name, name);
}
