/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)ast_predefined_type.cc	1.47% %92/06/11% Sun Microsystems"

/*
 * ast_predefined_type.cc - Implementation of class AST_PredefinedType
 *
 * AST_PredefinedType nodes denote the various predefined types such
 * as long, short, etc. that are available in IDL. Each AST_PredefinedType
 * node has a field (the value of this field is from the enum
 * AST_PredefinedType::PredefinedType) which denotes the specific predefined
 * type that this node represents. There is only one node in the entire
 * AST which represents each predefined type, such as long etc.
 */

#include	<idl.hh>
#include	<idl_extern.hh>

/*
 * Constructor(s)
 */
AST_PredefinedType::AST_PredefinedType()
		  : pd_pt(PT_long)
{
}

AST_PredefinedType::AST_PredefinedType(PredefinedType t, UTL_ScopedName *n,
				       UTL_StrList *p)
		   : AST_Decl(AST_Decl::NT_pre_defined, n, p),
		     pd_pt(t)
{
}

/*
 * Private operations
 */

/*
 * Public operations
 */


/*
 * Redefinition of inherited virtual operations
 */

/*
 * Dump this AST_PredefinedType node to the ostream o
 */
void
AST_PredefinedType::dump(ostream &o)
{
  AST_Decl::dump(o);
}

/*
 * Data accessors
 */

const AST_PredefinedType::PredefinedType
AST_PredefinedType::pt()
{
  return pd_pt;
}

// Narrowing
IMPL_NARROW_METHODS1(AST_PredefinedType, AST_ConcreteType)
IMPL_NARROW_FROM_DECL(AST_PredefinedType)
