/*
 *======================================================================
 *
 *Copyright 1992 Sun Microsystems, Inc.
 *
 *The Interface Definition Language Compiler Front End (CFE) is made
 *available for use provided that this legend is included on all media and
 *documentation and as a part of the software program in whole or part.
 *Users may copy and extend functionality (but may not remove
 *functionality) of the Interface Definition Language CFE without charge,
 *but are not authorized to license or distribute it to anyone else except
 *as part of a product or program developed by the user or with the express
 *written consent of Sun Microsystems, Inc.
 *
 *The names of Sun Microsystems, Inc. and any of its subsidiaries may not
 *be used in advertising or publicity pertaining to distribution of
 *Interface Definition Language CFE as permitted herein.
 *
 *The Interface Definition Language CFE may not be exported outside the
 *United States without first obtaining the appropriate government
 *approvals.
 *
 *INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES
 *OF ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND
 *FITNESS FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A
 *COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 *
 *Interface Definition Language CFE is provided with no support and
 *without any obligation on the part of Sun Microsystems, Inc. or any of
 *its subsidiaries or affiliates to assist in its use, correction,
 *modification or enhancement.
 *
 *SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL
 *HAVE NO LIABILITY WITH RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE
 *SECRETS OR ANY PATENTS BY INTERFACE DEFINITION LANGUAGE CFE OR ANY PART
 *THEREOF.
 *
 *IN NO EVENT WILL SUN MICROSYSTEMS, INC. OR ANY OF ITS SUBSIDIARIES OR
 *AFFILIATES BE LIABLE FOR ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL,
 *INDIRECT AND CONSEQUENTIAL DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE
 *POSSIBILITY OF SUCH DAMAGES.
 *
 *SunSoft, Inc.  
 *2550 Garcia Avenue 
 *Mountain View, California  94043
 *
 *
 *
 *
 *======================================================================
 */

#pragma ident "%@(#)ast_array.cc	1.46% %92/06/11% Sun Microsystems"

/*
 * ast_array.cc - Implementation of class AST_Array
 *
 * AST_Array nodes denote array type and field modifiers.
 * AST_Array nodes have a list of dimensions (a UTL_ExprList)
 * a count of the number of dimensions and a base type (a
 * subtype of AST_ConcreteType. This means that we cannot have
 * arrays of AST_Interfaces???
 */

#include	<idl.hh>
#include	<idl_extern.hh>
      
/*
 * Constructor(s) and destructor
 */
AST_Array::AST_Array()
	 : pd_n_dims(0), pd_base_type(NULL), pd_dims(NULL)
{
}

AST_Array::AST_Array(UTL_ScopedName *n, unsigned long nd, UTL_ExprList *ds)
	 : pd_n_dims(nd), pd_base_type(NULL),
	   AST_Decl(AST_Decl::NT_array, n, NULL)
{
  pd_dims = compute_dims(ds, nd);
}

/*
 * Private operations
 */

/*
 * Compute how many dimensions there are and collect their expressions
 * into an array
 */
AST_Expression **
AST_Array::compute_dims(UTL_ExprList *ds, unsigned long nds)
{
  AST_Expression	**result = new AST_Expression *[nds];
  UTL_ExprlistActiveIterator *l = new UTL_ExprlistActiveIterator(ds);
  long		i;

  for (i = 0; !(l->is_done()) && i < nds; l->next(), i++)
    result[i] = l->item();
  delete l;
  return result;
}

/*
 * Public operations
 */


/*
 * Redefinition of inherited virtual operations
 */

/*
 * Dump this AST_Array node to the ostream o
 */
void
AST_Array::dump(ostream &o)
{
  long	i;

  pd_base_type->dump(o);
  o << " " << local_name()->get_string();
  for (i = 0; i < pd_n_dims; i++) {
    o << "[";
    pd_dims[i]->dump(o);
    o << "]";
  }
}

/*
 * Data accessors
 */
const unsigned long 
AST_Array::n_dims()
{
  return pd_n_dims;
}

AST_Expression **
AST_Array::dims()
{
  return pd_dims;
}

AST_Type *
AST_Array::base_type()
{
  return pd_base_type;
}

void 
AST_Array::set_base_type(AST_Type *nbt)
{
  pd_base_type = nbt;
}

/*
 * Narrowing methods
 */
IMPL_NARROW_METHODS1(AST_Array, AST_ConcreteType)
IMPL_NARROW_FROM_DECL(AST_Array)
